﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceEngineers.Game.ModAPI;
using Sandbox.Common.ObjectBuilders;
using Sandbox.ModAPI;
using Sandbox.Game;
using VRage.Game;
using VRage.Game.ModAPI;
using VRage.Game.Components;
using VRage.ModAPI;
using VRage.ObjectBuilders;
using VRageMath;

namespace Test {

    /// Dialogs are structured as follows
    /// 
    /// _____________________________________
    /// |            Title                   |
    /// --------------------------------------
    /// |          Prefix Subtitle           |
    /// --------------------------------------
    /// |  ________________________________  |
    /// |  |         Content               | |
    /// |  --------------------------------- |
    /// |            ____________            |
    /// |           | ButtonText |           |
    /// |           --------------           |
    /// --------------------------------------
    /// 
    /// Button has a callback on click option, 
    /// but can't serialize that, so ¯\_(ツ)_/¯
    [MySessionComponentDescriptor(MyUpdateOrder.NoUpdate)]
    public class Main : MySessionComponentBase {

        public override void Init(MyObjectBuilder_SessionComponent sessionComponent) {

            base.Init(sessionComponent);

            MyVisualScriptLogicProvider.PlayerSpawned += PlayerSpawned;
        }

        protected override void UnloadData() {
            base.UnloadData();

            MyVisualScriptLogicProvider.PlayerSpawned -= PlayerSpawned;
        }

        public void PlayerSpawned(long playerId) {

            MyAPIGateway.Utilities.ShowMissionScreen("Title", "", "", "Text", null, null);
        }
    }
}