﻿/*
 * Script is Copyright © 2014-2015, Phoenix
 * Released under CC BY-SA 4.0 license
 **/
using System;
using System.Collections.Generic;
using Sandbox.Common.ObjectBuilders;
using Sandbox.Definitions;
using Sandbox.Game;
using Sandbox.ModAPI;
using VRage;
using VRage.ObjectBuilders;
using VRage.Game;
using VRage.ModAPI;
using VRage.Game.Components;
using VRage.Game.ModAPI;
using VRageMath;
using Sandbox.ModAPI.Weapons;
using System.Linq;
using Sandbox.Game.EntityComponents;
using Sandbox.ModAPI.Interfaces.Terminal;
using VRage.Utils;

namespace Phoenix.Stargate
{
    [MyEntityComponentDescriptor(typeof(MyObjectBuilder_TerminalBlock), false)]
    public class Stargate : MyGameLogicComponent
    {
        static bool m_ControlsInited = false;
        #region Core Entity Overrides
        public override void Init(MyObjectBuilder_EntityBase objectBuilder)
        {
            base.Init(objectBuilder);

            if (!(Container.Entity is IMyTerminalBlock))
                return;

                NeedsUpdate |= MyEntityUpdateEnum.BEFORE_NEXT_FRAME | MyEntityUpdateEnum.EACH_100TH_FRAME;
        }

        public override void UpdateOnceBeforeFrame()
        {
            if (MyAPIGateway.Session == null || MyAPIGateway.Gui == null)
            {
                NeedsUpdate |= MyEntityUpdateEnum.BEFORE_NEXT_FRAME;
                return;
            }

            CreateTerminalControls();
        }

        public override MyObjectBuilder_EntityBase GetObjectBuilder(bool copy = false)
        {
            var ob = Container.Entity.GetObjectBuilder(copy);
            return ob;
        }
        #endregion Core Entity Overrides

        #region Terminal Controls
        static void CreateTerminalControls()
        {
            if (m_ControlsInited)
                return;                         // This must be first!

            m_ControlsInited = true;

            // Do rest of init
            // Create controls first, so they can be referenced below
            // Dial button
            var dialname = "Phoenix.Stargate.Dial";
            var dialButton = MyAPIGateway.TerminalControls.CreateControl<IMyTerminalControlButton, Sandbox.ModAPI.Ingame.IMyTerminalBlock>(dialname);
            dialButton.Title = MyStringId.GetOrCompute("Dial");
            dialButton.Visible = (b) => true;
            dialButton.Enabled = (b) => b.IsFunctional;
            dialButton.Action = (b) => { };
            MyAPIGateway.TerminalControls.AddControl<Sandbox.ModAPI.Ingame.IMyTerminalBlock>(dialButton);
            MyAPIGateway.Utilities.ShowNotification("Loaded");
        }
        #endregion Terminal Controls

    }
}
// vim: tabstop=4 expandtab shiftwidth=4 nobackup
