﻿using Phoenix;
using Sandbox.Common.ObjectBuilders;
using Sandbox.Definitions;
using Sandbox.Game;
using Sandbox.Game.EntityComponents;
using Sandbox.ModAPI;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VRage.Game;
using VRage.Game.Components;
using VRage.Game.Entity;
using VRage.Game.ModAPI;
using VRage.ModAPI;
using VRage.ObjectBuilders;
using VRageMath;
using VRageRender.Messages;

namespace Phoenix.TeamColors
{
    [MyEntityComponentDescriptor(typeof(MyObjectBuilder_Character), false)]
    public class PlayerSkin : MyGameLogicComponent
    {
        public override void Init(MyObjectBuilder_EntityBase objectBuilder)
        {
            NeedsUpdate |= MyEntityUpdateEnum.EACH_100TH_FRAME;
        }

        public override void UpdateBeforeSimulation100()
        {
            var character = (Container.Entity as VRage.Game.ModAPI.IMyCharacter);
            if (character != null)
            {
                MyAPIGateway.Utilities.ShowNotification($"Character: {(character.Definition as MyCharacterDefinition).Id}");
            }
        }
   }
}