using Sandbox.ModAPI;
using SpaceEngineers.Game.ModAPI;
using VRage;
using VRage.Game.Components;
using VRage.Utils;

namespace gruzzob.BugDemos
{
    [MySessionComponentDescriptor(MyUpdateOrder.AfterSimulation)]
    public class Example_Session : MySessionComponentBase
    {
        public override void UpdateAfterSimulation()
        {
            if (MyAPIGateway.Input.IsNewKeyPressed(VRage.Input.MyKeys.L)) // also turns on suit light
            {
                var localChar = MyAPIGateway.Session.Player.Character;
                IMySurvivalBuffsProgression progression;
                if (localChar != null && localChar.Components.TryGet(out progression))
                {
                    var buffs = progression.GetActiveBuffs();
                    // since we cant index in to the readonly collection returned, just go through all of them
                    foreach (var buff in buffs)
                    {
                        MyLog.Default.WriteLine($"Increasing level of {MyTexts.GetString(buff.NameId)} buff from {buff.Level} to {buff.Level + 1}");
                        MyAPIGateway.Utilities.ShowMessage(MyTexts.GetString(buff.NameId), $"Increasing level from {buff.Level} to {buff.Level + 1}");
                        buff.Level = buff.Level + 1;
                    }
                }
            }
        }
    }
}