﻿using Sandbox.Definitions;
using SpaceEngineers.Game.Definitions;
using VRage.Game.Components;
using VRage.Utils;

namespace ExampleMod
{
    [MySessionComponentDescriptor(MyUpdateOrder.NoUpdate)]
    public class ExampleSessionComponent : MySessionComponentBase
    {
        public override void LoadData()
        {
            MyLog.Default.WriteLineAndConsole($"ExampleMod-49650 loading");
            foreach (var definition in MyDefinitionManager.Static.GetPhysicalItemDefinitions())
            {
                // This is the reproduction step. The type below should work, but it's in the wrong namespace.
                // As per https://support.keenswh.com/spaceengineers/pc/topic/49650-myseeditemdefinition-is-prohibited
                // the type MySeedItemDefinition is in SpaceEngineers.Game.Definitions which is not whitelisted.
                // While this compiles, it will not load in game.
                // Other types such as MyConsumableItemDefinition do work (see below)
                if (definition is MySeedItemDefinition)
                {
                    MyLog.Default.WriteLineAndConsole($"ExampleMod-49650 repro: Seed def: {definition.Id}");
                }

                // This works because MyConsumableItemDefinition is in the Sandbox.Definitions namespace which is whitelisted
                if (definition is MyConsumableItemDefinition)
                {
                    MyLog.Default.WriteLineAndConsole($"ExampleMod-49650 repro: Consumable def: {definition.Id}");
                }
            }
            MyLog.Default.WriteLineAndConsole($"ExampleMod-49650 load complete");
        }
    }
}