﻿using Sandbox.Game;
using Sandbox.Game.Entities;
using Sandbox.ModAPI;
using VRage.Game;
using VRage.Game.Components;
using VRage.ModAPI;
using VRage.ObjectBuilders;

namespace Digi.Experiments
{
    [MyEntityComponentDescriptor(typeof(MyObjectBuilder_FunctionalBlock), false)]
    public class Test_IsConveyorConnected : MyGameLogicComponent
    {
        public override void Init(MyObjectBuilder_EntityBase objectBuilder)
        {
            NeedsUpdate = MyEntityUpdateEnum.EACH_FRAME;
        }

        public override void UpdateAfterSimulation()
        {
            IMyTerminalBlock block = (IMyTerminalBlock)Entity;

            var grid = (MyCubeGrid)block.CubeGrid;

            foreach(var b in grid.GetFatBlocks())
            {
                IMyFarmPlotLogic farmPlotLogic;
                if(b != Entity & b.Components.TryGet(out farmPlotLogic))
                {
                    if(block.EntityId > b.EntityId) // only one of the pairs computes
                    {
                        bool conn = MyVisualScriptLogicProvider.IsConveyorConnected(block.Name, b.Name);
                        var tb = (IMyTerminalBlock)b;
                        MyAPIGateway.Utilities.ShowNotification($"{block.CustomName} connected to {tb.CustomName} = {conn}", 16);
                    }
                }
            }
        }
    }
}
