﻿using System.IO;
using Sandbox.ModAPI;
using VRage.Game.Components;
using VRage.Utils;

namespace Digi.Bugtests
{
    [MySessionComponentDescriptor(MyUpdateOrder.AfterSimulation)]
    public class BugTest_WriteToWorldStorage : MySessionComponentBase
    {
        public override void LoadData()
        {
            MyLog.Default.WriteLine($"### BugTest world path in LoadData(): {MyAPIGateway.Session?.CurrentPath}");
            WriteFile("written from LoadData.txt");
        }

        public override void BeforeStart()
        {
            MyLog.Default.WriteLine($"### BugTest world path in BeforeStart(): {MyAPIGateway.Session?.CurrentPath}");
            WriteFile("written from BeforeStart.txt");
        }

        int WriteUpdates = 10;

        public override void UpdateAfterSimulation()
        {
            if(--WriteUpdates <= 0)
            {
                MyAPIGateway.Utilities.InvokeOnGameThread(() => SetUpdateOrder(MyUpdateOrder.NoUpdate));
                return;
            }

            MyLog.Default.WriteLine($"### BugTest world path in UpdateAfterSimulation(): {MyAPIGateway.Session?.CurrentPath}");
            WriteFile($"written from UpdateAfterSimulation tick{WriteUpdates}.txt");
        }

        void WriteFile(string fileName)
        {
            using(TextWriter file = MyAPIGateway.Utilities.WriteFileInWorldStorage(fileName, typeof(BugTest_WriteToWorldStorage)))
            {
                file.Write("Hi :)");
            }
        }
    }
}