﻿
#if DEBUG
/*
References needed;
SpaceEngineers.Game.dll
SpaceEngineers.ObjectBuilders.dll
Sandbox.Game.dll
Sandbox.Common.dll
VRage.dll
VRage.Game.dll
VRage.Library.dll
VRage.Math.dll
*/
using System;
using System.Linq;
using System.Text;
using System.Collections;
using System.Collections.Generic;
//using System.Threading.Tasks;

using VRageMath;
using VRage.Game;
using VRage.Collections;
using VRage.Game.Components;
using VRage.Game.ModAPI.Ingame;
using VRage.Game.ObjectBuilders.Definitions;
using Sandbox.ModAPI.Ingame;
using Sandbox.ModAPI.Interfaces;
using Sandbox.Game.EntityComponents;
using SpaceEngineers.Game.ModAPI.Ingame;

namespace ClassLibrary_RotorTest
{
    public sealed class Program : MyGridProgram
    {
        //use MyGridProgram.GridTerminalSystem;
#endif
        // The constructor, Use it to initialize your script.
        public Program()
        {

            //Sets Update Frequency
            Runtime.UpdateFrequency = UpdateFrequency.Update10;

            // Creates User Interface
            try
            {
                Me.CustomData = "The custom data output is Here: \n" +
                    "===========================\n" +
                    "Instructions:\n" +
                    "===========================\n" +
                    "This is where there will be useful information about setting up and using this script.\n" +
                    "Errors Will be displayed in the terminal\n\n" +
                    "Hints/Tips:\n" +
                    "===========================\n";
            }
            catch
            { }
        }
        

        float rotorPreLowerLimit = 0;
        float rotorPreUpperLimit = 0;
        float rotorPreDisplacement = 0;

        float rotorPostLowerLimit = 0;
        float rotorPostUpperLimit = 0;
        float rotorPostDisplacement = 0;

        //const float rotor_no_upper_limit = float.MaxValue;
        //const float rotor_no_lower_limit = float.MinValue;
        const float rotor_no_upper_limit = (float)361;
        const float rotor_no_lower_limit = (float)-361;

        IMyMotorStator test_rotor;

        // The main entry point of the script, invoked every time
        // one of the programmable block's Run actions are invoked.
        public void Main(string args)
        {
            List<IMyTerminalBlock> rotors = new List<IMyTerminalBlock>();

            // Terminal output
            Echo_Title();

            if (test_rotor == null)
            {
                // Find rotor
                GridTerminalSystem.GetBlocksOfType<IMyMotorStator>(rotors, b => (b.CustomName.Contains("Rotor Test") == true));
                //Echo("Found " + rotors.Count + " Tracker Rotors");

                if (rotors.Count >= 0)
                {
                    test_rotor = rotors[0] as IMyMotorStator;

                    if (test_rotor != null)
                    {
                        // debug no-limit, pre set before teh script ran, can be manually set.
                        rotorPreLowerLimit = test_rotor.LowerLimitDeg;
                        rotorPreUpperLimit = test_rotor.UpperLimitDeg;
                        rotorPreDisplacement = test_rotor.Displacement;

                        Echo("Test rotor found");
                        Enter_Scanning(test_rotor, 6.0f);
                        
                        // debug no-limit, pre set before the script ran
                        rotorPostLowerLimit = test_rotor.LowerLimitDeg;
                        rotorPostUpperLimit = test_rotor.UpperLimitDeg;
                        rotorPostDisplacement = test_rotor.Displacement;
                    }
                }
            }

            // Sone test debug
            Echo("Rotor settings pre-script:");
            Echo("Rotor lower limit = " + rotorPreLowerLimit.ToString());
            Echo("Rotor upper limit = " + rotorPreUpperLimit.ToString());
            Echo("Rotor displacement = " + rotorPreDisplacement.ToString());

            Echo("Rotor settings post-script:");
            Echo("Rotor lower limit = " + rotorPostLowerLimit.ToString());
            Echo("Rotor upper limit = " + rotorPostUpperLimit.ToString());
            Echo("Rotor displacement = " + rotorPostDisplacement.ToString());
            Echo("");
            Echo("Rotor angle = " + rotorAngle(test_rotor));
        }

        // Called when the program needs to save its state. Use
        // this method to save your state to the Storage field
        // or some other means.
        public void Save()
        {
        }

        /********************************************************************/
                
        void Enter_Scanning(IMyMotorStator rotor, float velocity, float upper_limit = rotor_no_upper_limit, float lower_limit = rotor_no_lower_limit)
        {
            if (rotor != null)
            {
                rotor.BrakingTorque = 150000;
                rotor.Enabled = false;
                rotor.Torque = 100000;
                rotor.TargetVelocityRPM = velocity;
                rotor.UpperLimitDeg = upper_limit;
                rotor.LowerLimitDeg = lower_limit;
                rotor.RotorLock = false;
                rotor.Displacement = 0.0f;

                // Enable in the correct operating mode
                rotor.Enabled = true;
            }
        }

        float rotorAngle(IMyMotorStator rotor)
        {
            return rotor.Angle * 360f / (2f * (float)Math.PI);
        }

        ////////////////////////////////
        // Debug

        // Terminal running script indication
        string[] FUNCTION_BAR = new string[] { "/", "=", "\\", "|", "/", "-" };
        int FUNCTION_TIMER = 0;

        void Echo_Title()
        {
            Echo("    " + FUNCTION_BAR[FUNCTION_TIMER] + " ~ Test Script running ~ " + FUNCTION_BAR[FUNCTION_TIMER] + "\n");
            if (++FUNCTION_TIMER >= FUNCTION_BAR.Length)
            {
                FUNCTION_TIMER = 0;
            }
        }
#if DEBUG
    }
}
#endif

