using System;
using System.Linq;
using Sandbox.Game.Entities;
using Sandbox.ModAPI;
using VRage.Game.Components;
using VRage.Game.Entity;
using VRage.Utils;

namespace Digi.Experiments
{
    [MySessionComponentDescriptor(MyUpdateOrder.NoUpdate)]
    public class Test_GetEntityByIdThread : MySessionComponentBase
    {
        public override void BeforeStart()
        {
            MyEntity ent = MyEntities.GetEntities().FirstOrDefault();

            if(ent == null)
            {
                MyLog.Default.WriteLine($"### {GetType().Name}: Invalid world for testing, need at least one entity!");
                return;
            }

            MyLog.Default.WriteLine($"### {GetType().Name}: Test main-thread #{Environment.CurrentManagedThreadId}: {(ent != null ? "OK" : "FAIL")}");

            MyAPIGateway.Parallel.Start(() =>
            {
                ent = MyEntities.GetEntityById(ent.EntityId);

                MyLog.Default.WriteLine($"### {GetType().Name}: Test other thread #{Environment.CurrentManagedThreadId}: {(ent != null ? "OK" : "FAIL")}");
            });
        }
    }
}
