﻿using Sandbox.Common.ObjectBuilders;
using Sandbox.ModAPI;
using VRage.Game.Components;
using VRage.ObjectBuilders;

namespace Digi.Experiments
{
    [MyEntityComponentDescriptor(typeof(MyObjectBuilder_UpgradeModule), false)]
    public class Test1 : MyGameLogicComponent
    {
        public override void Init(MyObjectBuilder_EntityBase objectBuilder)
        {
            MyAPIGateway.Utilities.ShowMessage(GetType().Name, "Init()");
        }

        public override void OnAddedToScene()
        {
            // issue is this never triggers if entity has 2+ gamelogics
            // same with OnRemovedFromScene() too
            MyAPIGateway.Utilities.ShowMessage(GetType().Name, "OnAddedToScene()");
        }
    }

#if true // set this to false and re-test, now OnAddedToScene() will trigger since it's only one gamelogic present
    [MyEntityComponentDescriptor(typeof(MyObjectBuilder_UpgradeModule), false)]
    public class Test2 : MyGameLogicComponent
    {
        public override void Init(MyObjectBuilder_EntityBase objectBuilder)
        {
            MyAPIGateway.Utilities.ShowMessage(GetType().Name, "Init()");
        }

        public override void OnAddedToScene()
        {
            MyAPIGateway.Utilities.ShowMessage(GetType().Name, "OnAddedToScene()");
        }
    }
#endif
}
