using Sandbox.Common.ObjectBuilders;
using Sandbox.Game;
using Sandbox.Game.Entities;
using Sandbox.Game.Entities.Blocks;
using Sandbox.Game.Entities.Character;
using Sandbox.Game.EntityComponents;
using Sandbox.Game.World;
using Sandbox.ModAPI;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using VRage.Game;
using VRage.Game.Components;
using VRage.Game.Entity;
using VRage.Game.ModAPI;
using VRage.ModAPI;
using VRage.ObjectBuilders;
using VRage.Utils;
using VRageMath;

namespace JSGTieredShipToolsMod_Welders
{
	[MyEntityComponentDescriptor(typeof(MyObjectBuilder_ShipWelder), false, "LargeShipWelder", "SmallShipWelder", "JSGLargeShipWelderT1", "JSGSmallShipWelderT1", "JSGLargeShipWelderT2", "JSGSmallShipWelderT2", "JSGLargeShipWelderT3", "JSGSmallShipWelderT3", "JSGLargeShipWelderT4", "JSGSmallShipWelderT4")]

	public class JSG_Script_TieredWelders : MyGameLogicComponent
    {
        private IMyCubeBlock CubeBlock; // storing the entity as a block reference to avoid re-casting it every time it's needed, this is the lowest type a block entity can be.
        private IMyFunctionalBlock FunctionalBlock;
        private IMyTerminalBlock TerminalBlock;
        private IMyShipWelder IMyBlock;
		private string BlockDef;


        public override void Close()
        {
			BlockCleanup();
        }

        public override void Init(MyObjectBuilder_EntityBase objectBuilder)
        {
            base.Init(objectBuilder);

            CubeBlock = (IMyCubeBlock)Entity;
            FunctionalBlock = (IMyFunctionalBlock)Entity;
            IMyBlock = (IMyShipWelder)Entity;
            TerminalBlock = (IMyTerminalBlock)Entity;
			BlockDef = IMyBlock.BlockDefinition.SubtypeId.ToString();
			
			UpdateSettings(IMyBlock);
        }

        public override void MarkForClose()
        {
			BlockCleanup();
        }

        public override void UpdateAfterSimulation()
        {

        }

        public override void UpdateAfterSimulation10()
        {

        }

        public override void UpdateAfterSimulation100()
        {

        }

        public override void UpdateBeforeSimulation()
        {

        }

        public override void UpdateBeforeSimulation10()
        {

        }

        public override void UpdateBeforeSimulation100()
        {
            base.UpdateAfterSimulation100();

        }

        public override void UpdateOnceBeforeFrame()
        {

        }
		
		public void BlockCleanup()
        {
			NeedsUpdate = MyEntityUpdateEnum.NONE;
		}
		
		private void UpdateSettings(IMyCubeBlock _) 
		{
			double BasePower = 0.002; // Vanilla Block Max Power
			double TierMultiplierWeight = 1; // How big of a multiplier we add per TierMultiplier. Affects Vanilla as well
			double PercentageOfMaxPower = 1; // Get slider input of block function, otherwise set to 1

			// Dont change Variables Below. Edit in the Switch.
			double Power; // BasePower * PowerMultiplier
			double TierMultiplier; // Multiplier from vanilla block. Exampel: T1 = 2x vanilla | T2 = 2x T1 = 4x Vanilla
			double PowerMultiplier; // TierMultiplier * TierMultiplierWeight

			switch (BlockDef)
			{
				case "JSGLargeShipWelderT4": case "JSGSmallShipWelderT4":
					TierMultiplier = 16;
					break;

				case "JSGLargeShipWelderT3": case "JSGSmallShipWelderT3":
					TierMultiplier = 8;
					break;

				case "JSGLargeShipWelderT2": case "JSGSmallShipWelderT2":
					TierMultiplier = 4;
					break;

				case "JSGLargeShipWelderT1": case "JSGSmallShipWelderT1":
					TierMultiplier = 2;
					break;

				default:
					TierMultiplier = 1;
					break;

			}
			if (BlockDef.Contains("Large"))
			{
				TierMultiplierWeight = 30;
			}
			else if (BlockDef.Contains("Small"))
			{
				TierMultiplierWeight = 10;
			}

			PowerMultiplier = TierMultiplier * TierMultiplierWeight;
			Power = BasePower * PowerMultiplier;
			SetPowerSettings(Power, PercentageOfMaxPower);
		}
		
		private void SetPowerSettings (double MaxPower, double MultiplyValue)
        {
			try
			{
				var sink = Entity.Components.Get<MyResourceSinkComponent>();
				if (sink == null)
				{
					return;
				}

				double Math = MaxPower * MultiplyValue;
				float PowerRequired = (float)Math;


				sink.SetMaxRequiredInputByType(MyResourceDistributorComponent.ElectricityId, PowerRequired);
				sink.Update();
			}
			catch (Exception e)
			{
				MyLog.Default.WriteLine(e);
				MyAPIGateway.Utilities.ShowNotification($"[ Error in {GetType().FullName}: {e.Message} ]", 10000, MyFontEnum.Red);
			}
		}
	}
}


//Mod: JSGaming - Tiered Ship Tools
//Owner and Creator: JSGaming (Jorin91, Jorin)
//Modification, duplication or distribution of any data (code, files, images and so on) in this modpack in any way is prohibited without permission!