﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using UIFun.Interface;
using UIFun.Messagesv2;
using VRageMath;

namespace UIFun.StringProcessor
{
	public static class ColorReader
	{

		static readonly char[] key = new char[7] { '<', 'c', 'o', 'l', 'o', 'r', '=' };
		static int[] colors = new int[4];
 		static char[] ColorReaderBuffer = new char[21];
		const char seperator = ',';
		static CultureInfo CompairsonCulture = new CultureInfo("en-US");
		static Dictionary<char[], Color> ColorComparitor = new Dictionary<char[], Color>();
		static bool ColorListInit = false;
		
		internal static bool TryReadTag(char[] Buffer, int start, int max, out int indexincrease, out Vector4 colorOut)
		{
			if (!ColorListInit)
				InitColors();
			indexincrease = 0;
			colorOut = Color.White.ToVector4();
			bool hasSeperator = false;
			bool foundEndTag = false;


			if(start + 7 > max)
			{
				return false;
			}
			int i = 0;
			for(; i < 7; i++)
			{
				if(char.ToLower(Buffer[start + i], CompairsonCulture) != key[i])
				{
					return false;
				}
			}
			indexincrease += 7;
			start += i;
			i = 0;
			for(; i < 21; i++)
			{
				if(start + i > max || foundEndTag)
				{
					ColorReaderBuffer[i] = '\0';
					continue;
				}
				char BufferChar = char.ToLower(Buffer[start + i], CompairsonCulture);
				if(BufferChar == seperator)
				{
					hasSeperator = true;
					break;//go process type b.
				}
				if(BufferChar == '>')
				{
					foundEndTag = true;
					ColorReaderBuffer[i] = '\0';
					indexincrease += i;
                    continue;
				}
				ColorReaderBuffer[i] = BufferChar;
            }
			//if we dont have a seperator lets get the color and return it

			if(!hasSeperator)
			{
				if (!foundEndTag)
				{
					if (start + i > max)
                    {
						indexincrease = 0;
                        return false;
					}
					var EndTagTest = Buffer[start + i];
					if (EndTagTest != '>')
					{
						indexincrease = 0;
						return false;
					}
					else
					{
						indexincrease += i;
						foundEndTag = true;
					}
				}

				Color foundColor;
				if(TryGetColor(ColorReaderBuffer, out foundColor))
				{
					colorOut = foundColor.ToVector4();
					return true;
				}
				return false;//no color found
			}

			//we found a seperator
			int color = 0;
			int currentcolor = 0;
			i = 0;
			colors[0] = colors[1] = colors[2] = colors[3] = 255;
			for (; i < 21 && start + i <= max; i++)
			{
				char BufferChar = char.ToLower(Buffer[start + i], CompairsonCulture);
				if (BufferChar == seperator)
				{
					colors[color] = currentcolor;
					color++;
					currentcolor = 0;
					continue;
				}
				if (BufferChar == '>')
				{
					foundEndTag = true;
					indexincrease += i;
					colors[color] = currentcolor;
					color++;
					break;
				}
				if(char.IsNumber(BufferChar))
				{
					currentcolor *= 10;
					currentcolor += BufferChar - '0';
                }

			}
			if(color >= 3)
			{
				if(!foundEndTag)
				{
					if (start + i > max)
					{
						return false;
					}
					var EndTagTest = Buffer[start + i];
					if (EndTagTest != '>')
					{
						indexincrease = 0;
						return false;
					}
					else
					{
						indexincrease += i;
					}
				}
				colorOut = new Color(colors[0], colors[1], colors[2], colors[3]).ToVector4();
                return true;
			}
			return false;
		}

		private static void InitColors()
		{
			Dictionary<string, Color> ColorList = new Dictionary<string, Color>();
			ColorListInit = true;
			ColorList.Add("aliceblue", Color.AliceBlue);
			ColorList.Add("antiquewhite", Color.AntiqueWhite);
			ColorList.Add("aqua", Color.Aqua);
			ColorList.Add("aquamarine", Color.Aquamarine);
			ColorList.Add("azure", Color.Azure);
			ColorList.Add("beige", Color.Beige);
			ColorList.Add("bisque", Color.Bisque);
			ColorList.Add("black", Color.Black);
			ColorList.Add("blanchedalmond", Color.BlanchedAlmond);
			ColorList.Add("blue", Color.Blue);
			ColorList.Add("blueviolet", Color.BlueViolet);
			ColorList.Add("brown", Color.Brown);
			ColorList.Add("burlywood", Color.BurlyWood);
			ColorList.Add("badetblue", Color.CadetBlue);
			ColorList.Add("chartreuse", Color.Chartreuse);
			ColorList.Add("chocolate", Color.Chocolate);
			ColorList.Add("coral", Color.Coral);
			ColorList.Add("cornflowerblue", Color.CornflowerBlue);
			ColorList.Add("cornsilk", Color.Cornsilk);
			ColorList.Add("crimson", Color.Crimson);
			ColorList.Add("cyan", Color.Cyan);
			ColorList.Add("darkblue", Color.DarkBlue);
			ColorList.Add("darkcyan", Color.DarkCyan);
			ColorList.Add("darkgoldenrod", Color.DarkGoldenrod);
			ColorList.Add("darkgray", Color.DarkGray);
			ColorList.Add("darkgreen", Color.DarkGreen);
			ColorList.Add("darkkhaki", Color.DarkKhaki);
			ColorList.Add("darkmagenta", Color.DarkMagenta);
			ColorList.Add("darkoliveGreen", Color.DarkOliveGreen);
			ColorList.Add("darkorange", Color.DarkOrange);
			ColorList.Add("darkorchid", Color.DarkOrchid);
			ColorList.Add("darkred", Color.DarkRed);
			ColorList.Add("darksalmon", Color.DarkSalmon);
			ColorList.Add("darkseagreen", Color.DarkSeaGreen);
			ColorList.Add("darkslateblue", Color.DarkSlateBlue);
			ColorList.Add("darkslategray", Color.DarkSlateGray);
			ColorList.Add("darkturquoise", Color.DarkTurquoise);
			ColorList.Add("darkviolet", Color.DarkViolet);
			ColorList.Add("deeppink", Color.DeepPink);
			ColorList.Add("deepskyblue", Color.DeepSkyBlue);
			ColorList.Add("dimgray", Color.DimGray);
			ColorList.Add("dodgerblue", Color.DodgerBlue);
			ColorList.Add("firebrick", Color.Firebrick);
			ColorList.Add("floralwhite", Color.FloralWhite);
			ColorList.Add("forestgreen", Color.ForestGreen);
			ColorList.Add("fuchsia", Color.Fuchsia);
			ColorList.Add("gainsboro", Color.Gainsboro);
			ColorList.Add("ghostwhite", Color.GhostWhite);
			ColorList.Add("gold", Color.Gold);
			ColorList.Add("goldenrod", Color.Goldenrod);
			ColorList.Add("gray", Color.Gray);
			ColorList.Add("green", Color.Green);
			ColorList.Add("greenyellow", Color.GreenYellow);
			ColorList.Add("doneydew", Color.Honeydew);
			ColorList.Add("hotpink", Color.HotPink);
			ColorList.Add("indianred", Color.IndianRed);
			ColorList.Add("indigo", Color.Indigo);
			ColorList.Add("ivory", Color.Ivory);
			ColorList.Add("khaki", Color.Khaki);
			ColorList.Add("lavender", Color.Lavender);
			ColorList.Add("lavenderblush", Color.LavenderBlush);
			ColorList.Add("lawngreen", Color.LawnGreen);
			ColorList.Add("lemonchiffon", Color.LemonChiffon);
			ColorList.Add("lightblue", Color.LightBlue);
			ColorList.Add("lightcoral", Color.LightCoral);
			ColorList.Add("lightcyan", Color.LightCyan);
			ColorList.Add("lightgoldenrodyellow",Color.LightGoldenrodYellow);
			ColorList.Add("lightgray", Color.LightGray);
			ColorList.Add("lightgreen", Color.LightGreen);
			ColorList.Add("lightpink", Color.LightPink);
			ColorList.Add("lightsalmon", Color.LightSalmon);
			ColorList.Add("lightseagreen", Color.LightSeaGreen);
			ColorList.Add("lightskyblue", Color.LightSkyBlue);
			ColorList.Add("lightslategray", Color.LightSlateGray);
			ColorList.Add("lightsteelblue", Color.LightSteelBlue);
			ColorList.Add("lightyellow", Color.LightYellow);
			ColorList.Add("lime", Color.Lime);
			ColorList.Add("limegreen", Color.LimeGreen);
			ColorList.Add("linen", Color.Linen);
			ColorList.Add("magenta", Color.Magenta);
			ColorList.Add("maroon", Color.Maroon);
			ColorList.Add("mediumaquamarine", Color.MediumAquamarine);
			ColorList.Add("mediumblue", Color.MediumBlue);
			ColorList.Add("mediumorchid", Color.MediumOrchid);
			ColorList.Add("mediumpurple", Color.MediumPurple);
			ColorList.Add("mediumseagreen", Color.MediumSeaGreen);
			ColorList.Add("mediumslateblue", Color.MediumSlateBlue);
			ColorList.Add("mediumspringgreen", Color.MediumSpringGreen);
			ColorList.Add("mediumturquoise", Color.MediumTurquoise);
			ColorList.Add("mediumvioletred", Color.MediumVioletRed);
			ColorList.Add("midnightblue", Color.MidnightBlue);
			ColorList.Add("mintcream", Color.MintCream);
			ColorList.Add("mistyrose", Color.MistyRose);
			ColorList.Add("moccasin", Color.Moccasin);
			ColorList.Add("navajowhite", Color.NavajoWhite);
			ColorList.Add("navy", Color.Navy);
			ColorList.Add("oldlace", Color.OldLace);
			ColorList.Add("olive", Color.Olive);
			ColorList.Add("olivedrab", Color.OliveDrab);
			ColorList.Add("orange", Color.Orange);
			ColorList.Add("orangered", Color.OrangeRed);
			ColorList.Add("orchid", Color.Orchid);
			ColorList.Add("palegoldenrod", Color.PaleGoldenrod);
			ColorList.Add("palegreen", Color.PaleGreen);
			ColorList.Add("paleturquoise", Color.PaleTurquoise);
			ColorList.Add("palevioletred", Color.PaleVioletRed);
			ColorList.Add("papayawhip", Color.PapayaWhip);
			ColorList.Add("peachpuff", Color.PeachPuff);
			ColorList.Add("peru", Color.Peru);
			ColorList.Add("pink", Color.Pink);
			ColorList.Add("plum", Color.Plum);
			ColorList.Add("powderblue", Color.PowderBlue);
			ColorList.Add("purple", Color.Purple);
			ColorList.Add("red", Color.Red);
			ColorList.Add("rosybrown", Color.RosyBrown);
			ColorList.Add("royalblue", Color.RoyalBlue);
			ColorList.Add("saddlebrown", Color.SaddleBrown);
			ColorList.Add("salmon", Color.Salmon);
			ColorList.Add("sandybrown", Color.SandyBrown);
			ColorList.Add("seagreen", Color.SeaGreen);
			ColorList.Add("seashell", Color.SeaShell);
			ColorList.Add("sienna", Color.Sienna);
			ColorList.Add("silver", Color.Silver);
			ColorList.Add("skyblue", Color.SkyBlue);
			ColorList.Add("slateblue", Color.SlateBlue);
			ColorList.Add("slategray", Color.SlateGray);
			ColorList.Add("snow", Color.Snow);
			ColorList.Add("springgreen", Color.SpringGreen);
			ColorList.Add("steelblue", Color.SteelBlue);
			ColorList.Add("tan", Color.Tan);
			ColorList.Add("teal", Color.Teal);
			ColorList.Add("thistle", Color.Thistle);
			ColorList.Add("tomato", Color.Tomato);
			ColorList.Add("turquoise", Color.Turquoise);
			ColorList.Add("violet", Color.Violet);
			ColorList.Add("wheat", Color.Wheat);
			ColorList.Add("white", Color.White);
			ColorList.Add("whitesmoke", Color.WhiteSmoke);
			ColorList.Add("yellow", Color.Yellow);
			ColorList.Add("yellowgreen", Color.YellowGreen);
			
			foreach (var item in ColorList)
			{
				char[] chararray = new char[21];
				int i = 0;
				for (; i < item.Key.Length; i++)
				{
					chararray[i] = item.Key[i];
				}
				for (; i < 21; i++)
				{
					chararray[i] = '\0';
				}
				ColorComparitor.Add(chararray, item.Value);
			}
		}

		public static bool TryGetColor(char[] Buffer, out Color foundColor)
		{
			foreach(var item in ColorComparitor)
			{
				bool match = true;
                for (int i = 0; i < 21; i++)
				{
					
					if(item.Key[i] != Buffer[i])
					{
						match = false;
						break;
					}
					if(Buffer[i] == '\0')
					{
						break;
					}
				}
				if (!match)
				{
					continue;
				}
				
				foundColor = item.Value;
                return true;
			}

			foundColor = Color.White;
			return false;
		}
	}
}
