﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using UIFun.Messagesv2;
using VRage.Utils;
using VRageMath;
using BlendTypeEnum = VRageRender.MyBillboard.BlendTypeEnum;

namespace UIFun.Menu
{
	class HudButton : MenuObject
	{
		StringBuilder M_ButtonText;
		ModHUDMessage ButtonText = new ModHUDMessage();
		ModBillboardHUDMessage ButtonBackground = new ModBillboardHUDMessage();
		int m_RightSpacing = 0;
		int m_Padding = 0;
		double SCALE = 1.75d;
		public HudButton(Vector2D position, bool visible = true, MenuObject parent = null, Action mouseOver = null, Action onClick = null, string text = null, int rightspacing = 0, int padding = 0) : base(position, visible, parent, mouseOver, onClick)
		{
			
            ButtonText.Visible = true;
			ButtonText.Options = Options.None;
			ButtonText.Scale = SCALE;
			ButtonText.Blend = BlendTypeEnum.PostPP;
			//ButtonText.Origin = position;
			//ButtonBackground.Origin = position;
			ButtonText.Origin = ScreenPosition();
			ButtonBackground.Origin = ScreenPosition();
			ButtonBackground.Visible = true;
			ButtonBackground.Options = Options.Shadowing;
			ButtonBackground.BillBoardColor = Color.Black * 0.4f;
			ButtonBackground.Material = MyStringId.GetOrCompute("Square");
			ButtonBackground.Blend = BlendTypeEnum.PostPP;
			m_RightSpacing = rightspacing;
			m_Padding = padding;
			if (text != null)
				SetText(text);
		

		}
		public void SetText(string text)
		{
			ButtonText.Message.Clear();
			ButtonText.Message.Append("<color=white>");
            if (text != null)
				ButtonText.Message.Append(text);
			Refresh();

		}
		public override void Refresh()
		{
			ButtonText.hasCache = false;

			Vector2D ln = ButtonText.GetLength();
			Vector2D size = ln;
			size.X += FontTexture.xSPPix * m_RightSpacing;

			Size = size;

			ButtonBackground.Offset = ln / 2;
			ButtonBackground.Width = (float)(ln.X + FontTexture.xSPPix * m_Padding);
			ButtonBackground.Height = (float)(ln.Y + -FontTexture.ySPPix * m_Padding);

			base.Refresh();
		}
		public override void Draw()
		{
			if (!Visible)
				return;
			if (m_MouseHover)
				ButtonBackground.BillBoardColor = Color.Black * 0.5f;
			else
				ButtonBackground.BillBoardColor = Color.Black * 0.4f;
			if(m_isSelected)
			{
				ButtonBackground.BillBoardColor = Color.Blue * 0.6f;
			}
			if (Parent != null)
			{
				Parent.IsActive = m_isSelected;
			}
			ButtonBackground.Draw();
			ButtonText.Draw();

			//ModUI.Debug.Message.AppendLine(Size.X.ToString());
			//ModUI.Debug.Message.AppendLine(Size.Y.ToString());
			base.Draw();
		}

		public override void OnClick(Vector2D Position)
		{
			base.OnClick(Position);
			if(Parent != null)
			{
				Parent.IsActive = m_isSelected;
			}
		}

		public override void SetOffset(Vector2D offset)
		{

			//Offset.X = offset.X;
			//Offset.Y = 0;

		}
		public override void UpdateBounds()
		{
			if (Parent != null)
			{
				this.Offset = Vector2D.Zero;
				this.Offset.X = Parent.Size.X;
			}
			base.UpdateBounds();
			ButtonText.Origin = ScreenPosition();
			ButtonBackground.Origin = ScreenPosition();
		}

	}
}
