﻿using Sandbox.ModAPI;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using UIFun.Messagesv2;
using VRage.Collections;
using VRage.Utils;
using VRageMath;
using BlendTypeEnum = VRageRender.MyBillboard.BlendTypeEnum;

namespace UIFun.Menu.Dialog
{
	public class SliderDialog : DialogBox
	{
		StringBuilder EnteredText = new StringBuilder();
		ModHUDMessage Title = new ModHUDMessage();
		ModHUDMessage TextInput = new ModHUDMessage();
		ModHUDMessage CancelButton = new ModHUDMessage();
		ModHUDMessage ConfirmButton = new ModHUDMessage();
		ModBillboardHUDMessage CancelBackground = new ModBillboardHUDMessage();
		ModBillboardHUDMessage ConfirmBackground = new ModBillboardHUDMessage();
		ModBillboardHUDMessage BoxBackground = new ModBillboardHUDMessage();
		ModBillboardHUDMessage TitleBackground = new ModBillboardHUDMessage();
		ModBillboardHUDMessage Slider = new ModBillboardHUDMessage();
		ModBillboardHUDMessage SliderBox = new ModBillboardHUDMessage();
		float sliderposition = 0f;
		static StringBuilder CancelString = new StringBuilder("<color=red>Cancel  ");
		static StringBuilder ConfirmString = new StringBuilder("  <color=green>Confirm");
		//static StringBuilder DefaultInputColor = new StringBuilder("<color=darkgreen>");
		static MyStringId Background = MyStringId.GetOrCompute("Square");

		Action<float> SubmitAction;
		Func<float, object> SlidertoValue;
		Action CancelAction;

		bool selected = false;

		public object DefaultSliderValueConvert(float percent)
		{
			return MathHelper.Floor( (int)( percent * 100 ));
		}

		public SliderDialog()
		{
			TextInput.Message = EnteredText;
			SlidertoValue = DefaultSliderValueConvert;

            Title.Visible = true;
			TextInput.Visible = true;
			CancelButton.Visible = true;
			ConfirmButton.Visible = true;
			CancelBackground.Visible = true;
			ConfirmBackground.Visible = true;
			BoxBackground.Visible = true;
			TitleBackground.Visible = true;
			SliderBox.Visible = true;
			Slider.Visible = true;

			Title.Origin = Vector2D.Zero;
			TextInput.Origin = Vector2D.Zero;
			CancelButton.Origin = Vector2D.Zero;
			ConfirmButton.Origin = Vector2D.Zero;
			CancelBackground.Origin = Vector2D.Zero;
			ConfirmBackground.Origin = Vector2D.Zero;
			BoxBackground.Origin = Vector2D.Zero;
			TitleBackground.Origin = Vector2D.Zero;
			SliderBox.Origin = Vector2D.Zero;
			Slider.Origin = Vector2D.Zero;

			Title.Scale = 1.5d;
			TextInput.Scale = 1.5d;
			CancelButton.Scale = 1.5d;
			ConfirmButton.Scale = 1.5d;

			CancelButton.Message = CancelString;
			ConfirmButton.Message = ConfirmString;

			Title.Blend = BlendTypeEnum.PostPP;
			TextInput.Blend = BlendTypeEnum.PostPP;
			CancelButton.Blend = BlendTypeEnum.PostPP;
			ConfirmButton.Blend = BlendTypeEnum.PostPP;

			CancelBackground.BillBoardColor = Color.Black * 0.3f;
			CancelBackground.Blend = BlendTypeEnum.PostPP;
			CancelBackground.Material = Background;

			ConfirmBackground.BillBoardColor = Color.Black * 0.3f;
			ConfirmBackground.Blend = BlendTypeEnum.PostPP;
			ConfirmBackground.Material = Background;

			BoxBackground.BillBoardColor = Color.Black * 0.3f;
			BoxBackground.Blend = BlendTypeEnum.PostPP;
			BoxBackground.Material = Background;

			TitleBackground.BillBoardColor = Color.Blue * 0.3f + Color.Black * 0.5f;
			TitleBackground.Blend = BlendTypeEnum.PostPP;
			TitleBackground.Material = Background;

			SliderBox.Blend = BlendTypeEnum.PostPP;
			SliderBox.Material = Background;
			SliderBox.BillBoardColor = Color.Black * 0.5f;

			Slider.Blend = BlendTypeEnum.PostPP;
			Slider.Material = Background;
			Slider.BillBoardColor = Color.White;


			CancelBackground.Options = Options.Shadowing;
			ConfirmBackground.Options = Options.Shadowing;
			BoxBackground.Options = Options.Shadowing;
			TitleBackground.Options = Options.Shadowing;
			SliderBox.Options = Options.Shadowing;

			SubmitAction = null;

			//Refresh();
		}

		private void Refresh()
		{
			UpdateText();
			ConfirmButton.hasCache = false;
			CancelButton.hasCache = false;
            var ln = Title.GetLength();
			var inputln = TextInput.GetLength();
			var confirmln = ConfirmButton.GetLength();
			var cancelln = CancelButton.GetLength();
			var maxX = ln.X;
			if (confirmln.X + cancelln.X * 2.5 > maxX)
				maxX = (confirmln.X + cancelln.X) * 2.5;
			if (inputln.X > maxX)
				maxX = inputln.X;

			Title.Offset = Vector2D.Zero;
			TextInput.Offset = new Vector2D(0, ln.Y*2);
			ConfirmButton.Offset = new Vector2D(cancelln.X, ln.Y * 3d);
			CancelButton.Offset = new Vector2D(0, ln.Y * 3d);

			TitleBackground.Offset = new Vector2D(maxX / 2d, (ln / 2).Y);
			TitleBackground.Width = (float)maxX;
			TitleBackground.Height = (float)ln.Y;

			ConfirmBackground.Offset = (confirmln / 2) + ConfirmButton.Offset;
			ConfirmBackground.Width = (float)confirmln.X;
			ConfirmBackground.Height = (float)confirmln.Y;

			CancelBackground.Offset = (cancelln / 2) + CancelButton.Offset;
			CancelBackground.Width = (float)cancelln.X;
			CancelBackground.Height = (float)cancelln.Y;

			BoxBackground.Offset = new Vector2D(maxX / 2d, ln.Y * 2d );
			BoxBackground.Width = (float)maxX;
			BoxBackground.Height = (float)inputln.Y * 4f;

			SliderBox.Height = (float)cancelln.Y / 2f;
			SliderBox.Width = (float)(maxX);
			SliderBox.Offset = new Vector2D(maxX / 2f, ln.Y * 1.5d);

			Slider.Height = (float)cancelln.Y / 1.9f;
			Slider.Width = (float)(maxX) / 10f;
			Slider.Offset = new Vector2D(MathHelper.Lerp(0 + maxX / 20d, (float)(maxX) - maxX / 20d, sliderposition), ln.Y * 1.5d);
			
        }

		public void Request(StringBuilder title, Action<float> callback, float initialvalue, Func<float, object> SliderValueConvert, Action OnCancel)
		{
			Reset();
			if(SliderValueConvert != null)
			{
				SlidertoValue = SliderValueConvert;
            }
			sliderposition = MathHelper.Clamp(initialvalue, 0f, 1f);//cant assume a max value of 1. 
			Active = true;
			Title.Message = title;
			SubmitAction = callback;
			CancelAction = OnCancel;
			EnteredText.Clear();
			Refresh();
		}

		public override void onClick(Vector2D MousePosition, bool left, bool right)
		{
			base.onClick(MousePosition, left, right);
			if (!left)
				return;
			//MyAPIGateway.Utilities.ShowMessage("OnClick", "In Input " + Position.ToString());
			var ln = CancelButton.GetLength();
			var xstart = SliderBox.Origin.X;
			var totalx = SliderBox.Width + SliderBox.Origin.X;
            var pos = CancelButton.Origin + CancelButton.Offset;
			var pos2 = pos + ln;
			BoundingBox2D Area = new BoundingBox2D(new Vector2D(pos.X, pos2.Y), new Vector2D(pos2.X, pos.Y));
			if (Area.Contains(MousePosition) == ContainmentType.Contains)
			{
				Cancel();
			}
			ln = ConfirmButton.GetLength();

			pos = ConfirmButton.Origin + ConfirmButton.Offset;
			pos2 = pos + ln;
			Area = new BoundingBox2D(new Vector2D(pos.X, pos2.Y), new Vector2D(pos2.X, pos.Y));
			if (Area.Contains(MousePosition) == ContainmentType.Contains)
			{
				Submit();
			}
			if (MousePosition.X > xstart
				&& MousePosition.X < totalx 
				&& MousePosition.Y < SliderBox.Origin.Y + SliderBox.Offset.Y - SliderBox.Height
				&& MousePosition.Y > SliderBox.Origin.Y + SliderBox.Offset.Y + SliderBox.Height)
			{
				selected = true;
			}
        }

		public override void onMouseRelease(Vector2D MousePosition, bool left, bool right)
		{
			if (!left)
				return;
			if (selected)
				selected = false;
			base.onMouseRelease(MousePosition, left, right);
		}

		public override void onMouseOver(Vector2D MousePosition)
		{
			if(selected)
			{
				var xstart = SliderBox.Origin.X + (SliderBox.Width / 20f);
				var totalx = xstart + SliderBox.Width - (SliderBox.Width / 10f);
				var perc = MousePosition.X - xstart;
				sliderposition = MathHelper.Lerp(0f, 1f, (float)(perc / totalx));
				sliderposition = MathHelper.Clamp(sliderposition, 0f, 1f);
				Slider.Offset.X = MathHelper.Lerp(xstart, totalx, sliderposition);
				UpdateText();
			}
			base.onMouseOver(MousePosition);
		}

		private void UpdateText()
		{
			EnteredText.Clear();
			EnteredText.Append(SlidertoValue(sliderposition));
		}

		public override void Cancel()
		{
			if (CancelAction != null)
				CancelAction();
			Reset();
			base.Cancel();
		}

		public override void Reset()
		{
			CancelAction = null;
			SubmitAction = null;
			EnteredText.Clear();
			SlidertoValue = DefaultSliderValueConvert;
			Active = false;
		}

		public void Submit()
		{
			if (SubmitAction != null)
				SubmitAction(sliderposition);
			Reset();
			Active = false;
		}

		public override void Draw()
		{
			base.Draw();
			Title.Draw();
			TextInput.Draw();
			CancelButton.Draw();
			ConfirmButton.Draw();
			CancelBackground.Draw();
			ConfirmBackground.Draw();
			BoxBackground.Draw();
			TitleBackground.Draw();
			Slider.Draw();
			SliderBox.Draw();
		}
	}
}
