﻿using Sandbox.ModAPI;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using UIFun.Messagesv2;
using VRage.Input;
using VRage.Utils;
using VRageMath;
using BlendTypeEnum = VRageRender.MyBillboard.BlendTypeEnum;

namespace UIFun.Menu.Dialog
{
	public class ScreenInputDialog : DialogBox
	{
		static MyStringId Background = MyStringId.GetOrCompute("Square");
		ModBillboardHUDMessage BoxBackground = new ModBillboardHUDMessage();
		ModHUDMessage Title = new ModHUDMessage();
		Action<Vector2D> onConfirmCallback;
		Action<Vector2D> updateAction;
		Action onCancel;
		Vector2D Origin = Vector2D.Zero;
		Vector2D Size = Vector2D.Zero;
		Vector2D localoffset = Vector2D.Zero;
		bool selected = false;
		public ScreenInputDialog()
		{
			BoxBackground.Visible = true;
			Title.Visible = true;

			Title.Scale = 1.5d;

			Title.Blend = BlendTypeEnum.PostPP;

			BoxBackground.Material = Background;
			BoxBackground.Options = Options.Shadowing;
			BoxBackground.BillBoardColor = Color.Pink * 0.7f;
			BoxBackground.Blend = BlendTypeEnum.PostPP;


		}
		public void Request(StringBuilder title, Vector2D origin, Vector2D size, Action<Vector2D> callback, Action<Vector2D> update, Action Cancel)
		{
			Reset();
			Active = true;
			Title.Message = title;
			onConfirmCallback = callback;
			updateAction = update;
			Origin = origin;
			Size = size;
			onCancel = Cancel;
			Refresh();
		}
		public override void Reset()
		{
			onCancel = null;
			onConfirmCallback = null;
			updateAction = null;
			selected = false;
			Active = false;
		}
		public void Refresh()
		{

			Title.Origin = Origin;
			BoxBackground.Origin = Origin;
			BoxBackground.Offset = Size / 2d;
			
			BoxBackground.Width = (float)Size.X;
			BoxBackground.Height = (float)Size.Y;
		}
		public override void Draw()
		{
			Title.Draw();
			BoxBackground.Draw();
			base.Draw();
		}
		public override void onKeyPress(List<MyKeys> keys)
		{
			base.onKeyPress(keys);
			if (MyAPIGateway.Input.IsNewKeyReleased(MyKeys.Enter))
			{
				Cancel();
				return;
			}
			if (MyAPIGateway.Input.IsNewKeyReleased(MyKeys.Escape) || MyAPIGateway.Input.IsNewKeyReleased(MyKeys.Cancel))
			{
				Cancel();
				return;
			}
		}
		public override void onClick(Vector2D MousePosition, bool left, bool right)
		{
			base.onClick(MousePosition, left, right);
			if (!left)
				return;
			if (!selected)
			{
				/*var pos = BoxBackground.Origin;
				Vector2D m_Max, m_Min;

				var m_Size = Size;
				m_Max.X = pos.X + m_Size.X;
				m_Max.Y = pos.Y;
				m_Min.X = pos.X;
				m_Min.Y = pos.Y + m_Size.Y;
				if(m_Max.X < m_Min.X)
				{
					var temp = m_Max.X;
					m_Max.X = m_Min.X;
					m_Min.X = temp;
				}
				if (m_Max.Y < m_Min.Y)
				{
					var temp = m_Max.Y;
					m_Max.Y = m_Min.Y;
					m_Min.Y = temp;
				}
				if ((MousePosition.X <= m_Max.X) && (MousePosition.X >= m_Min.X) && (MousePosition.Y <= m_Max.Y) && (MousePosition.Y >= m_Min.Y))
				{*/
					localoffset = Title.Origin - MousePosition;
					selected = true;
				//}
			}
		}
		public override void onMouseRelease(Vector2D MousePosition, bool left, bool right)
		{
			if (!selected)
				return;
			if (!left)
				return;
			if(onConfirmCallback != null)
			{
				onConfirmCallback(MousePosition + localoffset);
				Reset();

			}

		}
		public override void onMouseOver(Vector2D MousePosition)
		{
			if (selected)
			{
				Title.Origin = MousePosition + localoffset;
				Title.hasCache = false;
				BoxBackground.Origin = MousePosition + localoffset;
				if(updateAction != null)
					updateAction(MousePosition + localoffset);
			}
		}
		public override void Cancel()
		{
			if (onCancel != null)
				onCancel();
			base.Cancel();
			Reset();
		}
	}
}