﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace UIFun.Menu.Api
{
	public class MenuSubCategory : MenuCategoryBase
	{
		MenuCategoryBase m_APIParent;

		public MenuCategoryBase APIParent
		{
			get
			{
				return m_APIParent;
			}

			set
			{
				if(m_APIParent != value)
				{
					m_APIParent = value;
					Register(value);
				}
			}
		}

		private enum MenuSubCategoryMembers : int
		{
			Parent = 200
		}

		public MenuSubCategory()
		{
			ScrollMenuItem.AddSubObject(ItemList);
		}

		public override object GetMember(int MemberEnum)
		{
			base.GetMember(MemberEnum);
			switch ((MenuSubCategoryMembers)MemberEnum)
			{
				case MenuSubCategoryMembers.Parent:
					return APIParent;
				default:
					return base.GetMember(MemberEnum);
			}
		}

		public override void SetMember(int MemberEnum, object Value)
		{
			switch ((MenuSubCategoryMembers)MemberEnum)
			{
				case MenuSubCategoryMembers.Parent:
					APIParent = (MenuCategoryBase)Value;
					return;
				default:
					base.SetMember(MemberEnum, Value);
					return;
			}
		}
	}
}
