﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VRageMath;

namespace UIFun.Menu.Api
{
	public class MenuScreenInput : MenuItemBase
	{
		Action<Vector2D> m_OnSubmit;
		Action m_OnCancel;
		Action m_OnSelect;
        MenuCategoryBase m_APIParent;
		StringBuilder DialogTitle = new StringBuilder();
		private Action<Vector2D> m_onUpdate;
		private Vector2D m_origin = Vector2D.Zero;
		private Vector2D m_size = Vector2D.Zero;
		private enum MenuScreenInputMembers : int
		{
			OnSubmitAction = 100,
			Parent,
			InputDialogTitle,
			Origin,
			Size,
			OnUpdateAction,
			Cancel,
			OnSelect
		}
		public MenuCategoryBase APIParent
		{
			get
			{
				return m_APIParent;
			}

			set
			{
				if (m_APIParent != value)
				{
					m_APIParent = value;
					Register(value);
				}
			}
		}
		public Action<Vector2D> OnSubmit
		{
			get
			{
				return m_OnSubmit;
			}

			set
			{
				if (m_OnSubmit != value)
				{
					m_OnSubmit = value;

				}
			}

		}
		public Action OnCancel
		{
			get
			{
				return m_OnCancel;
			}

			set
			{
				if (m_OnCancel != value)
				{
					m_OnCancel = value;

				}
			}

		}
		public Action OnSelect
		{
			get
			{
				return m_OnSelect;
			}

			set
			{
				if (m_OnSelect != value)
				{
					m_OnSelect = value;

				}
			}

		}
		public Action<Vector2D> OnUpdate
		{
			get
			{
				return m_onUpdate;
			}

			set
			{
				if (m_onUpdate != value)
				{
					m_onUpdate = value;

				}
			}

		}
		public Vector2D Origin
		{
			get
			{
				return m_origin;
			}
			set
			{
				m_origin = value;
			}

		}
		public Vector2D Size
		{
			get
			{
				return m_size;
			}
			set
			{
				m_size = value;
			}

		}
		public string DialogText
		{
			get
			{
				return DialogTitle.ToString();
			}
			set
			{
				if (DialogTitle.ToString() != value)
				{
					DialogTitle.Clear();
					DialogTitle.Append(value);
				}
			}
		}


		public MenuScreenInput()
		{
			ScrollMenuItem.Selectable = false;
			ScrollMenuItem.OnClickCallback = PromoteDialog;
		}
		public void PromoteDialog()
		{
			if (m_OnSelect != null)
				m_OnSelect();
			FontTexture.PromoteScreenInputDialog(DialogTitle, m_origin, m_size, m_OnSubmit, m_onUpdate, m_OnCancel);
		}
		public override object GetMember(int MemberEnum)
		{
			switch ((MenuScreenInputMembers)MemberEnum)
			{
				case MenuScreenInputMembers.OnSubmitAction:
					return OnSubmit;
				case MenuScreenInputMembers.Parent:
					return APIParent;
				case MenuScreenInputMembers.InputDialogTitle:
					return DialogText;
				case MenuScreenInputMembers.Origin:
					return Origin;
				case MenuScreenInputMembers.Size:
					return Size;
				case MenuScreenInputMembers.OnUpdateAction:
					return OnUpdate;
				case MenuScreenInputMembers.Cancel:
					return OnCancel;
				case MenuScreenInputMembers.OnSelect:
					return OnSelect;
				default:
					return base.GetMember(MemberEnum);
			}
		}

		public override void SetMember(int MemberEnum, object Value)
		{
			switch ((MenuScreenInputMembers)MemberEnum)
			{
				case MenuScreenInputMembers.OnSubmitAction:
					OnSubmit = (Action<Vector2D>)Value;
					return;
				case MenuScreenInputMembers.Parent:
					APIParent = (MenuCategoryBase)Value;
					return;
				case MenuScreenInputMembers.InputDialogTitle:
					DialogText = (string)Value;
					return;
				case MenuScreenInputMembers.Origin:
					Origin = (Vector2D)Value;
					return;
				case MenuScreenInputMembers.Size:
					Size = (Vector2D)Value;
					return;
				case MenuScreenInputMembers.OnUpdateAction:
					OnUpdate = (Action<Vector2D>)Value;
					return;
				case MenuScreenInputMembers.Cancel:
					OnCancel = (Action)Value;
					return;
				case MenuScreenInputMembers.OnSelect:
					OnSelect = (Action)Value;
					return;
				default:
					base.SetMember(MemberEnum, Value);
					return;
			}
		}
	}
}
