﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VRage.Input;

namespace UIFun.Menu.Api
{
	public class MenuKeybindItem : MenuItemBase
	{
		Action<MyKeys, bool, bool, bool> m_OnSubmit;
		MenuCategoryBase m_APIParent;
		StringBuilder DialogTitle = new StringBuilder();


		public MenuCategoryBase APIParent
		{
			get
			{
				return m_APIParent;
			}

			set
			{
				if (m_APIParent != value)
				{
					m_APIParent = value;
					Register(value);
				}
			}
		}
		public Action<MyKeys, bool, bool, bool> OnSubmit
		{
			get
			{
				return m_OnSubmit;
			}

			set
			{
				if (m_OnSubmit != value)
				{
					m_OnSubmit = value;

				}
			}

		}
		public string DialogText
		{
			get
			{
				return DialogTitle.ToString();
			}
			set
			{
				if (DialogTitle.ToString() != value)
				{
					DialogTitle.Clear();
					DialogTitle.Append(value);
				}
			}
		}

		private enum MenuKeybindInputMembers : int
		{
			OnSubmitAction = 100,
			Parent,
			InputDialogTitle
		}
		public MenuKeybindItem()
		{
			ScrollMenuItem.Selectable = false;
			ScrollMenuItem.OnClickCallback = PromoteDialog;
		}
		public void PromoteDialog()
		{
			FontTexture.PromoteKeybindDialog(OnSubmit, DialogTitle);
		}
		public override object GetMember(int MemberEnum)
		{
			switch ((MenuKeybindInputMembers)MemberEnum)
			{
				case MenuKeybindInputMembers.OnSubmitAction:
					return OnSubmit;
				case MenuKeybindInputMembers.Parent:
					return APIParent;
				case MenuKeybindInputMembers.InputDialogTitle:
					return DialogText;
				default:
					return base.GetMember(MemberEnum);
			}
		}

		public override void SetMember(int MemberEnum, object Value)
		{
			switch ((MenuKeybindInputMembers)MemberEnum)
			{
				case MenuKeybindInputMembers.OnSubmitAction:
					OnSubmit = (Action<MyKeys, bool, bool, bool>)Value;
					return;
				case MenuKeybindInputMembers.Parent:
					APIParent = (MenuCategoryBase)Value;
					return;
				case MenuKeybindInputMembers.InputDialogTitle:
					DialogText = (string)Value;
					return;
				default:
					base.SetMember(MemberEnum, Value);
					return;
			}
		}
	}
}
