﻿using Sandbox.ModAPI;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VRageMath;

namespace UIFun.Menu.Api
{
	public class MenuColorPicker : MenuItemBase
	{
		Action<Color> m_OnSubmit;
		Action<Color> m_OnUpdate;
		Action m_OnCancel;
		bool m_ShowAlpha = true;
		bool m_UseHSV = false;
		Color m_InitialColor = Color.White;
		MenuCategoryBase m_APIParent;
		StringBuilder DialogTitle = new StringBuilder();



		public MenuCategoryBase APIParent
		{
			get
			{
				return m_APIParent;
			}

			set
			{
				//MyAPIGateway.Utilities.ShowMessage("MenuColorPicker", value.HeaderText);
				if (m_APIParent != value)
				{
					m_APIParent = value;
					Register(value);
				}
			}
		}
		public Action<Color> OnSubmit
		{
			get
			{
				return m_OnSubmit;
			}

			set
			{
				if (m_OnSubmit != value)
				{
					m_OnSubmit = value;

				}
			}

		}
		public Action<Color> OnUpdate
		{
			get
			{
				return m_OnUpdate;
			}

			set
			{
				if (m_OnUpdate != value)
				{
					m_OnUpdate = value;

				}
			}

		}
		public Action OnCancel
		{
			get
			{
				return m_OnCancel;
			}

			set
			{
				if (m_OnCancel != value)
				{
					m_OnCancel = value;

				}
			}

		}
		public Color InitialColor
		{
			get
			{
				return m_InitialColor;
			}
			set
			{
				m_InitialColor = value;
			}
		}
		public bool ShowAlpha
		{
			get
			{
				return m_ShowAlpha;
			}
			set
			{
				m_ShowAlpha = value;
			}
		}

		public bool UseHSV
		{
			get
			{
				return m_UseHSV;
			}
			set
			{
				m_UseHSV = value;
			}
		}
		public string DialogText
		{
			get
			{
				return DialogTitle.ToString();
			}
			set
			{
				if (DialogTitle.ToString() != value)
				{
					DialogTitle.Clear();
					DialogTitle.Append(value);
				}
			}
		}

		private enum MenuColorPickerInputMembers : int
		{
			OnSubmitAction = 100,
			Parent,
			InputDialogTitle,
			OnUpdateAction,
			OnCancelAction,
			InitialColor,
			ShowAlpha,
			UseHSV
		}
		public MenuColorPicker()
		{
			ScrollMenuItem.Selectable = false;
			ScrollMenuItem.OnClickCallback = PromoteDialog;
		}
		public void PromoteDialog()
		{
			//MyAPIGateway.Utilities.ShowMessage("PromoteDialog", InitialColor.ToString());
			FontTexture.PromoteColorPickerDialog(DialogTitle, InitialColor, m_OnSubmit, m_OnUpdate, m_OnCancel, m_ShowAlpha, m_UseHSV);
		}
		public override object GetMember(int MemberEnum)
		{
			switch ((MenuColorPickerInputMembers)MemberEnum)
			{
				case MenuColorPickerInputMembers.OnSubmitAction:
					return OnSubmit;
				case MenuColorPickerInputMembers.OnUpdateAction:
					return OnUpdate;
				case MenuColorPickerInputMembers.OnCancelAction:
					return OnCancel;
				case MenuColorPickerInputMembers.InitialColor:
					return InitialColor;
                case MenuColorPickerInputMembers.Parent:
					return APIParent;
				case MenuColorPickerInputMembers.InputDialogTitle:
					return DialogText;
				case MenuColorPickerInputMembers.ShowAlpha:
					return ShowAlpha;
				case MenuColorPickerInputMembers.UseHSV:
					return UseHSV;
				default:
					return base.GetMember(MemberEnum);
			}
		}

		public override void SetMember(int MemberEnum, object Value)
		{
			switch ((MenuColorPickerInputMembers)MemberEnum)
			{
				case MenuColorPickerInputMembers.OnSubmitAction:
					OnSubmit = (Action<Color>)Value;
					return;
				case MenuColorPickerInputMembers.Parent:
					APIParent = (MenuCategoryBase)Value;
					return;
				case MenuColorPickerInputMembers.InputDialogTitle:
					DialogText = (string)Value;
					return;
				case MenuColorPickerInputMembers.OnUpdateAction:
					OnUpdate = (Action<Color>)Value;
					return;
				case MenuColorPickerInputMembers.OnCancelAction:
					OnCancel = (Action)Value;
					return;
				case MenuColorPickerInputMembers.InitialColor:
					//MyAPIGateway.Utilities.ShowMessage("SetMember", InitialColor.ToString());
					InitialColor = (Color)Value;
					return;
				case MenuColorPickerInputMembers.ShowAlpha:
					ShowAlpha = (bool)Value;
					return;
				case MenuColorPickerInputMembers.UseHSV:
					UseHSV = (bool)Value;
					return;
				default:
					base.SetMember(MemberEnum, Value);
					return;
			}
		}



	}
}
