﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using UIFun.Definition;
using UIFun.Messagesv2;
using VRageMath;

namespace Draygo.TextHUDAPI.BoxUI
{
	public class BoxUIText : BoxUIRoot
	{

		enum BoxUITextMembers : int
		{
			SetTextContent = 100
		}

		public BoxUIText()
		{

		}
		public override void Draw( bool hudhidden)
		{
			if (hideHud && hudhidden)
				return;
			if (!visible)
				return;
			if (Content != null)
			{
				var screenpos = this.ContentTopLeftCorner();
				var content = Content as ModHUDMessage;
				content.Options |= Options.Pixel;
				content.Origin = new Vector2D(screenpos.X, screenpos.Y);
				content.WordWrap = true;
				
				content.WordWrapMax = new Vector2I((int)((double)contentwidth * (1d / Content.Scale) * 28d), (int)((double)contentheight * (1d / Content.Scale) * 28d));

			}
			base.Draw(hudhidden);


			
		}
		public override object GetMember(int MemberEnum)
		{
			return base.GetMember(MemberEnum);
		}
		public override void SetMember(int MemberEnum, object Value)
		{
			switch((BoxUITextMembers)MemberEnum)
			{
				case BoxUITextMembers.SetTextContent:
					if (Content != null)
						Content.m_HasParent = false;
					Content = (ModHUDMessage)Value;
					Content.m_HasParent = true;
					return;
				default:
					base.SetMember(MemberEnum, Value);
					return;
			}
			
		}
	}
}
