﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VRageMath;

namespace UIFun.StringProcessor
{
	public class MarkupProcessor
	{

		static readonly char[] key = new char[3] { '<', 'i', '>' };
		static readonly char[] endkey = new char[4] { '<', '/', 'i', '>' };
		
		static CultureInfo CompairsonCulture = new CultureInfo("en-US");

		internal static bool TryReadTag(char[] Buffer, int start, int max, out int indexincrease, out short italicsincrement)
		{

			indexincrease = 0;
			italicsincrement = 0;
			if (start + 3 > max)
			{
				return false;
			}
			int i = 0;
			bool matchstart = true;
			bool matchend = true;
			for (; i < 3; i++)
			{
				if (Buffer[start + i] != key[i])
				{
					matchstart = false;
				}
				if (Buffer[start + i] != endkey[i])
				{
					matchend = false;
				}
			}

			if (!matchstart)
			{
				if (matchend)
				{
					if (start + 3 < max && Buffer[start + 3] == endkey[3])
					{
						indexincrease += 3;
						italicsincrement--;
						return true;
					}

				}

				return false;
			}
			indexincrease += 2;
			italicsincrement++;
			return true;

		}
	}
}
