﻿using System.Collections.Generic;
using VRage.ModAPI;
using Sandbox.ModAPI;
using System;
using VRage.Game;
using VRage.Game.Components;
using VRageMath;
using VRage.Game.ModAPI;
using Sandbox.Definitions;
using VRage.Collections;
using System.Text.RegularExpressions;
using Draygo.API;
using UIFun.Menu;
using UIFun.Messagesv2;
using VRage.Input;

namespace UIFun
{
	[MySessionComponentDescriptor(MyUpdateOrder.AfterSimulation)]
	public class ModUI : MySessionComponentBase
    {
		public static ModUI instance;
		bool init = false;
		bool isServer = false;
		bool isDedicated = false;
		bool initmenu = false;

		FontTexture FontUI;
		
		public ModUI()
		{

		}

		public override void UpdateAfterSimulation()
		{
			//Update();
		}
		public override void Draw()
		{
			Update();
		}
		protected override void UnloadData()
		{
			unload();
		}
		public void unload()
		{

			if (init && !isDedicated)
			{
				if (instance != null) FontUI.Close();

				init = false;
			}

			isServer = false;
			isDedicated = false;
			if (instance == this)
				instance = null;
			init = false;

		}

		private void Close()
		{
			
		}

		public void Init()
		{
			if (init)
				return;//script already initialized, abort.
			instance = this;
			init = true;

			isServer = MyAPIGateway.Session.OnlineMode == MyOnlineModeEnum.OFFLINE || MyAPIGateway.Multiplayer.IsServer;
			isDedicated = (MyAPIGateway.Utilities.IsDedicated && isServer);
			if (isDedicated) return;
			FontUI = new FontTexture();

		}

		private void Update()
		{

			if (!init)
			{

                if (MyAPIGateway.Session == null)
					return;
				if (MyAPIGateway.Multiplayer == null && MyAPIGateway.Session.OnlineMode != MyOnlineModeEnum.OFFLINE)
					return;
				Init();
			}

			if (MyAPIGateway.Session?.Camera == null) return;

			if (FontUI != null)
				FontUI.Update();


			if (MyAPIGateway.Session == null)
			{
				unload();
			}
			if (isDedicated) return;

		}

	}
}
