﻿using System;
using System.Text;
using System.Text.RegularExpressions;
using UIFun.Interface;
using VRageMath;
using BlendTypeEnum = VRageRender.MyBillboard.BlendTypeEnum;

namespace UIFun.Messagesv2
{
	[Flags]
	public enum Options : byte
	{
		None = 0x0,
		HideHud = 0x1,
		Shadowing = 0x2,
		Fixed = 0x4,
		FOVScale = 0x8,
		Pixel = 0x10,
	}
	enum MessageBaseMembers : int
	{
		Message = 0,
		Visible,
		TimeToLive,
		Scale,
		TextLength,
		Offset,
		BlendType,
		Draw,
		Flush,
		SkipLinearRGB
	}
	public class ModMessageBase : iTextHUDAPI
	{
		
		public bool MarkedForClose = false;

		public StringBuilder Message = new StringBuilder();
		public static Regex ColorEncoder = new Regex("<color=(\\w*?|\\d*?\\,\\d*?\\,\\d*?|\\d*?,\\d*?,\\d*?,\\d*?)>", RegexOptions.IgnoreCase | RegexOptions.Compiled);
		public bool Visible = true;
		public int TimeToLive = -1;
		public double Scale = 1.0;
		public Vector2D Offset = Vector2D.Zero;
		public BlendTypeEnum Blend = BlendTypeEnum.Standard;
		public bool m_HasParent = false;
		public bool m_skipLinearRGB = false;

		public Vector4 ToLinearRGB(Vector4 color)
		{
			if (m_skipLinearRGB)
				return color;
			return color.ToLinearRGB();
		}

		public virtual void Close()
		{
			//Message = null;
		}

		public virtual void MarkForClose()
		{
			Visible = false;//update visual status.
			MarkedForClose = true;
		}

		public virtual object CallMethod(int methodEnum, object args)
		{
			return null;
		}
		public virtual object GetMember(int MemberEnum)
		{
			switch((MessageBaseMembers)MemberEnum)
			{
				case MessageBaseMembers.Message:
					return Message;
				case MessageBaseMembers.Scale:
					return Scale;
				case MessageBaseMembers.TimeToLive:
					return TimeToLive;
				case MessageBaseMembers.Visible:
					return Visible;
				case MessageBaseMembers.TextLength:
					return GetLength();
				case MessageBaseMembers.Offset:
					return Offset;
				case MessageBaseMembers.Draw:
					this.Draw();
					return null;
				case MessageBaseMembers.Flush:
					this.Flush();
					return null;
				case MessageBaseMembers.SkipLinearRGB:
					return m_skipLinearRGB;
			}
			throw new Exception(string.Format("ModMessageBase-GetMember: MemberEnum out of enumerable range {0}", MemberEnum)); //ArguementOutOfRangeException is prohibited
		}

		public virtual Vector2D GetLength()
		{
			return Vector2D.Zero;
		}
		public virtual void Flush()
		{

		}
		public virtual void SetMember(int MemberEnum, object Value)
		{
			switch ((MessageBaseMembers)MemberEnum)
			{
				case MessageBaseMembers.Message:
					Message = (StringBuilder)Value;
					return;
				case MessageBaseMembers.Scale:
					Scale = (double)Value;
					return;
				case MessageBaseMembers.TimeToLive:
					TimeToLive = (int)Value;
					return;
				case MessageBaseMembers.Visible:
					Visible = (bool)Value;
					return;
				case MessageBaseMembers.Offset:
					Offset = (Vector2D)Value;
					return;
				case MessageBaseMembers.BlendType:
					Blend = (BlendTypeEnum)Value;
					return;
				case MessageBaseMembers.SkipLinearRGB:
					m_skipLinearRGB = (bool)Value;
					return;
			}
			throw new Exception(string.Format("ModMessageBase-SetMember: MemberEnum out of enumerable range {0} {1}", MemberEnum, Value)); //ArguementOutOfRangeException is prohibited
		}

		public virtual void Draw()
		{
		}


	}
}
