﻿using System;
using VRageMath;

namespace UIFun.Menu
{
	public class ScrollItem : MenuObject
	{
		public string ItemText = "";
		public static string inactiveColor = "<color=255,255,255,255>";
		//public static string highlightColor = "<color=150,150,255,255>";
		//public static string selectedColor = "<color=100,125,255,255>";
		private bool m_selectable = true;
		private bool m_Interactable = true;

		public bool Selectable
		{
			get
			{
				return m_selectable;
			}

			set
			{
				m_selectable = value;
			}
		}

		public bool Interactable
		{
			get
			{
				return m_Interactable;
			}
			set
			{
				m_Interactable = value;
			}
		}
		public override void onClickCallbackCall()
		{
			if(Interactable)
				base.onClickCallbackCall();
		}
		public ScrollItem(Vector2D position, bool visible = true, MenuObject parent = null, Action mouseOver = null, Action onClick = null, string text = null, bool selectable = true) : base(position, visible, parent, mouseOver, onClick)
		{
			m_selectable = selectable;
			ItemText = text;
			Size = Vector2D.Zero;
			if(parent is HudMenuScrollBox)
				(parent as HudMenuScrollBox).UpdateList();
		}

		public void SetText(string newText)
		{
			if ( ItemText != newText )
			{
				ItemText = newText;
				if(Parent is HudMenuScrollBox)
					(Parent as HudMenuScrollBox).UpdateList();
			}
		}
		public override void OnClick(Vector2D MousePosition)
		{
			base.OnClick(MousePosition);
		}
		public override string ToString()
		{
			return inactiveColor + ItemText + '\n';
		}

		public override void Draw()
		{
			base.Draw();
		}
	}
}
