﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace UIFun.Menu.Api
{
	public class MenuTextInput : MenuItemBase
	{
		Action<string> m_OnSubmit;
		MenuCategoryBase m_APIParent;
		StringBuilder DialogTitle = new StringBuilder();


		public MenuCategoryBase APIParent
		{
			get
			{
				return m_APIParent;
			}

			set
			{
				if (m_APIParent != value)
				{
					m_APIParent = value;
					Register(value);
				}
			}
		}
		public Action<string> OnSubmit
		{
			get
			{
				return m_OnSubmit;
			}

			set
			{
				if (m_OnSubmit != value)
				{
					m_OnSubmit = value;

				}
			}

		}
		public string DialogText
		{
			get
			{
				return DialogTitle.ToString();
			}
			set
			{
				if (DialogTitle.ToString() != value)
				{
					DialogTitle.Clear();
					DialogTitle.Append(value);
                }
			}
		}

		private enum MenuTextInputMembers : int
		{
			OnSubmitAction = 100,
			Parent,
			InputDialogTitle
		}
		public MenuTextInput()
		{
			ScrollMenuItem.Selectable = false;
			ScrollMenuItem.OnClickCallback = PromoteDialog;
		}
		public void PromoteDialog()
		{
			FontTexture.PromoteTextDialog(OnSubmit, DialogTitle);
		}
		public override object GetMember(int MemberEnum)
		{
			switch ((MenuTextInputMembers)MemberEnum)
			{
				case MenuTextInputMembers.OnSubmitAction:
					return OnSubmit;
				case MenuTextInputMembers.Parent:
					return APIParent;
				case MenuTextInputMembers.InputDialogTitle:
					return DialogText;
				default:
					return base.GetMember(MemberEnum);
			}
		}

		public override void SetMember(int MemberEnum, object Value)
		{
			switch ((MenuTextInputMembers)MemberEnum)
			{
				case MenuTextInputMembers.OnSubmitAction:
					OnSubmit = (Action<string>)Value;
					return;
				case MenuTextInputMembers.Parent:
					APIParent = (MenuCategoryBase)Value;
					return;
				case MenuTextInputMembers.InputDialogTitle:
					DialogText = (string)Value;
					return;
				default:
					base.SetMember(MemberEnum, Value);
					return;
			}
		}
	}
}
