﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace UIFun.Menu.Api
{
	public class MenuSliderItem : MenuItemBase
	{
		Action<float> m_OnSubmit;
		Action m_OnCancel;
		float m_initialValue = 1f;
		Func<float, object> m_SliderPercentToValue;
        MenuCategoryBase m_APIParent;
		StringBuilder DialogTitle = new StringBuilder();


		public MenuCategoryBase APIParent
		{
			get
			{
				return m_APIParent;
			}

			set
			{
				if (m_APIParent != value)
				{
					m_APIParent = value;
					Register(value);
				}
			}
		}
		public Action<float> OnSubmit
		{
			get
			{
				return m_OnSubmit;
			}

			set
			{
				if (m_OnSubmit != value)
				{
					m_OnSubmit = value;

				}
			}

		}
		public string DialogText
		{
			get
			{
				return DialogTitle.ToString();
			}
			set
			{
				if (DialogTitle.ToString() != value)
				{
					DialogTitle.Clear();
					DialogTitle.Append(value);
				}
			}
		}
		public float InitialValue
		{
			get
			{
				return m_initialValue;
			}
			set
			{
				m_initialValue = value;
			}
		}
		public Func<float, object> SliderPercentToValue
		{
			get
			{
				return m_SliderPercentToValue;
			}
			set
			{
				m_SliderPercentToValue = value;
			}
		}
		public Action OnCancel
		{
			get
			{
				return m_OnCancel;
			}
			set
			{
				m_OnCancel = value;
			}
		}
        private enum MenuSliderItemMembers : int
		{
			OnSubmitAction = 100,
			Parent,
			InputDialogTitle,
			InitialPercent,
			SliderPercentToValue,
			OnCancel
		}
		public MenuSliderItem()
		{
			ScrollMenuItem.Selectable = false;
			ScrollMenuItem.OnClickCallback = PromoteDialog;
		}
		public void PromoteDialog()
		{
			FontTexture.PromoteSliderDialog(DialogTitle, OnSubmit, InitialValue, SliderPercentToValue, OnCancel);
		}
		public override object GetMember(int MemberEnum)
		{
			switch ((MenuSliderItemMembers)MemberEnum)
			{
				case MenuSliderItemMembers.OnSubmitAction:
					return OnSubmit;
				case MenuSliderItemMembers.Parent:
					return APIParent;
				case MenuSliderItemMembers.InputDialogTitle:
					return DialogText;
				case MenuSliderItemMembers.InitialPercent:
					return InitialValue;
				case MenuSliderItemMembers.SliderPercentToValue:
					return SliderPercentToValue;
				case MenuSliderItemMembers.OnCancel:
					return OnCancel;
				default:
					return base.GetMember(MemberEnum);
			}
		}

		public override void SetMember(int MemberEnum, object Value)
		{
			switch ((MenuSliderItemMembers)MemberEnum)
			{
				case MenuSliderItemMembers.OnSubmitAction:
					OnSubmit = (Action<float>)Value;
					return;
				case MenuSliderItemMembers.Parent:
					APIParent = (MenuCategoryBase)Value;
					return;
				case MenuSliderItemMembers.InputDialogTitle:
					DialogText = (string)Value;
					return;
				case MenuSliderItemMembers.InitialPercent:
					InitialValue = (float)Value;
					return;
				case MenuSliderItemMembers.SliderPercentToValue:
					SliderPercentToValue = (Func<float, object>)Value;
					return;
				case MenuSliderItemMembers.OnCancel:
					OnCancel = (Action)Value;
					return;
				default:
					base.SetMember(MemberEnum, Value);
					return;
			}
		}
	}
}
