﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace UIFun.Menu.Api
{
	public class MenuRootCategory : MenuCategoryBase
	{
		//should be limited only to one per mod, but cant really stop modders from using more than one. oh well. 
		HudMenuScrollBox Menu1, Menu2;
		MenuFlag m_AttachedMenu = MenuFlag.None;

		public MenuFlag AttachedMenu
		{
			get
			{
				return m_AttachedMenu;
			}

			set
			{
				if(m_AttachedMenu != value )
				{
					
					m_AttachedMenu = value;
					if (m_AttachedMenu == MenuFlag.PlayerMenu)
						Register(Menu1);
					if (m_AttachedMenu == MenuFlag.AdminMenu)
						Register(Menu2);
				}

			}
		}

		public enum MenuFlag : int
		{
			None = 0,
			PlayerMenu = 1,
			AdminMenu = 2
		}
		private enum MenuRootCategoryMembers : int
		{
			MenuFlag = 200
		}

		public MenuRootCategory(HudMenuScrollBox menu1, HudMenuScrollBox menu2)
		{
            Menu1 = menu1;
			Menu2 = menu2;
			ScrollMenuItem.AddSubObject(ItemList);
		}

		public override object GetMember(int MemberEnum)
		{
			switch ((MenuRootCategoryMembers)MemberEnum)
			{
				case MenuRootCategoryMembers.MenuFlag:
					return AttachedMenu;
				default:
					return base.GetMember(MemberEnum);
			}
			throw new Exception(string.Format("MenuRootCategory-GetMember: MemberEnum out of enumerable range {0}", MemberEnum)); //ArguementOutOfRangeException is prohibited
		}

		public override void SetMember(int MemberEnum, object Value)
		{
			switch ((MenuRootCategoryMembers)MemberEnum)
			{
				case MenuRootCategoryMembers.MenuFlag:
					AttachedMenu = (MenuFlag)Value;
					return;
				default:
					base.SetMember(MemberEnum, Value);
					return;
			}
			throw new Exception(string.Format("MenuRootCategory-SetMember: MemberEnum out of enumerable range {0} {1}", MemberEnum, Value)); //ArguementOutOfRangeException is prohibited
		}

	}
}
