﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using UIFun.Interface;
using VRageMath;

namespace UIFun.Menu.Api
{
	public class MenuItemBase : iTextHUDAPI
	{
		private enum MenuItemBaseMembers : int
		{
			Text = 0,
			Interactable
		}
		private bool m_Interactable = true;
		private string m_Text;
		private HudMenuScrollBox Parent;
		internal ScrollItem ScrollMenuItem = new ScrollItem(Vector2D.Zero);
		public string Text
		{
			get
			{
				return m_Text;
			}
			set
			{
				if (m_Text != value)
				{
					m_Text = value;
					UpdateText();
				}
			}
		}

		public bool Interactable
		{
			get
			{
				return m_Interactable;
			}
			set
			{
				if (m_Interactable != value)
				{
					m_Interactable = value;
					UpdateIntractable();
				}
			}
		}

		public virtual void UpdateIntractable()
		{
			ScrollMenuItem.Interactable = Interactable;
		}
		public virtual object GetMember(int MemberEnum)
		{
			switch ((MenuItemBaseMembers)MemberEnum)
			{
				case MenuItemBaseMembers.Text:
					return Text;
				case MenuItemBaseMembers.Interactable:
					return Interactable;
			}
			throw new Exception(string.Format("MenuItemBase-GetMember: MemberEnum out of enumerable range {0}", MemberEnum)); //ArguementOutOfRangeException is prohibited
		}

		public virtual void SetMember(int MemberEnum, object Value)
		{
			switch ((MenuItemBaseMembers)MemberEnum)
			{
				case MenuItemBaseMembers.Text:
					Text = (string)Value;
					return;
				case MenuItemBaseMembers.Interactable:
					Interactable = (bool)Value;
					return;
			}
			throw new Exception(string.Format("MenuItemBase-SetMember: MemberEnum out of enumerable range {0} {1}", MemberEnum, Value)); //ArguementOutOfRangeException is prohibited
		}

		public virtual void Register(HudMenuScrollBox Menu)
		{
			if (Parent == Menu)
				return;
			if(Parent != null)
				Unregister();
			
			Menu.AddSubObject(ScrollMenuItem);
			Parent = Menu;
		}
		public virtual void Register(MenuCategoryBase Menu)
		{
			if (Parent == Menu.ItemList)
				return;
			if (Parent != null)
				Unregister();
			Menu.ItemList.AddSubObject(ScrollMenuItem);
			Parent = Menu.ItemList;
		}
		public virtual void Unregister()
		{
			Parent.RemoveSubObject(ScrollMenuItem);
			Parent = null;
		}
		public virtual void UpdateText()
		{
			ScrollMenuItem.SetText(Text);
		}
	}
}
