﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace UIFun.Menu.Api
{
	public class MenuItem : MenuItemBase
	{
		Action m_OnClick;
		MenuCategoryBase m_APIParent;

		public MenuCategoryBase APIParent
		{
			get
			{
				return m_APIParent;
			}

			set
			{
				if (m_APIParent != value)
				{
					m_APIParent = value;
					Register(value);
				}
			}
		}
		public Action OnClick
		{
			get
			{
				return m_OnClick;
			}

			set
			{
				if(m_OnClick != value)
				{
					m_OnClick = value;
					ScrollMenuItem.OnClickCallback = m_OnClick;
                }
			}

		}

		private enum MenuItemMembers : int
		{
			OnClickAction = 100,
			Parent
		}
		public MenuItem()
		{
			ScrollMenuItem.Selectable = false;
		}
		public override object GetMember(int MemberEnum)
		{
			switch ((MenuItemMembers)MemberEnum)
			{
				case MenuItemMembers.OnClickAction:
					return OnClick;
				case MenuItemMembers.Parent:
					return APIParent;
				default:
					return base.GetMember(MemberEnum);
			}
		}

		public override void SetMember(int MemberEnum, object Value)
		{
			switch ((MenuItemMembers)MemberEnum)
			{
				case MenuItemMembers.OnClickAction:
					OnClick = (Action)Value;
					return;
				case MenuItemMembers.Parent:
					APIParent = (MenuCategoryBase)Value;
					return;
				default:
					base.SetMember(MemberEnum, Value);
					return;
			}
		}

	}
}
