﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VRageMath;

namespace UIFun.Menu.Api
{
	public class MenuCategoryBase : MenuItemBase
	{
		internal HudMenuScrollBox ItemList = new HudMenuScrollBox(Vector2D.Zero, false, rightpadding: 10);
		string m_HeaderText = "";
		public string HeaderText
		{
			get
			{
				return m_HeaderText;
			}
			set
			{
				if(m_HeaderText != value)
				{
					m_HeaderText = value;
					ItemList.SetHeaderText(value);
				}
			}
		}

		private enum MenuBaseCategoryMembers : int
		{
			Header = 100
		}
		public override object GetMember(int MemberEnum)
		{
			switch ((MenuBaseCategoryMembers)MemberEnum)
			{
				case MenuBaseCategoryMembers.Header:
					return HeaderText;
				default:
					return base.GetMember(MemberEnum);
			}
			
		}

		public override void SetMember(int MemberEnum, object Value)
		{
			switch ((MenuBaseCategoryMembers)MemberEnum)
			{
				case MenuBaseCategoryMembers.Header:
					HeaderText = (string)Value;
					return;
				default:
					base.SetMember(MemberEnum, Value);
					return;
			}
			
		}
		public override void Register(HudMenuScrollBox Menu)
		{
			base.Register(Menu);
        }
	}
}
