﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VRage.ModAPI;
using Sandbox.ModAPI;
using VRage.Game;
using VRage.Game.Components;
using VRageMath;
using VRage.Game.ModAPI;
using Sandbox.Definitions;
using UIFun.Messagesv2;
using VRage;
using System.Collections.Concurrent;
using Sandbox.Game;
using VRage.Utils;
using UIFun.Menu;
using VRage.Game.Definitions;
using UIFun.Menu.Api;
using UIFun.Interface;
using UIFun.Menu.Dialog;
using VRage.Input;
using VRageRender;
using BlendTypeEnum = VRageRender.MyBillboard.BlendTypeEnum;
using Sandbox.Game.Entities;
using UIFun.Definition;
using Draygo.TextHUDAPI.BoxUI;
using System.Linq.Expressions;

namespace UIFun
{
	//System.Environment.CurrentManagedThreadId   Thread
	public class FontTexture
	{
		int heartbeatsend = 300;
		int errorcount = 0;
        public static FontTexture instance;
		public const double DRAWDISTANCE = 0.1d;
		internal static FontDefinition GetFont(MyStringId v)
		{
			if (FontDefinitions.ContainsKey(v.Id))
			{
				return FontDefinitions[v.Id];
			}
			else
			{
				var add = new FontDefinition();
				add.fontname = v;
				FontDefinitions.Add(v.Id, add);
				return add;
			}
		}
		
		public enum TextOrientation : byte
		{
			ltr = 1,
			center = 2,
			rtl = 3
		}


		public HudMenu EscMenu = new HudMenu(new Vector2D(-0.9, 0.6));
		public HudMenu F11Menu = new HudMenu(new Vector2D(-1, 0.9));
		//public static Dictionary<string, Dictionary<char, FontMatrix>> FontDefinitionDictionary = new Dictionary<string, Dictionary<char, FontMatrix>>();
		public static Dictionary<int, FontDefinition> FontDefinitions = new Dictionary<int, FontDefinition>();
		//public Dictionary<char, FontMatrix> FontDict = new Dictionary<char, FontMatrix>();
		private List<ModMessageBase> ModMessageDictionary = new List<ModMessageBase>();
		//Dictionary<long, Dictionary<long, MessageBase>> MessageDict = new Dictionary<long, Dictionary<long, MessageBase>>();
		//private readonly long TEXTAPIMODID = 758597413;
		private const long REGISTRATIONID = 573804956;
		public static bool m_HudHidden = false;
		private MyEntity3DSoundEmitter HudHighlightSound;
		private MyEntity3DSoundEmitter ClickSound;

		public BoxUIRoot RootUi;
		public Dictionary<int, UIDefinition> UIDefinitions = new Dictionary<int, UIDefinition>();
		public Dictionary<int, UIBehaviourDefinition> UIBehaviours = new Dictionary<int, UIBehaviourDefinition>();

		//add property for isInMenu

		public static bool hudHidden 
		{
			get
			{
				return m_HudHidden;
			}
			set
			{
				m_HudHidden = value;
			}

		}
		static float m_fov = 80.0f;
		public static float fov
		{
			get
			{
				return m_fov;
			}
			set
			{
				m_fov = value;
				m_localScale = 0.1 * Math.Tan(m_fov / 2d);
				
				float x = MyAPIGateway.Session?.Config?.ScreenWidth ?? MyAPIGateway.Session.Camera.ViewportSize.X;
				float y = MyAPIGateway.Session?.Config?.ScreenHeight ?? MyAPIGateway.Session.Camera.ViewportSize.Y;
				var screen = Vector3D.Transform(new Vector3D(2, 2, DRAWDISTANCE), MatrixD.Identity);
				m_aspectRatio = x / y;
				m_xPix = (screen.X / 1920f) * m_localScale;
				m_yPix = (screen.Y / 1920f) * m_localScale;
				m_xPix *= 0.5f;
				m_yPix *= 0.5f;

				m_xSPPix = (screen.X / x);
				m_ySPPix = (screen.Y / y) ;

				m_oneX = 1 / MyAPIGateway.Session.Camera.ViewportSize.X * m_localScale * m_aspectRatio * 0.5d;
				m_oneY = 1 / MyAPIGateway.Session.Camera.ViewportSize.Y * m_localScale * 0.5d;

			}
		}
		static double m_aspectRatio = 16d/9d;
		public static double aspectRatio
		{
			get
			{
				return m_aspectRatio;
			}
			set
			{
				m_aspectRatio = value;
			}
		}
		static double m_localScale = DRAWDISTANCE * Math.Tan(FontTexture.fov / 2d);
		public static Vector3 projectionNormal = Vector3.Zero;
		public static double localscale
		{
			get
			{
				return m_localScale;
			}
		}
		static double m_xPix = 1;
		static double m_yPix = 1;
		static double m_xSPPix = 1;
		static double m_ySPPix = 1;
		static double m_oneX = 1;
		static double m_oneY = 1;
		public static double OneX
		{
			get
			{
				return m_oneX;
			}
		}
		public static double OneY
		{
			get
			{
				return m_oneY;
			}
		}
		public static double xPix
		{
			get
			{
				return m_xPix;
			}
		}
		public static double yPix
		{
			get
			{
				return m_yPix;
			}
		}
		public static double xSPPix
		{
			get
			{
				return m_xSPPix;
			}
		}
		public static double ySPPix
		{
			get
			{
				return m_ySPPix;
			}
		}
		//call in init only

		public FontTexture()
		{
			//FontDict.Clear();
			instance = this;
			//MyDefinitionManager.Static.LoadData(MyAPIGateway.Session.Mods);
			//MyTransparentMaterial a;
			//var b = MyTransparentMaterials.Count;
			//init
			#region monospace
			TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  ' '   ,"0020"   ,0   ,0,0    ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  '!'   ,"0021"   ,0   ,30,0   ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  '"'	,"0022"	,0	,60,0	,30,42	,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  '#'	,"0023"	,0	,90,0	,30,42	,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  '$'	,"0024"   ,0   ,120,0  ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  '%'   ,"0025"   ,0   ,150,0  ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  '&'   ,"0026"   ,0   ,180,0  ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  '\''	,"0027"	,0	,210,0	,30,42	,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  '('   ,"0028"   ,0   ,240,0  ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  ')'   ,"0029"   ,0   ,270,0  ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  '*'   ,"002a"   ,0   ,300,0  ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  '+'   ,"002b"   ,0   ,330,0  ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  ','	,"002c"   ,0   ,360,0  ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  '-'   ,"002d"   ,0   ,390,0  ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  '.'   ,"002e"   ,0   ,420,0  ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  '/'   ,"002f"   ,0   ,450,0  ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  '0'   ,"0030"   ,0   ,480,0  ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  '1'   ,"0031"   ,0   ,510,0  ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  '2'   ,"0032"   ,0   ,540,0  ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  '3'   ,"0033"   ,0   ,570,0  ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  '4'   ,"0034"   ,0   ,600,0  ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  '5'   ,"0035"   ,0   ,630,0  ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  '6'   ,"0036"   ,0   ,660,0  ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  '7'   ,"0037"   ,0   ,690,0  ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  '8'   ,"0038"   ,0   ,720,0  ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  '9'   ,"0039"   ,0   ,750,0  ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  ':'	,"003a"   ,0   ,780,0  ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  ';'   ,"003b"   ,0   ,810,0  ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  '<'   ,"003c"   ,0   ,840,0  ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  '='   ,"003d"   ,0   ,870,0  ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  '>'   ,"003e"   ,0   ,900,0  ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  '?'   ,"003f"   ,0   ,930,0  ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  '@'	,"0040"   ,0   ,960,0  ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'A'   ,"0041"   ,0   ,990,0  ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'B'   ,"0042"   ,0   ,0,44   ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'C'   ,"0043"   ,0   ,30,44  ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'D'   ,"0044"   ,0   ,60,44  ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'E'   ,"0045"   ,0   ,90,44  ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'F'   ,"0046"   ,0   ,120,44 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'G'   ,"0047"   ,0   ,150,44 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'H'   ,"0048"   ,0   ,180,44 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'I'   ,"0049"   ,0   ,210,44 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'J'   ,"004a"   ,0   ,240,44 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'K'   ,"004b"   ,0   ,270,44 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'L'   ,"004c"   ,0   ,300,44 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'M'   ,"004d"   ,0   ,330,44 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'N'   ,"004e"   ,0   ,360,44 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'O'   ,"004f"   ,0   ,390,44 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'P'   ,"0050"   ,0   ,420,44 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'Q'   ,"0051"   ,0   ,450,44 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'R'   ,"0052"   ,0   ,480,44 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'S'   ,"0053"   ,0   ,510,44 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'T'   ,"0054"   ,0   ,540,44 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'U'   ,"0055"   ,0   ,570,44 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'V'   ,"0056"   ,0   ,600,44 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'W'   ,"0057"   ,0   ,630,44 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'X'   ,"0058"   ,0   ,660,44 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'Y'   ,"0059"   ,0   ,690,44 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'Z'   ,"005a"   ,0   ,720,44 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  '['   ,"005b"   ,0   ,750,44 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  '\\'	,"005c"   ,0   ,780,44 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  ']'   ,"005d"   ,0   ,810,44 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  '^'   ,"005e"   ,0   ,840,44 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  '_'   ,"005f"   ,0   ,870,44 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  '`'	,"0060"   ,0   ,900,44 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'a'   ,"0061"   ,0   ,930,44 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'b'   ,"0062"   ,0   ,960,44 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'c'   ,"0063"   ,0   ,990,44 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'd'   ,"0064"   ,0   ,0,88   ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'e'   ,"0065"   ,0   ,30,88  ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'f'   ,"0066"   ,0   ,60,88  ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'g'   ,"0067"   ,0   ,90,88  ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'h'   ,"0068"   ,0   ,120,88 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'i'   ,"0069"   ,0   ,150,88 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'j'   ,"006a"   ,0   ,180,88 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'k'   ,"006b"   ,0   ,210,88 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'l'   ,"006c"   ,0   ,240,88 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'm'   ,"006d"   ,0   ,270,88 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'n'   ,"006e"   ,0   ,300,88 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'o'   ,"006f"   ,0   ,330,88 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'p'   ,"0070"   ,0   ,360,88 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'q'   ,"0071"   ,0   ,390,88 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'r'   ,"0072"   ,0   ,420,88 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  's'   ,"0073"   ,0   ,450,88 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  't'   ,"0074"   ,0   ,480,88 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'u'   ,"0075"   ,0   ,510,88 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'v'   ,"0076"   ,0   ,540,88 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'w'   ,"0077"   ,0   ,570,88 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'x'   ,"0078"   ,0   ,600,88 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'y'   ,"0079"   ,0   ,630,88 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'z'   ,"007a"   ,0   ,660,88 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  '{'	,"007b"   ,0   ,690,88 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  '|'   ,"007c"   ,0   ,720,88 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  '}'	,"007d"   ,0   ,750,88 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  '~'   ,"007e"   ,0   ,780,88 ,30,42   ,24  ,-3);
//TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  ''	,"007f"   ,0   ,810,88 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  ' ', "00a0"   ,0   ,0,0    ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  '¡'	,"00a1"   ,0   ,840,88 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  '¢'	,"00a2"   ,0   ,870,88 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  '£'	,"00a3"   ,0   ,900,88 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  '¤'	,"00a4"   ,0   ,930,88 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  '¥'	,"00a5"   ,0   ,960,88 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  '¦'	,"00a6"   ,0   ,720,88 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  '§'	,"00a7"   ,0   ,990,88 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  '¨'	,"00a8"   ,0   ,0,132  ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  '©'	,"00a9"   ,0   ,30,132 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'ª'   ,"00aa"   ,0   ,60,132 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  '«'	,"00ab"   ,0   ,90,132 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  '¬'	,"00ac"   ,0   ,120,132,30,42   ,24  ,-3);
//TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  ''	,"00ad"   ,0   ,390,0  ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  '®'	,"00ae"   ,0   ,150,132,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  '¯'	,"00af"   ,0   ,180,132,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  '°'	,"00b0"   ,0   ,210,132,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  '±'	,"00b1"   ,0   ,240,132,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  '²'	,"00b2"   ,0   ,270,132,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  '³'	,"00b3"   ,0   ,300,132,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  '´'	,"00b4"   ,0   ,330,132,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'µ'   ,"00b5"   ,0   ,360,132,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  '¶'	,"00b6"   ,0   ,390,132,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  '·'	,"00b7"   ,0   ,420,132,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  '¸'	,"00b8"   ,0   ,450,132,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  '¹'	,"00b9"   ,0   ,480,132,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'º'   ,"00ba"   ,0   ,510,132,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  '»'	,"00bb"   ,0   ,540,132,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  '¼'	,"00bc"   ,0   ,570,132,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  '½'	,"00bd"   ,0   ,600,132,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  '¾'	,"00be"   ,0   ,630,132,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  '¿'	,"00bf"   ,0   ,660,132,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'À'   ,"00c0"   ,0   ,690,132,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'Á'   ,"00c1"   ,0   ,720,132,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'Â'   ,"00c2"   ,0   ,750,132,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'Ã'   ,"00c3"   ,0   ,780,132,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'Ä'   ,"00c4"   ,0   ,810,132,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'Å'   ,"00c5"   ,0   ,840,132,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'Æ'   ,"00c6"   ,0   ,870,132,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'Ç'   ,"00c7"   ,0   ,900,132,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'È'   ,"00c8"   ,0   ,930,132,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'É'   ,"00c9"   ,0   ,960,132,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'Ê'   ,"00ca"   ,0   ,990,132,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'Ë'   ,"00cb"   ,0   ,0,176  ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'Ì'   ,"00cc"   ,0   ,30,176 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'Í'   ,"00cd"   ,0   ,60,176 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'Î'   ,"00ce"   ,0   ,90,176 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ï'   ,"00cf"   ,0   ,120,176,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ð'   ,"00d0"   ,0   ,150,176,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ñ'   ,"00d1"   ,0   ,180,176,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ò'   ,"00d2"   ,0   ,210,176,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ó'   ,"00d3"   ,0   ,240,176,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ô'   ,"00d4"   ,0   ,270,176,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Õ'   ,"00d5"   ,0   ,300,176,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ö'   ,"00d6"   ,0   ,330,176,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '×'	,"00d7"   ,0   ,360,176,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ø'   ,"00d8"   ,0   ,390,176,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ù'   ,"00d9"   ,0   ,420,176,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ú'   ,"00da"   ,0   ,450,176,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Û'   ,"00db"   ,0   ,480,176,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ü'   ,"00dc"   ,0   ,510,176,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ý'   ,"00dd"   ,0   ,540,176,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Þ'   ,"00de"   ,0   ,570,176,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ß'   ,"00df"   ,0   ,600,176,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'à'   ,"00e0"   ,0   ,630,176,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'á'   ,"00e1"   ,0   ,660,176,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'â'   ,"00e2"   ,0   ,690,176,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ã'   ,"00e3"   ,0   ,720,176,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ä'   ,"00e4"   ,0   ,750,176,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'å'   ,"00e5"   ,0   ,780,176,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'æ'   ,"00e6"   ,0   ,810,176,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ç'   ,"00e7"   ,0   ,840,176,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'è'   ,"00e8"   ,0   ,870,176,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'é'   ,"00e9"   ,0   ,900,176,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ê'   ,"00ea"   ,0   ,930,176,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ë'   ,"00eb"   ,0   ,960,176,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ì'   ,"00ec"   ,0   ,990,176,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'í'   ,"00ed"   ,0   ,0,220  ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'î'   ,"00ee"   ,0   ,30,220 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ï'   ,"00ef"   ,0   ,60,220 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ð'   ,"00f0"   ,0   ,90,220 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ñ'   ,"00f1"   ,0   ,120,220,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ò'   ,"00f2"   ,0   ,150,220,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ó'   ,"00f3"   ,0   ,180,220,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ô'   ,"00f4"   ,0   ,210,220,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'õ'   ,"00f5"   ,0   ,240,220,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ö'   ,"00f6"   ,0   ,270,220,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '÷'	,"00f7"   ,0   ,300,220,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ø'   ,"00f8"   ,0   ,330,220,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ù'   ,"00f9"   ,0   ,360,220,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ú'   ,"00fa"   ,0   ,390,220,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'û'   ,"00fb"   ,0   ,420,220,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ü'   ,"00fc"   ,0   ,450,220,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ý'   ,"00fd"   ,0   ,480,220,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'þ'   ,"00fe"   ,0   ,510,220,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ÿ'   ,"00ff"   ,0   ,540,220,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ā'   ,"0100"   ,0   ,570,220,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ā'   ,"0101"   ,0   ,600,220,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ă'   ,"0102"   ,0   ,630,220,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ă'   ,"0103"   ,0   ,660,220,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ą'   ,"0104"   ,0   ,690,220,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ą'   ,"0105"   ,0   ,720,220,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ć'   ,"0106"   ,0   ,750,220,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ć'   ,"0107"   ,0   ,780,220,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ĉ'   ,"0108"   ,0   ,810,220,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ĉ'   ,"0109"   ,0   ,840,220,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ċ'   ,"010a"   ,0   ,870,220,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ċ'   ,"010b"   ,0   ,900,220,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Č'   ,"010c"   ,0   ,930,220,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'č'   ,"010d"   ,0   ,960,220,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ď'   ,"010e"   ,0   ,990,220,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ď'   ,"010f"   ,0   ,0,264  ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Đ'   ,"0110"   ,0   ,30,264 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'đ'   ,"0111"   ,0   ,60,264 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ē'   ,"0112"   ,0   ,90,264 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ē'   ,"0113"   ,0   ,120,264,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ĕ'   ,"0114"   ,0   ,150,264,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ĕ'   ,"0115"   ,0   ,180,264,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ė'   ,"0116"   ,0   ,210,264,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ė'   ,"0117"   ,0   ,240,264,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ę'   ,"0118"   ,0   ,270,264,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ę'   ,"0119"   ,0   ,300,264,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ě'   ,"011a"   ,0   ,330,264,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ě'   ,"011b"   ,0   ,360,264,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ĝ'   ,"011c"   ,0   ,390,264,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ĝ'   ,"011d"   ,0   ,420,264,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ğ'   ,"011e"   ,0   ,450,264,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ğ'   ,"011f"   ,0   ,480,264,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ġ'   ,"0120"   ,0   ,510,264,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ġ'   ,"0121"   ,0   ,540,264,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ģ'   ,"0122"   ,0   ,570,264,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ģ'   ,"0123"   ,0   ,600,264,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ĥ'   ,"0124"   ,0   ,630,264,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ĥ'   ,"0125"   ,0   ,660,264,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ħ'   ,"0126"   ,0   ,690,264,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ħ'   ,"0127"   ,0   ,720,264,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ĩ'   ,"0128"   ,0   ,750,264,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ĩ'   ,"0129"   ,0   ,780,264,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ī'   ,"012a"   ,0   ,810,264,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ī'   ,"012b"   ,0   ,840,264,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ĭ'   ,"012c"   ,0   ,870,264,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ĭ'   ,"012d"   ,0   ,900,264,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Į'   ,"012e"   ,0   ,930,264,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'į'   ,"012f"   ,0   ,960,264,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'İ'   ,"0130"   ,0   ,990,264,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ı'   ,"0131"   ,0   ,0,308  ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ĳ'   ,"0132"   ,0   ,30,308 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ĳ'   ,"0133"   ,0   ,60,308 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ĵ'   ,"0134"   ,0   ,90,308 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ĵ'   ,"0135"   ,0   ,120,308,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ķ'   ,"0136"   ,0   ,150,308,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ķ'   ,"0137"   ,0   ,180,308,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ĸ'   ,"0138"   ,0   ,210,308,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ĺ'   ,"0139"   ,0   ,240,308,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ĺ'   ,"013a"   ,0   ,270,308,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ļ'   ,"013b"   ,0   ,300,308,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ļ'   ,"013c"   ,0   ,330,308,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ľ'   ,"013d"   ,0   ,360,308,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ľ'   ,"013e"   ,0   ,390,308,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ŀ'   ,"013f"   ,0   ,420,308,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ŀ'   ,"0140"   ,0   ,450,308,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ł'   ,"0141"   ,0   ,480,308,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ł'   ,"0142"   ,0   ,510,308,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ń'   ,"0143"   ,0   ,540,308,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ń'   ,"0144"   ,0   ,570,308,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ņ'   ,"0145"   ,0   ,600,308,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ņ'   ,"0146"   ,0   ,630,308,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ň'   ,"0147"   ,0   ,660,308,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ň'   ,"0148"   ,0   ,690,308,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ŉ'   ,"0149"   ,0   ,720,308,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ŋ'   ,"014a"   ,0   ,750,308,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ŋ'   ,"014b"   ,0   ,780,308,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ō'   ,"014c"   ,0   ,810,308,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ō'   ,"014d"   ,0   ,840,308,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ŏ'   ,"014e"   ,0   ,870,308,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ŏ'   ,"014f"   ,0   ,900,308,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ő'   ,"0150"   ,0   ,930,308,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ő'   ,"0151"   ,0   ,960,308,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Œ'   ,"0152"   ,0   ,990,308,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'œ'   ,"0153"   ,0   ,0,352  ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ŕ'   ,"0154"   ,0   ,30,352 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ŕ'   ,"0155"   ,0   ,60,352 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ŗ'   ,"0156"   ,0   ,90,352 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ŗ'   ,"0157"   ,0   ,120,352,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ř'   ,"0158"   ,0   ,150,352,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ř'   ,"0159"   ,0   ,180,352,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ś'   ,"015a"   ,0   ,210,352,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ś'   ,"015b"   ,0   ,240,352,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ŝ'   ,"015c"   ,0   ,270,352,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ŝ'   ,"015d"   ,0   ,300,352,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ş'   ,"015e"   ,0   ,330,352,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ş'   ,"015f"   ,0   ,360,352,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Š'   ,"0160"   ,0   ,390,352,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'š'   ,"0161"   ,0   ,420,352,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ţ'   ,"0162"   ,0   ,450,352,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ţ'   ,"0163"   ,0   ,480,352,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ť'   ,"0164"   ,0   ,510,352,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ť'   ,"0165"   ,0   ,540,352,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ŧ'   ,"0166"   ,0   ,570,352,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ŧ'   ,"0167"   ,0   ,600,352,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ũ'   ,"0168"   ,0   ,630,352,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ũ'   ,"0169"   ,0   ,660,352,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ū'   ,"016a"   ,0   ,690,352,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ū'   ,"016b"   ,0   ,720,352,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ŭ'   ,"016c"   ,0   ,750,352,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ŭ'   ,"016d"   ,0   ,780,352,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ů'   ,"016e"   ,0   ,810,352,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ů'   ,"016f"   ,0   ,840,352,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ű'   ,"0170"   ,0   ,870,352,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ű'   ,"0171"   ,0   ,900,352,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ų'   ,"0172"   ,0   ,930,352,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ų'   ,"0173"   ,0   ,960,352,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ŵ'   ,"0174"   ,0   ,990,352,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ŵ'   ,"0175"   ,0   ,0,396  ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ŷ'   ,"0176"   ,0   ,30,396 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ŷ'   ,"0177"   ,0   ,60,396 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ÿ'   ,"0178"   ,0   ,90,396 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ź'   ,"0179"   ,0   ,120,396,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ź'   ,"017a"   ,0   ,150,396,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ż'   ,"017b"   ,0   ,180,396,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ż'   ,"017c"   ,0   ,210,396,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ž'   ,"017d"   ,0   ,240,396,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ž'   ,"017e"   ,0   ,270,396,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ſ'   ,"017f"   ,0   ,300,396,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ƒ'   ,"0192"   ,0   ,330,396,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ơ'   ,"01a1"   ,0   ,360,396,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ʒ'   ,"01b7"   ,0   ,390,396,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ǻ'   ,"01fa"   ,0   ,420,396,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ǻ'   ,"01fb"   ,0   ,450,396,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ǽ'   ,"01fc"   ,0   ,480,396,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ǽ'   ,"01fd"   ,0   ,510,396,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ǿ'   ,"01fe"   ,0   ,540,396,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ǿ'   ,"01ff"   ,0   ,570,396,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ș'   ,"0218"   ,0   ,600,396,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ș'   ,"0219"   ,0   ,360,352,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ț'   ,"021a"   ,0   ,630,396,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ț'   ,"021b"   ,0   ,660,396,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ɑ'   ,"0251"   ,0   ,690,396,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ɸ'   ,"0278"   ,0   ,720,396,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ˆ'   ,"02c6"   ,0   ,840,44 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ˇ'   ,"02c7"   ,0   ,750,396,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ˉ'   ,"02c9"   ,0   ,780,396,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '˘'	,"02d8"   ,0   ,810,396,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '˙'	,"02d9"   ,0   ,840,396,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '˚'	,"02da"   ,0   ,210,132,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '˛'	,"02db"   ,0   ,870,396,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '˜'	,"02dc"   ,0   ,780,88 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '˝'	,"02dd"   ,0   ,900,396,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, ';'	,"037e"   ,0   ,930,396,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '΄'	,"0384"   ,0   ,960,396,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '΅'	,"0385"   ,0   ,990,396,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ά'   ,"0386"   ,0   ,0,440  ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '·'	,"0387"   ,0   ,30,440 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Έ'   ,"0388"   ,0   ,60,440 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ή'   ,"0389"   ,0   ,90,440 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ί'   ,"038a"   ,0   ,120,440,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ό'   ,"038c"   ,0   ,150,440,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ύ'   ,"038e"   ,0   ,180,440,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ώ'   ,"038f"   ,0   ,210,440,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ΐ'   ,"0390"   ,0   ,240,440,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Α'   ,"0391"   ,0   ,990,0  ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Β'   ,"0392"   ,0   ,0,44   ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Γ'   ,"0393"   ,0   ,270,440,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Δ'   ,"0394"   ,0   ,300,440,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ε'   ,"0395"   ,0   ,90,44  ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ζ'   ,"0396"   ,0   ,720,44 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Η'   ,"0397"   ,0   ,180,44 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Θ'   ,"0398"   ,0   ,330,440,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ι'   ,"0399"   ,0   ,210,44 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Κ'   ,"039a"   ,0   ,270,44 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Λ'   ,"039b"   ,0   ,360,440,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Μ'   ,"039c"   ,0   ,330,44 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ν'   ,"039d"   ,0   ,360,44 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ξ'   ,"039e"   ,0   ,390,440,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ο'   ,"039f"   ,0   ,390,44 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Π'   ,"03a0"   ,0   ,420,440,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ρ'   ,"03a1"   ,0   ,420,44 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Σ'   ,"03a3"   ,0   ,450,440,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Τ'   ,"03a4"   ,0   ,540,44 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Υ'   ,"03a5"   ,0   ,690,44 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Φ'   ,"03a6"   ,0   ,480,440,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Χ'   ,"03a7"   ,0   ,660,44 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ψ'   ,"03a8"   ,0   ,510,440,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ω'   ,"03a9"   ,0   ,540,440,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ϊ'   ,"03aa"   ,0   ,120,176,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ϋ'   ,"03ab"   ,0   ,90,396 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ά'   ,"03ac"   ,0   ,570,440,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'έ'   ,"03ad"   ,0   ,600,440,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ή'   ,"03ae"   ,0   ,630,440,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ί'   ,"03af"   ,0   ,660,440,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ΰ'   ,"03b0"   ,0   ,690,440,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'α'   ,"03b1"   ,0   ,720,440,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'β'   ,"03b2"   ,0   ,750,440,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'γ'   ,"03b3"   ,0   ,780,440,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'δ'   ,"03b4"   ,0   ,810,440,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ε'   ,"03b5"   ,0   ,840,440,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ζ'   ,"03b6"   ,0   ,870,440,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'η'   ,"03b7"   ,0   ,900,440,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'θ'   ,"03b8"   ,0   ,930,440,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ι'   ,"03b9"   ,0   ,960,440,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'κ'   ,"03ba"   ,0   ,990,440,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'λ'   ,"03bb"   ,0   ,0,484  ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'μ'   ,"03bc"   ,0   ,30,484 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ν'   ,"03bd"   ,0   ,60,484 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ξ'   ,"03be"   ,0   ,90,484 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ο'   ,"03bf"   ,0   ,330,88 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'π'   ,"03c0"   ,0   ,120,484,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ρ'   ,"03c1"   ,0   ,150,484,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ς'   ,"03c2"   ,0   ,180,484,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'σ'   ,"03c3"   ,0   ,210,484,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'τ'   ,"03c4"   ,0   ,240,484,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'υ'   ,"03c5"   ,0   ,270,484,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'φ'   ,"03c6"   ,0   ,300,484,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'χ'   ,"03c7"   ,0   ,330,484,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ψ'   ,"03c8"   ,0   ,360,484,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ω'   ,"03c9"   ,0   ,390,484,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ϊ'   ,"03ca"   ,0   ,420,484,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ϋ'   ,"03cb"   ,0   ,450,484,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ό'   ,"03cc"   ,0   ,480,484,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ύ'   ,"03cd"   ,0   ,510,484,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ώ'   ,"03ce"   ,0   ,540,484,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ϐ'   ,"03d0"   ,0   ,570,484,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ϴ'   ,"03f4"   ,0   ,330,440,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ѐ'   ,"0400"   ,0   ,600,484,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ё'   ,"0401"   ,0   ,630,484,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ђ'   ,"0402"   ,0   ,660,484,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ѓ'   ,"0403"   ,0   ,690,484,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Є'   ,"0404"   ,0   ,720,484,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ѕ'   ,"0405"   ,0   ,510,44 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'І'   ,"0406"   ,0   ,210,44 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ї'   ,"0407"   ,0   ,750,484,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ј'   ,"0408"   ,0   ,240,44 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Љ'   ,"0409"   ,0   ,780,484,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Њ'   ,"040a"   ,0   ,810,484,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ћ'   ,"040b"   ,0   ,840,484,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ќ'   ,"040c"   ,0   ,870,484,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ѝ'   ,"040d"   ,0   ,900,484,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ў'   ,"040e"   ,0   ,930,484,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Џ'   ,"040f"   ,0   ,960,484,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'А'   ,"0410"   ,0   ,990,484,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Б'   ,"0411"   ,0   ,0,528  ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'В'   ,"0412"   ,0   ,0,44   ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Г'   ,"0413"   ,0   ,270,440,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Д'   ,"0414"   ,0   ,30,528 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Е'   ,"0415"   ,0   ,90,44  ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ж'   ,"0416"   ,0   ,60,528 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'З'   ,"0417"   ,0   ,90,528 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'И'   ,"0418"   ,0   ,120,528,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Й'   ,"0419"   ,0   ,150,528,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'К'   ,"041a"   ,0   ,270,44 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Л'   ,"041b"   ,0   ,180,528,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'М'   ,"041c"   ,0   ,330,44 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Н'   ,"041d"   ,0   ,180,44 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'О'   ,"041e"   ,0   ,390,44 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'П'   ,"041f"   ,0   ,420,440,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Р'   ,"0420"   ,0   ,420,44 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'С'   ,"0421"   ,0   ,210,528,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Т'   ,"0422"   ,0   ,540,44 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'У'   ,"0423"   ,0   ,240,528,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ф'   ,"0424"   ,0   ,270,528,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Х'   ,"0425"   ,0   ,660,44 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ц'   ,"0426"   ,0   ,300,528,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ч'   ,"0427"   ,0   ,330,528,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ш'   ,"0428"   ,0   ,360,528,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Щ'   ,"0429"   ,0   ,390,528,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ъ'   ,"042a"   ,0   ,420,528,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ы'   ,"042b"   ,0   ,450,528,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ь'   ,"042c"   ,0   ,480,528,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Э'   ,"042d"   ,0   ,510,528,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ю'   ,"042e"   ,0   ,540,528,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Я'   ,"042f"   ,0   ,570,528,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'а'   ,"0430"   ,0   ,930,44 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'б'   ,"0431"   ,0   ,600,528,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'в'   ,"0432"   ,0   ,630,528,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'г'   ,"0433"   ,0   ,660,528,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'д'   ,"0434"   ,0   ,690,528,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'е'   ,"0435"   ,0   ,30,88  ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ж'   ,"0436"   ,0   ,720,528,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'з'   ,"0437"   ,0   ,750,528,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'и'   ,"0438"   ,0   ,780,528,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'й'   ,"0439"   ,0   ,810,528,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'к'   ,"043a"   ,0   ,210,308,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'л'   ,"043b"   ,0   ,840,528,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'м'   ,"043c"   ,0   ,870,528,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'н'   ,"043d"   ,0   ,900,528,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'о'   ,"043e"   ,0   ,330,88 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'п'   ,"043f"   ,0   ,930,528,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'р'   ,"0440"   ,0   ,360,88 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'с'   ,"0441"   ,0   ,990,44 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'т'   ,"0442"   ,0   ,960,528,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'у'   ,"0443"   ,0   ,990,528,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ф'   ,"0444"   ,0   ,0,572  ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'х'   ,"0445"   ,0   ,600,88 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ц'   ,"0446"   ,0   ,30,572 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ч'   ,"0447"   ,0   ,60,572 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ш'   ,"0448"   ,0   ,90,572 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'щ'   ,"0449"   ,0   ,120,572,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ъ'   ,"044a"   ,0   ,150,572,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ы'   ,"044b"   ,0   ,180,572,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ь'   ,"044c"   ,0   ,210,572,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'э'   ,"044d"   ,0   ,240,572,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ю'   ,"044e"   ,0   ,270,572,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'я'   ,"044f"   ,0   ,300,572,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ѐ'   ,"0450"   ,0   ,870,176,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ё'   ,"0451"   ,0   ,330,572,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ђ'   ,"0452"   ,0   ,360,572,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ѓ'   ,"0453"   ,0   ,390,572,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'є'   ,"0454"   ,0   ,420,572,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ѕ'   ,"0455"   ,0   ,450,88 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'і'   ,"0456"   ,0   ,150,88 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ї'   ,"0457"   ,0   ,450,572,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ј'   ,"0458"   ,0   ,180,88 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'љ'   ,"0459"   ,0   ,480,572,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'њ'   ,"045a"   ,0   ,510,572,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ћ'   ,"045b"   ,0   ,540,572,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ќ'   ,"045c"   ,0   ,570,572,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ѝ'   ,"045d"   ,0   ,600,572,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ў'   ,"045e"   ,0   ,630,572,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'џ'   ,"045f"   ,0   ,660,572,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ґ'   ,"0490"   ,0   ,690,572,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ґ'   ,"0491"   ,0   ,720,572,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  '־', "05be"   ,0   ,750,572,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'א', "05d0"   ,0   ,780,572,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'ב', "05d1"   ,0   ,810,572,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'ג', "05d2"   ,0   ,840,572,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'ד', "05d3"   ,0   ,870,572,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'ה', "05d4"   ,0   ,900,572,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'ו', "05d5"   ,0   ,930,572,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'ז', "05d6"   ,0   ,960,572,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'ח', "05d7"   ,0   ,990,572,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'ט', "05d8"   ,0   ,0,616  ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'י', "05d9"   ,0   ,30,616 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'ך', "05da"   ,0   ,60,616 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'כ', "05db"   ,0   ,90,616 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'ל', "05dc"   ,0   ,120,616,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'ם', "05dd"   ,0   ,150,616,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'מ', "05de"   ,0   ,180,616,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'ן', "05df"   ,0   ,210,616,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'נ', "05e0"   ,0   ,240,616,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'ס', "05e1"   ,0   ,270,616,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'ע', "05e2"   ,0   ,300,616,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'ף', "05e3"   ,0   ,330,616,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'פ', "05e4"   ,0   ,360,616,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'ץ', "05e5"   ,0   ,390,616,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'צ', "05e6"   ,0   ,420,616,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'ק', "05e7"   ,0   ,450,616,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'ר', "05e8"   ,0   ,480,616,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'ש', "05e9"   ,0   ,510,616,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'ת', "05ea"   ,0   ,540,616,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'װ', "05f0"   ,0   ,570,616,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'ױ', "05f1"   ,0   ,600,616,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  'ײ', "05f2"   ,0   ,630,616,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  '׳', "05f3"   ,0   ,660,616,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024,  '״', "05f4"   ,0   ,690,616,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ᴛ'   ,"1d1b"   ,0   ,720,616,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ᴦ'   ,"1d26"   ,0   ,750,616,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ᴨ'   ,"1d28"   ,0   ,780,616,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ẁ'   ,"1e80"   ,0   ,810,616,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ẁ'   ,"1e81"   ,0   ,840,616,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ẃ'   ,"1e82"   ,0   ,870,616,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ẃ'   ,"1e83"   ,0   ,900,616,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ẅ'   ,"1e84"   ,0   ,930,616,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ẅ'   ,"1e85"   ,0   ,960,616,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ẟ'   ,"1e9f"   ,0   ,810,440,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ỳ'   ,"1ef2"   ,0   ,990,616,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ỳ'   ,"1ef3"   ,0   ,0,660  ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '‐'	,"2010"   ,0   ,30,660 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '‒'	,"2012"   ,0   ,60,660 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '–'	,"2013"   ,0   ,60,660 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '—'	,"2014"   ,0   ,90,660 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '―'	,"2015"   ,0   ,90,660 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '‗'	,"2017"   ,0   ,120,660,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '‘'	,"2018"   ,0   ,150,660,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '’'	,"2019"   ,0   ,180,660,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '‚'	,"201a"   ,0   ,210,660,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '‛'	,"201b"   ,0   ,900,44 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '“'	,"201c"   ,0   ,240,660,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '”'	,"201d"   ,0   ,270,660,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '„'	,"201e"   ,0   ,300,660,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '‟'	,"201f"   ,0   ,330,660,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '†'	,"2020"   ,0   ,360,660,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '‡'	,"2021"   ,0   ,390,660,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '•'	,"2022"   ,0   ,420,660,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '…'	,"2026"   ,0   ,450,660,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '‧'	,"2027"   ,0   ,480,660,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '‰'	,"2030"   ,0   ,510,660,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '′'	,"2032"   ,0   ,330,132,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '″'	,"2033"   ,0   ,900,396,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '‵'	,"2035"   ,0   ,540,660,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '‹'	,"2039"   ,0   ,570,660,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '›'	,"203a"   ,0   ,600,660,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '‼'	,"203c"   ,0   ,630,660,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '‾'	,"203e"   ,0   ,660,660,30,42   ,24  ,-3);
//TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '‿,', "203f"   ,0   ,690,660,30,42   ,24  ,-3);
//TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, ''	,"2040"   ,0   ,720,660,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '⁄'	,"2044"   ,0   ,450,0  ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '⁔'	,"2054"   ,0   ,750,660,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '⁴'	,"2074"   ,0   ,780,660,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '⁵'	,"2075"   ,0   ,810,660,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '⁶'	,"2076"   ,0   ,840,660,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '⁷'	,"2077"   ,0   ,870,660,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '⁸'	,"2078"   ,0   ,900,660,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '⁹'	,"2079"   ,0   ,930,660,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '⁺'	,"207a"   ,0   ,960,660,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '⁻'	,"207b"   ,0   ,990,660,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ⁿ'   ,"207f"   ,0   ,0,704  ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '₁'	,"2081"   ,0   ,30,704 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '₂'	,"2082"   ,0   ,60,704 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '₃'	,"2083"   ,0   ,90,704 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '₄'	,"2084"   ,0   ,120,704,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '₅'	,"2085"   ,0   ,150,704,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '₆'	,"2086"   ,0   ,180,704,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '₇'	,"2087"   ,0   ,210,704,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '₈'	,"2088"   ,0   ,240,704,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '₉'	,"2089"   ,0   ,270,704,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '₊'	,"208a"   ,0   ,300,704,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '₋'	,"208b"   ,0   ,330,704,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '₣'	,"20a3"   ,0   ,360,704,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '₤'	,"20a4"   ,0   ,390,704,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '₧'	,"20a7"   ,0   ,420,704,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '₪'	,"20aa"   ,0   ,450,704,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '€'	,"20ac"   ,0   ,480,704,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '℅'	,"2105"   ,0   ,510,704,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'ℓ'   ,"2113"   ,0   ,540,704,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '№'	,"2116"   ,0   ,570,704,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '™'	,"2122"   ,0   ,600,704,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, 'Ω'   ,"2126"   ,0   ,630,704,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '℮'	,"212e"   ,0   ,30,88  ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '⅐'	,"2150"   ,0   ,660,704,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '⅑'	,"2151"   ,0   ,690,704,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '⅓'	,"2153"   ,0   ,720,704,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '⅔'	,"2154"   ,0   ,750,704,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '⅕'	,"2155"   ,0   ,780,704,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '⅖'	,"2156"   ,0   ,810,704,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '⅗'	,"2157"   ,0   ,840,704,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '⅘'	,"2158"   ,0   ,870,704,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '⅙'	,"2159"   ,0   ,900,704,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '⅚'	,"215a"   ,0   ,930,704,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '⅛'	,"215b"   ,0   ,960,704,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '⅜'	,"215c"   ,0   ,990,704,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '⅝'	,"215d"   ,0   ,0,748  ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '⅞'	,"215e"   ,0   ,30,748 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '←'	,"2190"   ,0   ,60,748 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '↑'	,"2191"   ,0   ,90,748 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '→'	,"2192"   ,0   ,120,748,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '↓'	,"2193"   ,0   ,150,748,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '↔'	,"2194"   ,0   ,180,748,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '↕'	,"2195"   ,0   ,210,748,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '↨'	,"21a8"   ,0   ,240,748,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '∂'	,"2202"   ,0   ,270,748,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '∅'	,"2205"   ,0   ,300,748,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '∆'	,"2206"   ,0   ,330,748,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '∈'	,"2208"   ,0   ,360,748,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '∏'	,"220f"   ,0   ,390,748,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '∑'	,"2211"   ,0   ,420,748,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '−'	,"2212"   ,0   ,390,0  ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '∕'	,"2215"   ,0   ,450,0  ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '∙'	,"2219"   ,0   ,480,660,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '√'	,"221a"   ,0   ,450,748,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '∞'	,"221e"   ,0   ,480,748,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '∟'	,"221f"   ,0   ,510,748,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '∩'	,"2229"   ,0   ,540,748,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '∫'	,"222b"   ,0   ,570,748,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '≈'	,"2248"   ,0   ,600,748,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '≠'	,"2260"   ,0   ,630,748,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '≡'	,"2261"   ,0   ,660,748,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '≤'	,"2264"   ,0   ,690,748,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '≥'	,"2265"   ,0   ,720,748,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '⊙'	,"2299"   ,0   ,750,748,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '⌀'	,"2300"   ,0   ,780,748,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '⌂'	,"2302"   ,0   ,810,88 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '⌐'	,"2310"   ,0   ,810,748,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '⌠'	,"2320"   ,0   ,840,748,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '⌡'	,"2321"   ,0   ,870,748,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '─'	,"2500"   ,0   ,900,748,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '│'	,"2502"   ,0   ,930,748,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '┌'	,"250c"   ,0   ,960,748,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '┐'	,"2510"   ,0   ,990,748,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '└'	,"2514"   ,0   ,0,792  ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '┘'	,"2518"   ,0   ,30,792 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '├'	,"251c"   ,0   ,60,792 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '┤'	,"2524"   ,0   ,90,792 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '┬'	,"252c"   ,0   ,120,792,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '┴'	,"2534"   ,0   ,150,792,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '┼'	,"253c"   ,0   ,180,792,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '═'	,"2550"   ,0   ,210,792,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '║'	,"2551"   ,0   ,240,792,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '╒'	,"2552"   ,0   ,270,792,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '╓'	,"2553"   ,0   ,300,792,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '╔'	,"2554"   ,0   ,330,792,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '╕'	,"2555"   ,0   ,360,792,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '╖'	,"2556"   ,0   ,390,792,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '╗'	,"2557"   ,0   ,420,792,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '╘'	,"2558"   ,0   ,450,792,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '╙'	,"2559"   ,0   ,480,792,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '╚'	,"255a"   ,0   ,510,792,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '╛'	,"255b"   ,0   ,540,792,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '╜'	,"255c"   ,0   ,570,792,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '╝'	,"255d"   ,0   ,600,792,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '╞'	,"255e"   ,0   ,630,792,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '╟'	,"255f"   ,0   ,660,792,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '╠'	,"2560"   ,0   ,690,792,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '╡'	,"2561"   ,0   ,720,792,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '╢'	,"2562"   ,0   ,750,792,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '╣'	,"2563"   ,0   ,780,792,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '╤'	,"2564"   ,0   ,810,792,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '╥'	,"2565"   ,0   ,840,792,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '╦'	,"2566"   ,0   ,870,792,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '╧'	,"2567"   ,0   ,900,792,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '╨'	,"2568"   ,0   ,930,792,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '╩'	,"2569"   ,0   ,960,792,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '╪'	,"256a"   ,0   ,990,792,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '╫'	,"256b"   ,0   ,0,836  ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '╬'	,"256c"   ,0   ,30,836 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '▀'	,"2580"   ,0   ,60,836 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '▁'	,"2581"   ,0   ,90,836 ,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '▄'	,"2584"   ,0   ,120,836,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '█'	,"2588"   ,0   ,150,836,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '▌'	,"258c"   ,0   ,180,836,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '▐'	,"2590"   ,0   ,210,836,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '░'	,"2591"   ,0   ,240,836,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '▒'	,"2592"   ,0   ,270,836,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '▓'	,"2593"   ,0   ,300,836,30,42   ,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0", 1024, '■'	,"25a0"	,0	,330,836,30,42	,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,'□'	,"25a1"	,0	,210,924,30,42	,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,'▪'	,"25aa"	,0	,390,836,30,42	,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,'▫'	,"25ab"	,0	,420,836,30,42	,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,'▬'	,"25ac"	,0	,450,836,30,42	,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,'▲'	,"25b2"	,0	,480,836,30,42	,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,'►'	,"25ba"	,0	,510,836,30,42	,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,'▼'	,"25bc"	,0	,540,836,30,42	,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,'◄'	,"25c4"	,0	,570,836,30,42	,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,'◊'	,"25ca"	,0	,600,836,30,42	,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,'○'	,"25cb"	,0	,630,836,30,42	,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,'●'	,"25cf"	,0	,660,836,30,42	,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,'◘'	,"25d8"	,0	,690,836,30,42	,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,'◙'	,"25d9"	,0	,720,836,30,42	,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,'◦'	,"25e6"	,0	,750,836,30,42	,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,'☺'	,"263a"	,0	,780,836,30,42	,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,'☻'	,"263b"	,0	,810,836,30,42	,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,'☼'	,"263c"	,0	,840,836,30,42	,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,'♀'	,"2640"	,0	,870,836,30,42	,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,'♂'	,"2642"	,0	,900,836,30,42	,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,'♠'	,"2660"	,0	,930,836,30,42	,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,'♣'	,"2663"	,0	,960,836,30,42	,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,'♥'	,"2665"	,0	,990,836,30,42	,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,'♦'	,"2666"	,0	,0,880	,30,42	,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,'♪'	,"266a"	,0	,30,880	,30,42	,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,'♫'	,"266b"	,0	,60,880	,30,42	,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,'✓'	,"2713"	,0	,90,880	,30,42	,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e001"	,0	,240,924,53,45	,49  ,-4);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e002"	,0	,293,924,53,45	,49  ,-4);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e003"	,0	,346,924,53,45	,49  ,-4);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e004"	,0	,399,924,53,45	,49  ,-4);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e005"	,0	,452,924,53,45	,49  ,-4);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e006"	,0	,505,924,53,45	,49  ,-4);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e007"	,0	,558,924,53,45	,49  ,-4);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e008"	,0	,611,924,53,45	,49  ,-4);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e009"	,0	,664,924,53,45	,49  ,-4);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e00a"	,0	,717,924,53,45	,49  ,-4);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e00b"	,0	,770,924,53,45	,49  ,-4);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e00c"	,0	,823,924,53,45	,49  ,-4);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e00d"	,0	,876,924,53,45	,49  ,-4);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e00e"	,0	,929,924,53,45	,49  ,-4);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e00f"	,0	,0,969	,53,45	,49  ,-4);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e010"	,0	,53,969	,53,45	,49  ,-4);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e011"	,0	,106,969,53,45	,49  ,-4);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e012"	,0	,159,969,53,45	,49  ,-4);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e013"	,0	,212,969,53,45	,49  ,-4);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e014"	,0	,265,969,53,45	,49  ,-4);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e015"	,0	,318,969,53,45	,49  ,-4);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e016"	,0	,371,969,53,45	,49  ,-4);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e017"	,0	,424,969,53,45	,49  ,-4);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e018"	,0	,477,969,53,45	,49  ,-4);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e019"	,0	,530,969,53,45	,49  ,-4);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e020"	,0	,583,969,53,45	,49  ,-4);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e021"	,0	,636,969,53,45	,49  ,-4);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e030"	,0	,120,880,30,42	,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e031"	,0	,150,880,30,42	,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e032"	,0	,180,880,30,42	,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e033"	,0	,210,880,30,42	,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e034"	,0	,240,880,30,42	,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e035"	,0	,270,880,30,42	,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e036"	,0	,300,880,30,42	,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e037"	,0	,330,880,30,42	,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e038"	,0	,360,880,30,42	,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e039"	,0	,390,880,30,42	,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e03a"	,0	,420,880,30,42	,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e03b"	,0	,450,880,30,42	,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e03c"	,0	,480,880,30,42	,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e03d"	,0	,510,880,30,42	,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e03e"	,0	,540,880,30,42	,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e03f"	,0	,570,880,30,42	,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e040"	,0	,600,880,30,42	,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e041"	,0	,630,880,30,42	,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e042"	,0	,660,880,30,42	,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e043"	,0	,690,880,30,42	,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e044"	,0	,720,880,30,42	,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e045"	,0	,750,880,30,42	,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e046"	,0	,780,880,30,42	,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e047"	,0	,810,880,30,42	,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e048"	,0	,840,880,30,42	,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e049"	,0	,870,880,30,42	,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e050"	,0	,900,880,30,42	,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e051"	,0	,930,880,30,42	,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e052"	,0	,960,880,30,42	,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e053"	,0	,990,880,30,42	,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e054"	,0	,0,924	,30,42	,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e055"	,0	,30,924	,30,42	,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e056"	,0	,60,924	,30,42	,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e057"	,0	,90,924	,30,42	,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e058"	,0	,120,924,30,42	,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,'ﬁ'	,"fb01"	,0	,150,924,30,42	,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,'ﬂ'	,"fb02"	,0	,180,924,30,42	,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,'�'	,"fffd"	,0	,360,836,30,42	,24  ,-3);
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e070"	,0	,0,0  	,1 ,1	,0	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e071"	,0	,0,0  	,1 ,1   ,1	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e072"	,0	,0,0  	,1 ,1	,3	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e073"	,0	,0,0  	,1 ,1	,7	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e074"	,0	,0,0  	,1 ,1	,15	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e075"	,0	,0,0  	,1 ,1	,31	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e076"	,0	,0,0  	,1 ,1	,63	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e077"	,0	,0,0  	,1 ,1	,127,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData0",1024				,''	,"e078"	,0	,0,0  	,1 ,1	,255,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e100"	,1	,14,14	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e101"	,1	,78,14	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e102"	,1	,142,14	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e103"	,1	,206,14	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e104"	,1	,270,14	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e105"	,1	,334,14	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e106"	,1	,398,14	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e107"	,1	,462,14	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e108"	,1	,526,14	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e109"	,1	,590,14	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e10a"	,1	,654,14	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e10b"	,1	,718,14	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e10c"	,1	,782,14	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e10d"	,1	,846,14	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e10e"	,1	,910,14	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e10f"	,1	,974,14	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e110"	,1	,14,78	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e111"	,1	,78,78	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e112"	,1	,142,78	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e113"	,1	,206,78	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e114"	,1	,270,78	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e115"	,1	,334,78	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e116"	,1	,398,78	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e117"	,1	,462,78	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e118"	,1	,526,78	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e119"	,1	,590,78	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e11a"	,1	,654,78	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e11b"	,1	,718,78	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e11c"	,1	,782,78	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e11d"	,1	,846,78	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e11e"	,1	,910,78	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e11f"	,1	,974,78	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e120"	,1	,14,142	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e121"	,1	,78,142	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e122"	,1	,142,142,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e123"	,1	,206,142,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e124"	,1	,270,142,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e125"	,1	,334,142,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e126"	,1	,398,142,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e127"	,1	,462,142,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e128"	,1	,526,142,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e129"	,1	,590,142,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e12a"	,1	,654,142,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e12b"	,1	,718,142,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e12c"	,1	,782,142,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e12d"	,1	,846,142,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e12e"	,1	,910,142,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e12f"	,1	,974,142,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e130"	,1	,14,206	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e131"	,1	,78,206	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e132"	,1	,142,206,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e133"	,1	,206,206,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e134"	,1	,270,206,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e135"	,1	,334,206,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e136"	,1	,398,206,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e137"	,1	,462,206,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e138"	,1	,526,206,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e139"	,1	,590,206,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e13a"	,1	,654,206,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e13b"	,1	,718,206,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e13c"	,1	,782,206,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e13d"	,1	,846,206,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e13e"	,1	,910,206,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e13f"	,1	,974,206,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e140"	,1	,14,270	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e141"	,1	,78,270	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e142"	,1	,142,270,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e143"	,1	,206,270,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e144"	,1	,270,270,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e145"	,1	,334,270,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e146"	,1	,398,270,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e147"	,1	,462,270,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e148"	,1	,526,270,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e149"	,1	,590,270,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e14a"	,1	,654,270,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e14b"	,1	,718,270,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e14c"	,1	,782,270,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e14d"	,1	,846,270,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e14e"	,1	,910,270,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e14f"	,1	,974,270,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e150"	,1	,14,334	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e151"	,1	,78,334	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e152"	,1	,142,334,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e153"	,1	,206,334,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e154"	,1	,270,334,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e155"	,1	,334,334,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e156"	,1	,398,334,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e157"	,1	,462,334,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e158"	,1	,526,334,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e159"	,1	,590,334,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e15a"	,1	,654,334,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e15b"	,1	,718,334,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e15c"	,1	,782,334,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e15d"	,1	,846,334,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e15e"	,1	,910,334,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e15f"	,1	,974,334,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e160"	,1	,14,398	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e161"	,1	,78,398	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e162"	,1	,142,398,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e163"	,1	,206,398,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e164"	,1	,270,398,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e165"	,1	,334,398,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e166"	,1	,398,398,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e167"	,1	,462,398,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e168"	,1	,526,398,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e169"	,1	,590,398,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e16a"	,1	,654,398,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e16b"	,1	,718,398,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e16c"	,1	,782,398,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e16d"	,1	,846,398,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e16e"	,1	,910,398,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e16f"	,1	,974,398,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e170"	,1	,14,462	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e171"	,1	,78,462	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e172"	,1	,142,462,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e173"	,1	,206,462,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e174"	,1	,270,462,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e175"	,1	,334,462,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e176"	,1	,398,462,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e177"	,1	,462,462,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e178"	,1	,526,462,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e179"	,1	,590,462,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e17a"	,1	,654,462,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e17b"	,1	,718,462,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e17c"	,1	,782,462,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e17d"	,1	,846,462,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e17e"	,1	,910,462,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e17f"	,1	,974,462,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e180"	,1	,14,526	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e181"	,1	,78,526	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e182"	,1	,142,526,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e183"	,1	,206,526,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e184"	,1	,270,526,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e185"	,1	,334,526,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e186"	,1	,398,526,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e187"	,1	,462,526,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e188"	,1	,526,526,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e189"	,1	,590,526,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e18a"	,1	,654,526,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e18b"	,1	,718,526,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e18c"	,1	,782,526,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e18d"	,1	,846,526,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e18e"	,1	,910,526,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e18f"	,1	,974,526,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e190"	,1	,14,590	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e191"	,1	,78,590	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e192"	,1	,142,590,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e193"	,1	,206,590,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e194"	,1	,270,590,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e195"	,1	,334,590,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e196"	,1	,398,590,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e197"	,1	,462,590,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e198"	,1	,526,590,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e199"	,1	,590,590,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e19a"	,1	,654,590,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e19b"	,1	,718,590,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e19c"	,1	,782,590,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e19d"	,1	,846,590,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e19e"	,1	,910,590,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e19f"	,1	,974,590,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1a0"	,1	,14,654	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1a1"	,1	,78,654	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1a2"	,1	,142,654,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1a3"	,1	,206,654,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1a4"	,1	,270,654,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1a5"	,1	,334,654,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1a6"	,1	,398,654,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1a7"	,1	,462,654,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1a8"	,1	,526,654,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1a9"	,1	,590,654,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1aa"	,1	,654,654,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1ab"	,1	,718,654,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1ac"	,1	,782,654,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1ad"	,1	,846,654,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1ae"	,1	,910,654,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1af"	,1	,974,654,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1b0"	,1	,14,718	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1b1"	,1	,78,718	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1b2"	,1	,142,718,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1b3"	,1	,206,718,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1b4"	,1	,270,718,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1b5"	,1	,334,718,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1b6"	,1	,398,718,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1b7"	,1	,462,718,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1b8"	,1	,526,718,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1b9"	,1	,590,718,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1ba"	,1	,654,718,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1bb"	,1	,718,718,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1bc"	,1	,782,718,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1bd"	,1	,846,718,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1be"	,1	,910,718,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1bf"	,1	,974,718,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1c0"	,1	,14,782	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1c1"	,1	,78,782	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1c2"	,1	,142,782,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1c3"	,1	,206,782,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1c4"	,1	,270,782,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1c5"	,1	,334,782,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1c6"	,1	,398,782,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1c7"	,1	,462,782,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1c8"	,1	,526,782,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1c9"	,1	,590,782,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1ca"	,1	,654,782,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1cb"	,1	,718,782,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1cc"	,1	,782,782,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1cd"	,1	,846,782,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1ce"	,1	,910,782,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1cf"	,1	,974,782,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1d0"	,1	,14,846	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1d1"	,1	,78,846	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1d2"	,1	,142,846,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1d3"	,1	,206,846,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1d4"	,1	,270,846,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1d5"	,1	,334,846,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1d6"	,1	,398,846,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1d7"	,1	,462,846,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1d8"	,1	,526,846,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1d9"	,1	,590,846,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1da"	,1	,654,846,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1db"	,1	,718,846,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1dc"	,1	,782,846,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1dd"	,1	,846,846,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1de"	,1	,910,846,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1df"	,1	,974,846,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1e0"	,1	,14,910	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1e1"	,1	,78,910	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1e2"	,1	,142,910,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1e3"	,1	,206,910,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1e4"	,1	,270,910,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1e5"	,1	,334,910,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1e6"	,1	,398,910,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1e7"	,1	,462,910,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1e8"	,1	,526,910,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1e9"	,1	,590,910,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1ea"	,1	,654,910,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1eb"	,1	,718,910,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1ec"	,1	,782,910,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1ed"	,1	,846,910,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1ee"	,1	,910,910,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1ef"	,1	,974,910,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1f0"	,1	,14,974	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1f1"	,1	,78,974	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1f2"	,1	,142,974,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1f3"	,1	,206,974,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1f4"	,1	,270,974,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1f5"	,1	,334,974,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1f6"	,1	,398,974,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1f7"	,1	,462,974,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1f8"	,1	,526,974,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1f9"	,1	,590,974,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1fa"	,1	,654,974,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1fb"	,1	,718,974,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1fc"	,1	,782,974,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1fd"	,1	,846,974,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1fe"	,1	,910,974,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData1",1024				,''	,"e1ff"	,1	,974,974,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e200"	,2	,14,14	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e201"	,2	,78,14	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e202"	,2	,142,14	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e203"	,2	,206,14	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e204"	,2	,270,14	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e205"	,2	,334,14	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e206"	,2	,398,14	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e207"	,2	,462,14	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e208"	,2	,526,14	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e209"	,2	,590,14	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e20a"	,2	,654,14	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e20b"	,2	,718,14	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e20c"	,2	,782,14	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e20d"	,2	,846,14	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e20e"	,2	,910,14	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e20f"	,2	,974,14	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e210"	,2	,14,78	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e211"	,2	,78,78	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e212"	,2	,142,78	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e213"	,2	,206,78	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e214"	,2	,270,78	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e215"	,2	,334,78	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e216"	,2	,398,78	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e217"	,2	,462,78	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e218"	,2	,526,78	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e219"	,2	,590,78	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e21a"	,2	,654,78	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e21b"	,2	,718,78	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e21c"	,2	,782,78	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e21d"	,2	,846,78	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e21e"	,2	,910,78	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e21f"	,2	,974,78	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e220"	,2	,14,142	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e221"	,2	,78,142	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e222"	,2	,142,142,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e223"	,2	,206,142,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e224"	,2	,270,142,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e225"	,2	,334,142,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e226"	,2	,398,142,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e227"	,2	,462,142,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e228"	,2	,526,142,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e229"	,2	,590,142,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e22a"	,2	,654,142,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e22b"	,2	,718,142,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e22c"	,2	,782,142,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e22d"	,2	,846,142,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e22e"	,2	,910,142,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e22f"	,2	,974,142,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e230"	,2	,14,206	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e231"	,2	,78,206	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e232"	,2	,142,206,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e233"	,2	,206,206,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e234"	,2	,270,206,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e235"	,2	,334,206,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e236"	,2	,398,206,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e237"	,2	,462,206,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e238"	,2	,526,206,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e239"	,2	,590,206,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e23a"	,2	,654,206,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e23b"	,2	,718,206,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e23c"	,2	,782,206,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e23d"	,2	,846,206,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e23e"	,2	,910,206,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e23f"	,2	,974,206,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e240"	,2	,14,270	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e241"	,2	,78,270	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e242"	,2	,142,270,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e243"	,2	,206,270,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e244"	,2	,270,270,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e245"	,2	,334,270,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e246"	,2	,398,270,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e247"	,2	,462,270,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e248"	,2	,526,270,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e249"	,2	,590,270,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e24a"	,2	,654,270,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e24b"	,2	,718,270,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e24c"	,2	,782,270,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e24d"	,2	,846,270,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e24e"	,2	,910,270,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e24f"	,2	,974,270,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e250"	,2	,14,334	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e251"	,2	,78,334	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e252"	,2	,142,334,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e253"	,2	,206,334,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e254"	,2	,270,334,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e255"	,2	,334,334,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e256"	,2	,398,334,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e257"	,2	,462,334,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e258"	,2	,526,334,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e259"	,2	,590,334,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e25a"	,2	,654,334,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e25b"	,2	,718,334,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e25c"	,2	,782,334,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e25d"	,2	,846,334,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e25e"	,2	,910,334,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e25f"	,2	,974,334,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e260"	,2	,14,398	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e261"	,2	,78,398	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e262"	,2	,142,398,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e263"	,2	,206,398,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e264"	,2	,270,398,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e265"	,2	,334,398,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e266"	,2	,398,398,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e267"	,2	,462,398,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e268"	,2	,526,398,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e269"	,2	,590,398,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e26a"	,2	,654,398,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e26b"	,2	,718,398,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e26c"	,2	,782,398,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e26d"	,2	,846,398,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e26e"	,2	,910,398,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e26f"	,2	,974,398,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e270"	,2	,14,462	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e271"	,2	,78,462	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e272"	,2	,142,462,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e273"	,2	,206,462,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e274"	,2	,270,462,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e275"	,2	,334,462,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e276"	,2	,398,462,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e277"	,2	,462,462,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e278"	,2	,526,462,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e279"	,2	,590,462,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e27a"	,2	,654,462,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e27b"	,2	,718,462,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e27c"	,2	,782,462,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e27d"	,2	,846,462,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e27e"	,2	,910,462,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e27f"	,2	,974,462,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e280"	,2	,14,526	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e281"	,2	,78,526	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e282"	,2	,142,526,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e283"	,2	,206,526,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e284"	,2	,270,526,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e285"	,2	,334,526,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e286"	,2	,398,526,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e287"	,2	,462,526,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e288"	,2	,526,526,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e289"	,2	,590,526,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e28a"	,2	,654,526,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e28b"	,2	,718,526,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e28c"	,2	,782,526,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e28d"	,2	,846,526,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e28e"	,2	,910,526,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e28f"	,2	,974,526,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e290"	,2	,14,590	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e291"	,2	,78,590	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e292"	,2	,142,590,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e293"	,2	,206,590,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e294"	,2	,270,590,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e295"	,2	,334,590,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e296"	,2	,398,590,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e297"	,2	,462,590,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e298"	,2	,526,590,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e299"	,2	,590,590,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e29a"	,2	,654,590,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e29b"	,2	,718,590,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e29c"	,2	,782,590,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e29d"	,2	,846,590,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e29e"	,2	,910,590,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e29f"	,2	,974,590,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2a0"	,2	,14,654	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2a1"	,2	,78,654	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2a2"	,2	,142,654,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2a3"	,2	,206,654,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2a4"	,2	,270,654,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2a5"	,2	,334,654,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2a6"	,2	,398,654,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2a7"	,2	,462,654,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2a8"	,2	,526,654,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2a9"	,2	,590,654,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2aa"	,2	,654,654,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2ab"	,2	,718,654,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2ac"	,2	,782,654,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2ad"	,2	,846,654,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2ae"	,2	,910,654,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2af"	,2	,974,654,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2b0"	,2	,14,718	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2b1"	,2	,78,718	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2b2"	,2	,142,718,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2b3"	,2	,206,718,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2b4"	,2	,270,718,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2b5"	,2	,334,718,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2b6"	,2	,398,718,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2b7"	,2	,462,718,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2b8"	,2	,526,718,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2b9"	,2	,590,718,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2ba"	,2	,654,718,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2bb"	,2	,718,718,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2bc"	,2	,782,718,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2bd"	,2	,846,718,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2be"	,2	,910,718,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2bf"	,2	,974,718,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2c0"	,2	,14,782	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2c1"	,2	,78,782	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2c2"	,2	,142,782,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2c3"	,2	,206,782,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2c4"	,2	,270,782,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2c5"	,2	,334,782,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2c6"	,2	,398,782,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2c7"	,2	,462,782,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2c8"	,2	,526,782,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2c9"	,2	,590,782,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2ca"	,2	,654,782,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2cb"	,2	,718,782,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2cc"	,2	,782,782,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2cd"	,2	,846,782,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2ce"	,2	,910,782,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2cf"	,2	,974,782,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2d0"	,2	,14,846	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2d1"	,2	,78,846	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2d2"	,2	,142,846,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2d3"	,2	,206,846,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2d4"	,2	,270,846,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2d5"	,2	,334,846,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2d6"	,2	,398,846,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2d7"	,2	,462,846,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2d8"	,2	,526,846,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2d9"	,2	,590,846,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2da"	,2	,654,846,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2db"	,2	,718,846,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2dc"	,2	,782,846,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2dd"	,2	,846,846,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2de"	,2	,910,846,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2df"	,2	,974,846,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2e0"	,2	,14,910	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2e1"	,2	,78,910	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2e2"	,2	,142,910,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2e3"	,2	,206,910,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2e4"	,2	,270,910,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2e5"	,2	,334,910,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2e6"	,2	,398,910,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2e7"	,2	,462,910,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2e8"	,2	,526,910,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2e9"	,2	,590,910,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2ea"	,2	,654,910,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2eb"	,2	,718,910,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2ec"	,2	,782,910,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2ed"	,2	,846,910,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2ee"	,2	,910,910,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2ef"	,2	,974,910,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2f0"	,2	,14,974	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2f1"	,2	,78,974	,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2f2"	,2	,142,974,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2f3"	,2	,206,974,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2f4"	,2	,270,974,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2f5"	,2	,334,974,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2f6"	,2	,398,974,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2f7"	,2	,462,974,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2f8"	,2	,526,974,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2f9"	,2	,590,974,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2fa"	,2	,654,974,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2fb"	,2	,718,974,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2fc"	,2	,782,974,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2fd"	,2	,846,974,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2fe"	,2	,910,974,37,37	,36	,0 );
TryAddChar("monospace",30,37  ,23, "MonoFontData2",1024				,''	,"e2ff"	,2	,974,974,37,37	,36	,0 );

			#endregion

			#region whitefont


TryAddChar("white" ,30,37,23, "FontData0"      ,1024,' ' ,"0020",0 ,0  ,0  ,15,45,8 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'!' ,"0021",0 ,15 ,0  ,24,45,8 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'"' ,"0022",0	,39 ,0	,25,45,10,-7);	
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'#' ,"0023",0	,64 ,0	,35,45,19,-7);	
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'$' ,"0024",0 ,99 ,0  ,36,45,20,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'%' ,"0025",0 ,135,0  ,39,45,24,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'&' ,"0026",0 ,174,0  ,35,45,20,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'\'',"0027",0	,209,0	,22,45,6 ,-7);	
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'(' ,"0028",0 ,231,0  ,24,45,9 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,')' ,"0029",0 ,255,0  ,24,45,9 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'*' ,"002a",0 ,279,0  ,26,45,11,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'+' ,"002b",0 ,305,0  ,34,45,18,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,',' ,"002c",0 ,339,0  ,25,45,9 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'-' ,"002d",0 ,364,0  ,25,45,10,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'.' ,"002e",0 ,389,0  ,25,45,9 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'/' ,"002f",0 ,414,0  ,30,45,14,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'0' ,"0030",0 ,444,0  ,35,45,19,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'1' ,"0031",0 ,479,0  ,24,45,9 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'2' ,"0032",0 ,503,0  ,34,45,19,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'3' ,"0033",0 ,537,0  ,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'4' ,"0034",0 ,570,0  ,34,45,19,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'5' ,"0035",0 ,604,0  ,35,45,19,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'6' ,"0036",0 ,639,0  ,35,45,19,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'7' ,"0037",0 ,674,0  ,31,45,16,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'8' ,"0038",0 ,705,0  ,35,45,19,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'9' ,"0039",0 ,740,0  ,35,45,19,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,':' ,"003a",0 ,775,0  ,25,45,9 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,';' ,"003b",0 ,800,0  ,25,45,9 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'<' ,"003c",0 ,825,0  ,34,45,18,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'=' ,"003d",0 ,859,0  ,34,45,18,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'>' ,"003e",0 ,893,0  ,34,45,18,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'?' ,"003f",0 ,927,0  ,31,45,16,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'@' ,"0040",0 ,958,0  ,40,45,25,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'A' ,"0041",0 ,0  ,45 ,37,45,21,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'B' ,"0042",0 ,37 ,45 ,37,45,21,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'C' ,"0043",0 ,74 ,45 ,35,45,19,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'D' ,"0044",0 ,109,45 ,37,45,21,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'E' ,"0045",0 ,146,45 ,34,45,18,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'F' ,"0046",0 ,180,45 ,32,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'G' ,"0047",0 ,212,45 ,36,45,20,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'H' ,"0048",0 ,248,45 ,35,45,20,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'I' ,"0049",0 ,283,45 ,24,45,8 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'J' ,"004a",0 ,307,45 ,31,45,16,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'K' ,"004b",0 ,338,45 ,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'L' ,"004c",0 ,371,45 ,30,45,15,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'M' ,"004d",0 ,401,45 ,42,45,26,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'N' ,"004e",0 ,443,45 ,37,45,21,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'O' ,"004f",0 ,480,45 ,37,45,21,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'P' ,"0050",0 ,517,45 ,35,45,20,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Q' ,"0051",0 ,552,45 ,37,45,21,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'R' ,"0052",0 ,589,45 ,37,45,21,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'S' ,"0053",0 ,626,45 ,37,45,21,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'T' ,"0054",0 ,663,45 ,32,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'U' ,"0055",0 ,695,45 ,36,45,20,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'V' ,"0056",0 ,731,45 ,35,45,20,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'W' ,"0057",0 ,766,45 ,47,45,31,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'X' ,"0058",0 ,813,45 ,35,45,19,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Y' ,"0059",0 ,848,45 ,36,45,20,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Z' ,"005a",0 ,884,45 ,35,45,19,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'[' ,"005b",0 ,919,45 ,25,45,9 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'\\',"005c",0 ,944,45 ,28,45,12,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,']' ,"005d",0 ,972,45 ,25,45,9 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'^' ,"005e",0 ,0  ,90 ,34,45,18,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'_' ,"005f",0 ,34 ,90 ,31,45,15,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'`' ,"0060",0 ,65 ,90 ,23,45,8 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'a' ,"0061",0 ,88 ,90 ,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'b' ,"0062",0 ,121,90 ,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'c' ,"0063",0 ,154,90 ,32,45,16,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'d' ,"0064",0 ,186,90 ,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'e' ,"0065",0 ,219,90 ,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'f' ,"0066",0 ,252,90 ,24,45,9 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'g' ,"0067",0 ,276,90 ,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'h' ,"0068",0 ,309,90 ,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'i' ,"0069",0 ,342,90 ,23,45,8 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'j' ,"006a",0 ,365,90 ,23,45,8 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'k' ,"006b",0 ,388,90 ,32,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'l' ,"006c",0 ,420,90 ,23,45,8 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'m' ,"006d",0 ,443,90 ,42,45,27,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'n' ,"006e",0 ,485,90 ,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'o' ,"006f",0 ,518,90 ,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'p' ,"0070",0 ,551,90 ,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'q' ,"0071",0 ,584,90 ,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'r' ,"0072",0 ,617,90 ,25,45,10,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'s' ,"0073",0 ,642,90 ,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'t' ,"0074",0 ,675,90 ,25,45,9 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'u' ,"0075",0 ,700,90 ,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'v' ,"0076",0 ,733,90 ,30,45,15,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'w' ,"0077",0 ,763,90 ,42,45,27,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'x' ,"0078",0 ,805,90 ,31,45,15,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'y' ,"0079",0 ,836,90 ,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'z' ,"007a",0 ,869,90 ,31,45,16,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'{' ,"007b",0 ,900,90 ,25,45,9 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'|' ,"007c",0 ,925,90 ,22,45,6 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'}' ,"007d",0 ,947,90 ,25,45,9 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'~' ,"007e",0 ,972,90 ,34,45,18,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,' ' ,"00a0",0 ,0  ,135,23,45,8 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'¡' ,"00a1",0 ,23 ,135,24,45,8 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'¢' ,"00a2",0 ,47 ,135,32,45,16,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'£' ,"00a3",0 ,79 ,135,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'¤' ,"00a4",0 ,112,135,35,45,19,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'¥' ,"00a5",0 ,147,135,35,45,19,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'¦' ,"00a6",0 ,182,135,22,45,6 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'§' ,"00a7",0 ,204,135,36,45,20,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'¨' ,"00a8",0 ,240,135,23,45,8 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'©' ,"00a9",0 ,263,135,40,45,25,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ª' ,"00aa",0 ,303,135,26,45,10,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'«' ,"00ab",0 ,329,135,30,45,15,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'¬' ,"00ac",0 ,359,135,34,45,18,-7);
//TryAddChar("white" ,30  ,37  ,23,0   ,"FontDa0ds"    ,1024 ­,'­'  ,"00ad"     ,0    ,393,135 ,14,8    ,10  ,-7);//check
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'®' ,"00ae",0 ,407,135,40,45,25,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'¯' ,"00af",0 ,447,135,23,45,8 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'°' ,"00b0",0 ,470,135,27,45,12,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'±' ,"00b1",0 ,497,135,34,45,18,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'²' ,"00b2",0 ,531,135,27,45,11,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'³' ,"00b3",0 ,558,135,27,45,11,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'´' ,"00b4",0 ,585,135,23,45,8 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'µ' ,"00b5",0 ,608,135,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'¶' ,"00b6",0 ,641,135,34,45,18,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'·' ,"00b7",0 ,675,135,25,45,9 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'¸' ,"00b8",0 ,700,135,23,45,8 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'¹' ,"00b9",0 ,723,135,27,45,11,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'º' ,"00ba",0 ,750,135,26,45,10,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'»' ,"00bb",0 ,776,135,30,45,15,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'¼' ,"00bc",0 ,806,135,43,45,27,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'½' ,"00bd",0 ,849,135,45,45,29,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'¾' ,"00be",0 ,894,135,43,45,28,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'¿' ,"00bf",0 ,937,135,31,45,16,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'À' ,"00c0",0 ,968,135,37,45,21,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Á' ,"00c1",0 ,0  ,180,37,45,21,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Â' ,"00c2",0 ,37 ,180,37,45,21,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ã' ,"00c3",0 ,74 ,180,37,45,21,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ä' ,"00c4",0 ,111,180,37,45,21,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Å' ,"00c5",0 ,148,180,37,45,21,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Æ' ,"00c6",0 ,185,180,47,45,31,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ç' ,"00c7",0 ,232,180,35,45,19,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'È' ,"00c8",0 ,267,180,34,45,18,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'É' ,"00c9",0 ,301,180,34,45,18,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ê' ,"00ca",0 ,335,180,34,45,18,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ë' ,"00cb",0 ,369,180,34,45,18,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ì' ,"00cc",0 ,403,180,24,45,8 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Í' ,"00cd",0 ,427,180,24,45,8 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Î' ,"00ce",0 ,451,180,24,45,8 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ï' ,"00cf",0 ,475,180,24,45,8 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ð' ,"00d0",0 ,499,180,37,45,21,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ñ' ,"00d1",0 ,536,180,37,45,21,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ò' ,"00d2",0 ,573,180,37,45,21,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ó' ,"00d3",0 ,610,180,37,45,21,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ô' ,"00d4",0 ,647,180,37,45,21,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Õ' ,"00d5",0 ,684,180,37,45,21,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ö' ,"00d6",0 ,721,180,37,45,21,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'×' ,"00d7",0 ,758,180,34,45,18,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ø' ,"00d8",0 ,792,180,37,45,21,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ù' ,"00d9",0 ,829,180,36,45,20,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ú' ,"00da",0 ,865,180,36,45,20,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Û' ,"00db",0 ,901,180,36,45,20,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ü' ,"00dc",0 ,937,180,36,45,20,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ý' ,"00dd",0 ,973,180,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Þ' ,"00de",0 ,0  ,225,35,45,20,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ß' ,"00df",0 ,35 ,225,34,45,19,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'à' ,"00e0",0 ,69 ,225,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'á' ,"00e1",0 ,102,225,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'â' ,"00e2",0 ,135,225,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ã' ,"00e3",0 ,168,225,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ä' ,"00e4",0 ,201,225,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'å' ,"00e5",0 ,234,225,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'æ' ,"00e6",0 ,267,225,44,45,28,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ç' ,"00e7",0 ,311,225,32,45,16,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'è' ,"00e8",0 ,343,225,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'é' ,"00e9",0 ,376,225,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ê' ,"00ea",0 ,409,225,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ë' ,"00eb",0 ,442,225,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ì' ,"00ec",0 ,475,225,23,45,8 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'í' ,"00ed",0 ,498,225,23,45,8 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'î' ,"00ee",0 ,521,225,23,45,8 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ï' ,"00ef",0 ,544,225,23,45,8 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ð' ,"00f0",0 ,567,225,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ñ' ,"00f1",0 ,600,225,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ò' ,"00f2",0 ,633,225,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ó' ,"00f3",0 ,666,225,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ô' ,"00f4",0 ,699,225,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'õ' ,"00f5",0 ,732,225,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ö' ,"00f6",0 ,765,225,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'÷' ,"00f7",0 ,798,225,34,45,18,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ø' ,"00f8",0 ,832,225,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ù' ,"00f9",0 ,865,225,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ú' ,"00fa",0 ,898,225,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'û' ,"00fb",0 ,931,225,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ü' ,"00fc",0 ,964,225,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ý' ,"00fd",0 ,0  ,270,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'þ' ,"00fe",0 ,33 ,270,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ÿ' ,"00ff",0 ,66 ,270,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ā' ,"0100",0 ,99 ,270,35,45,20,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ā' ,"0101",0 ,134,270,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ă' ,"0102",0 ,167,270,37,45,21,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ă' ,"0103",0 ,204,270,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ą' ,"0104",0 ,237,270,37,45,21,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ą' ,"0105",0 ,274,270,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ć' ,"0106",0 ,307,270,35,45,19,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ć' ,"0107",0 ,342,270,32,45,16,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ĉ' ,"0108",0 ,374,270,35,45,19,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ĉ' ,"0109",0 ,409,270,32,45,16,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ċ' ,"010a",0 ,441,270,35,45,19,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ċ' ,"010b",0 ,476,270,32,45,16,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Č' ,"010c",0 ,508,270,35,45,19,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'č' ,"010d",0 ,543,270,32,45,16,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ď' ,"010e",0 ,575,270,37,45,21,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ď' ,"010f",0 ,612,270,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Đ' ,"0110",0 ,645,270,37,45,21,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'đ' ,"0111",0 ,682,270,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ē' ,"0112",0 ,715,270,34,45,18,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ē' ,"0113",0 ,749,270,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ĕ' ,"0114",0 ,782,270,34,45,18,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ĕ' ,"0115",0 ,816,270,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ė' ,"0116",0 ,849,270,34,45,18,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ė' ,"0117",0 ,883,270,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ę' ,"0118",0 ,916,270,34,45,18,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ę' ,"0119",0 ,950,270,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ě' ,"011a",0 ,983,270,34,45,18,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ě' ,"011b",0 ,0  ,315,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ĝ' ,"011c",0 ,33 ,315,36,45,20,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ĝ' ,"011d",0 ,69 ,315,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ğ' ,"011e",0 ,102,315,36,45,20,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ğ' ,"011f",0 ,138,315,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ġ' ,"0120",0 ,171,315,36,45,20,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ġ' ,"0121",0 ,207,315,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ģ' ,"0122",0 ,240,315,36,45,20,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ģ' ,"0123",0 ,276,315,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ĥ' ,"0124",0 ,309,315,35,45,20,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ĥ' ,"0125",0 ,344,315,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ħ' ,"0126",0 ,377,315,35,45,20,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ħ' ,"0127",0 ,412,315,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ĩ' ,"0128",0 ,445,315,24,45,8 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ĩ' ,"0129",0 ,469,315,23,45,8 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ī' ,"012a",0 ,492,315,24,45,8 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ī' ,"012b",0 ,516,315,23,45,8 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Į' ,"012e",0 ,539,315,24,45,8 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'į' ,"012f",0 ,563,315,23,45,8 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'İ' ,"0130",0 ,586,315,24,45,8 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ı' ,"0131",0 ,610,315,23,45,8 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ĳ' ,"0132",0 ,633,315,40,45,24,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ĳ' ,"0133",0 ,673,315,29,45,14,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ĵ' ,"0134",0 ,702,315,31,45,16,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ĵ' ,"0135",0 ,733,315,23,45,8 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ķ' ,"0136",0 ,756,315,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ķ' ,"0137",0 ,789,315,32,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ĺ' ,"0139",0 ,821,315,30,45,15,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ĺ' ,"013a",0 ,851,315,23,45,8 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ļ' ,"013b",0 ,874,315,30,45,15,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ļ' ,"013c",0 ,904,315,23,45,8 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ľ' ,"013d",0 ,927,315,30,45,15,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ľ' ,"013e",0 ,957,315,23,45,8 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ŀ' ,"013f",0 ,980,315,30,45,15,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ŀ' ,"0140",0 ,0  ,360,26,45,10,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ł' ,"0141",0 ,26 ,360,30,45,15,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ł' ,"0142",0 ,56 ,360,23,45,8 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ń' ,"0143",0 ,79 ,360,37,45,21,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ń' ,"0144",0 ,116,360,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ņ' ,"0145",0 ,149,360,37,45,21,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ņ' ,"0146",0 ,186,360,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ň' ,"0147",0 ,219,360,37,45,21,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ň' ,"0148",0 ,256,360,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ŉ' ,"0149",0 ,289,360,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ō' ,"014c",0 ,322,360,37,45,21,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ō' ,"014d",0 ,359,360,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ŏ' ,"014e",0 ,392,360,37,45,21,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ŏ' ,"014f",0 ,429,360,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ő' ,"0150",0 ,462,360,37,45,21,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ő' ,"0151",0 ,499,360,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Œ' ,"0152",0 ,532,360,47,45,31,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'œ' ,"0153",0 ,579,360,44,45,28,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ŕ' ,"0154",0 ,623,360,37,45,21,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ŕ' ,"0155",0 ,660,360,25,45,10,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ŗ' ,"0156",0 ,685,360,37,45,21,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ŗ' ,"0157",0 ,722,360,25,45,10,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ř' ,"0158",0 ,747,360,37,45,21,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ř' ,"0159",0 ,784,360,25,45,10,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ś' ,"015a",0 ,809,360,37,45,21,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ś' ,"015b",0 ,846,360,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ŝ' ,"015c",0 ,879,360,37,45,21,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ŝ' ,"015d",0 ,916,360,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ş' ,"015e",0 ,949,360,37,45,21,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ş' ,"015f",0 ,986,360,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Š' ,"0160",0 ,0  ,405,37,45,21,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'š' ,"0161",0 ,37 ,405,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ţ' ,"0162",0 ,70 ,405,32,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ţ' ,"0163",0 ,102,405,25,45,9 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ť' ,"0164",0 ,127,405,32,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ť' ,"0165",0 ,159,405,25,45,9 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ŧ' ,"0166",0 ,184,405,32,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ŧ' ,"0167",0 ,216,405,25,45,9 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ũ' ,"0168",0 ,241,405,36,45,20,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ũ' ,"0169",0 ,277,405,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ū' ,"016a",0 ,310,405,36,45,20,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ū' ,"016b",0 ,346,405,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ŭ' ,"016c",0 ,379,405,36,45,20,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ŭ' ,"016d",0 ,415,405,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ů' ,"016e",0 ,448,405,36,45,20,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ů' ,"016f",0 ,484,405,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ű' ,"0170",0 ,517,405,36,45,20,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ű' ,"0171",0 ,553,405,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ų' ,"0172",0 ,586,405,36,45,20,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ų' ,"0173",0 ,622,405,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ŵ' ,"0174",0 ,655,405,47,45,31,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ŵ' ,"0175",0 ,702,405,42,45,27,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ŷ' ,"0176",0 ,744,405,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ŷ' ,"0177",0 ,777,405,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ÿ' ,"0178",0 ,810,405,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ź' ,"0179",0 ,843,405,35,45,19,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ź' ,"017a",0 ,878,405,31,45,16,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ż' ,"017b",0 ,909,405,35,45,19,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ż' ,"017c",0 ,944,405,31,45,16,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ž' ,"017d",0 ,975,405,35,45,19,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ž' ,"017e",0 ,0  ,450,31,45,16,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ƒ' ,"0192",0 ,31 ,450,35,45,19,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ș' ,"0218",0 ,66 ,450,37,45,21,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ș' ,"0219",0 ,103,450,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ț' ,"021a",0 ,136,450,32,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ț' ,"021b",0 ,168,450,25,45,9 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ˆ' ,"02c6",0 ,193,450,23,45,8 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ˇ' ,"02c7",0 ,216,450,23,45,8 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ˉ' ,"02c9",0 ,239,450,22,45,6 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'˘' ,"02d8",0 ,261,450,23,45,8 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'˙' ,"02d9",0 ,284,450,23,45,8 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'˚' ,"02da",0 ,307,450,23,45,8 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'˛' ,"02db",0 ,330,450,23,45,8 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'˜' ,"02dc",0 ,353,450,23,45,8 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'˝' ,"02dd",0 ,376,450,23,45,8 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ё' ,"0401",0 ,399,450,34,45,19,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ѓ' ,"0403",0 ,433,450,32,45,16,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Є' ,"0404",0 ,465,450,34,45,18,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ѕ' ,"0405",0 ,499,450,37,45,21,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'І' ,"0406",0 ,536,450,24,45,8 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ї' ,"0407",0 ,560,450,24,45,8 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ј' ,"0408",0 ,584,450,31,45,16,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Љ' ,"0409",0 ,615,450,43,45,28,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Њ' ,"040a",0 ,658,450,37,45,21,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ќ' ,"040c",0 ,695,450,34,45,19,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ў' ,"040e",0 ,729,450,32,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Џ' ,"040f",0 ,761,450,33,45,18,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'А' ,"0410",0 ,794,450,35,45,19,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Б' ,"0411",0 ,829,450,35,45,19,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'В' ,"0412",0 ,864,450,35,45,19,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Г' ,"0413",0 ,899,450,30,45,15,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Д' ,"0414",0 ,929,450,35,45,19,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Е' ,"0415",0 ,964,450,34,45,18,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ж' ,"0416",0 ,0  ,495,37,45,21,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'З' ,"0417",0 ,37 ,495,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'И' ,"0418",0 ,70 ,495,35,45,19,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Й' ,"0419",0 ,105,495,34,45,19,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'К' ,"041a",0 ,139,495,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Л' ,"041b",0 ,172,495,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'М' ,"041c",0 ,205,495,42,45,26,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Н' ,"041d",0 ,247,495,33,45,18,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'О' ,"041e",0 ,280,495,35,45,20,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'П' ,"041f",0 ,315,495,34,45,19,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Р' ,"0420",0 ,349,495,34,45,19,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'С' ,"0421",0 ,383,495,35,45,19,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Т' ,"0422",0 ,418,495,35,45,19,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'У' ,"0423",0 ,453,495,35,45,19,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ф' ,"0424",0 ,488,495,36,45,20,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Х' ,"0425",0 ,524,495,35,45,19,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ц' ,"0426",0 ,559,495,36,45,20,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ч' ,"0427",0 ,595,495,32,45,16,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ш' ,"0428",0 ,627,495,42,45,26,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Щ' ,"0429",0 ,669,495,45,45,29,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ъ' ,"042a",0 ,714,495,35,45,20,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ы' ,"042b",0 ,749,495,40,45,24,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ь' ,"042c",0 ,789,495,34,45,19,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Э' ,"042d",0 ,823,495,34,45,18,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ю' ,"042e",0 ,857,495,42,45,27,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Я' ,"042f",0 ,899,495,35,45,20,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'а' ,"0430",0 ,934,495,32,45,16,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'б' ,"0431",0 ,966,495,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'в' ,"0432",0 ,0  ,540,31,45,16,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'г' ,"0433",0 ,31 ,540,30,45,15,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'д' ,"0434",0 ,61 ,540,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'е' ,"0435",0 ,94 ,540,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ж' ,"0436",0 ,127,540,36,45,20,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'з' ,"0437",0 ,163,540,30,45,15,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'и' ,"0438",0 ,193,540,32,45,16,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'й' ,"0439",0 ,225,540,32,45,16,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'к' ,"043a",0 ,257,540,32,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'л' ,"043b",0 ,289,540,30,45,15,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'м' ,"043c",0 ,319,540,41,45,25,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'н' ,"043d",0 ,360,540,31,45,16,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'о' ,"043e",0 ,391,540,32,45,16,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'п' ,"043f",0 ,423,540,32,45,16,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'р' ,"0440",0 ,455,540,32,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'с' ,"0441",0 ,487,540,32,45,16,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'т' ,"0442",0 ,519,540,30,45,14,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'у' ,"0443",0 ,549,540,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ф' ,"0444",0 ,582,540,37,45,21,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'х' ,"0445",0 ,619,540,31,45,15,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ц' ,"0446",0 ,650,540,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ч' ,"0447",0 ,683,540,31,45,15,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ш' ,"0448",0 ,714,540,41,45,25,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'щ' ,"0449",0 ,755,540,42,45,27,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ъ' ,"044a",0 ,797,540,31,45,16,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ы' ,"044b",0 ,828,540,36,45,20,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ь' ,"044c",0 ,864,540,31,45,16,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'э' ,"044d",0 ,895,540,30,45,14,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ю' ,"044e",0 ,925,540,39,45,23,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'я' ,"044f",0 ,964,540,32,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ё' ,"0451",0 ,0  ,585,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ђ' ,"0452",0 ,33 ,585,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ѓ' ,"0453",0 ,66 ,585,31,45,16,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'є' ,"0454",0 ,97 ,585,30,45,14,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ѕ' ,"0455",0 ,127,585,32,45,16,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'і' ,"0456",0 ,159,585,23,45,8 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ї' ,"0457",0 ,182,585,23,45,8 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ј' ,"0458",0 ,205,585,22,45,7 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'љ' ,"0459",0 ,227,585,38,45,22,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'њ' ,"045a",0 ,265,585,41,45,25,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ћ' ,"045b",0 ,306,585,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ќ' ,"045c",0 ,339,585,31,45,16,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ў' ,"045e",0 ,370,585,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'џ' ,"045f",0 ,403,585,33,45,17,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'Ґ' ,"0490",0 ,436,585,30,45,15,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'ґ' ,"0491",0 ,466,585,29,45,13,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'–' ,"2013",0 ,495,585,30,45,15,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'—' ,"2014",0 ,525,585,46,45,31,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'‘' ,"2018",0 ,571,585,22,45,6 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'’' ,"2019",0 ,593,585,22,45,6 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'‚' ,"201a",0 ,615,585,22,45,6 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'“' ,"201c",0 ,637,585,27,45,12,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'”' ,"201d",0 ,664,585,27,45,12,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'„' ,"201e",0 ,691,585,27,45,12,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'†' ,"2020",0 ,718,585,36,45,20,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'‡' ,"2021",0 ,754,585,36,45,20,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'•' ,"2022",0 ,790,585,31,45,15,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'…' ,"2026",0 ,821,585,47,45,31,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'‰' ,"2030",0 ,868,585,47,45,31,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'‹' ,"2039",0 ,915,585,24,45,8 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'›' ,"203a",0 ,939,585,24,45,8 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'€' ,"20ac",0 ,963,585,35,45,19,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'™' ,"2122",0 ,0  ,630,46,45,30,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'−' ,"2212",0 ,46 ,630,34,45,18,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'∙' ,"2219",0 ,80 ,630,24,45,8 ,-7);
TryAddChar("white" ,30,37,23, "FontData0"      ,1024,'□' ,"25a1",0 ,104,630,37,45,21,-7);

TryAddChar("white", 30, 37, 23, "FontData0", 1024, '', "e001", 0, 141, 630, 66, 60, 45, -10, true);
TryAddChar("white", 30, 37, 23, "FontData0", 1024, '', "e002", 0, 207, 630, 66, 60, 45, -10, true);
TryAddChar("white", 30, 37, 23, "FontData0", 1024, '', "e003", 0, 273, 630, 66, 60, 45, -10, true);
TryAddChar("white", 30, 37, 23, "FontData0", 1024, '', "e004", 0, 339, 630, 66, 60, 45, -10, true);
TryAddChar("white", 30, 37, 23, "FontData0", 1024, '', "e005", 0, 405, 630, 66, 60, 46, -10, true);
TryAddChar("white", 30, 37, 23, "FontData0", 1024, '', "e006", 0, 471, 630, 66, 60, 46, -10, true);
TryAddChar("white", 30, 37, 23, "FontData0", 1024, '', "e007", 0, 537, 630, 66, 60, 37, -10, true);
TryAddChar("white", 30, 37, 23, "FontData0", 1024, '', "e008", 0, 603, 630, 66, 60, 37, -10, true);
TryAddChar("white", 30, 37, 23, "FontData0", 1024, '', "e009", 0, 669, 630, 66, 60, 45, -10, true);
TryAddChar("white", 30, 37, 23, "FontData0", 1024, '', "e00a", 0, 735, 630, 66, 60, 45, -10, true);
TryAddChar("white", 30, 37, 23, "FontData0", 1024, '', "e00b", 0, 801, 630, 66, 60, 57, -10, true);
TryAddChar("white", 30, 37, 23, "FontData0", 1024, '', "e00c", 0, 867, 630, 66, 60, 57, -10, true);
TryAddChar("white", 30, 37, 23, "FontData0", 1024, '', "e00d", 0, 933, 630, 66, 60, 45, -10, true);
TryAddChar("white", 30, 37, 23, "FontData0", 1024, '', "e00e", 0, 0, 690, 66, 60, 45, -10, true);
TryAddChar("white", 30, 37, 23, "FontData0", 1024, '', "e00f", 0, 66, 690, 66, 60, 45, -10, true);
TryAddChar("white", 30, 37, 23, "FontData0", 1024, '', "e010", 0, 132, 690, 66, 60, 45, -10, true);
TryAddChar("white", 30, 37, 23, "FontData0", 1024, '', "e011", 0, 198, 690, 66, 60, 37, -10, true);
TryAddChar("white", 30, 37, 23, "FontData0", 1024, '', "e012", 0, 264, 690, 66, 60, 46, -10, true);
TryAddChar("white", 30, 37, 23, "FontData0", 1024, '', "e013", 0, 330, 690, 66, 60, 37, -10, true);
TryAddChar("white", 30, 37, 23, "FontData0", 1024, '', "e014", 0, 396, 690, 66, 60, 45, -10, true);
TryAddChar("white", 30, 37, 23, "FontData0", 1024, '', "e015", 0, 462, 690, 66, 60, 45, -10, true);
TryAddChar("white", 30, 37, 23, "FontData0", 1024, '', "e016", 0, 528, 690, 66, 60, 45, -10, true);
TryAddChar("white", 30, 37, 23, "FontData0", 1024, '', "e017", 0, 594, 690, 66, 60, 45, -10, true);
TryAddChar("white", 30, 37, 23, "FontData0", 1024, '', "e018", 0, 660, 690, 66, 60, 45, -10, true);
TryAddChar("white", 30, 37, 23, "FontData0", 1024, '', "e019", 0, 726, 690, 66, 60, 45, -10, true);
TryAddChar("white", 30, 37, 23, "FontData0", 1024, '', "e020", 0, 792, 690, 66, 60, 45, -10, true);
TryAddChar("white", 30, 37, 23, "FontData0", 1024, '', "e021", 0, 858, 690, 66, 60, 45, -10, true);
TryAddChar("white", 30, 37, 23, "FontData0", 1024, '', "e022", 0, 924, 690, 66, 60, 45, -10, true);
TryAddChar("white", 30, 37, 23, "FontData0", 1024, '', "e023", 0, 0, 750, 66, 60, 45, -10, true);
TryAddChar("white", 30, 37, 23, "FontData0", 1024, '', "e024", 0, 66, 750, 66, 60, 45, -10, true);
TryAddChar("white", 30, 37, 23, "FontData0", 1024, '', "e025", 0, 132, 750, 66, 60, 45, -10, true);
TryAddChar("white", 30, 37, 23, "FontData0", 1024, '', "e026", 0, 198, 750, 66, 60, 45, -10, true);
TryAddChar("white", 30, 37, 23, "FontData0", 1024, '', "e027", 0, 264, 750, 66, 60, 45, -10, true);

			TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'一',"3000",10,0  ,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'丁',"3001",10,38 ,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'七',"3002",10,76 ,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'万',"3003",10,114,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'丈',"3004",10,152,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'三',"3005",10,190,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'上',"3006",10,228,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'下',"3007",10,266,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'丌',"3008",10,304,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'不',"3009",10,342,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'与',"3010",10,380,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'丐',"3011",10,418,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'丑',"3012",10,456,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'专',"3013",10,494,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'且',"3014",10,532,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'丕',"3015",10,570,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'世',"3016",10,608,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'丘',"3017",10,646,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'丙',"3018",10,684,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'业',"3019",10,722,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'丛',"3020",10,760,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'东',"3021",10,798,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'丝',"3022",10,836,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'丞',"3023",10,874,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'丢',"3024",10,912,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'两',"3025",10,950,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'严',"3026",10,0  ,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'丧',"3027",10,38 ,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'丨',"3028",10,76 ,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'个',"3029",10,114,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'丫',"3030",10,152,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'丬',"3031",10,190,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'中',"3032",10,228,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'丰',"3033",10,266,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'串',"3034",10,304,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'临',"3035",10,342,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'丶',"3036",10,380,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'丸',"3037",10,418,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'丹',"3038",10,456,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'为',"3039",10,494,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'主',"3040",10,532,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'丽',"3041",10,570,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'举',"3042",10,608,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'丿',"3043",10,646,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'乃',"3044",10,684,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'久',"3045",10,722,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'乇',"3046",10,760,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'么',"3047",10,798,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'义',"3048",10,836,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'之',"3049",10,874,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'乌',"3050",10,912,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'乍',"3051",10,950,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'乎',"3052",10,0  ,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'乏',"3053",10,38 ,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'乐',"3054",10,76 ,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'乒',"3055",10,114,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'乓',"3056",10,152,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'乔',"3057",10,190,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'乖',"3058",10,228,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'乘',"3059",10,266,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'乙',"3060",10,304,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'乜',"3061",10,342,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'九',"3062",10,380,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'乞',"3063",10,418,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'也',"3064",10,456,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'习',"3065",10,494,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'乡',"3066",10,532,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'书',"3067",10,570,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'乩',"3068",10,608,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'买',"3069",10,646,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'乱',"3070",10,684,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'乳',"3071",10,722,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'乾',"3072",10,760,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'了',"3073",10,798,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'予',"3074",10,836,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'争',"3075",10,874,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'事',"3076",10,912,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'二',"3077",10,950,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'亍',"3078",10,0  ,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'于',"3079",10,38 ,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'亏',"3080",10,76 ,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'云',"3081",10,114,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'互',"3082",10,152,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'亓',"3083",10,190,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'五',"3084",10,228,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'井',"3085",10,266,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'亘',"3086",10,304,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'亚',"3087",10,342,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'些',"3088",10,380,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'亟',"3089",10,418,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'亠',"3090",10,456,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'亡',"3091",10,494,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'亢',"3092",10,532,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'交',"3093",10,570,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'亥',"3094",10,608,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'亦',"3095",10,646,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'产',"3096",10,684,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'亨',"3097",10,722,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'亩',"3098",10,760,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'享',"3099",10,798,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'京',"3100",10,836,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'亭',"3101",10,874,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'亮',"3102",10,912,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'亲',"3103",10,950,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'亳',"3104",10,0  ,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'亵',"3105",10,38 ,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'人',"3106",10,76 ,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'亻',"3107",10,114,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'亿',"3108",10,152,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'什',"3109",10,190,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'仁',"3110",10,228,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'仂',"3111",10,266,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'仃',"3112",10,304,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'仄',"3113",10,342,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'仅',"3114",10,380,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'仆',"3115",10,418,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'仇',"3116",10,456,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'仉',"3117",10,494,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'今',"3118",10,532,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'介',"3119",10,570,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'仍',"3120",10,608,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'从',"3121",10,646,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'仑',"3122",10,684,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'仓',"3123",10,722,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'仔',"3124",10,760,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'仕',"3125",10,798,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'他',"3126",10,836,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'仗',"3127",10,874,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'付',"3128",10,912,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'仙',"3129",10,950,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'仝',"3130",10,0  ,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'仞',"3131",10,38 ,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'仟',"3132",10,76 ,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'仡',"3133",10,114,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'代',"3134",10,152,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'令',"3135",10,190,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'以',"3136",10,228,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'仨',"3137",10,266,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'仪',"3138",10,304,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'仫',"3139",10,342,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'们',"3140",10,380,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'仰',"3141",10,418,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'仲',"3142",10,456,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'仳',"3143",10,494,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'仵',"3144",10,532,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'件',"3145",10,570,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'价',"3146",10,608,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'任',"3147",10,646,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'份',"3148",10,684,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'仿',"3149",10,722,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'企',"3150",10,760,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'伉',"3151",10,798,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'伊',"3152",10,836,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'伍',"3153",10,874,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'伎',"3154",10,912,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'伏',"3155",10,950,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'伐',"3156",10,0  ,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'休',"3157",10,38 ,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'众',"3158",10,76 ,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'优',"3159",10,114,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'伙',"3160",10,152,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'会',"3161",10,190,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'伛',"3162",10,228,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'伞',"3163",10,266,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'伟',"3164",10,304,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'传',"3165",10,342,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'伢',"3166",10,380,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'伤',"3167",10,418,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'伥',"3168",10,456,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'伦',"3169",10,494,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'伧',"3170",10,532,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'伪',"3171",10,570,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'伫',"3172",10,608,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'伯',"3173",10,646,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'估',"3174",10,684,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'伲',"3175",10,722,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'伴',"3176",10,760,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'伶',"3177",10,798,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'伸',"3178",10,836,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'伺',"3179",10,874,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'似',"3180",10,912,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'伽',"3181",10,950,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'佃',"3182",10,0  ,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'但',"3183",10,38 ,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'位',"3184",10,76 ,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'低',"3185",10,114,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'住',"3186",10,152,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'佐',"3187",10,190,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'佑',"3188",10,228,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'体',"3189",10,266,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'何',"3190",10,304,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'佗',"3191",10,342,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'佘',"3192",10,380,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'余',"3193",10,418,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'佚',"3194",10,456,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'佛',"3195",10,494,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'作',"3196",10,532,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'佝',"3197",10,570,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'佞',"3198",10,608,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'佟',"3199",10,646,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'你',"3200",10,684,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'佣',"3201",10,722,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'佤',"3202",10,760,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'佥',"3203",10,798,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'佧',"3204",10,836,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'佩',"3205",10,874,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'佬',"3206",10,912,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'佯',"3207",10,950,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'佰',"3208",10,0  ,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'佳',"3209",10,38 ,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'佴',"3210",10,76 ,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'佶',"3211",10,114,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'佻',"3212",10,152,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'佼',"3213",10,190,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'佾',"3214",10,228,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'使',"3215",10,266,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'侃',"3216",10,304,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'侄',"3217",10,342,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'侈',"3218",10,380,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'侉',"3219",10,418,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'例',"3220",10,456,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'侍',"3221",10,494,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'侏',"3222",10,532,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'侑',"3223",10,570,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'侔',"3224",10,608,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'侗',"3225",10,646,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'供',"3226",10,684,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'依',"3227",10,722,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'侠',"3228",10,760,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'侣',"3229",10,798,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'侥',"3230",10,836,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'侦',"3231",10,874,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'侧',"3232",10,912,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'侨',"3233",10,950,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'侩',"3234",10,0  ,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'侪',"3235",10,38 ,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'侬',"3236",10,76 ,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'侮',"3237",10,114,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'侯',"3238",10,152,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'侵',"3239",10,190,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'便',"3240",10,228,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'促',"3241",10,266,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'俄',"3242",10,304,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'俅',"3243",10,342,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'俊',"3244",10,380,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'俎',"3245",10,418,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'俏',"3246",10,456,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'俐',"3247",10,494,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'俑',"3248",10,532,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'俗',"3249",10,570,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'俘',"3250",10,608,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'俚',"3251",10,646,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'俜',"3252",10,684,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'保',"3253",10,722,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'俞',"3254",10,760,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'俟',"3255",10,798,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'信',"3256",10,836,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'俣',"3257",10,874,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'俦',"3258",10,912,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'俨',"3259",10,950,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'俩',"3260",10,0  ,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'俪',"3261",10,38 ,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'俭',"3262",10,76 ,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'修',"3263",10,114,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'俯',"3264",10,152,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'俱',"3265",10,190,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'俳',"3266",10,228,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'俸',"3267",10,266,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'俺',"3268",10,304,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'俾',"3269",10,342,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'倌',"3270",10,380,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'倍',"3271",10,418,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'倏',"3272",10,456,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'倒',"3273",10,494,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'倔',"3274",10,532,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'倘',"3275",10,570,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'候',"3276",10,608,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'倚',"3277",10,646,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'倜',"3278",10,684,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'借',"3279",10,722,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'倡',"3280",10,760,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'倥',"3281",10,798,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'倦',"3282",10,836,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'倨',"3283",10,874,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'倩',"3284",10,912,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'倪',"3285",10,950,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'倬',"3286",10,0  ,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'倭',"3287",10,38 ,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'倮',"3288",10,76 ,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'债',"3289",10,114,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'值',"3290",10,152,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'倾',"3291",10,190,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'偃',"3292",10,228,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'假',"3293",10,266,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'偈',"3294",10,304,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'偌',"3295",10,342,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'偎',"3296",10,380,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'偏',"3297",10,418,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'偕',"3298",10,456,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'做',"3299",10,494,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'停',"3300",10,532,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'健',"3301",10,570,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'偬',"3302",10,608,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'偶',"3303",10,646,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'偷',"3304",10,684,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'偻',"3305",10,722,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'偾',"3306",10,760,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'偿',"3307",10,798,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'傀',"3308",10,836,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'傅',"3309",10,874,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'傈',"3310",10,912,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'傍',"3311",10,950,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'傣',"3312",10,0  ,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'傥',"3313",10,38 ,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'傧',"3314",10,76 ,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'储',"3315",10,114,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'傩',"3316",10,152,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'催',"3317",10,190,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'傲',"3318",10,228,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'傺',"3319",10,266,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'傻',"3320",10,304,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'像',"3321",10,342,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'僖',"3322",10,380,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'僚',"3323",10,418,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'僦',"3324",10,456,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'僧',"3325",10,494,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'僬',"3326",10,532,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'僭',"3327",10,570,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'僮',"3328",10,608,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'僳',"3329",10,646,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'僵',"3330",10,684,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'僻',"3331",10,722,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'儆',"3332",10,760,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'儇',"3333",10,798,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'儋',"3334",10,836,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'儒',"3335",10,874,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'儡',"3336",10,912,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'儿',"3337",10,950,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'兀',"3338",10,0  ,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'允',"3339",10,38 ,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'元',"3340",10,76 ,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'兄',"3341",10,114,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'充',"3342",10,152,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'兆',"3343",10,190,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'先',"3344",10,228,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'光',"3345",10,266,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'克',"3346",10,304,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'免',"3347",10,342,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'兑',"3348",10,380,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'兔',"3349",10,418,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'兕',"3350",10,456,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'兖',"3351",10,494,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'党',"3352",10,532,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'兜',"3353",10,570,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'兢',"3354",10,608,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'入',"3355",10,646,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'全',"3356",10,684,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'八',"3357",10,722,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'公',"3358",10,760,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'六',"3359",10,798,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'兮',"3360",10,836,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'兰',"3361",10,874,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'共',"3362",10,912,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'关',"3363",10,950,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'兴',"3364",10,0  ,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'兵',"3365",10,38 ,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'其',"3366",10,76 ,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'具',"3367",10,114,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'典',"3368",10,152,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'兹',"3369",10,190,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'养',"3370",10,228,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'兼',"3371",10,266,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'兽',"3372",10,304,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'冀',"3373",10,342,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'冁',"3374",10,380,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'冂',"3375",10,418,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'内',"3376",10,456,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'冈',"3377",10,494,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'冉',"3378",10,532,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'册',"3379",10,570,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'再',"3380",10,608,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'冒',"3381",10,646,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'冕',"3382",10,684,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'冖',"3383",10,722,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'冗',"3384",10,760,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'写',"3385",10,798,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'军',"3386",10,836,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'农',"3387",10,874,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'冠',"3388",10,912,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'冢',"3389",10,950,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'冤',"3390",10,0  ,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'冥',"3391",10,38 ,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'冫',"3392",10,76 ,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'冬',"3393",10,114,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'冯',"3394",10,152,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'冰',"3395",10,190,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'冱',"3396",10,228,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'冲',"3397",10,266,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'决',"3398",10,304,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'况',"3399",10,342,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'冶',"3400",10,380,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'冷',"3401",10,418,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'冻',"3402",10,456,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'冼',"3403",10,494,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'冽',"3404",10,532,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'净',"3405",10,570,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'凄',"3406",10,608,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'准',"3407",10,646,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'凇',"3408",10,684,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'凉',"3409",10,722,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'凋',"3410",10,760,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'凌',"3411",10,798,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'减',"3412",10,836,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'凑',"3413",10,874,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'凛',"3414",10,912,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'凝',"3415",10,950,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'几',"3416",10,0  ,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'凡',"3417",10,38 ,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'凤',"3418",10,76 ,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'凫',"3419",10,114,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'凭',"3420",10,152,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'凯',"3421",10,190,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'凰',"3422",10,228,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'凳',"3423",10,266,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'凵',"3424",10,304,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'凶',"3425",10,342,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'凸',"3426",10,380,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'凹',"3427",10,418,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'出',"3428",10,456,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'击',"3429",10,494,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'凼',"3430",10,532,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'函',"3431",10,570,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'凿',"3432",10,608,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'刀',"3433",10,646,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'刁',"3434",10,684,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'刂',"3435",10,722,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'刃',"3436",10,760,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'分',"3437",10,798,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'切',"3438",10,836,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'刈',"3439",10,874,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'刊',"3440",10,912,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'刍',"3441",10,950,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'刎',"3442",10,0  ,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'刑',"3443",10,38 ,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'划',"3444",10,76 ,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'刖',"3445",10,114,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'列',"3446",10,152,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'刘',"3447",10,190,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'则',"3448",10,228,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'刚',"3449",10,266,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'创',"3450",10,304,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'初',"3451",10,342,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'删',"3452",10,380,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'判',"3453",10,418,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'刨',"3454",10,456,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'利',"3455",10,494,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'别',"3456",10,532,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'刭',"3457",10,570,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'刮',"3458",10,608,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'到',"3459",10,646,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'刳',"3460",10,684,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'制',"3461",10,722,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'刷',"3462",10,760,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'券',"3463",10,798,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'刹',"3464",10,836,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'刺',"3465",10,874,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'刻',"3466",10,912,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'刽',"3467",10,950,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'刿',"3468",10,0  ,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'剀',"3469",10,38 ,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'剁',"3470",10,76 ,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'剂',"3471",10,114,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'剃',"3472",10,152,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'削',"3473",10,190,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'剌',"3474",10,228,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'前',"3475",10,266,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'剐',"3476",10,304,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'剑',"3477",10,342,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'剔',"3478",10,380,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'剖',"3479",10,418,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'剜',"3480",10,456,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'剞',"3481",10,494,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'剡',"3482",10,532,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'剥',"3483",10,570,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'剧',"3484",10,608,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'剩',"3485",10,646,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'剪',"3486",10,684,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'副',"3487",10,722,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'割',"3488",10,760,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'剽',"3489",10,798,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'剿',"3490",10,836,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'劁',"3491",10,874,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'劂',"3492",10,912,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'劈',"3493",10,950,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'劐',"3494",10,0  ,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'劓',"3495",10,38 ,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'力',"3496",10,76 ,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'劝',"3497",10,114,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'办',"3498",10,152,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'功',"3499",10,190,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'加',"3500",10,228,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'务',"3501",10,266,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'劢',"3502",10,304,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'劣',"3503",10,342,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'动',"3504",10,380,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'助',"3505",10,418,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'努',"3506",10,456,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'劫',"3507",10,494,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'劬',"3508",10,532,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'劭',"3509",10,570,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'励',"3510",10,608,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'劲',"3511",10,646,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'劳',"3512",10,684,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'劾',"3513",10,722,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'势',"3514",10,760,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'勃',"3515",10,798,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'勇',"3516",10,836,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'勉',"3517",10,874,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'勋',"3518",10,912,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'勐',"3519",10,950,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'勒',"3520",10,0  ,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'勖',"3521",10,38 ,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'勘',"3522",10,76 ,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'募',"3523",10,114,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'勤',"3524",10,152,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'勰',"3525",10,190,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'勹',"3526",10,228,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'勺',"3527",10,266,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'勾',"3528",10,304,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'勿',"3529",10,342,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'匀',"3530",10,380,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'包',"3531",10,418,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'匆',"3532",10,456,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'匈',"3533",10,494,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'匍',"3534",10,532,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'匏',"3535",10,570,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'匐',"3536",10,608,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'匕',"3537",10,646,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'化',"3538",10,684,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'北',"3539",10,722,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'匙',"3540",10,760,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'匚',"3541",10,798,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'匝',"3542",10,836,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'匠',"3543",10,874,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'匡',"3544",10,912,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'匣',"3545",10,950,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'匦',"3546",10,0  ,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'匪',"3547",10,38 ,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'匮',"3548",10,76 ,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'匹',"3549",10,114,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'区',"3550",10,152,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'医',"3551",10,190,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'匾',"3552",10,228,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'匿',"3553",10,266,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'十',"3554",10,304,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'千',"3555",10,342,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'卅',"3556",10,380,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'升',"3557",10,418,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'午',"3558",10,456,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'卉',"3559",10,494,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'半',"3560",10,532,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'华',"3561",10,570,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'协',"3562",10,608,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'卑',"3563",10,646,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'卒',"3564",10,684,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'卓',"3565",10,722,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'单',"3566",10,760,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'卖',"3567",10,798,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'南',"3568",10,836,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'博',"3569",10,874,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'卜',"3570",10,912,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'卞',"3571",10,950,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'卟',"3572",10,0  ,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'占',"3573",10,38 ,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'卡',"3574",10,76 ,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'卢',"3575",10,114,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'卣',"3576",10,152,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'卤',"3577",10,190,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'卦',"3578",10,228,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'卧',"3579",10,266,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'卩',"3580",10,304,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'卫',"3581",10,342,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'卮',"3582",10,380,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'卯',"3583",10,418,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'印',"3584",10,456,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'危',"3585",10,494,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'即',"3586",10,532,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'却',"3587",10,570,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'卵',"3588",10,608,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'卷',"3589",10,646,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'卸',"3590",10,684,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'卺',"3591",10,722,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'卿',"3592",10,760,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'厂',"3593",10,798,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'厄',"3594",10,836,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'厅',"3595",10,874,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'历',"3596",10,912,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'厉',"3597",10,950,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'压',"3598",10,0  ,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'厌',"3599",10,38 ,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'厍',"3600",10,76 ,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'厕',"3601",10,114,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'厘',"3602",10,152,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'厚',"3603",10,190,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'厝',"3604",10,228,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'原',"3605",10,266,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'厢',"3606",10,304,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'厣',"3607",10,342,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'厥',"3608",10,380,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'厦',"3609",10,418,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'厨',"3610",10,456,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'厩',"3611",10,494,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'厮',"3612",10,532,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'厶',"3613",10,570,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'去',"3614",10,608,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'县',"3615",10,646,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'叁',"3616",10,684,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'参',"3617",10,722,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'又',"3618",10,760,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'叉',"3619",10,798,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'及',"3620",10,836,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'友',"3621",10,874,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'双',"3622",10,912,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'反',"3623",10,950,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'发',"3624",10,0  ,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'叔',"3625",10,38 ,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'取',"3626",10,76 ,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'受',"3627",10,114,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'变',"3628",10,152,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'叙',"3629",10,190,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'叛',"3630",10,228,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'叟',"3631",10,266,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'叠',"3632",10,304,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'口',"3633",10,342,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'古',"3634",10,380,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'句',"3635",10,418,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'另',"3636",10,456,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'叨',"3637",10,494,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'叩',"3638",10,532,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'只',"3639",10,570,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'叫',"3640",10,608,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'召',"3641",10,646,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'叭',"3642",10,684,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'叮',"3643",10,722,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'可',"3644",10,760,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'台',"3645",10,798,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'叱',"3646",10,836,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'史',"3647",10,874,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'右',"3648",10,912,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'叵',"3649",10,950,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'叶',"3650",10,0  ,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'号',"3651",10,38 ,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'司',"3652",10,76 ,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'叹',"3653",10,114,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'叻',"3654",10,152,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'叼',"3655",10,190,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'叽',"3656",10,228,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'吁',"3657",10,266,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'吃',"3658",10,304,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'各',"3659",10,342,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'吆',"3660",10,380,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'合',"3661",10,418,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'吉',"3662",10,456,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'吊',"3663",10,494,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'同',"3664",10,532,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'名',"3665",10,570,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'后',"3666",10,608,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'吏',"3667",10,646,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'吐',"3668",10,684,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'向',"3669",10,722,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'吒',"3670",10,760,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'吓',"3671",10,798,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'吕',"3672",10,836,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'吖',"3673",10,874,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'吗',"3674",10,912,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'君',"3675",10,950,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'吝',"3676",10,0  ,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'吞',"3677",10,38 ,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'吟',"3678",10,76 ,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'吠',"3679",10,114,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'吡',"3680",10,152,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'吣',"3681",10,190,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'否',"3682",10,228,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'吧',"3683",10,266,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'吨',"3684",10,304,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'吩',"3685",10,342,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'含',"3686",10,380,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'听',"3687",10,418,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'吭',"3688",10,456,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'吮',"3689",10,494,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'启',"3690",10,532,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'吱',"3691",10,570,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'吲',"3692",10,608,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'吴',"3693",10,646,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'吵',"3694",10,684,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'吸',"3695",10,722,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'吹',"3696",10,760,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'吻',"3697",10,798,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'吼',"3698",10,836,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'吾',"3699",10,874,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'呀',"3700",10,912,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-01",1024,'呃',"3701",10,950,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'外',"3702",9 ,0  ,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'夕',"3703",9 ,38 ,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'夔',"3704",9 ,76 ,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'夏',"3705",9 ,114,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'复',"3706",9 ,152,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'备',"3707",9 ,190,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'处',"3708",9 ,228,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'夂',"3709",9 ,266,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'壹',"3710",9 ,304,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'壶',"3711",9 ,342,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'壳',"3712",9 ,380,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'声',"3713",9 ,418,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'壮',"3714",9 ,456,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'壬',"3715",9 ,494,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'士',"3716",9 ,532,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'壤',"3717",9 ,570,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'壕',"3718",9 ,608,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'壑',"3719",9 ,646,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'壅',"3720",9 ,684,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'壁',"3721",9 ,722,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'墼',"3722",9 ,760,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'墩',"3723",9 ,798,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'墨',"3724",9 ,836,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'墟',"3725",9 ,874,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'增',"3726",9 ,912,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'墚',"3727",9 ,950,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'墙',"3728",9 ,0  ,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'墓',"3729",9 ,38 ,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'墒',"3730",9 ,76 ,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'墉',"3731",9 ,114,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'墅',"3732",9 ,152,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'境',"3733",9 ,190,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'墁',"3734",9 ,228,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'墀',"3735",9 ,266,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'塾',"3736",9 ,304,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'塬',"3737",9 ,342,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'填',"3738",9 ,380,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'塥',"3739",9 ,418,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'塞',"3740",9 ,456,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'塘',"3741",9 ,494,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'塔',"3742",9 ,532,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'塑',"3743",9 ,570,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'塍',"3744",9 ,608,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'塌',"3745",9 ,646,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'塄',"3746",9 ,684,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'堵',"3747",9 ,722,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'堰',"3748",9 ,760,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'堪',"3749",9 ,798,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'堤',"3750",9 ,836,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'堡',"3751",9 ,874,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'堠',"3752",9 ,912,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'堞',"3753",9 ,950,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'堙',"3754",9 ,0  ,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'堕',"3755",9 ,38 ,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'堑',"3756",9 ,76 ,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'堍',"3757",9 ,114,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'堋',"3758",9 ,152,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'堇',"3759",9 ,190,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'堆',"3760",9 ,228,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'堂',"3761",9 ,266,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'堀',"3762",9 ,304,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'埽',"3763",9 ,342,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'基',"3764",9 ,380,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'培',"3765",9 ,418,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'埸',"3766",9 ,456,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'埴',"3767",9 ,494,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'埯',"3768",9 ,532,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'埭',"3769",9 ,570,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'埤',"3770",9 ,608,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'埠',"3771",9 ,646,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'域',"3772",9 ,684,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'埝',"3773",9 ,722,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'埚',"3774",9 ,760,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'埙',"3775",9 ,798,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'埘',"3776",9 ,836,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'埕',"3777",9 ,874,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'埔',"3778",9 ,912,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'埒',"3779",9 ,950,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'埏',"3780",9 ,0  ,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'城',"3781",9 ,38 ,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'埋',"3782",9 ,76 ,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'埃',"3783",9 ,114,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'埂',"3784",9 ,152,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'垸',"3785",9 ,190,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'垴',"3786",9 ,228,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'垲',"3787",9 ,266,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'垮',"3788",9 ,304,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'垭',"3789",9 ,342,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'垫',"3790",9 ,380,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'垩',"3791",9 ,418,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'垧',"3792",9 ,456,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'垦',"3793",9 ,494,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'垤',"3794",9 ,532,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'垣',"3795",9 ,570,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'垢',"3796",9 ,608,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'垡',"3797",9 ,646,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'垠',"3798",9 ,684,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'垛',"3799",9 ,722,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'垓',"3800",9 ,760,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'垒',"3801",9 ,798,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'垌',"3802",9 ,836,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'型',"3803",9 ,874,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'垆',"3804",9 ,912,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'垅',"3805",9 ,950,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'垄',"3806",9 ,0  ,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'垃',"3807",9 ,38 ,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'垂',"3808",9 ,76 ,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'坼',"3809",9 ,114,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'坻',"3810",9 ,152,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'坷',"3811",9 ,190,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'坶',"3812",9 ,228,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'坳',"3813",9 ,266,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'坯',"3814",9 ,304,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'坭',"3815",9 ,342,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'坫',"3816",9 ,380,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'坪',"3817",9 ,418,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'坩',"3818",9 ,456,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'坨',"3819",9 ,494,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'坦',"3820",9 ,532,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'坤',"3821",9 ,570,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'坡',"3822",9 ,608,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'坠',"3823",9 ,646,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'坟',"3824",9 ,684,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'坞',"3825",9 ,722,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'坝',"3826",9 ,760,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'坜',"3827",9 ,798,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'坛',"3828",9 ,836,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'坚',"3829",9 ,874,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'块',"3830",9 ,912,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'坑',"3831",9 ,950,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'坐',"3832",9 ,0  ,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'坏',"3833",9 ,38 ,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'坎',"3834",9 ,76 ,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'坍',"3835",9 ,114,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'坌',"3836",9 ,152,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'坊',"3837",9 ,190,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'均',"3838",9 ,228,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'坂',"3839",9 ,266,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'址',"3840",9 ,304,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'圾',"3841",9 ,342,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'圻',"3842",9 ,380,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'场',"3843",9 ,418,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'圹',"3844",9 ,456,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'圳',"3845",9 ,494,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'地',"3846",9 ,532,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'圯',"3847",9 ,570,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'圮',"3848",9 ,608,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'圭',"3849",9 ,646,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'圬',"3850",9 ,684,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'圪',"3851",9 ,722,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'圩',"3852",9 ,760,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'在',"3853",9 ,798,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'圣',"3854",9 ,836,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'土',"3855",9 ,874,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'圜',"3856",9 ,912,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'圊',"3857",9 ,950,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'圉',"3858",9 ,0  ,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'圈',"3859",9 ,38 ,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'圆',"3860",9 ,76 ,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'圄',"3861",9 ,114,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'圃',"3862",9 ,152,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'囿',"3863",9 ,190,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'图',"3864",9 ,228,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'国',"3865",9 ,266,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'固',"3866",9 ,304,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'囹',"3867",9 ,342,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'囵',"3868",9 ,380,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'围',"3869",9 ,418,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'囱',"3870",9 ,456,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'困',"3871",9 ,494,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'园',"3872",9 ,532,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'囫',"3873",9 ,570,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'囤',"3874",9 ,608,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'团',"3875",9 ,646,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'囡',"3876",9 ,684,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'因',"3877",9 ,722,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'囟',"3878",9 ,760,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'回',"3879",9 ,798,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'囝',"3880",9 ,836,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'四',"3881",9 ,874,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'囚',"3882",9 ,912,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'囗',"3883",9 ,950,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'囔',"3884",9 ,0  ,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'囊',"3885",9 ,38 ,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'嚼',"3886",9 ,76 ,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'嚷',"3887",9 ,114,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'嚯',"3888",9 ,152,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'嚣',"3889",9 ,190,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'嚓',"3890",9 ,228,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'嚏',"3891",9 ,266,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'嚎',"3892",9 ,304,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'嚆',"3893",9 ,342,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'嚅',"3894",9 ,380,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'噼',"3895",9 ,418,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'噻',"3896",9 ,456,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'噶',"3897",9 ,494,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'噱',"3898",9 ,532,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'噬',"3899",9 ,570,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'噫',"3900",9 ,608,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'噪',"3901",9 ,646,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'噩',"3902",9 ,684,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'器',"3903",9 ,722,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'噤',"3904",9 ,760,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'噢',"3905",9 ,798,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'噜',"3906",9 ,836,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'噙',"3907",9 ,874,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'噘',"3908",9 ,912,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'噗',"3909",9 ,950,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'噔',"3910",9 ,0  ,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'噎',"3911",9 ,38 ,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'噍',"3912",9 ,76 ,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'噌',"3913",9 ,114,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'嘿',"3914",9 ,152,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'嘻',"3915",9 ,190,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'嘹',"3916",9 ,228,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'嘶',"3917",9 ,266,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'嘴',"3918",9 ,304,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'嘲',"3919",9 ,342,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'嘱',"3920",9 ,380,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'嘭',"3921",9 ,418,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'嘬',"3922",9 ,456,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'嘧',"3923",9 ,494,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'嘤',"3924",9 ,532,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'嘣',"3925",9 ,570,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'嘟',"3926",9 ,608,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'嘞',"3927",9 ,646,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'嘛',"3928",9 ,684,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'嘘',"3929",9 ,722,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'嘏',"3930",9 ,760,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'嘎',"3931",9 ,798,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'嘌',"3932",9 ,836,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'嘉',"3933",9 ,874,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'嘈',"3934",9 ,912,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'嘁',"3935",9 ,950,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'嘀',"3936",9 ,0  ,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'嗾',"3937",9 ,38 ,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'嗽',"3938",9 ,76 ,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'嗷',"3939",9 ,114,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'嗵',"3940",9 ,152,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'嗳',"3941",9 ,190,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'嗲',"3942",9 ,228,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'嗯',"3943",9 ,266,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'嗬',"3944",9 ,304,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'嗫',"3945",9 ,342,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'嗪',"3946",9 ,380,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'嗨',"3947",9 ,418,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'嗦',"3948",9 ,456,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'嗥',"3949",9 ,494,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'嗤',"3950",9 ,532,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'嗣',"3951",9 ,570,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'嗡',"3952",9 ,608,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'嗟',"3953",9 ,646,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'嗝',"3954",9 ,684,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'嗜',"3955",9 ,722,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'嗖',"3956",9 ,760,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'嗔',"3957",9 ,798,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'嗓',"3958",9 ,836,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'嗒',"3959",9 ,874,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'嗑',"3960",9 ,912,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'嗍',"3961",9 ,950,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'嗌',"3962",9 ,0  ,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'嗉',"3963",9 ,38 ,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'嗅',"3964",9 ,76 ,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'嗄',"3965",9 ,114,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'喾',"3966",9 ,152,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'喽',"3967",9 ,190,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'喻',"3968",9 ,228,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'喹',"3969",9 ,266,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'喷',"3970",9 ,304,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'喵',"3971",9 ,342,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'喳',"3972",9 ,380,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'喱',"3973",9 ,418,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'喧',"3974",9 ,456,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'喟',"3975",9 ,494,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'喝',"3976",9 ,532,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'喜',"3977",9 ,570,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'喙',"3978",9 ,608,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'喘',"3979",9 ,646,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'喔',"3980",9 ,684,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'喑',"3981",9 ,722,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'喏',"3982",9 ,760,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'喋',"3983",9 ,798,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'喊',"3984",9 ,836,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'喉',"3985",9 ,874,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'喈',"3986",9 ,912,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'喇',"3987",9 ,950,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'善',"3988",9 ,0  ,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'喃',"3989",9 ,38 ,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'喂',"3990",9 ,76 ,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'喁',"3991",9 ,114,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'喀',"3992",9 ,152,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'啾',"3993",9 ,190,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'啼',"3994",9 ,228,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'啻',"3995",9 ,266,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'啸',"3996",9 ,304,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'啷',"3997",9 ,342,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'啶',"3998",9 ,380,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'啵',"3999",9 ,418,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'啮',"4000",9 ,456,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'啭',"4001",9 ,494,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'啬',"4002",9 ,532,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'啪',"4003",9 ,570,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'啧',"4004",9 ,608,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'啦',"4005",9 ,646,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'啥',"4006",9 ,684,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'啤',"4007",9 ,722,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'啡',"4008",9 ,760,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'啜',"4009",9 ,798,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'啖',"4010",9 ,836,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'啕',"4011",9 ,874,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'啐',"4012",9 ,912,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'啊',"4013",9 ,950,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'啉',"4014",9 ,0  ,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'商',"4015",9 ,38 ,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'啄',"4016",9 ,76 ,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'啃',"4017",9 ,114,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'啁',"4018",9 ,152,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'唿',"4019",9 ,190,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'唾',"4020",9 ,228,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'唼',"4021",9 ,266,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'唷',"4022",9 ,304,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'唳',"4023",9 ,342,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'唱',"4024",9 ,380,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'唰',"4025",9 ,418,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'唯',"4026",9 ,456,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'售',"4027",9 ,494,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'唬',"4028",9 ,532,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'唪',"4029",9 ,570,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'唧',"4030",9 ,608,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'唤',"4031",9 ,646,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'唣',"4032",9 ,684,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'唢',"4033",9 ,722,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'唠',"4034",9 ,760,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'唛',"4035",9 ,798,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'唔',"4036",9 ,836,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'唑',"4037",9 ,874,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'唐',"4038",9 ,912,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'唏',"4039",9 ,950,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'唉',"4040",9 ,0  ,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'唇',"4041",9 ,38 ,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'唆',"4042",9 ,76 ,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'唁',"4043",9 ,114,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'哿',"4044",9 ,152,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'哽',"4045",9 ,190,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'哼',"4046",9 ,228,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'哺',"4047",9 ,266,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'哳',"4048",9 ,304,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'哲',"4049",9 ,342,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'哮',"4050",9 ,380,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'哭',"4051",9 ,418,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'哪',"4052",9 ,456,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'哩',"4053",9 ,494,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'哨',"4054",9 ,532,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'哧',"4055",9 ,570,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'哦',"4056",9 ,608,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'哥',"4057",9 ,646,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'哟',"4058",9 ,684,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'哞',"4059",9 ,722,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'哝',"4060",9 ,760,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'哜',"4061",9 ,798,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'哚',"4062",9 ,836,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'哙',"4063",9 ,874,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'哗',"4064",9 ,912,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'哕',"4065",9 ,950,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'哔',"4066",9 ,0  ,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'哓',"4067",9 ,38 ,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'哒',"4068",9 ,76 ,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'哑',"4069",9 ,114,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'哐',"4070",9 ,152,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'哏',"4071",9 ,190,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'哎',"4072",9 ,228,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'响',"4073",9 ,266,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'哌',"4074",9 ,304,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'哉',"4075",9 ,342,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'哈',"4076",9 ,380,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'哇',"4077",9 ,418,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'哆',"4078",9 ,456,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'哄',"4079",9 ,494,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'哂',"4080",9 ,532,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'品',"4081",9 ,570,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'哀',"4082",9 ,608,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'咿',"4083",9 ,646,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'咽',"4084",9 ,684,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'咻',"4085",9 ,722,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'咸',"4086",9 ,760,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'咴',"4087",9 ,798,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'咳',"4088",9 ,836,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'咱',"4089",9 ,874,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'咯',"4090",9 ,912,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'咭',"4091",9 ,950,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'咬',"4092",9 ,0  ,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'咫',"4093",9 ,38 ,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'咪',"4094",9 ,76 ,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'咩',"4095",9 ,114,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'咨',"4096",9 ,152,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'咧',"4097",9 ,190,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'咦',"4098",9 ,228,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'咤',"4099",9 ,266,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'咣',"4100",9 ,304,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'咝',"4101",9 ,342,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'咛',"4102",9 ,380,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'咚',"4103",9 ,418,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'咙',"4104",9 ,456,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'咖',"4105",9 ,494,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'咕',"4106",9 ,532,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'咔',"4107",9 ,570,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'咒',"4108",9 ,608,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'咐',"4109",9 ,646,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'咏',"4110",9 ,684,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'咎',"4111",9 ,722,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'和',"4112",9 ,760,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'咋',"4113",9 ,798,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'咆',"4114",9 ,836,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'咄',"4115",9 ,874,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'咂',"4116",9 ,912,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'咀',"4117",9 ,950,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'命',"4118",9 ,0  ,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'呼',"4119",9 ,38 ,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'呻',"4120",9 ,76 ,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'呸',"4121",9 ,114,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'呷',"4122",9 ,152,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'呶',"4123",9 ,190,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'呵',"4124",9 ,228,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'味',"4125",9 ,266,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'呲',"4126",9 ,304,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'呱',"4127",9 ,342,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'周',"4128",9 ,380,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'呦',"4129",9 ,418,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'呤',"4130",9 ,456,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'呢',"4131",9 ,494,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'呜',"4132",9 ,532,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'呛',"4133",9 ,570,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'呙',"4134",9 ,608,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'员',"4135",9 ,646,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'呗',"4136",9 ,684,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'呖',"4137",9 ,722,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'呕',"4138",9 ,760,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'呔',"4139",9 ,798,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'呓',"4140",9 ,836,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'呒',"4141",9 ,874,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'呐',"4142",9 ,912,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'呋',"4143",9 ,950,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'告',"4144",9 ,0  ,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'呈',"4145",9 ,38 ,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-10",1024,'呆',"4146",9 ,76 ,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'悻',"4147",8 ,0  ,  3,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'悸',"4148",8 ,38 ,  3,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'悴',"4149",8 ,76 ,  3,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'悲',"4150",8 ,114,  3,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'悱',"4151",8 ,152,  3,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'悯',"4152",8 ,190,  3,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'悭',"4153",8 ,228,  3,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'悬',"4154",8 ,266,  3,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'悫',"4155",8 ,304,  3,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'您',"4156",8 ,342,  3,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'悦',"4157",8 ,380,  3,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'患',"4158",8 ,418,  3,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'悠',"4159",8 ,456,  3,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'悟',"4160",8 ,494,  3,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'悝',"4161",8 ,532,  3,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'悛',"4162",8 ,570,  3,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'悚',"4163",8 ,608,  3,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'悖',"4164",8 ,646,  3,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'悔',"4165",8 ,684,  3,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'悒',"4166",8 ,722,  3,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'悍',"4167",8 ,760,  3,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'悌',"4168",8 ,798,  3,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'悉',"4169",8 ,836,  3,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'悄',"4170",8 ,874,  3,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'悃',"4171",8 ,912,  3,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'恿',"4172",8 ,950,  3,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'恽',"4173",8 ,0  , 40,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'恼',"4174",8 ,38 , 40,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'恻',"4175",8 ,76 , 40,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'恺',"4176",8 ,114, 40,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'恹',"4177",8 ,152, 40,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'恸',"4178",8 ,190, 40,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'恶',"4179",8 ,228, 40,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'恳',"4180",8 ,266, 40,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'恰',"4181",8 ,304, 40,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'息',"4182",8 ,342, 40,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'恭',"4183",8 ,380, 40,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'恬',"4184",8 ,418, 40,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'恫',"4185",8 ,456, 40,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'恪',"4186",8 ,494, 40,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'恩',"4187",8 ,532, 40,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'恨',"4188",8 ,570, 40,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'恧',"4189",8 ,608, 40,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'恤',"4190",8 ,646, 40,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'恣',"4191",8 ,684, 40,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'恢',"4192",8 ,722, 40,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'恝',"4193",8 ,760, 40,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'恚',"4194",8 ,798, 40,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'恙',"4195",8 ,836, 40,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'恕',"4196",8 ,874, 40,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'恒',"4197",8 ,912, 40,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'恐',"4198",8 ,950, 40,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'恍',"4199",8 ,0  , 77,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'恋',"4200",8 ,38 , 77,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'恃',"4201",8 ,76 , 77,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'恂',"4202",8 ,114, 77,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'恁',"4203",8 ,152, 77,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'怿',"4204",8 ,190, 77,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'怼',"4205",8 ,228, 77,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'总',"4206",8 ,266, 77,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'怵',"4207",8 ,304, 77,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'怯',"4208",8 ,342, 77,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'怫',"4209",8 ,380, 77,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'怪',"4210",8 ,418, 77,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'怩',"4211",8 ,456, 77,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'怨',"4212",8 ,494, 77,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'性',"4213",8 ,532, 77,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'怦',"4214",8 ,570, 77,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'急',"4215",8 ,608, 77,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'怡',"4216",8 ,646, 77,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'怠',"4217",8 ,684, 77,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'思',"4218",8 ,722, 77,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'怜',"4219",8 ,760, 77,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'怛',"4220",8 ,798, 77,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'怙',"4221",8 ,836, 77,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'怖',"4222",8 ,874, 77,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'怕',"4223",8 ,912, 77,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'怔',"4224",8 ,950, 77,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'怒',"4225",8 ,0  ,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'怏',"4226",8 ,38 ,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'怎',"4227",8 ,76 ,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'怍',"4228",8 ,114,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'怊',"4229",8 ,152,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'怆',"4230",8 ,190,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'怅',"4231",8 ,228,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'怄',"4232",8 ,266,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'怃',"4233",8 ,304,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'怂',"4234",8 ,342,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'态',"4235",8 ,380,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'怀',"4236",8 ,418,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'忿',"4237",8 ,456,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'忾',"4238",8 ,494,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'忽',"4239",8 ,532,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'忻',"4240",8 ,570,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'忸',"4241",8 ,608,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'念',"4242",8 ,646,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'忱',"4243",8 ,684,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'忮',"4244",8 ,722,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'忭',"4245",8 ,760,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'快',"4246",8 ,798,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'忪',"4247",8 ,836,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'忧',"4248",8 ,874,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'忤',"4249",8 ,912,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'忡',"4250",8 ,950,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'忠',"4251",8 ,0  ,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'忝',"4252",8 ,38 ,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'忙',"4253",8 ,76 ,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'忘',"4254",8 ,114,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'志',"4255",8 ,152,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'忖',"4256",8 ,190,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'忒',"4257",8 ,228,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'忑',"4258",8 ,266,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'忐',"4259",8 ,304,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'忏',"4260",8 ,342,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'忍',"4261",8 ,380,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'忌',"4262",8 ,418,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'忉',"4263",8 ,456,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'忆',"4264",8 ,494,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'必',"4265",8 ,532,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'忄',"4266",8 ,570,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'心',"4267",8 ,608,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'徽',"4268",8 ,646,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'徼',"4269",8 ,684,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'德',"4270",8 ,722,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'徵',"4271",8 ,760,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'微',"4272",8 ,798,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'徭',"4273",8 ,836,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'循',"4274",8 ,874,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'徨',"4275",8 ,912,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'御',"4276",8 ,950,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'徜',"4277",8 ,0  ,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'徙',"4278",8 ,38 ,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'徘',"4279",8 ,76 ,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'得',"4280",8 ,114,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'徕',"4281",8 ,152,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'徒',"4282",8 ,190,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'徐',"4283",8 ,228,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'後',"4284",8 ,266,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'律',"4285",8 ,304,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'徊',"4286",8 ,342,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'徉',"4287",8 ,380,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'很',"4288",8 ,418,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'徇',"4289",8 ,456,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'待',"4290",8 ,494,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'径',"4291",8 ,532,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'徂',"4292",8 ,570,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'征',"4293",8 ,608,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'往',"4294",8 ,646,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'彼',"4295",8 ,684,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'彻',"4296",8 ,722,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'役',"4297",8 ,760,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'彷',"4298",8 ,798,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'彳',"4299",8 ,836,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'影',"4300",8 ,874,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'彰',"4301",8 ,912,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'彭',"4302",8 ,950,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'彬',"4303",8 ,0  ,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'彪',"4304",8 ,38 ,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'彩',"4305",8 ,76 ,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'彦',"4306",8 ,114,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'彤',"4307",8 ,152,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'形',"4308",8 ,190,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'彡',"4309",8 ,228,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'彝',"4310",8 ,266,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'彘',"4311",8 ,304,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'彗',"4312",8 ,342,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'彖',"4313",8 ,380,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'录',"4314",8 ,418,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'当',"4315",8 ,456,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'归',"4316",8 ,494,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'彐',"4317",8 ,532,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'彀',"4318",8 ,570,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'弼',"4319",8 ,608,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'强',"4320",8 ,646,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'弹',"4321",8 ,684,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'弱',"4322",8 ,722,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'弯',"4323",8 ,760,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'弭',"4324",8 ,798,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'弪',"4325",8 ,836,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'弩',"4326",8 ,874,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'弧',"4327",8 ,912,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'弦',"4328",8 ,950,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'弥',"4329",8 ,0  ,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'张',"4330",8 ,38 ,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'弟',"4331",8 ,76 ,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'弛',"4332",8 ,114,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'弘',"4333",8 ,152,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'弗',"4334",8 ,190,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'引',"4335",8 ,228,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'弓',"4336",8 ,266,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'弑',"4337",8 ,304,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'式',"4338",8 ,342,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'弋',"4339",8 ,380,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'弊',"4340",8 ,418,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'弈',"4341",8 ,456,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'弄',"4342",8 ,494,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'弃',"4343",8 ,532,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'异',"4344",8 ,570,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'弁',"4345",8 ,608,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'开',"4346",8 ,646,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'廿',"4347",8 ,684,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'廾',"4348",8 ,722,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'建',"4349",8 ,760,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'廷',"4350",8 ,798,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'延',"4351",8 ,836,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'廴',"4352",8 ,874,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'廪',"4353",8 ,912,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'廨',"4354",8 ,950,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'廛',"4355",8 ,0  ,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'廖',"4356",8 ,38 ,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'廓',"4357",8 ,76 ,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'廒',"4358",8 ,114,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'廑',"4359",8 ,152,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'廊',"4360",8 ,190,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'廉',"4361",8 ,228,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'庾',"4362",8 ,266,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'庹',"4363",8 ,304,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'庸',"4364",8 ,342,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'康',"4365",8 ,380,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'庶',"4366",8 ,418,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'庵',"4367",8 ,456,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'庳',"4368",8 ,494,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'庭',"4369",8 ,532,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'座',"4370",8 ,570,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'度',"4371",8 ,608,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'庥',"4372",8 ,646,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'庠',"4373",8 ,684,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'废',"4374",8 ,722,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'庞',"4375",8 ,760,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'府',"4376",8 ,798,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'庚',"4377",8 ,836,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'庙',"4378",8 ,874,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'店',"4379",8 ,912,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'庖',"4380",8 ,950,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'底',"4381",8 ,0  ,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'应',"4382",8 ,38 ,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'库',"4383",8 ,76 ,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'庑',"4384",8 ,114,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'庐',"4385",8 ,152,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'序',"4386",8 ,190,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'庋',"4387",8 ,228,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'床',"4388",8 ,266,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'庇',"4389",8 ,304,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'庆',"4390",8 ,342,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'庄',"4391",8 ,380,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'庀',"4392",8 ,418,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'广',"4393",8 ,456,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'幽',"4394",8 ,494,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'幼',"4395",8 ,532,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'幻',"4396",8 ,570,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'幺',"4397",8 ,608,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'幸',"4398",8 ,646,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'并',"4399",8 ,684,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'年',"4400",8 ,722,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'平',"4401",8 ,760,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'干',"4402",8 ,798,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'幢',"4403",8 ,836,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'幡',"4404",8 ,874,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'幞',"4405",8 ,912,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'幛',"4406",8 ,950,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'幕',"4407",8 ,0  ,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'幔',"4408",8 ,38 ,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'幌',"4409",8 ,76 ,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'幅',"4410",8 ,114,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'幄',"4411",8 ,152,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'幂',"4412",8 ,190,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'帽',"4413",8 ,228,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'帼',"4414",8 ,266,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'帻',"4415",8 ,304,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'常',"4416",8 ,342,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'帷',"4417",8 ,380,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'帱',"4418",8 ,418,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'帮',"4419",8 ,456,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'席',"4420",8 ,494,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'帧',"4421",8 ,532,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'带',"4422",8 ,570,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'帝',"4423",8 ,608,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'帜',"4424",8 ,646,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'帛',"4425",8 ,684,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'帚',"4426",8 ,722,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'帙',"4427",8 ,760,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'帘',"4428",8 ,798,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'帖',"4429",8 ,836,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'帕',"4430",8 ,874,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'帔',"4431",8 ,912,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'帑',"4432",8 ,950,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'帐',"4433",8 ,0  ,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'帏',"4434",8 ,38 ,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'希',"4435",8 ,76 ,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'师',"4436",8 ,114,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'帆',"4437",8 ,152,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'帅',"4438",8 ,190,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'布',"4439",8 ,228,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'市',"4440",8 ,266,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'币',"4441",8 ,304,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'巾',"4442",8 ,342,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'巽',"4443",8 ,380,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'巷',"4444",8 ,418,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'巴',"4445",8 ,456,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'巳',"4446",8 ,494,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'已',"4447",8 ,532,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'己',"4448",8 ,570,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'巯',"4449",8 ,608,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'差',"4450",8 ,646,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'巫',"4451",8 ,684,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'巩',"4452",8 ,722,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'巨',"4453",8 ,760,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'巧',"4454",8 ,798,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'左',"4455",8 ,836,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'工',"4456",8 ,874,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'巢',"4457",8 ,912,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'巡',"4458",8 ,950,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'州',"4459",8 ,0  ,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'川',"4460",8 ,38 ,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'巛',"4461",8 ,76 ,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'巍',"4462",8 ,114,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'巅',"4463",8 ,152,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'嶷',"4464",8 ,190,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'嶝',"4465",8 ,228,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'嶙',"4466",8 ,266,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'嶂',"4467",8 ,304,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'嵴',"4468",8 ,342,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'嵯',"4469",8 ,380,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'嵬',"4470",8 ,418,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'嵫',"4471",8 ,456,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'嵩',"4472",8 ,494,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'嵝',"4473",8 ,532,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'嵛',"4474",8 ,570,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'嵘',"4475",8 ,608,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'嵌',"4476",8 ,646,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'嵋',"4477",8 ,684,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'嵊',"4478",8 ,722,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'嵇',"4479",8 ,760,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'崾',"4480",8 ,798,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'崽',"4481",8 ,836,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'崴',"4482",8 ,874,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'崮',"4483",8 ,912,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'崭',"4484",8 ,950,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'崩',"4485",8 ,0  ,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'崧',"4486",8 ,38 ,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'崦',"4487",8 ,76 ,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'崤',"4488",8 ,114,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'崞',"4489",8 ,152,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'崛',"4490",8 ,190,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'崖',"4491",8 ,228,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'崔',"4492",8 ,266,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'崎',"4493",8 ,304,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'崇',"4494",8 ,342,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'崆',"4495",8 ,380,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'崃',"4496",8 ,418,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'崂',"4497",8 ,456,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'峻',"4498",8 ,494,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'峰',"4499",8 ,532,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'峭',"4500",8 ,570,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'峪',"4501",8 ,608,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'峨',"4502",8 ,646,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'峦',"4503",8 ,684,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'峥',"4504",8 ,722,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'峤',"4505",8 ,760,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'峡',"4506",8 ,798,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'峙',"4507",8 ,836,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'峒',"4508",8 ,874,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'峋',"4509",8 ,912,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'峄',"4510",8 ,950,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'峁',"4511",8 ,0  ,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'岿',"4512",8 ,38 ,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'岽',"4513",8 ,76 ,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'岸',"4514",8 ,114,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'岷',"4515",8 ,152,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'岵',"4516",8 ,190,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'岳',"4517",8 ,228,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'岱',"4518",8 ,266,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'岭',"4519",8 ,304,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'岬',"4520",8 ,342,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'岫',"4521",8 ,380,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'岩',"4522",8 ,418,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'岣',"4523",8 ,456,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'岢',"4524",8 ,494,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'岜',"4525",8 ,532,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'岛',"4526",8 ,570,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'岚',"4527",8 ,608,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'岙',"4528",8 ,646,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'岘',"4529",8 ,684,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'岗',"4530",8 ,722,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'岖',"4531",8 ,760,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'岔',"4532",8 ,798,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'岑',"4533",8 ,836,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'岐',"4534",8 ,874,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'岍',"4535",8 ,912,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'岌',"4536",8 ,950,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'岈',"4537",8 ,0  ,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'岂',"4538",8 ,38 ,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'岁',"4539",8 ,76 ,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'屿',"4540",8 ,114,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'屺',"4541",8 ,152,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'屹',"4542",8 ,190,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'山',"4543",8 ,228,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'屯',"4544",8 ,266,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'屮',"4545",8 ,304,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'屦',"4546",8 ,342,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'履',"4547",8 ,380,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'屣',"4548",8 ,418,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'屡',"4549",8 ,456,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'屠',"4550",8 ,494,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'属',"4551",8 ,532,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'屙',"4552",8 ,570,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'展',"4553",8 ,608,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'屑',"4554",8 ,646,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'屐',"4555",8 ,684,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'屏',"4556",8 ,722,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'屎',"4557",8 ,760,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'屋',"4558",8 ,798,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'届',"4559",8 ,836,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'屉',"4560",8 ,874,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'屈',"4561",8 ,912,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'居',"4562",8 ,950,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'层',"4563",8 ,0  ,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'屁',"4564",8 ,38 ,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'局',"4565",8 ,76 ,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'尿',"4566",8 ,114,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'尾',"4567",8 ,152,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'尽',"4568",8 ,190,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'尼',"4569",8 ,228,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'尻',"4570",8 ,266,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'尺',"4571",8 ,304,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'尹',"4572",8 ,342,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'尸',"4573",8 ,380,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'尴',"4574",8 ,418,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'就',"4575",8 ,456,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'尬',"4576",8 ,494,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'尧',"4577",8 ,532,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'尥',"4578",8 ,570,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'尤',"4579",8 ,608,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'尢',"4580",8 ,646,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'尝',"4581",8 ,684,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'尜',"4582",8 ,722,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'尚',"4583",8 ,760,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'尘',"4584",8 ,798,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'尖',"4585",8 ,836,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'尕',"4586",8 ,874,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'尔',"4587",8 ,912,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'少',"4588",8 ,950,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'小',"4589",8 ,0  ,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'尊',"4590",8 ,38 ,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'尉',"4591",8 ,76 ,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'将',"4592",8 ,114,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'射',"4593",8 ,152,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'封',"4594",8 ,190,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'寿',"4595",8 ,228,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'导',"4596",8 ,266,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'寻',"4597",8 ,304,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'寺',"4598",8 ,342,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'对',"4599",8 ,380,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'寸',"4600",8 ,418,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'寰',"4601",8 ,456,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'寮',"4602",8 ,494,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'寨',"4603",8 ,532,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'寥',"4604",8 ,570,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'寤',"4605",8 ,608,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'寡',"4606",8 ,646,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'察',"4607",8 ,684,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'寞',"4608",8 ,722,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'寝',"4609",8 ,760,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'寓',"4610",8 ,798,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'寒',"4611",8 ,836,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'寐',"4612",8 ,874,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'富',"4613",8 ,912,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'寇',"4614",8 ,950,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'密',"4615",8 ,0  ,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'寅',"4616",8 ,38 ,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'寄',"4617",8 ,76 ,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'寂',"4618",8 ,114,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'宿',"4619",8 ,152,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'宾',"4620",8 ,190,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'宽',"4621",8 ,228,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'容',"4622",8 ,266,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'宸',"4623",8 ,304,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'家',"4624",8 ,342,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'宵',"4625",8 ,380,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'宴',"4626",8 ,418,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'害',"4627",8 ,456,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'宰',"4628",8 ,494,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'宫',"4629",8 ,532,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'宪',"4630",8 ,570,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'宦',"4631",8 ,608,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'宥',"4632",8 ,646,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'室',"4633",8 ,684,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'宣',"4634",8 ,722,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'客',"4635",8 ,760,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'审',"4636",8 ,798,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'宠',"4637",8 ,836,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'实',"4638",8 ,874,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'宝',"4639",8 ,912,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'宜',"4640",8 ,950,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'宛',"4641",8 ,0  ,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'定',"4642",8 ,38 ,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'宙',"4643",8 ,76 ,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'官',"4644",8 ,114,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'宗',"4645",8 ,152,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'宕',"4646",8 ,190,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'宓',"4647",8 ,228,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'宏',"4648",8 ,266,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'完',"4649",8 ,304,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'宋',"4650",8 ,342,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'安',"4651",8 ,380,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'守',"4652",8 ,418,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'宇',"4653",8 ,456,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'宅',"4654",8 ,494,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'宄',"4655",8 ,532,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'它',"4656",8 ,570,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'宁',"4657",8 ,608,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'宀',"4658",8 ,646,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'孽',"4659",8 ,684,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'孺',"4660",8 ,722,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'孵',"4661",8 ,760,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'孳',"4662",8 ,798,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'孱',"4663",8 ,836,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'孰',"4664",8 ,874,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'孬',"4665",8 ,912,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'孪',"4666",8 ,950,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'孩',"4667",8 ,0  ,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'学',"4668",8 ,38 ,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'孥',"4669",8 ,76 ,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'孤',"4670",8 ,114,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'季',"4671",8 ,152,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'孢',"4672",8 ,190,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'孟',"4673",8 ,228,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'孝',"4674",8 ,266,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'孜',"4675",8 ,304,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'孛',"4676",8 ,342,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'孚',"4677",8 ,380,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'孙',"4678",8 ,418,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'存',"4679",8 ,456,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'字',"4680",8 ,494,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'孕',"4681",8 ,532,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'孔',"4682",8 ,570,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'孓',"4683",8 ,608,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'孑',"4684",8 ,646,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'子',"4685",8 ,684,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'孀',"4686",8 ,722,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'嬷',"4687",8 ,760,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'嬴',"4688",8 ,798,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'嬲',"4689",8 ,836,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'嬗',"4690",8 ,874,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'嬖',"4691",8 ,912,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'嬉',"4692",8 ,950,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'嫱',"4693",8 ,0  ,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'嫫',"4694",8 ,38 ,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'嫩',"4695",8 ,76 ,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'嫦',"4696",8 ,114,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'嫣',"4697",8 ,152,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'嫡',"4698",8 ,190,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'嫠',"4699",8 ,228,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'嫜',"4700",8 ,266,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'嫘',"4701",8 ,304,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'嫖',"4702",8 ,342,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'嫔',"4703",8 ,380,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'嫒',"4704",8 ,418,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'嫌',"4705",8 ,456,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'嫉',"4706",8 ,494,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'嫂',"4707",8 ,532,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'嫁',"4708",8 ,570,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'媾',"4709",8 ,608,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'媸',"4710",8 ,646,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'媵',"4711",8 ,684,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'媳',"4712",8 ,722,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'媲',"4713",8 ,760,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'媪',"4714",8 ,798,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'媛',"4715",8 ,836,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'媚',"4716",8 ,874,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'媒',"4717",8 ,912,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'婿',"4718",8 ,950,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'婺',"4719",8 ,0  ,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'婷',"4720",8 ,38 ,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'婶',"4721",8 ,76 ,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'婵',"4722",8 ,114,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'婴',"4723",8 ,152,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'婪',"4724",8 ,190,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'婧',"4725",8 ,228,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'婢',"4726",8 ,266,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'婚',"4727",8 ,304,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'婕',"4728",8 ,342,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'婊',"4729",8 ,380,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'婉',"4730",8 ,418,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'婆',"4731",8 ,456,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'婀',"4732",8 ,494,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'娼',"4733",8 ,532,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'娶',"4734",8 ,570,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'娴',"4735",8 ,608,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'娲',"4736",8 ,646,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'娱',"4737",8 ,684,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'娩',"4738",8 ,722,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'娥',"4739",8 ,760,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'娣',"4740",8 ,798,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'娠',"4741",8 ,836,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'娟',"4742",8 ,874,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'娜',"4743",8 ,912,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'娘',"4744",8 ,950,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'娓',"4745",8 ,0  ,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'娑',"4746",8 ,38 ,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'娌',"4747",8 ,76 ,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'娉',"4748",8 ,114,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'娈',"4749",8 ,152,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'娇',"4750",8 ,190,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'娆',"4751",8 ,228,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'娅',"4752",8 ,266,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'娄',"4753",8 ,304,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'娃',"4754",8 ,342,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'威',"4755",8 ,380,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'姿',"4756",8 ,418,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'姻',"4757",8 ,456,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'姹',"4758",8 ,494,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'姬',"4759",8 ,532,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'姨',"4760",8 ,570,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'姥',"4761",8 ,608,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'姣',"4762",8 ,646,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'姝',"4763",8 ,684,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'姜',"4764",8 ,722,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'姚',"4765",8 ,760,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'姘',"4766",8 ,798,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'姗',"4767",8 ,836,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'委',"4768",8 ,874,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'姓',"4769",8 ,912,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'姒',"4770",8 ,950,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'姑',"4771",8 ,0  ,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'姐',"4772",8 ,38 ,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'始',"4773",8 ,76 ,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'姊',"4774",8 ,114,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'姆',"4775",8 ,152,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'妾',"4776",8 ,190,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'妻',"4777",8 ,228,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'妹',"4778",8 ,266,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'妲',"4779",8 ,304,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'妯',"4780",8 ,342,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'妮',"4781",8 ,380,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'妫',"4782",8 ,418,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'妪',"4783",8 ,456,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'妩',"4784",8 ,494,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'妨',"4785",8 ,532,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'妥',"4786",8 ,570,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'妤',"4787",8 ,608,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'妣',"4788",8 ,646,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'妞',"4789",8 ,684,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'妙',"4790",8 ,722,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'妗',"4791",8 ,760,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'妖',"4792",8 ,798,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'妓',"4793",8 ,836,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'妒',"4794",8 ,874,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'妍',"4795",8 ,912,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'妊',"4796",8 ,950,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'妈',"4797",8 ,0  ,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'妇',"4798",8 ,38 ,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'妆',"4799",8 ,76 ,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'妄',"4800",8 ,114,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'妃',"4801",8 ,152,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'如',"4802",8 ,190,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'妁',"4803",8 ,228,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'好',"4804",8 ,266,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'她',"4805",8 ,304,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'奸',"4806",8 ,342,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'奶',"4807",8 ,380,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'奴',"4808",8 ,418,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'女',"4809",8 ,456,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'奥',"4810",8 ,494,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'奢',"4811",8 ,532,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'奠',"4812",8 ,570,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'奚',"4813",8 ,608,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'奘',"4814",8 ,646,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'套',"4815",8 ,684,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'奖',"4816",8 ,722,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'奕',"4817",8 ,760,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'奔',"4818",8 ,798,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'契',"4819",8 ,836,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'奏',"4820",8 ,874,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'奎',"4821",8 ,912,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'奋',"4822",8 ,950,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'奉',"4823",8 ,0  ,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'奈',"4824",8 ,38 ,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'奇',"4825",8 ,76 ,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'奄',"4826",8 ,114,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'奂',"4827",8 ,152,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'奁',"4828",8 ,190,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'夼',"4829",8 ,228,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'夺',"4830",8 ,266,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'夹',"4831",8 ,304,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'夸',"4832",8 ,342,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'夷',"4833",8 ,380,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'头',"4834",8 ,418,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'失',"4835",8 ,456,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'夯',"4836",8 ,494,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'央',"4837",8 ,532,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'夭',"4838",8 ,570,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'夫',"4839",8 ,608,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'太',"4840",8 ,646,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'天',"4841",8 ,684,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'大',"4842",8 ,722,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'夥',"4843",8 ,760,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'夤',"4844",8 ,798,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'够',"4845",8 ,836,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'夜',"4846",8 ,874,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'多',"4847",8 ,912,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-09",1024,'夙',"4848",8 ,950,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'栾',"4849",7 ,0  ,  3,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'栽',"4850",7 ,38 ,  3,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'格',"4851",7 ,76 ,  3,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'根',"4852",7 ,114,  3,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'核',"4853",7 ,152,  3,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'样',"4854",7 ,190,  3,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'栳',"4855",7 ,228,  3,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'栲',"4856",7 ,266,  3,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'株',"4857",7 ,304,  3,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'栩',"4858",7 ,342,  3,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'校',"4859",7 ,380,  3,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'栝',"4860",7 ,418,  3,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'栗',"4861",7 ,456,  3,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'栖',"4862",7 ,494,  3,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'栓',"4863",7 ,532,  3,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'树',"4864",7 ,570,  3,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'栏',"4865",7 ,608,  3,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'栎',"4866",7 ,646,  3,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'栌',"4867",7 ,684,  3,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'栋',"4868",7 ,722,  3,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'栊',"4869",7 ,760,  3,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'栉',"4870",7 ,798,  3,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'栈',"4871",7 ,836,  3,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'标',"4872",7 ,874,  3,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'栅',"4873",7 ,912,  3,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'栀',"4874",7 ,950,  3,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'柿',"4875",7 ,0  ,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'柽',"4876",7 ,38 ,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'柴',"4877",7 ,76 ,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'柳',"4878",7 ,114,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'柱',"4879",7 ,152,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'柰',"4880",7 ,190,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'柯',"4881",7 ,228,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'柬',"4882",7 ,266,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'柩',"4883",7 ,304,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'查',"4884",7 ,342,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'柢',"4885",7 ,380,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'柠',"4886",7 ,418,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'柞',"4887",7 ,456,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'柝',"4888",7 ,494,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'柜',"4889",7 ,532,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'柚',"4890",7 ,570,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'柙',"4891",7 ,608,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'柘',"4892",7 ,646,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'柔',"4893",7 ,684,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'染',"4894",7 ,722,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'柒',"4895",7 ,760,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'柑',"4896",7 ,798,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'某',"4897",7 ,836,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'柏',"4898",7 ,874,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'柄',"4899",7 ,912,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'柃',"4900",7 ,950,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'柁',"4901",7 ,0  ,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'枸',"4902",7 ,38 ,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'枷',"4903",7 ,76 ,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'架',"4904",7 ,114,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'枵',"4905",7 ,152,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'枳',"4906",7 ,190,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'枰',"4907",7 ,228,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'枯',"4908",7 ,266,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'枭',"4909",7 ,304,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'枫',"4910",7 ,342,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'枪',"4911",7 ,380,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'枨',"4912",7 ,418,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'枧',"4913",7 ,456,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'枥',"4914",7 ,494,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'枣',"4915",7 ,532,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'枢',"4916",7 ,570,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'枞',"4917",7 ,608,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'枝',"4918",7 ,646,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'果',"4919",7 ,684,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'枚',"4920",7 ,722,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'枘',"4921",7 ,760,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'林',"4922",7 ,798,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'枕',"4923",7 ,836,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'析',"4924",7 ,874,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'枋',"4925",7 ,912,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'枉',"4926",7 ,950,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'枇',"4927",7 ,0  ,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'构',"4928",7 ,38 ,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'极',"4929",7 ,76 ,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'板',"4930",7 ,114,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'松',"4931",7 ,152,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'杼',"4932",7 ,190,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'杷',"4933",7 ,228,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'杵',"4934",7 ,266,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'杳',"4935",7 ,304,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'杲',"4936",7 ,342,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'杰',"4937",7 ,380,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'杯',"4938",7 ,418,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'杭',"4939",7 ,456,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'杪',"4940",7 ,494,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'杩',"4941",7 ,532,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'杨',"4942",7 ,570,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'来',"4943",7 ,608,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'条',"4944",7 ,646,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'杠',"4945",7 ,684,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'束',"4946",7 ,722,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'杞',"4947",7 ,760,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'杜',"4948",7 ,798,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'杖',"4949",7 ,836,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'杓',"4950",7 ,874,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'村',"4951",7 ,912,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'材',"4952",7 ,950,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'杏',"4953",7 ,0  ,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'李',"4954",7 ,38 ,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'杌',"4955",7 ,76 ,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'杉',"4956",7 ,114,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'杈',"4957",7 ,152,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'杆',"4958",7 ,190,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'权',"4959",7 ,228,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'杂',"4960",7 ,266,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'杀',"4961",7 ,304,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'朽',"4962",7 ,342,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'机',"4963",7 ,380,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'朵',"4964",7 ,418,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'朴',"4965",7 ,456,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'朱',"4966",7 ,494,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'术',"4967",7 ,532,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'札',"4968",7 ,570,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'本',"4969",7 ,608,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'末',"4970",7 ,646,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'未',"4971",7 ,684,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'木',"4972",7 ,722,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'朦',"4973",7 ,760,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'期',"4974",7 ,798,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'朝',"4975",7 ,836,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'望',"4976",7 ,874,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'朗',"4977",7 ,912,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'朕',"4978",7 ,950,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'朔',"4979",7 ,0  ,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'朐',"4980",7 ,38 ,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'服',"4981",7 ,76 ,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'朋',"4982",7 ,114,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'朊',"4983",7 ,152,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'有',"4984",7 ,190,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'月',"4985",7 ,228,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'最',"4986",7 ,266,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'替',"4987",7 ,304,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'曾',"4988",7 ,342,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'曼',"4989",7 ,380,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'曹',"4990",7 ,418,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'曷',"4991",7 ,456,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'更',"4992",7 ,494,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'曳',"4993",7 ,532,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'曲',"4994",7 ,570,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'曰',"4995",7 ,608,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'曩',"4996",7 ,646,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'曦',"4997",7 ,684,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'曝',"4998",7 ,722,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'曜',"4999",7 ,760,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'曛',"5000",7 ,798,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'曙',"5001",7 ,836,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'暾',"5002",7 ,874,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'暹',"5003",7 ,912,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'暴',"5004",7 ,950,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'暮',"5005",7 ,0  ,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'暨',"5006",7 ,38 ,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'暧',"5007",7 ,76 ,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'暝',"5008",7 ,114,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'暗',"5009",7 ,152,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'暖',"5010",7 ,190,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'暑',"5011",7 ,228,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'暌',"5012",7 ,266,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'暇',"5013",7 ,304,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'暄',"5014",7 ,342,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'暂',"5015",7 ,380,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'晾',"5016",7 ,418,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'智',"5017",7 ,456,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'晷',"5018",7 ,494,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'晶',"5019",7 ,532,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'晴',"5020",7 ,570,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'晰',"5021",7 ,608,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'景',"5022",7 ,646,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'普',"5023",7 ,684,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'晨',"5024",7 ,722,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'晦',"5025",7 ,760,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'晤',"5026",7 ,798,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'晡',"5027",7 ,836,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'晟',"5028",7 ,874,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'晚',"5029",7 ,912,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'晗',"5030",7 ,950,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'晖',"5031",7 ,0  ,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'晕',"5032",7 ,38 ,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'晔',"5033",7 ,76 ,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'晓',"5034",7 ,114,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'晒',"5035",7 ,152,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'晏',"5036",7 ,190,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'晌',"5037",7 ,228,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'晋',"5038",7 ,266,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'晃',"5039",7 ,304,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'晁',"5040",7 ,342,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'显',"5041",7 ,380,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'昼',"5042",7 ,418,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'昶',"5043",7 ,456,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'昵',"5044",7 ,494,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'昴',"5045",7 ,532,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'昱',"5046",7 ,570,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'是',"5047",7 ,608,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'昭',"5048",7 ,646,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'昨',"5049",7 ,684,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'昧',"5050",7 ,722,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'春',"5051",7 ,760,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'映',"5052",7 ,798,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'星',"5053",7 ,836,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'昝',"5054",7 ,874,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'昙',"5055",7 ,912,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'昕',"5056",7 ,950,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'昔',"5057",7 ,0  ,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'易',"5058",7 ,38 ,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'昏',"5059",7 ,76 ,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'明',"5060",7 ,114,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'昌',"5061",7 ,152,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'昊',"5062",7 ,190,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'昆',"5063",7 ,228,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'昃',"5064",7 ,266,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'昂',"5065",7 ,304,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'昀',"5066",7 ,342,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'旺',"5067",7 ,380,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'旷',"5068",7 ,418,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'时',"5069",7 ,456,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'旱',"5070",7 ,494,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'旰',"5071",7 ,532,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'旯',"5072",7 ,570,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'旮',"5073",7 ,608,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'旭',"5074",7 ,646,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'旬',"5075",7 ,684,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'早',"5076",7 ,722,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'旨',"5077",7 ,760,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'旧',"5078",7 ,798,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'旦',"5079",7 ,836,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'日',"5080",7 ,874,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'既',"5081",7 ,912,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'无',"5082",7 ,950,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'旗',"5083",7 ,0  ,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'旖',"5084",7 ,38 ,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'旒',"5085",7 ,76 ,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'族',"5086",7 ,114,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'旎',"5087",7 ,152,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'旌',"5088",7 ,190,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'旋',"5089",7 ,228,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'旆',"5090",7 ,266,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'旅',"5091",7 ,304,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'旄',"5092",7 ,342,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'旃',"5093",7 ,380,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'旁',"5094",7 ,418,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'施',"5095",7 ,456,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'於',"5096",7 ,494,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'方',"5097",7 ,532,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'新',"5098",7 ,570,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'斯',"5099",7 ,608,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'断',"5100",7 ,646,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'斫',"5101",7 ,684,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'斩',"5102",7 ,722,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'斧',"5103",7 ,760,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'斥',"5104",7 ,798,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'斤',"5105",7 ,836,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'斡',"5106",7 ,874,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'斟',"5107",7 ,912,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'斜',"5108",7 ,950,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'斛',"5109",7 ,0  ,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'料',"5110",7 ,38 ,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'斗',"5111",7 ,76 ,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'斓',"5112",7 ,114,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'斑',"5113",7 ,152,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'斐',"5114",7 ,190,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'斌',"5115",7 ,228,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'斋',"5116",7 ,266,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'文',"5117",7 ,304,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'敷',"5118",7 ,342,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'整',"5119",7 ,380,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'敲',"5120",7 ,418,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'数',"5121",7 ,456,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'敬',"5122",7 ,494,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'敫',"5123",7 ,532,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'敦',"5124",7 ,570,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'散',"5125",7 ,608,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'敢',"5126",7 ,646,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'敞',"5127",7 ,684,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'敝',"5128",7 ,722,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'敛',"5129",7 ,760,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'教',"5130",7 ,798,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'敖',"5131",7 ,836,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'敕',"5132",7 ,874,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'救',"5133",7 ,912,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'敏',"5134",7 ,950,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'敌',"5135",7 ,0  ,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'敉',"5136",7 ,38 ,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'效',"5137",7 ,76 ,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'故',"5138",7 ,114,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'政',"5139",7 ,152,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'放',"5140",7 ,190,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'攻',"5141",7 ,228,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'改',"5142",7 ,266,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'攸',"5143",7 ,304,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'收',"5144",7 ,342,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'攵',"5145",7 ,380,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'攴',"5146",7 ,418,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'支',"5147",7 ,456,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'攮',"5148",7 ,494,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'攫',"5149",7 ,532,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'攥',"5150",7 ,570,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'攘',"5151",7 ,608,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'攒',"5152",7 ,646,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'攉',"5153",7 ,684,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'攀',"5154",7 ,722,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'擦',"5155",7 ,760,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'擤',"5156",7 ,798,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'擢',"5157",7 ,836,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'擞',"5158",7 ,874,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'擘',"5159",7 ,912,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'擗',"5160",7 ,950,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'擒',"5161",7 ,0  ,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'擐',"5162",7 ,38 ,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'擎',"5163",7 ,76 ,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'操',"5164",7 ,114,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'擅',"5165",7 ,152,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'擂',"5166",7 ,190,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'擀',"5167",7 ,228,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'撼',"5168",7 ,266,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'撺',"5169",7 ,304,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'撸',"5170",7 ,342,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'撷',"5171",7 ,380,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'撵',"5172",7 ,418,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'撰',"5173",7 ,456,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'撮',"5174",7 ,494,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'播',"5175",7 ,532,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'撬',"5176",7 ,570,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'撩',"5177",7 ,608,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'撤',"5178",7 ,646,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'撞',"5179",7 ,684,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'撙',"5180",7 ,722,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'撖',"5181",7 ,760,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'撕',"5182",7 ,798,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'撒',"5183",7 ,836,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'撑',"5184",7 ,874,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'撇',"5185",7 ,912,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'撅',"5186",7 ,950,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'撄',"5187",7 ,0  ,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'撂',"5188",7 ,38 ,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'摺',"5189",7 ,76 ,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'摹',"5190",7 ,114,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'摸',"5191",7 ,152,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'摭',"5192",7 ,190,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'摩',"5193",7 ,228,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'摧',"5194",7 ,266,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'摞',"5195",7 ,304,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'摘',"5196",7 ,342,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'摔',"5197",7 ,380,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'摒',"5198",7 ,418,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'摊',"5199",7 ,456,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'摈',"5200",7 ,494,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'摇',"5201",7 ,532,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'摆',"5202",7 ,570,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'摅',"5203",7 ,608,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'摄',"5204",7 ,646,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'摁',"5205",7 ,684,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'搿',"5206",7 ,722,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'搽',"5207",7 ,760,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'携',"5208",7 ,798,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'搴',"5209",7 ,836,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'搭',"5210",7 ,874,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'搬',"5211",7 ,912,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'搪',"5212",7 ,950,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'搦',"5213",7 ,0  ,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'搡',"5214",7 ,38 ,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'搠',"5215",7 ,76 ,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'搞',"5216",7 ,114,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'搜',"5217",7 ,152,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'搛',"5218",7 ,190,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'搔',"5219",7 ,228,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'搓',"5220",7 ,266,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'搐',"5221",7 ,304,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'搏',"5222",7 ,342,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'搌',"5223",7 ,380,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'搋',"5224",7 ,418,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'搅',"5225",7 ,456,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'搂',"5226",7 ,494,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'搁',"5227",7 ,532,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'搀',"5228",7 ,570,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'揿',"5229",7 ,608,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'揽',"5230",7 ,646,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'揸',"5231",7 ,684,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'揶',"5232",7 ,722,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'援',"5233",7 ,760,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'揲',"5234",7 ,798,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'揭',"5235",7 ,836,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'揪',"5236",7 ,874,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'揩',"5237",7 ,912,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'揣',"5238",7 ,950,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'握',"5239",7 ,0  ,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'揠',"5240",7 ,38 ,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'揞',"5241",7 ,76 ,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'揖',"5242",7 ,114,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'插',"5243",7 ,152,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'提',"5244",7 ,190,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'描',"5245",7 ,228,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'揎',"5246",7 ,266,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'揍',"5247",7 ,304,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'揉',"5248",7 ,342,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'揆',"5249",7 ,380,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'揄',"5250",7 ,418,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'掾',"5251",7 ,456,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'掼',"5252",7 ,494,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'掺',"5253",7 ,532,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'掸',"5254",7 ,570,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'掷',"5255",7 ,608,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'掴',"5256",7 ,646,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'掳',"5257",7 ,684,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'掰',"5258",7 ,722,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'掮',"5259",7 ,760,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'掭',"5260",7 ,798,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'掬',"5261",7 ,836,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'措',"5262",7 ,874,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'掩',"5263",7 ,912,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'推',"5264",7 ,950,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'控',"5265",7 ,0  ,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'接',"5266",7 ,38 ,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'掣',"5267",7 ,76 ,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'探',"5268",7 ,114,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'掠',"5269",7 ,152,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'掘',"5270",7 ,190,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'掖',"5271",7 ,228,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'排',"5272",7 ,266,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'掐',"5273",7 ,304,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'掏',"5274",7 ,342,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'掎',"5275",7 ,380,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'掌',"5276",7 ,418,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'掊',"5277",7 ,456,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'掉',"5278",7 ,494,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'授',"5279",7 ,532,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'掇',"5280",7 ,570,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'掂',"5281",7 ,608,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'掀',"5282",7 ,646,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'捻',"5283",7 ,684,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'捺',"5284",7 ,722,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'捷',"5285",7 ,760,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'捶',"5286",7 ,798,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'捱',"5287",7 ,836,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'据',"5288",7 ,874,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'捭',"5289",7 ,912,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'捩',"5290",7 ,950,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'捧',"5291",7 ,0  ,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'捣',"5292",7 ,38 ,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'换',"5293",7 ,76 ,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'捡',"5294",7 ,114,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'损',"5295",7 ,152,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'捞',"5296",7 ,190,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'捕',"5297",7 ,228,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'捐',"5298",7 ,266,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'捏',"5299",7 ,304,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'捎',"5300",7 ,342,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'捍',"5301",7 ,380,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'捌',"5302",7 ,418,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'捋',"5303",7 ,456,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'捉',"5304",7 ,494,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'捆',"5305",7 ,532,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'捅',"5306",7 ,570,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'捃',"5307",7 ,608,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'捂',"5308",7 ,646,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'挽',"5309",7 ,684,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'挺',"5310",7 ,722,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'挹',"5311",7 ,760,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'挲',"5312",7 ,798,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'振',"5313",7 ,836,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'挫',"5314",7 ,874,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'挪',"5315",7 ,912,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'挨',"5316",7 ,950,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'挥',"5317",7 ,0  ,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'挤',"5318",7 ,38 ,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'挣',"5319",7 ,76 ,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'挢',"5320",7 ,114,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'挡',"5321",7 ,152,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'挠',"5322",7 ,190,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'挟',"5323",7 ,228,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'挞',"5324",7 ,266,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'挝',"5325",7 ,304,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'挛',"5326",7 ,342,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'挚',"5327",7 ,380,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'挖',"5328",7 ,418,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'挑',"5329",7 ,456,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'挎',"5330",7 ,494,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'按',"5331",7 ,532,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'挈',"5332",7 ,570,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'指',"5333",7 ,608,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'挂',"5334",7 ,646,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'持',"5335",7 ,684,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'拿',"5336",7 ,722,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'拾',"5337",7 ,760,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'拽',"5338",7 ,798,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'拼',"5339",7 ,836,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'拷',"5340",7 ,874,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'拶',"5341",7 ,912,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'拴',"5342",7 ,950,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'拳',"5343",7 ,0  ,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'拱',"5344",7 ,38 ,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'拯',"5345",7 ,76 ,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'拮',"5346",7 ,114,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'拭',"5347",7 ,152,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'括',"5348",7 ,190,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'择',"5349",7 ,228,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'拨',"5350",7 ,266,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'拧',"5351",7 ,304,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'拦',"5352",7 ,342,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'拥',"5353",7 ,380,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'拣',"5354",7 ,418,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'拢',"5355",7 ,456,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'拟',"5356",7 ,494,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'拜',"5357",7 ,532,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'招',"5358",7 ,570,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'拚',"5359",7 ,608,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'拙',"5360",7 ,646,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'拘',"5361",7 ,684,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'拗',"5362",7 ,722,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'拖',"5363",7 ,760,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'拔',"5364",7 ,798,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'拓',"5365",7 ,836,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'拒',"5366",7 ,874,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'拐',"5367",7 ,912,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'拎',"5368",7 ,950,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'拍',"5369",7 ,0  ,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'拌',"5370",7 ,38 ,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'拊',"5371",7 ,76 ,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'拉',"5372",7 ,114,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'拈',"5373",7 ,152,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'拇',"5374",7 ,190,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'拆',"5375",7 ,228,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'担',"5376",7 ,266,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'拄',"5377",7 ,304,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'拂',"5378",7 ,342,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'抿',"5379",7 ,380,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'抽',"5380",7 ,418,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'押',"5381",7 ,456,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'抻',"5382",7 ,494,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'抹',"5383",7 ,532,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'抵',"5384",7 ,570,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'抱',"5385",7 ,608,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'抬',"5386",7 ,646,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'披',"5387",7 ,684,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'抨',"5388",7 ,722,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'报',"5389",7 ,760,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'护',"5390",7 ,798,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'抢',"5391",7 ,836,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'抡',"5392",7 ,874,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'抠',"5393",7 ,912,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'抟',"5394",7 ,950,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'抛',"5395",7 ,0  ,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'抚',"5396",7 ,38 ,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'折',"5397",7 ,76 ,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'抗',"5398",7 ,114,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'抖',"5399",7 ,152,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'投',"5400",7 ,190,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'抓',"5401",7 ,228,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'抒',"5402",7 ,266,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'抑',"5403",7 ,304,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'把',"5404",7 ,342,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'抉',"5405",7 ,380,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'抄',"5406",7 ,418,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'技',"5407",7 ,456,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'承',"5408",7 ,494,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'找',"5409",7 ,532,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'扼',"5410",7 ,570,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'批',"5411",7 ,608,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'扶',"5412",7 ,646,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'扳',"5413",7 ,684,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'扰',"5414",7 ,722,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'扯',"5415",7 ,760,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'扮',"5416",7 ,798,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'扭',"5417",7 ,836,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'扬',"5418",7 ,874,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'扫',"5419",7 ,912,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'扪',"5420",7 ,950,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'扩',"5421",7 ,0  ,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'执',"5422",7 ,38 ,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'扦',"5423",7 ,76 ,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'扣',"5424",7 ,114,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'扛',"5425",7 ,152,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'托',"5426",7 ,190,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'扔',"5427",7 ,228,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'打',"5428",7 ,266,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'扒',"5429",7 ,304,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'扑',"5430",7 ,342,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'扎',"5431",7 ,380,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'才',"5432",7 ,418,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'扌',"5433",7 ,456,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'手',"5434",7 ,494,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'扉',"5435",7 ,532,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'扈',"5436",7 ,570,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'扇',"5437",7 ,608,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'扃',"5438",7 ,646,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'扁',"5439",7 ,684,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'所',"5440",7 ,722,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'房',"5441",7 ,760,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'戾',"5442",7 ,798,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'戽',"5443",7 ,836,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'户',"5444",7 ,874,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'戴',"5445",7 ,912,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'戳',"5446",7 ,950,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'戮',"5447",7 ,0  ,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'戬',"5448",7 ,38 ,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'截',"5449",7 ,76 ,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'戥',"5450",7 ,114,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'戤',"5451",7 ,152,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'戢',"5452",7 ,190,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'戡',"5453",7 ,228,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'戟',"5454",7 ,266,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'戛',"5455",7 ,304,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'戚',"5456",7 ,342,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'战',"5457",7 ,380,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'戗',"5458",7 ,418,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'或',"5459",7 ,456,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'戕',"5460",7 ,494,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'戒',"5461",7 ,532,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'我',"5462",7 ,570,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'成',"5463",7 ,608,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'戏',"5464",7 ,646,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'戎',"5465",7 ,684,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'戍',"5466",7 ,722,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'戌',"5467",7 ,760,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'戋',"5468",7 ,798,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'戊',"5469",7 ,836,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'戈',"5470",7 ,874,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'戆',"5471",7 ,912,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'懿',"5472",7 ,950,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'懵',"5473",7 ,0  ,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'懦',"5474",7 ,38 ,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'懔',"5475",7 ,76 ,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'懒',"5476",7 ,114,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'懑',"5477",7 ,152,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'懋',"5478",7 ,190,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'懊',"5479",7 ,228,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'懈',"5480",7 ,266,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'懂',"5481",7 ,304,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'憾',"5482",7 ,342,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'憷',"5483",7 ,380,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'憬',"5484",7 ,418,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'憩',"5485",7 ,456,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'憨',"5486",7 ,494,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'憧',"5487",7 ,532,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'憝',"5488",7 ,570,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'憔',"5489",7 ,608,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'憎',"5490",7 ,646,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'憋',"5491",7 ,684,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'慷',"5492",7 ,722,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'慵',"5493",7 ,760,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'慰',"5494",7 ,798,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'慨',"5495",7 ,836,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'慧',"5496",7 ,874,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'慢',"5497",7 ,912,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'慝',"5498",7 ,950,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'慕',"5499",7 ,0  ,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'慑',"5500",7 ,38 ,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'慎',"5501",7 ,76 ,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'慌',"5502",7 ,114,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'慊',"5503",7 ,152,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'慈',"5504",7 ,190,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'愿',"5505",7 ,228,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'愫',"5506",7 ,266,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'愧',"5507",7 ,304,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'愦',"5508",7 ,342,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'愤',"5509",7 ,380,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'愣',"5510",7 ,418,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'愠',"5511",7 ,456,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'感',"5512",7 ,494,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'愚',"5513",7 ,532,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'愕',"5514",7 ,570,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'意',"5515",7 ,608,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'愎',"5516",7 ,646,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'愍',"5517",7 ,684,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'愉',"5518",7 ,722,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'愈',"5519",7 ,760,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'愆',"5520",7 ,798,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'愁',"5521",7 ,836,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'愀',"5522",7 ,874,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'惺',"5523",7 ,912,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'惹',"5524",7 ,950,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'惶',"5525",7 ,0  ,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'惴',"5526",7 ,38 ,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'想',"5527",7 ,76 ,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'惰',"5528",7 ,114,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'惯',"5529",7 ,152,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'惮',"5530",7 ,190,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'惭',"5531",7 ,228,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'惬',"5532",7 ,266,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'惫',"5533",7 ,304,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'惩',"5534",7 ,342,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'惨',"5535",7 ,380,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'惧',"5536",7 ,418,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'惦',"5537",7 ,456,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'惠',"5538",7 ,494,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'惟',"5539",7 ,532,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'惝',"5540",7 ,570,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'惜',"5541",7 ,608,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'惚',"5542",7 ,646,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'惘',"5543",7 ,684,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'惕',"5544",7 ,722,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'惑',"5545",7 ,760,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'惋',"5546",7 ,798,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'惊',"5547",7 ,836,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'惆',"5548",7 ,874,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'情',"5549",7 ,912,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-08",1024,'悼',"5550",7 ,950,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'煊',"5551",6 ,0  ,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'煅',"5552",6 ,38 ,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'然',"5553",6 ,76 ,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'焱',"5554",6 ,114,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'焰',"5555",6 ,152,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'焯',"5556",6 ,190,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'焦',"5557",6 ,228,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'焚',"5558",6 ,266,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'焙',"5559",6 ,304,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'焘',"5560",6 ,342,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'焖',"5561",6 ,380,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'焕',"5562",6 ,418,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'焓',"5563",6 ,456,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'焐',"5564",6 ,494,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'焊',"5565",6 ,532,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'焉',"5566",6 ,570,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'烽',"5567",6 ,608,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'烹',"5568",6 ,646,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'烷',"5569",6 ,684,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'烯',"5570",6 ,722,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'热',"5571",6 ,760,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'烬',"5572",6 ,798,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'烫',"5573",6 ,836,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'烩',"5574",6 ,874,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'烨',"5575",6 ,912,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'烧',"5576",6 ,950,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'烦',"5577",6 ,0  ,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'烤',"5578",6 ,38 ,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'烟',"5579",6 ,76 ,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'烛',"5580",6 ,114,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'烙',"5581",6 ,152,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'烘',"5582",6 ,190,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'烊',"5583",6 ,228,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'烈',"5584",6 ,266,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'烃',"5585",6 ,304,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'烂',"5586",6 ,342,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'烁',"5587",6 ,380,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'烀',"5588",6 ,418,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'炽',"5589",6 ,456,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'炼',"5590",6 ,494,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'炻',"5591",6 ,532,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'点',"5592",6 ,570,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'炸',"5593",6 ,608,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'炷',"5594",6 ,646,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'炳',"5595",6 ,684,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'炱',"5596",6 ,722,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'炯',"5597",6 ,760,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'炮',"5598",6 ,798,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'炭',"5599",6 ,836,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'炬',"5600",6 ,874,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'炫',"5601",6 ,912,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'炝',"5602",6 ,950,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'炜',"5603",6 ,0  ,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'炙',"5604",6 ,38 ,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'炖',"5605",6 ,76 ,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'炕',"5606",6 ,114,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'炔',"5607",6 ,152,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'炒',"5608",6 ,190,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'炎',"5609",6 ,228,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'炊',"5610",6 ,266,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'炉',"5611",6 ,304,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'炅',"5612",6 ,342,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'炀',"5613",6 ,380,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'灿',"5614",6 ,418,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'灾',"5615",6 ,456,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'灼',"5616",6 ,494,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'灸',"5617",6 ,532,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'灶',"5618",6 ,570,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'灵',"5619",6 ,608,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'灰',"5620",6 ,646,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'灯',"5621",6 ,684,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'灭',"5622",6 ,722,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'灬',"5623",6 ,760,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'火',"5624",6 ,798,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'灞',"5625",6 ,836,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'灏',"5626",6 ,874,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'灌',"5627",6 ,912,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'瀹',"5628",6 ,950,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'瀵',"5629",6 ,0  ,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'瀣',"5630",6 ,38 ,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'瀛',"5631",6 ,76 ,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'瀚',"5632",6 ,114,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'瀑',"5633",6 ,152,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'濯',"5634",6 ,190,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'濮',"5635",6 ,228,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'濡',"5636",6 ,266,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'濠',"5637",6 ,304,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'濞',"5638",6 ,342,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'濒',"5639",6 ,380,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'濑',"5640",6 ,418,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'濉',"5641",6 ,456,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'濂',"5642",6 ,494,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'激',"5643",6 ,532,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'澹',"5644",6 ,570,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'澶',"5645",6 ,608,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'澳',"5646",6 ,646,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'澧',"5647",6 ,684,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'澡',"5648",6 ,722,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'澜',"5649",6 ,760,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'澎',"5650",6 ,798,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'澍',"5651",6 ,836,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'澌',"5652",6 ,874,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'澉',"5653",6 ,912,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'澈',"5654",6 ,950,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'澄',"5655",6 ,0  ,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'潼',"5656",6 ,38 ,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'潺',"5657",6 ,76 ,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'潸',"5658",6 ,114,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'潴',"5659",6 ,152,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'潲',"5660",6 ,190,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'潮',"5661",6 ,228,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'潭',"5662",6 ,266,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'潦',"5663",6 ,304,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'潢',"5664",6 ,342,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'潞',"5665",6 ,380,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'潜',"5666",6 ,418,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'潘',"5667",6 ,456,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'潍',"5668",6 ,494,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'潋',"5669",6 ,532,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'潇',"5670",6 ,570,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'潆',"5671",6 ,608,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'漾',"5672",6 ,646,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'漶',"5673",6 ,684,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'漳',"5674",6 ,722,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'漱',"5675",6 ,760,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'漯',"5676",6 ,798,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'漭',"5677",6 ,836,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'漫',"5678",6 ,874,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'漪',"5679",6 ,912,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'漩',"5680",6 ,950,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'漤',"5681",6 ,0  ,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'漠',"5682",6 ,38 ,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'漕',"5683",6 ,76 ,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'演',"5684",6 ,114,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'漓',"5685",6 ,152,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'漏',"5686",6 ,190,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'漉',"5687",6 ,228,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'漆',"5688",6 ,266,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'漂',"5689",6 ,304,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'滹',"5690",6 ,342,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'滴',"5691",6 ,380,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'滩',"5692",6 ,418,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'滨',"5693",6 ,456,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'滦',"5694",6 ,494,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'滥',"5695",6 ,532,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'滤',"5696",6 ,570,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'滢',"5697",6 ,608,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'满',"5698",6 ,646,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'滠',"5699",6 ,684,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'滟',"5700",6 ,722,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'滞',"5701",6 ,760,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'滚',"5702",6 ,798,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'滗',"5703",6 ,836,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'滕',"5704",6 ,874,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'滔',"5705",6 ,912,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'滓',"5706",6 ,950,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'滑',"5707",6 ,0  ,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'滏',"5708",6 ,38 ,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'滋',"5709",6 ,76 ,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'滇',"5710",6 ,114,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'滂',"5711",6 ,152,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'滁',"5712",6 ,190,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'溽',"5713",6 ,228,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'溻',"5714",6 ,266,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'溺',"5715",6 ,304,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'溷',"5716",6 ,342,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'溶',"5717",6 ,380,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'溴',"5718",6 ,418,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'溲',"5719",6 ,456,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'溱',"5720",6 ,494,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'溯',"5721",6 ,532,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'溪',"5722",6 ,570,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'溧',"5723",6 ,608,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'溥',"5724",6 ,646,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'溢',"5725",6 ,684,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'溟',"5726",6 ,722,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'溜',"5727",6 ,760,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'溘',"5728",6 ,798,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'源',"5729",6 ,836,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'溏',"5730",6 ,874,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'溉',"5731",6 ,912,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'溆',"5732",6 ,950,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'溅',"5733",6 ,0  ,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'溃',"5734",6 ,38 ,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'湿',"5735",6 ,76 ,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'湾',"5736",6 ,114,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'湮',"5737",6 ,152,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'湫',"5738",6 ,190,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'湟',"5739",6 ,228,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'湛',"5740",6 ,266,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'湘',"5741",6 ,304,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'湖',"5742",6 ,342,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'湔',"5743",6 ,380,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'湓',"5744",6 ,418,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'湎',"5745",6 ,456,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'湍',"5746",6 ,494,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'湄',"5747",6 ,532,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'湃',"5748",6 ,570,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'渺',"5749",6 ,608,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'游',"5750",6 ,646,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'渴',"5751",6 ,684,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'渲',"5752",6 ,722,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'港',"5753",6 ,760,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'渭',"5754",6 ,798,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'渫',"5755",6 ,836,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'温',"5756",6 ,874,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'渥',"5757",6 ,912,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'渤',"5758",6 ,950,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'渣',"5759",6 ,0  ,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'渡',"5760",6 ,38 ,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'渠',"5761",6 ,76 ,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'渝',"5762",6 ,114,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'渚',"5763",6 ,152,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'渗',"5764",6 ,190,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'渖',"5765",6 ,228,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'渔',"5766",6 ,266,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'渑',"5767",6 ,304,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'渐',"5768",6 ,342,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'渎',"5769",6 ,380,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'渍',"5770",6 ,418,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'渌',"5771",6 ,456,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'渊',"5772",6 ,494,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'清',"5773",6 ,532,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'淼',"5774",6 ,570,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'添',"5775",6 ,608,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'淹',"5776",6 ,646,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'混',"5777",6 ,684,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'淳',"5778",6 ,722,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'深',"5779",6 ,760,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'淮',"5780",6 ,798,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'淬',"5781",6 ,836,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'淫',"5782",6 ,874,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'淦',"5783",6 ,912,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'淤',"5784",6 ,950,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'淡',"5785",6 ,0  ,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'淠',"5786",6 ,38 ,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'淞',"5787",6 ,76 ,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'淝',"5788",6 ,114,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'淙',"5789",6 ,152,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'淘',"5790",6 ,190,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'淖',"5791",6 ,228,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'淑',"5792",6 ,266,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'淌',"5793",6 ,304,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'淋',"5794",6 ,342,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'淇',"5795",6 ,380,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'淆',"5796",6 ,418,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'淅',"5797",6 ,456,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'淄',"5798",6 ,494,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'淀',"5799",6 ,532,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'涿',"5800",6 ,570,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'涸',"5801",6 ,608,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'涵',"5802",6 ,646,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'液',"5803",6 ,684,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'涯',"5804",6 ,722,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'涮',"5805",6 ,760,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'涫',"5806",6 ,798,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'涪',"5807",6 ,836,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'涩',"5808",6 ,874,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'涨',"5809",6 ,912,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'涧',"5810",6 ,950,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'润',"5811",6 ,0  ,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'涤',"5812",6 ,38 ,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'涣',"5813",6 ,76 ,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'涡',"5814",6 ,114,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'涠',"5815",6 ,152,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'涟',"5816",6 ,190,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'涞',"5817",6 ,228,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'涝',"5818",6 ,266,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'涛',"5819",6 ,304,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'涕',"5820",6 ,342,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'涔',"5821",6 ,380,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'涓',"5822",6 ,418,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'涑',"5823",6 ,456,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'涎',"5824",6 ,494,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'涌',"5825",6 ,532,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'涉',"5826",6 ,570,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'消',"5827",6 ,608,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'涅',"5828",6 ,646,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'涂',"5829",6 ,684,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'浼',"5830",6 ,722,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'浸',"5831",6 ,760,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'海',"5832",6 ,798,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'浴',"5833",6 ,836,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'浯',"5834",6 ,874,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'浮',"5835",6 ,912,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'浪',"5836",6 ,950,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'浩',"5837",6 ,0  ,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'浦',"5838",6 ,38 ,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'浣',"5839",6 ,76 ,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'浠',"5840",6 ,114,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'浞',"5841",6 ,152,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'浜',"5842",6 ,190,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'浚',"5843",6 ,228,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'浙',"5844",6 ,266,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'浔',"5845",6 ,304,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'浓',"5846",6 ,342,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'浒',"5847",6 ,380,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'浑',"5848",6 ,418,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'浏',"5849",6 ,456,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'济',"5850",6 ,494,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'浍',"5851",6 ,532,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'测',"5852",6 ,570,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'浊',"5853",6 ,608,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'浈',"5854",6 ,646,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'浇',"5855",6 ,684,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'浆',"5856",6 ,722,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'浅',"5857",6 ,760,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'浃',"5858",6 ,798,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'流',"5859",6 ,836,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'派',"5860",6 ,874,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'洽',"5861",6 ,912,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'洼',"5862",6 ,950,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'活',"5863",6 ,0  ,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'洹',"5864",6 ,38 ,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'洵',"5865",6 ,76 ,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'洳',"5866",6 ,114,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'洲',"5867",6 ,152,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'洱',"5868",6 ,190,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'洮',"5869",6 ,228,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'洫',"5870",6 ,266,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'洪',"5871",6 ,304,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'洧',"5872",6 ,342,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'津',"5873",6 ,380,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'洞',"5874",6 ,418,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'洛',"5875",6 ,456,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'洚',"5876",6 ,494,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'洙',"5877",6 ,532,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'洗',"5878",6 ,570,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'洒',"5879",6 ,608,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'洎',"5880",6 ,646,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'洌',"5881",6 ,684,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'洋',"5882",6 ,722,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'洇',"5883",6 ,760,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'洄',"5884",6 ,798,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'洁',"5885",6 ,836,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'泾',"5886",6 ,874,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'泽',"5887",6 ,912,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'泼',"5888",6 ,950,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'泻',"5889",6 ,0  ,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'泺',"5890",6 ,38 ,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'泸',"5891",6 ,76 ,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'泷',"5892",6 ,114,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'泶',"5893",6 ,152,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'泵',"5894",6 ,190,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'泳',"5895",6 ,228,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'泱',"5896",6 ,266,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'泰',"5897",6 ,304,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'泯',"5898",6 ,342,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'泮',"5899",6 ,380,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'泫',"5900",6 ,418,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'泪',"5901",6 ,456,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'注',"5902",6 ,494,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'泥',"5903",6 ,532,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'泣',"5904",6 ,570,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'波',"5905",6 ,608,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'泡',"5906",6 ,646,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'泠',"5907",6 ,684,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'泞',"5908",6 ,722,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'泛',"5909",6 ,760,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'泗',"5910",6 ,798,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'泖',"5911",6 ,836,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'法',"5912",6 ,874,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'泔',"5913",6 ,912,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'泓',"5914",6 ,950,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'泐',"5915",6 ,0  ,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'泌',"5916",6 ,38 ,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'泊',"5917",6 ,76 ,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'泉',"5918",6 ,114,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'泅',"5919",6 ,152,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'泄',"5920",6 ,190,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'沿',"5921",6 ,228,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'沾',"5922",6 ,266,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'沽',"5923",6 ,304,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'沼',"5924",6 ,342,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'治',"5925",6 ,380,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'油',"5926",6 ,418,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'沸',"5927",6 ,456,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'河',"5928",6 ,494,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'沲',"5929",6 ,532,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'沱',"5930",6 ,570,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'沮',"5931",6 ,608,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'沭',"5932",6 ,646,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'沫',"5933",6 ,684,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'沪',"5934",6 ,722,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'沩',"5935",6 ,760,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'沧',"5936",6 ,798,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'沦',"5937",6 ,836,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'沥',"5938",6 ,874,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'沤',"5939",6 ,912,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'沣',"5940",6 ,950,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'没',"5941",6 ,0  ,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'沟',"5942",6 ,38 ,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'沛',"5943",6 ,76 ,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'沙',"5944",6 ,114,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'沔',"5945",6 ,152,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'沓',"5946",6 ,190,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'沐',"5947",6 ,228,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'沏',"5948",6 ,266,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'沌',"5949",6 ,304,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'沉',"5950",6 ,342,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'沈',"5951",6 ,380,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'沆',"5952",6 ,418,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'沅',"5953",6 ,456,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'沃',"5954",6 ,494,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'沂',"5955",6 ,532,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'沁',"5956",6 ,570,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'汾',"5957",6 ,608,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'汽',"5958",6 ,646,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'汹',"5959",6 ,684,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'汶',"5960",6 ,722,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'汴',"5961",6 ,760,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'汲',"5962",6 ,798,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'汰',"5963",6 ,836,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'汪',"5964",6 ,874,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'汩',"5965",6 ,912,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'汨',"5966",6 ,950,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'汤',"5967",6 ,0  ,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'污',"5968",6 ,38 ,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'池',"5969",6 ,76 ,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'江',"5970",6 ,114,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'汞',"5971",6 ,152,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'汝',"5972",6 ,190,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'汜',"5973",6 ,228,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'汛',"5974",6 ,266,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'汗',"5975",6 ,304,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'汕',"5976",6 ,342,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'汔',"5977",6 ,380,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'汐',"5978",6 ,418,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'汊',"5979",6 ,456,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'汉',"5980",6 ,494,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'汇',"5981",6 ,532,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'汆',"5982",6 ,570,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'求',"5983",6 ,608,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'汁',"5984",6 ,646,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'汀',"5985",6 ,684,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'氽',"5986",6 ,722,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'永',"5987",6 ,760,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'氵',"5988",6 ,798,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'水',"5989",6 ,836,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'氲',"5990",6 ,874,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'氰',"5991",6 ,912,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'氯',"5992",6 ,950,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'氮',"5993",6 ,0  ,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'氪',"5994",6 ,38 ,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'氩',"5995",6 ,76 ,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'氨',"5996",6 ,114,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'氧',"5997",6 ,152,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'氦',"5998",6 ,190,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'氤',"5999",6 ,228,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'氢',"6000",6 ,266,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'氡',"6001",6 ,304,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'氟',"6002",6 ,342,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'氛',"6003",6 ,380,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'氚',"6004",6 ,418,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'氙',"6005",6 ,456,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'氘',"6006",6 ,494,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'氖',"6007",6 ,532,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'氕',"6008",6 ,570,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'气',"6009",6 ,608,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'氓',"6010",6 ,646,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'民',"6011",6 ,684,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'氐',"6012",6 ,722,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'氏',"6013",6 ,760,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'氍',"6014",6 ,798,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'氇',"6015",6 ,836,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'氆',"6016",6 ,874,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'氅',"6017",6 ,912,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'毽',"6018",6 ,950,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'毹',"6019",6 ,0  ,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'毵',"6020",6 ,38 ,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'毳',"6021",6 ,76 ,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'毯',"6022",6 ,114,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'毫',"6023",6 ,152,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'毪',"6024",6 ,190,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'毡',"6025",6 ,228,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'毛',"6026",6 ,266,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'毙',"6027",6 ,304,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'毗',"6028",6 ,342,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'毖',"6029",6 ,380,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'毕',"6030",6 ,418,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'比',"6031",6 ,456,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'毓',"6032",6 ,494,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'毒',"6033",6 ,532,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'每',"6034",6 ,570,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'母',"6035",6 ,608,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'毋',"6036",6 ,646,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'毅',"6037",6 ,684,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'毂',"6038",6 ,722,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'毁',"6039",6 ,760,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'殿',"6040",6 ,798,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'殷',"6041",6 ,836,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'段',"6042",6 ,874,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'殴',"6043",6 ,912,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'殳',"6044",6 ,950,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'殪',"6045",6 ,0  ,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'殡',"6046",6 ,38 ,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'殛',"6047",6 ,76 ,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'殚',"6048",6 ,114,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'殖',"6049",6 ,152,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'殓',"6050",6 ,190,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'殒',"6051",6 ,228,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'殍',"6052",6 ,266,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'残',"6053",6 ,304,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'殊',"6054",6 ,342,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'殉',"6055",6 ,380,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'殇',"6056",6 ,418,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'殆',"6057",6 ,456,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'殄',"6058",6 ,494,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'殃',"6059",6 ,532,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'殂',"6060",6 ,570,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'殁',"6061",6 ,608,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'歼',"6062",6 ,646,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'死',"6063",6 ,684,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'歹',"6064",6 ,722,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'歪',"6065",6 ,760,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'歧',"6066",6 ,798,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'武',"6067",6 ,836,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'步',"6068",6 ,874,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'此',"6069",6 ,912,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'正',"6070",6 ,950,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'止',"6071",6 ,0  ,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'歙',"6072",6 ,38 ,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'歌',"6073",6 ,76 ,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'歉',"6074",6 ,114,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'歇',"6075",6 ,152,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'歆',"6076",6 ,190,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'歃',"6077",6 ,228,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'款',"6078",6 ,266,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'欺',"6079",6 ,304,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'欹',"6080",6 ,342,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'欷',"6081",6 ,380,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'欲',"6082",6 ,418,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'欧',"6083",6 ,456,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'欤',"6084",6 ,494,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'欣',"6085",6 ,532,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'欢',"6086",6 ,570,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'次',"6087",6 ,608,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'欠',"6088",6 ,646,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'檬',"6089",6 ,684,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'檫',"6090",6 ,722,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'檩',"6091",6 ,760,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'檠',"6092",6 ,798,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'檗',"6093",6 ,836,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'檑',"6094",6 ,874,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'檐',"6095",6 ,912,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'檎',"6096",6 ,950,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'檄',"6097",6 ,0  ,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'檀',"6098",6 ,38 ,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'橼',"6099",6 ,76 ,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'橹',"6100",6 ,114,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'橱',"6101",6 ,152,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'橥',"6102",6 ,190,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'橡',"6103",6 ,228,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'橛',"6104",6 ,266,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'橙',"6105",6 ,304,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'橘',"6106",6 ,342,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'橐',"6107",6 ,380,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'橇',"6108",6 ,418,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'橄',"6109",6 ,456,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'樾',"6110",6 ,494,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'樽',"6111",6 ,532,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'樵',"6112",6 ,570,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'樱',"6113",6 ,608,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'樯',"6114",6 ,646,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'横',"6115",6 ,684,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'樨',"6116",6 ,722,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'模',"6117",6 ,760,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'樟',"6118",6 ,798,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'樘',"6119",6 ,836,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'樗',"6120",6 ,874,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'樊',"6121",6 ,912,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'槿',"6122",6 ,950,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'槽',"6123",6 ,0  ,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'槲',"6124",6 ,38 ,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'槭',"6125",6 ,76 ,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'槠',"6126",6 ,114,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'槟',"6127",6 ,152,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'槛',"6128",6 ,190,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'槔',"6129",6 ,228,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'槐',"6130",6 ,266,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'槎',"6131",6 ,304,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'槌',"6132",6 ,342,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'槊',"6133",6 ,380,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'槁',"6134",6 ,418,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'榻',"6135",6 ,456,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'榷',"6136",6 ,494,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'榴',"6137",6 ,532,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'榱',"6138",6 ,570,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'榭',"6139",6 ,608,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'榫',"6140",6 ,646,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'榨',"6141",6 ,684,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'榧',"6142",6 ,722,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'榜',"6143",6 ,760,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'榛',"6144",6 ,798,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'榘',"6145",6 ,836,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'榕',"6146",6 ,874,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'榔',"6147",6 ,912,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'榍',"6148",6 ,950,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'榉',"6149",6 ,0  ,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'榈',"6150",6 ,38 ,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'榇',"6151",6 ,76 ,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'榆',"6152",6 ,114,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'榄',"6153",6 ,152,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'概',"6154",6 ,190,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'榀',"6155",6 ,228,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'楼',"6156",6 ,266,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'楹',"6157",6 ,304,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'楸',"6158",6 ,342,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'楷',"6159",6 ,380,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'楱',"6160",6 ,418,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'楮',"6161",6 ,456,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'楫',"6162",6 ,494,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'楦',"6163",6 ,532,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'楣',"6164",6 ,570,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'楠',"6165",6 ,608,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'楞',"6166",6 ,646,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'楝',"6167",6 ,684,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'楚',"6168",6 ,722,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'楗',"6169",6 ,760,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'楔',"6170",6 ,798,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'楂',"6171",6 ,836,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'椿',"6172",6 ,874,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'椽',"6173",6 ,912,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'椹',"6174",6 ,950,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'椴',"6175",6 ,0  ,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'椰',"6176",6 ,38 ,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'椭',"6177",6 ,76 ,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'椤',"6178",6 ,114,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'椠',"6179",6 ,152,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'椟',"6180",6 ,190,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'椒',"6181",6 ,228,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'椐',"6182",6 ,266,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'椎',"6183",6 ,304,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'植',"6184",6 ,342,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'椋',"6185",6 ,380,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'椅',"6186",6 ,418,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'椁',"6187",6 ,456,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'棼',"6188",6 ,494,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'棺',"6189",6 ,532,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'棹',"6190",6 ,570,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'棵',"6191",6 ,608,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'棱',"6192",6 ,646,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'棰',"6193",6 ,684,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'森',"6194",6 ,722,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'棣',"6195",6 ,760,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'棠',"6196",6 ,798,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'棚',"6197",6 ,836,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'棘',"6198",6 ,874,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'棕',"6199",6 ,912,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'棒',"6200",6 ,950,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'棍',"6201",6 ,0  ,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'棋',"6202",6 ,38 ,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'棉',"6203",6 ,76 ,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'棂',"6204",6 ,114,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'检',"6205",6 ,152,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'梵',"6206",6 ,190,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'梳',"6207",6 ,228,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'械',"6208",6 ,266,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'梯',"6209",6 ,304,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'梭',"6210",6 ,342,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'梨',"6211",6 ,380,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'梧',"6212",6 ,418,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'梦',"6213",6 ,456,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'梢',"6214",6 ,494,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'梗',"6215",6 ,532,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'梓',"6216",6 ,570,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'梏',"6217",6 ,608,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'梆',"6218",6 ,646,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'梅',"6219",6 ,684,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'梃',"6220",6 ,722,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'梁',"6221",6 ,760,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'桷',"6222",6 ,798,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'桶',"6223",6 ,836,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'桴',"6224",6 ,874,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'桫',"6225",6 ,912,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'桩',"6226",6 ,950,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'桨',"6227",6 ,0  ,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'桧',"6228",6 ,38 ,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'桦',"6229",6 ,76 ,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'桥',"6230",6 ,114,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'桤',"6231",6 ,152,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'档',"6232",6 ,190,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'桢',"6233",6 ,228,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'桡',"6234",6 ,266,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'桠',"6235",6 ,304,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'桕',"6236",6 ,342,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'桔',"6237",6 ,380,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'桓',"6238",6 ,418,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'桑',"6239",6 ,456,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'桐',"6240",6 ,494,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'桎',"6241",6 ,532,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'桌',"6242",6 ,570,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'桊',"6243",6 ,608,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'桉',"6244",6 ,646,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'案',"6245",6 ,684,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'框',"6246",6 ,722,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'桅',"6247",6 ,760,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'桄',"6248",6 ,798,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'桃',"6249",6 ,836,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'桂',"6250",6 ,874,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'桁',"6251",6 ,912,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-07",1024,'桀',"6252",6 ,950,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'秽',"6253",5 ,0  ,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'移',"6254",5 ,38 ,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'秸',"6255",5 ,76 ,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'称',"6256",5 ,114,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'积',"6257",5 ,152,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'秭',"6258",5 ,190,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'秫',"6259",5 ,228,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'秩',"6260",5 ,266,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'秧',"6261",5 ,304,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'秦',"6262",5 ,342,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'秤',"6263",5 ,380,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'秣',"6264",5 ,418,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'租',"6265",5 ,456,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'秘',"6266",5 ,494,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'秕',"6267",5 ,532,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'秒',"6268",5 ,570,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'科',"6269",5 ,608,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'种',"6270",5 ,646,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'秋',"6271",5 ,684,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'秉',"6272",5 ,722,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'秆',"6273",5 ,760,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'秃',"6274",5 ,798,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'私',"6275",5 ,836,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'秀',"6276",5 ,874,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'禾',"6277",5 ,912,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'禽',"6278",5 ,950,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'离',"6279",5 ,0  ,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'禺',"6280",5 ,38 ,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'禹',"6281",5 ,76 ,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'禳',"6282",5 ,114,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'禧',"6283",5 ,152,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'禚',"6284",5 ,190,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'福',"6285",5 ,228,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'禊',"6286",5 ,266,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'禅',"6287",5 ,304,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'禄',"6288",5 ,342,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'禁',"6289",5 ,380,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'禀',"6290",5 ,418,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'祺',"6291",5 ,456,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'祸',"6292",5 ,494,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'祷',"6293",5 ,532,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'祯',"6294",5 ,570,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'祭',"6295",5 ,608,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'票',"6296",5 ,646,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'祧',"6297",5 ,684,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'祥',"6298",5 ,722,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'祢',"6299",5 ,760,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'祠',"6300",5 ,798,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'祟',"6301",5 ,836,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'神',"6302",5 ,874,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'祝',"6303",5 ,912,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'祜',"6304",5 ,950,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'祛',"6305",5 ,0  ,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'祚',"6306",5 ,38 ,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'祗',"6307",5 ,76 ,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'祖',"6308",5 ,114,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'祓',"6309",5 ,152,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'祉',"6310",5 ,190,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'祈',"6311",5 ,228,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'祆',"6312",5 ,266,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'祁',"6313",5 ,304,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'祀',"6314",5 ,342,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'社',"6315",5 ,380,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'礼',"6316",5 ,418,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'礻',"6317",5 ,456,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'示',"6318",5 ,494,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'礴',"6319",5 ,532,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'礤',"6320",5 ,570,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'礞',"6321",5 ,608,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'礓',"6322",5 ,646,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'礅',"6323",5 ,684,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'礁',"6324",5 ,722,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'磺',"6325",5 ,760,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'磷',"6326",5 ,798,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'磴',"6327",5 ,836,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'磲',"6328",5 ,874,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'磬',"6329",5 ,912,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'磨',"6330",5 ,950,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'磙',"6331",5 ,0  ,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'磕',"6332",5 ,38 ,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'磔',"6333",5 ,76 ,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'磐',"6334",5 ,114,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'磋',"6335",5 ,152,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'磊',"6336",5 ,190,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'磉',"6337",5 ,228,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'磅',"6338",5 ,266,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'磁',"6339",5 ,304,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'碾',"6340",5 ,342,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'碹',"6341",5 ,380,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'碴',"6342",5 ,418,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'碳',"6343",5 ,456,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'碲',"6344",5 ,494,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'碱',"6345",5 ,532,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'碰',"6346",5 ,570,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'碧',"6347",5 ,608,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'碥',"6348",5 ,646,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'碣',"6349",5 ,684,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'碡',"6350",5 ,722,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'碟',"6351",5 ,760,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'碜',"6352",5 ,798,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'碛',"6353",5 ,836,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'碚',"6354",5 ,874,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'碘',"6355",5 ,912,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'碗',"6356",5 ,950,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'碓',"6357",5 ,0  ,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'碑',"6358",5 ,38 ,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'碎',"6359",5 ,76 ,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'碍',"6360",5 ,114,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'碌',"6361",5 ,152,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'碉',"6362",5 ,190,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'碇',"6363",5 ,228,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'硼',"6364",5 ,266,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'硷',"6365",5 ,304,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'确',"6366",5 ,342,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'硭',"6367",5 ,380,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'硬',"6368",5 ,418,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'硫',"6369",5 ,456,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'硪',"6370",5 ,494,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'硝',"6371",5 ,532,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'硗',"6372",5 ,570,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'硖',"6373",5 ,608,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'硕',"6374",5 ,646,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'硒',"6375",5 ,684,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'硐',"6376",5 ,722,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'硎',"6377",5 ,760,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'硌',"6378",5 ,798,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'硇',"6379",5 ,836,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'硅',"6380",5 ,874,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'础',"6381",5 ,912,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'砾',"6382",5 ,950,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'砼',"6383",5 ,0  ,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'砻',"6384",5 ,38 ,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'砺',"6385",5 ,76 ,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'砹',"6386",5 ,114,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'砸',"6387",5 ,152,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'砷',"6388",5 ,190,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'破',"6389",5 ,228,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'砰',"6390",5 ,266,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'砭',"6391",5 ,304,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'砬',"6392",5 ,342,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'砩',"6393",5 ,380,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'砧',"6394",5 ,418,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'砦',"6395",5 ,456,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'砥',"6396",5 ,494,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'砣',"6397",5 ,532,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'砟',"6398",5 ,570,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'砝',"6399",5 ,608,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'砜',"6400",5 ,646,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'砚',"6401",5 ,684,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'砘',"6402",5 ,722,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'砗',"6403",5 ,760,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'砖',"6404",5 ,798,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'研',"6405",5 ,836,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'砒',"6406",5 ,874,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'砑',"6407",5 ,912,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'砍',"6408",5 ,950,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'砌',"6409",5 ,0  ,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'砉',"6410",5 ,38 ,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'砂',"6411",5 ,76 ,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'码',"6412",5 ,114,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'砀',"6413",5 ,152,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'矿',"6414",5 ,190,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'矾',"6415",5 ,228,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'矽',"6416",5 ,266,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'矸',"6417",5 ,304,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'矶',"6418",5 ,342,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'石',"6419",5 ,380,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'矮',"6420",5 ,418,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'短',"6421",5 ,456,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'矬',"6422",5 ,494,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'矫',"6423",5 ,532,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'矩',"6424",5 ,570,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'矧',"6425",5 ,608,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'知',"6426",5 ,646,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'矣',"6427",5 ,684,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'矢',"6428",5 ,722,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'矜',"6429",5 ,760,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'矛',"6430",5 ,798,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'矗',"6431",5 ,836,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'矍',"6432",5 ,874,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瞿',"6433",5 ,912,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瞽',"6434",5 ,950,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瞻',"6435",5 ,0  ,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瞵',"6436",5 ,38 ,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瞳',"6437",5 ,76 ,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瞰',"6438",5 ,114,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瞬',"6439",5 ,152,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瞪',"6440",5 ,190,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瞩',"6441",5 ,228,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瞧',"6442",5 ,266,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瞥',"6443",5 ,304,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瞢',"6444",5 ,342,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瞠',"6445",5 ,380,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瞟',"6446",5 ,418,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瞒',"6447",5 ,456,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瞑',"6448",5 ,494,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瞎',"6449",5 ,532,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瞍',"6450",5 ,570,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瞌',"6451",5 ,608,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瞅',"6452",5 ,646,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瞄',"6453",5 ,684,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瞀',"6454",5 ,722,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'睿',"6455",5 ,760,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'睾',"6456",5 ,798,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'睽',"6457",5 ,836,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'睹',"6458",5 ,874,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'睬',"6459",5 ,912,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'睫',"6460",5 ,950,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'睨',"6461",5 ,0  ,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'睦',"6462",5 ,38 ,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'睥',"6463",5 ,76 ,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'督',"6464",5 ,114,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'睢',"6465",5 ,152,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'睡',"6466",5 ,190,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'睛',"6467",5 ,228,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'睚',"6468",5 ,266,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'睑',"6469",5 ,304,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'睐',"6470",5 ,342,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'睇',"6471",5 ,380,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'睃',"6472",5 ,418,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'睁',"6473",5 ,456,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'着',"6474",5 ,494,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'眼',"6475",5 ,532,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'眺',"6476",5 ,570,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'眸',"6477",5 ,608,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'眷',"6478",5 ,646,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'眶',"6479",5 ,684,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'眵',"6480",5 ,722,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'眯',"6481",5 ,760,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'眭',"6482",5 ,798,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'眩',"6483",5 ,836,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'眨',"6484",5 ,874,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'眦',"6485",5 ,912,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'眢',"6486",5 ,950,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'眠',"6487",5 ,0  ,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'真',"6488",5 ,38 ,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'眚',"6489",5 ,76 ,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'眙',"6490",5 ,114,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'眍',"6491",5 ,152,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'看',"6492",5 ,190,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'眉',"6493",5 ,228,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'眈',"6494",5 ,266,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'眇',"6495",5 ,304,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'眄',"6496",5 ,342,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'省',"6497",5 ,380,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'盾',"6498",5 ,418,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'盼',"6499",5 ,456,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'盹',"6500",5 ,494,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'相',"6501",5 ,532,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'直',"6502",5 ,570,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'盲',"6503",5 ,608,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'盱',"6504",5 ,646,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'盯',"6505",5 ,684,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'目',"6506",5 ,722,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'盥',"6507",5 ,760,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'盟',"6508",5 ,798,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'盛',"6509",5 ,836,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'盘',"6510",5 ,874,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'盗',"6511",5 ,912,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'盖',"6512",5 ,950,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'盔',"6513",5 ,0  ,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'盒',"6514",5 ,38 ,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'监',"6515",5 ,76 ,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'盐',"6516",5 ,114,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'盏',"6517",5 ,152,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'盎',"6518",5 ,190,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'盍',"6519",5 ,228,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'益',"6520",5 ,266,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'盈',"6521",5 ,304,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'盆',"6522",5 ,342,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'盅',"6523",5 ,380,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'盂',"6524",5 ,418,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'皿',"6525",5 ,456,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'皴',"6526",5 ,494,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'皲',"6527",5 ,532,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'皱',"6528",5 ,570,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'皮',"6529",5 ,608,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'皤',"6530",5 ,646,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'皙',"6531",5 ,684,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'皖',"6532",5 ,722,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'皓',"6533",5 ,760,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'皑',"6534",5 ,798,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'皎',"6535",5 ,836,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'皋',"6536",5 ,874,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'皈',"6537",5 ,912,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'皇',"6538",5 ,950,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'皆',"6539",5 ,0  ,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'的',"6540",5 ,38 ,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'皂',"6541",5 ,76 ,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'百',"6542",5 ,114,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'白',"6543",5 ,152,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'登',"6544",5 ,190,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'癸',"6545",5 ,228,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'癯',"6546",5 ,266,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'癫',"6547",5 ,304,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'癣',"6548",5 ,342,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'癞',"6549",5 ,380,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'癜',"6550",5 ,418,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'癖',"6551",5 ,456,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'癔',"6552",5 ,494,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'癍',"6553",5 ,532,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'癌',"6554",5 ,570,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'癃',"6555",5 ,608,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'癀',"6556",5 ,646,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瘿',"6557",5 ,684,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瘾',"6558",5 ,722,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瘼',"6559",5 ,760,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瘸',"6560",5 ,798,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瘵',"6561",5 ,836,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瘴',"6562",5 ,874,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瘳',"6563",5 ,912,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瘰',"6564",5 ,950,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瘭',"6565",5 ,0  ,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瘫',"6566",5 ,38 ,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瘪',"6567",5 ,76 ,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瘩',"6568",5 ,114,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瘦',"6569",5 ,152,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瘥',"6570",5 ,190,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瘤',"6571",5 ,228,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瘢',"6572",5 ,266,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瘠',"6573",5 ,304,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瘟',"6574",5 ,342,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瘛',"6575",5 ,380,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瘙',"6576",5 ,418,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瘘',"6577",5 ,456,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瘗',"6578",5 ,494,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瘕',"6579",5 ,532,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瘐',"6580",5 ,570,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瘌',"6581",5 ,608,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瘊',"6582",5 ,646,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瘅',"6583",5 ,684,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瘃',"6584",5 ,722,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瘁',"6585",5 ,760,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瘀',"6586",5 ,798,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'痿',"6587",5 ,836,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'痼',"6588",5 ,874,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'痹',"6589",5 ,912,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'痴',"6590",5 ,950,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'痱',"6591",5 ,0  ,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'痰',"6592",5 ,38 ,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'痫',"6593",5 ,76 ,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'痪',"6594",5 ,114,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'痨',"6595",5 ,152,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'痧',"6596",5 ,190,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'痦',"6597",5 ,228,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'痤',"6598",5 ,266,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'痣',"6599",5 ,304,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'痢',"6600",5 ,342,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'痞',"6601",5 ,380,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'痛',"6602",5 ,418,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'痘',"6603",5 ,456,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'痖',"6604",5 ,494,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'痕',"6605",5 ,532,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'痔',"6606",5 ,570,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'痒',"6607",5 ,608,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'痍',"6608",5 ,646,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'痊',"6609",5 ,684,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'痉',"6610",5 ,722,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'痈',"6611",5 ,760,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'症',"6612",5 ,798,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'病',"6613",5 ,836,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'痄',"6614",5 ,874,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'痃',"6615",5 ,912,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'痂',"6616",5 ,950,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'疾',"6617",5 ,0  ,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'疽',"6618",5 ,38 ,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'疼',"6619",5 ,76 ,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'疹',"6620",5 ,114,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'疸',"6621",5 ,152,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'疵',"6622",5 ,190,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'疴',"6623",5 ,228,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'疳',"6624",5 ,266,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'疲',"6625",5 ,304,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'疱',"6626",5 ,342,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'疰',"6627",5 ,380,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'疯',"6628",5 ,418,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'疮',"6629",5 ,456,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'疬',"6630",5 ,494,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'疫',"6631",5 ,532,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'疥',"6632",5 ,570,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'疤',"6633",5 ,608,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'疣',"6634",5 ,646,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'疡',"6635",5 ,684,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'疠',"6636",5 ,722,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'疟',"6637",5 ,760,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'疝',"6638",5 ,798,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'疚',"6639",5 ,836,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'疙',"6640",5 ,874,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'疗',"6641",5 ,912,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'疖',"6642",5 ,950,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'疔',"6643",5 ,0  ,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'疒',"6644",5 ,38 ,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'疑',"6645",5 ,76 ,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'疏',"6646",5 ,114,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'疋',"6647",5 ,152,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'疆',"6648",5 ,190,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'疃',"6649",5 ,228,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'畿',"6650",5 ,266,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'畹',"6651",5 ,304,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'畸',"6652",5 ,342,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'畴',"6653",5 ,380,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'畲',"6654",5 ,418,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'番',"6655",5 ,456,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'畦',"6656",5 ,494,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'略',"6657",5 ,532,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'畜',"6658",5 ,570,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'畛',"6659",5 ,608,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'畚',"6660",5 ,646,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'留',"6661",5 ,684,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'畔',"6662",5 ,722,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'畏',"6663",5 ,760,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'畎',"6664",5 ,798,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'界',"6665",5 ,836,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'畋',"6666",5 ,874,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'畈',"6667",5 ,912,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'畅',"6668",5 ,950,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'畀',"6669",5 ,0  ,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'甾',"6670",5 ,38 ,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'画',"6671",5 ,76 ,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'町',"6672",5 ,114,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'甸',"6673",5 ,152,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'男',"6674",5 ,190,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'电',"6675",5 ,228,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'申',"6676",5 ,266,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'甲',"6677",5 ,304,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'由',"6678",5 ,342,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'田',"6679",5 ,380,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'甯',"6680",5 ,418,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'甭',"6681",5 ,456,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'甬',"6682",5 ,494,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'甫',"6683",5 ,532,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'甩',"6684",5 ,570,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'用',"6685",5 ,608,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'甥',"6686",5 ,646,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'生',"6687",5 ,684,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'甜',"6688",5 ,722,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'甚',"6689",5 ,760,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'甙',"6690",5 ,798,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'甘',"6691",5 ,836,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'甓',"6692",5 ,874,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'甑',"6693",5 ,912,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'甏',"6694",5 ,950,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'甍',"6695",5 ,0  ,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'甄',"6696",5 ,38 ,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瓿',"6697",5 ,76 ,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瓷',"6698",5 ,114,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瓶',"6699",5 ,152,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瓴',"6700",5 ,190,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瓯',"6701",5 ,228,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瓮',"6702",5 ,266,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瓦',"6703",5 ,304,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瓤',"6704",5 ,342,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瓣',"6705",5 ,380,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瓢',"6706",5 ,418,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瓠',"6707",5 ,456,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瓞',"6708",5 ,494,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瓜',"6709",5 ,532,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瓒',"6710",5 ,570,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'璺',"6711",5 ,608,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'璩',"6712",5 ,646,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'璨',"6713",5 ,684,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'璧',"6714",5 ,722,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'璞',"6715",5 ,760,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'璜',"6716",5 ,798,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'璐',"6717",5 ,836,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'璎',"6718",5 ,874,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'璋',"6719",5 ,912,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'璇',"6720",5 ,950,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'璃',"6721",5 ,0  ,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'璁',"6722",5 ,38 ,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'璀',"6723",5 ,76 ,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瑾',"6724",5 ,114,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瑷',"6725",5 ,152,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瑶',"6726",5 ,190,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瑰',"6727",5 ,228,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瑭',"6728",5 ,266,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瑟',"6729",5 ,304,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瑞',"6730",5 ,342,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瑜',"6731",5 ,380,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瑛',"6732",5 ,418,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瑚',"6733",5 ,456,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瑙',"6734",5 ,494,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瑗',"6735",5 ,532,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瑕',"6736",5 ,570,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'瑁',"6737",5 ,608,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'琼',"6738",5 ,646,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'琶',"6739",5 ,684,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'琵',"6740",5 ,722,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'琴',"6741",5 ,760,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'琳',"6742",5 ,798,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'琰',"6743",5 ,836,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'琮',"6744",5 ,874,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'琬',"6745",5 ,912,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'琪',"6746",5 ,950,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'琨',"6747",5 ,0  ,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'琦',"6748",5 ,38 ,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'琥',"6749",5 ,76 ,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'琢',"6750",5 ,114,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'琛',"6751",5 ,152,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'琚',"6752",5 ,190,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'琐',"6753",5 ,228,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'琏',"6754",5 ,266,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'琊',"6755",5 ,304,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'琉',"6756",5 ,342,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'理',"6757",5 ,380,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'琅',"6758",5 ,418,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'球',"6759",5 ,456,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'珲',"6760",5 ,494,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'班',"6761",5 ,532,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'珩',"6762",5 ,570,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'珧',"6763",5 ,608,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'珥',"6764",5 ,646,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'珠',"6765",5 ,684,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'珞',"6766",5 ,722,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'珙',"6767",5 ,760,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'珑',"6768",5 ,798,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'珐',"6769",5 ,836,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'珏',"6770",5 ,874,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'珍',"6771",5 ,912,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'珊',"6772",5 ,950,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'珉',"6773",5 ,0  ,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'珈',"6774",5 ,38 ,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'珂',"6775",5 ,76 ,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'珀',"6776",5 ,114,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'玻',"6777",5 ,152,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'玺',"6778",5 ,190,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'玷',"6779",5 ,228,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'玳',"6780",5 ,266,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'玲',"6781",5 ,304,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'现',"6782",5 ,342,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'环',"6783",5 ,380,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'玮',"6784",5 ,418,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'玫',"6785",5 ,456,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'玩',"6786",5 ,494,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'玢',"6787",5 ,532,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'玟',"6788",5 ,570,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'玛',"6789",5 ,608,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'玖',"6790",5 ,646,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'玑',"6791",5 ,684,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'玎',"6792",5 ,722,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'王',"6793",5 ,760,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'玉',"6794",5 ,798,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'率',"6795",5 ,836,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'玄',"6796",5 ,874,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'獾',"6797",5 ,912,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'獯',"6798",5 ,950,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'獭',"6799",5 ,0  ,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'獬',"6800",5 ,38 ,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'獠',"6801",5 ,76 ,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'獗',"6802",5 ,114,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'獒',"6803",5 ,152,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'獐',"6804",5 ,190,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'獍',"6805",5 ,228,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'猿',"6806",5 ,266,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'猾',"6807",5 ,304,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'猹',"6808",5 ,342,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'猸',"6809",5 ,380,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'猷',"6810",5 ,418,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'猴',"6811",5 ,456,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'猱',"6812",5 ,494,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'献',"6813",5 ,532,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'猬',"6814",5 ,570,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'猫',"6815",5 ,608,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'猪',"6816",5 ,646,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'猩',"6817",5 ,684,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'猥',"6818",5 ,722,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'猢',"6819",5 ,760,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'猡',"6820",5 ,798,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'猞',"6821",5 ,836,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'猝',"6822",5 ,874,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'猜',"6823",5 ,912,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'猛',"6824",5 ,950,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'猗',"6825",5 ,0  ,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'猖',"6826",5 ,38 ,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'猕',"6827",5 ,76 ,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'猓',"6828",5 ,114,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'猎',"6829",5 ,152,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'猊',"6830",5 ,190,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'猃',"6831",5 ,228,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'猁',"6832",5 ,266,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'狼',"6833",5 ,304,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'狻',"6834",5 ,342,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'狺',"6835",5 ,380,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'狸',"6836",5 ,418,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'狷',"6837",5 ,456,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'狴',"6838",5 ,494,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'狳',"6839",5 ,532,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'狲',"6840",5 ,570,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'狱',"6841",5 ,608,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'狰',"6842",5 ,646,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'狯',"6843",5 ,684,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'狮',"6844",5 ,722,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'狭',"6845",5 ,760,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'独',"6846",5 ,798,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'狩',"6847",5 ,836,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'狨',"6848",5 ,874,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'狡',"6849",5 ,912,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'狠',"6850",5 ,950,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'狞',"6851",5 ,0  ,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'狙',"6852",5 ,38 ,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'狗',"6853",5 ,76 ,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'狒',"6854",5 ,114,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'狐',"6855",5 ,152,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'狎',"6856",5 ,190,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'狍',"6857",5 ,228,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'狈',"6858",5 ,266,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'狄',"6859",5 ,304,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'狃',"6860",5 ,342,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'狂',"6861",5 ,380,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'狁',"6862",5 ,418,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'犹',"6863",5 ,456,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'犸',"6864",5 ,494,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'犷',"6865",5 ,532,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'状',"6866",5 ,570,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'犴',"6867",5 ,608,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'犰',"6868",5 ,646,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'犯',"6869",5 ,684,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'犭',"6870",5 ,722,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'犬',"6871",5 ,760,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'犟',"6872",5 ,798,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'犒',"6873",5 ,836,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'犏',"6874",5 ,874,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'犍',"6875",5 ,912,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'犋',"6876",5 ,950,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'犊',"6877",5 ,0  ,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'犄',"6878",5 ,38 ,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'犁',"6879",5 ,76 ,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'犀',"6880",5 ,114,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'牿',"6881",5 ,152,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'牾',"6882",5 ,190,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'牺',"6883",5 ,228,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'特',"6884",5 ,266,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'牵',"6885",5 ,304,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'牲',"6886",5 ,342,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'牯',"6887",5 ,380,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'牮',"6888",5 ,418,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'物',"6889",5 ,456,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'牧',"6890",5 ,494,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'牦',"6891",5 ,532,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'牢',"6892",5 ,570,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'牡',"6893",5 ,608,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'牟',"6894",5 ,646,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'牝',"6895",5 ,684,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'牛',"6896",5 ,722,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'牙',"6897",5 ,760,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'牖',"6898",5 ,798,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'牒',"6899",5 ,836,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'牍',"6900",5 ,874,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'牌',"6901",5 ,912,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'版',"6902",5 ,950,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'片',"6903",5 ,0  ,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'爿',"6904",5 ,38 ,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'爽',"6905",5 ,76 ,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'爻',"6906",5 ,114,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'爹',"6907",5 ,152,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'爸',"6908",5 ,190,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'爷',"6909",5 ,228,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'父',"6910",5 ,266,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'爵',"6911",5 ,304,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'爱',"6912",5 ,342,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'爰',"6913",5 ,380,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'爬',"6914",5 ,418,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'爪',"6915",5 ,456,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'爨',"6916",5 ,494,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'爝',"6917",5 ,532,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'爆',"6918",5 ,570,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'燹',"6919",5 ,608,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'燮',"6920",5 ,646,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'燧',"6921",5 ,684,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'燥',"6922",5 ,722,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'燠',"6923",5 ,760,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'燕',"6924",5 ,798,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'燔',"6925",5 ,836,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'燎',"6926",5 ,874,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'燃',"6927",5 ,912,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'熹',"6928",5 ,950,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'熵',"6929",5 ,0  ,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'熳',"6930",5 ,38 ,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'熬',"6931",5 ,76 ,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'熨',"6932",5 ,114,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'熠',"6933",5 ,152,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'熟',"6934",5 ,190,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'熙',"6935",5 ,228,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'熘',"6936",5 ,266,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'熔',"6937",5 ,304,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'熏',"6938",5 ,342,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'熊',"6939",5 ,380,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'熄',"6940",5 ,418,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'煽',"6941",5 ,456,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'煺',"6942",5 ,494,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'煸',"6943",5 ,532,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'煳',"6944",5 ,570,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'煲',"6945",5 ,608,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'煮',"6946",5 ,646,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'煨',"6947",5 ,684,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'照',"6948",5 ,722,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'煦',"6949",5 ,760,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'煤',"6950",5 ,798,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'煞',"6951",5 ,836,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'煜',"6952",5 ,874,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'煎',"6953",5 ,912,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-06",1024,'煌',"6954",5 ,950,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'艹',"6955",4 ,0  ,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'艴',"6956",4 ,38 ,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'艳',"6957",4 ,76 ,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'色',"6958",4 ,114,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'艰',"6959",4 ,152,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'良',"6960",4 ,190,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'艮',"6961",4 ,228,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'艨',"6962",4 ,266,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'艟',"6963",4 ,304,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'艚',"6964",4 ,342,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'艘',"6965",4 ,380,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'艏',"6966",4 ,418,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'艋',"6967",4 ,456,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'艉',"6968",4 ,494,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'艇',"6969",4 ,532,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'艄',"6970",4 ,570,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'舾',"6971",4 ,608,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'舻',"6972",4 ,646,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'船',"6973",4 ,684,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'舸',"6974",4 ,722,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'舷',"6975",4 ,760,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'舶',"6976",4 ,798,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'舵',"6977",4 ,836,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'舴',"6978",4 ,874,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'舳',"6979",4 ,912,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'舱',"6980",4 ,950,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'舰',"6981",4 ,0  ,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'舯',"6982",4 ,38 ,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'舭',"6983",4 ,76 ,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'般',"6984",4 ,114,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'舫',"6985",4 ,152,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'航',"6986",4 ,190,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'舨',"6987",4 ,228,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'舣',"6988",4 ,266,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'舢',"6989",4 ,304,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'舡',"6990",4 ,342,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'舟',"6991",4 ,380,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'舞',"6992",4 ,418,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'舜',"6993",4 ,456,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'舛',"6994",4 ,494,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'舔',"6995",4 ,532,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'舒',"6996",4 ,570,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'舐',"6997",4 ,608,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'舍',"6998",4 ,646,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'舌',"6999",4 ,684,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'舆',"7000",4 ,722,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'舅',"7001",4 ,760,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'舄',"7002",4 ,798,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'舂',"7003",4 ,836,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'舁',"7004",4 ,874,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'舀',"7005",4 ,912,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'臾',"7006",4 ,950,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'臼',"7007",4 ,0  ,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'臻',"7008",4 ,38 ,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'致',"7009",4 ,76 ,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'至',"7010",4 ,114,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'臭',"7011",4 ,152,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'臬',"7012",4 ,190,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'自',"7013",4 ,228,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'臧',"7014",4 ,266,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'臣',"7015",4 ,304,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'臌',"7016",4 ,342,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'臊',"7017",4 ,380,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'臆',"7018",4 ,418,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'臃',"7019",4 ,456,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'臂',"7020",4 ,494,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'臁',"7021",4 ,532,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'臀',"7022",4 ,570,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'膻',"7023",4 ,608,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'膺',"7024",4 ,646,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'膳',"7025",4 ,684,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'膪',"7026",4 ,722,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'膨',"7027",4 ,760,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'膦',"7028",4 ,798,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'膣',"7029",4 ,836,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'膝',"7030",4 ,874,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'膜',"7031",4 ,912,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'膛',"7032",4 ,950,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'膘',"7033",4 ,0  ,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'膑',"7034",4 ,38 ,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'膏',"7035",4 ,76 ,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'膊',"7036",4 ,114,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'膈',"7037",4 ,152,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'膂',"7038",4 ,190,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'膀',"7039",4 ,228,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'腿',"7040",4 ,266,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'腾',"7041",4 ,304,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'腽',"7042",4 ,342,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'腼',"7043",4 ,380,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'腻',"7044",4 ,418,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'腺',"7045",4 ,456,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'腹',"7046",4 ,494,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'腴',"7047",4 ,532,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'腱',"7048",4 ,570,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'腰',"7049",4 ,608,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'腮',"7050",4 ,646,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'腭',"7051",4 ,684,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'腩',"7052",4 ,722,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'腧',"7053",4 ,760,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'腥',"7054",4 ,798,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'腠',"7055",4 ,836,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'腚',"7056",4 ,874,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'腙',"7057",4 ,912,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'腕',"7058",4 ,950,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'腔',"7059",4 ,0  ,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'腓',"7060",4 ,38 ,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'腑',"7061",4 ,76 ,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'腐',"7062",4 ,114,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'腌',"7063",4 ,152,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'腋',"7064",4 ,190,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'腊',"7065",4 ,228,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'腈',"7066",4 ,266,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'腆',"7067",4 ,304,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'脾',"7068",4 ,342,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'脸',"7069",4 ,380,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'脶',"7070",4 ,418,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'脲',"7071",4 ,456,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'脱',"7072",4 ,494,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'脯',"7073",4 ,532,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'脬',"7074",4 ,570,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'脞',"7075",4 ,608,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'脚',"7076",4 ,646,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'脘',"7077",4 ,684,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'脖',"7078",4 ,722,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'脔',"7079",4 ,760,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'脓',"7080",4 ,798,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'脒',"7081",4 ,836,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'脑',"7082",4 ,874,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'脐',"7083",4 ,912,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'脏',"7084",4 ,950,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'脎',"7085",4 ,0  ,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'脍',"7086",4 ,38 ,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'脊',"7087",4 ,76 ,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'脉',"7088",4 ,114,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'脆',"7089",4 ,152,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'脂',"7090",4 ,190,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'能',"7091",4 ,228,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'胼',"7092",4 ,266,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'胺',"7093",4 ,304,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'胸',"7094",4 ,342,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'胶',"7095",4 ,380,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'胴',"7096",4 ,418,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'胳',"7097",4 ,456,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'胲',"7098",4 ,494,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'胱',"7099",4 ,532,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'胰',"7100",4 ,570,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'胯',"7101",4 ,608,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'胭',"7102",4 ,646,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'胬',"7103",4 ,684,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'胫',"7104",4 ,722,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'胪',"7105",4 ,760,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'胩',"7106",4 ,798,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'胨',"7107",4 ,836,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'胧',"7108",4 ,874,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'胥',"7109",4 ,912,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'胤',"7110",4 ,950,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'胡',"7111",4 ,0  ,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'胞',"7112",4 ,38 ,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'胝',"7113",4 ,76 ,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'胜',"7114",4 ,114,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'胛',"7115",4 ,152,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'胚',"7116",4 ,190,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'胙',"7117",4 ,228,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'胗',"7118",4 ,266,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'胖',"7119",4 ,304,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'胎',"7120",4 ,342,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'胍',"7121",4 ,380,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'背',"7122",4 ,418,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'胆',"7123",4 ,456,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'胄',"7124",4 ,494,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'胃',"7125",4 ,532,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'胂',"7126",4 ,570,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'胁',"7127",4 ,608,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'胀',"7128",4 ,646,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'肿',"7129",4 ,684,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'肾',"7130",4 ,722,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'肽',"7131",4 ,760,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'肼',"7132",4 ,798,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'肺',"7133",4 ,836,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'肷',"7134",4 ,874,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'肴',"7135",4 ,912,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'育',"7136",4 ,950,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'肱',"7137",4 ,0  ,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'肯',"7138",4 ,38 ,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'肮',"7139",4 ,76 ,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'肭',"7140",4 ,114,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'肫',"7141",4 ,152,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'肪',"7142",4 ,190,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'肩',"7143",4 ,228,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'肥',"7144",4 ,266,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'肤',"7145",4 ,304,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'肢',"7146",4 ,342,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'股',"7147",4 ,380,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'肠',"7148",4 ,418,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'肟',"7149",4 ,456,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'肝',"7150",4 ,494,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'肜',"7151",4 ,532,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'肛',"7152",4 ,570,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'肚',"7153",4 ,608,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'肘',"7154",4 ,646,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'肖',"7155",4 ,684,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'肓',"7156",4 ,722,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'肌',"7157",4 ,760,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'肋',"7158",4 ,798,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'肉',"7159",4 ,836,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'肇',"7160",4 ,874,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'肆',"7161",4 ,912,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'肄',"7162",4 ,950,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'肃',"7163",4 ,0  ,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'肀',"7164",4 ,38 ,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'聿',"7165",4 ,76 ,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'聱',"7166",4 ,114,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'聪',"7167",4 ,152,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'聩',"7168",4 ,190,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'聚',"7169",4 ,228,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'聘',"7170",4 ,266,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'联',"7171",4 ,304,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'聒',"7172",4 ,342,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'聍',"7173",4 ,380,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'职',"7174",4 ,418,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'聋',"7175",4 ,456,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'聊',"7176",4 ,494,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'聆',"7177",4 ,532,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'聃',"7178",4 ,570,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'聂',"7179",4 ,608,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'耿',"7180",4 ,646,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'耽',"7181",4 ,684,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'耻',"7182",4 ,722,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'耸',"7183",4 ,760,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'耷',"7184",4 ,798,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'耶',"7185",4 ,836,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'耵',"7186",4 ,874,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'耳',"7187",4 ,912,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'耱',"7188",4 ,950,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'耪',"7189",4 ,0  ,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'耩',"7190",4 ,38 ,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'耨',"7191",4 ,76 ,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'耧',"7192",4 ,114,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'耦',"7193",4 ,152,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'耥',"7194",4 ,190,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'耢',"7195",4 ,228,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'耠',"7196",4 ,266,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'耜',"7197",4 ,304,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'耙',"7198",4 ,342,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'耘',"7199",4 ,380,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'耗',"7200",4 ,418,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'耖',"7201",4 ,456,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'耕',"7202",4 ,494,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'耔',"7203",4 ,532,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'耒',"7204",4 ,570,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'耐',"7205",4 ,608,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'耍',"7206",4 ,646,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'而',"7207",4 ,684,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'耋',"7208",4 ,722,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'耆',"7209",4 ,760,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'者',"7210",4 ,798,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'耄',"7211",4 ,836,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'考',"7212",4 ,874,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'老',"7213",4 ,912,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'耀',"7214",4 ,950,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'翼',"7215",4 ,0  ,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'翻',"7216",4 ,38 ,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'翳',"7217",4 ,76 ,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'翱',"7218",4 ,114,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'翰',"7219",4 ,152,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'翮',"7220",4 ,190,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'翩',"7221",4 ,228,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'翦',"7222",4 ,266,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'翥',"7223",4 ,304,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'翡',"7224",4 ,342,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'翠',"7225",4 ,380,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'翟',"7226",4 ,418,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'翘',"7227",4 ,456,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'翕',"7228",4 ,494,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'翔',"7229",4 ,532,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'翎',"7230",4 ,570,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'翌',"7231",4 ,608,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'翊',"7232",4 ,646,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'翅',"7233",4 ,684,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'翁',"7234",4 ,722,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'羿',"7235",4 ,760,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'羽',"7236",4 ,798,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'羼',"7237",4 ,836,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'羹',"7238",4 ,874,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'羸',"7239",4 ,912,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'羲',"7240",4 ,950,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'羰',"7241",4 ,0  ,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'羯',"7242",4 ,38 ,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'羧',"7243",4 ,76 ,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'群',"7244",4 ,114,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'羡',"7245",4 ,152,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'羟',"7246",4 ,190,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'羞',"7247",4 ,228,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'羝',"7248",4 ,266,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'羚',"7249",4 ,304,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'羔',"7250",4 ,342,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'美',"7251",4 ,380,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'羌',"7252",4 ,418,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'羊',"7253",4 ,456,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'羁',"7254",4 ,494,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'罾',"7255",4 ,532,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'罹',"7256",4 ,570,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'罴',"7257",4 ,608,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'署',"7258",4 ,646,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'罱',"7259",4 ,684,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'置',"7260",4 ,722,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'罪',"7261",4 ,760,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'罩',"7262",4 ,798,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'罨',"7263",4 ,836,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'罢',"7264",4 ,874,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'罡',"7265",4 ,912,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'罟',"7266",4 ,950,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'罚',"7267",4 ,0  ,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'罘',"7268",4 ,38 ,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'罗',"7269",4 ,76 ,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'罕',"7270",4 ,114,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'罔',"7271",4 ,152,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'网',"7272",4 ,190,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'罐',"7273",4 ,228,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'罅',"7274",4 ,266,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'罄',"7275",4 ,304,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'罂',"7276",4 ,342,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'缺',"7277",4 ,380,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'缸',"7278",4 ,418,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'缶',"7279",4 ,456,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'缵',"7280",4 ,494,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'缴',"7281",4 ,532,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'缳',"7282",4 ,570,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'缲',"7283",4 ,608,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'缱',"7284",4 ,646,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'缰',"7285",4 ,684,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'缯',"7286",4 ,722,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'缮',"7287",4 ,760,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'缭',"7288",4 ,798,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'缬',"7289",4 ,836,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'缫',"7290",4 ,874,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'缪',"7291",4 ,912,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'缩',"7292",4 ,950,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'缨',"7293",4 ,0  ,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'缧',"7294",4 ,38 ,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'缦',"7295",4 ,76 ,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'缥',"7296",4 ,114,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'缤',"7297",4 ,152,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'缣',"7298",4 ,190,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'缢',"7299",4 ,228,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'缡',"7300",4 ,266,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'缠',"7301",4 ,304,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'缟',"7302",4 ,342,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'缝',"7303",4 ,380,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'缜',"7304",4 ,418,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'缛',"7305",4 ,456,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'缚',"7306",4 ,494,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'缙',"7307",4 ,532,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'缘',"7308",4 ,570,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'缗',"7309",4 ,608,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'编',"7310",4 ,646,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'缕',"7311",4 ,684,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'缔',"7312",4 ,722,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'缓',"7313",4 ,760,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'缒',"7314",4 ,798,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'缑',"7315",4 ,836,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'缏',"7316",4 ,874,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'缎',"7317",4 ,912,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'缍',"7318",4 ,950,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'缌',"7319",4 ,0  ,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'缋',"7320",4 ,38 ,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'缉',"7321",4 ,76 ,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'缈',"7322",4 ,114,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'缇',"7323",4 ,152,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'缆',"7324",4 ,190,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'缅',"7325",4 ,228,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'缄',"7326",4 ,266,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'缃',"7327",4 ,304,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'缂',"7328",4 ,342,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'缁',"7329",4 ,380,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'缀',"7330",4 ,418,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'绿',"7331",4 ,456,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'绾',"7332",4 ,494,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'绽',"7333",4 ,532,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'综',"7334",4 ,570,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'绻',"7335",4 ,608,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'绺',"7336",4 ,646,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'绸',"7337",4 ,684,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'绷',"7338",4 ,722,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'绶',"7339",4 ,760,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'绵',"7340",4 ,798,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'维',"7341",4 ,836,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'绳',"7342",4 ,874,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'绲',"7343",4 ,912,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'绱',"7344",4 ,950,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'绰',"7345",4 ,0  ,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'绯',"7346",4 ,38 ,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'绮',"7347",4 ,76 ,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'续',"7348",4 ,114,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'绫',"7349",4 ,152,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'绪',"7350",4 ,190,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'绩',"7351",4 ,228,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'绨',"7352",4 ,266,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'继',"7353",4 ,304,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'绦',"7354",4 ,342,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'绥',"7355",4 ,380,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'绣',"7356",4 ,418,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'绢',"7357",4 ,456,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'绡',"7358",4 ,494,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'绠',"7359",4 ,532,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'统',"7360",4 ,570,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'绞',"7361",4 ,608,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'绝',"7362",4 ,646,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'络',"7363",4 ,684,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'绛',"7364",4 ,722,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'绚',"7365",4 ,760,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'给',"7366",4 ,798,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'绘',"7367",4 ,836,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'绗',"7368",4 ,874,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'绕',"7369",4 ,912,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'绔',"7370",4 ,950,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'结',"7371",4 ,0  ,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'绒',"7372",4 ,38 ,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'绑',"7373",4 ,76 ,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'绐',"7374",4 ,114,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'经',"7375",4 ,152,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'绎',"7376",4 ,190,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'绍',"7377",4 ,228,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'绌',"7378",4 ,266,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'绋',"7379",4 ,304,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'绊',"7380",4 ,342,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'绉',"7381",4 ,380,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'终',"7382",4 ,418,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'织',"7383",4 ,456,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'细',"7384",4 ,494,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'绅',"7385",4 ,532,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'组',"7386",4 ,570,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'练',"7387",4 ,608,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'绂',"7388",4 ,646,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'绁',"7389",4 ,684,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'绀',"7390",4 ,722,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'线',"7391",4 ,760,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'纾',"7392",4 ,798,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'纽',"7393",4 ,836,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'纺',"7394",4 ,874,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'纹',"7395",4 ,912,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'纸',"7396",4 ,950,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'纷',"7397",4 ,0  ,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'纶',"7398",4 ,38 ,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'纵',"7399",4 ,76 ,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'纳',"7400",4 ,114,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'纲',"7401",4 ,152,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'纱',"7402",4 ,190,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'纰',"7403",4 ,228,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'纯',"7404",4 ,266,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'纭',"7405",4 ,304,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'纬',"7406",4 ,342,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'纫',"7407",4 ,380,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'纪',"7408",4 ,418,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'纩',"7409",4 ,456,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'纨',"7410",4 ,494,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'级',"7411",4 ,532,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'约',"7412",4 ,570,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'纥',"7413",4 ,608,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'纤',"7414",4 ,646,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'纣',"7415",4 ,684,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'红',"7416",4 ,722,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'纡',"7417",4 ,760,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'纠',"7418",4 ,798,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'纟',"7419",4 ,836,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'纛',"7420",4 ,874,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'纂',"7421",4 ,912,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'繇',"7422",4 ,950,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'繁',"7423",4 ,0  ,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'縻',"7424",4 ,38 ,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'綮',"7425",4 ,76 ,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'綦',"7426",4 ,114,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'絷',"7427",4 ,152,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'絮',"7428",4 ,190,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'累',"7429",4 ,228,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'紫',"7430",4 ,266,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'紧',"7431",4 ,304,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'索',"7432",4 ,342,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'素',"7433",4 ,380,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'紊',"7434",4 ,418,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'系',"7435",4 ,456,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'糸',"7436",4 ,494,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'糯',"7437",4 ,532,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'糨',"7438",4 ,570,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'糠',"7439",4 ,608,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'糟',"7440",4 ,646,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'糜',"7441",4 ,684,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'糙',"7442",4 ,722,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'糗',"7443",4 ,760,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'糖',"7444",4 ,798,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'糕',"7445",4 ,836,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'糍',"7446",4 ,874,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'糌',"7447",4 ,912,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'糊',"7448",4 ,950,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'糈',"7449",4 ,0  ,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'糇',"7450",4 ,38 ,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'糅',"7451",4 ,76 ,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'糁',"7452",4 ,114,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'精',"7453",4 ,152,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'粽',"7454",4 ,190,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'粼',"7455",4 ,228,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'粹',"7456",4 ,266,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'粳',"7457",4 ,304,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'粲',"7458",4 ,342,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'粱',"7459",4 ,380,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'粮',"7460",4 ,418,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'粪',"7461",4 ,456,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'粥',"7462",4 ,494,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'粤',"7463",4 ,532,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'粢',"7464",4 ,570,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'粟',"7465",4 ,608,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'粞',"7466",4 ,646,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'粝',"7467",4 ,684,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'粜',"7468",4 ,722,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'粘',"7469",4 ,760,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'粗',"7470",4 ,798,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'粕',"7471",4 ,836,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'粒',"7472",4 ,874,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'粑',"7473",4 ,912,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'粉',"7474",4 ,950,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'籽',"7475",4 ,0  ,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'籼',"7476",4 ,38 ,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'类',"7477",4 ,76 ,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'籴',"7478",4 ,114,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'米',"7479",4 ,152,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'籍',"7480",4 ,190,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'籁',"7481",4 ,228,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'籀',"7482",4 ,266,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'簿',"7483",4 ,304,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'簸',"7484",4 ,342,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'簪',"7485",4 ,380,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'簧',"7486",4 ,418,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'簦',"7487",4 ,456,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'簟',"7488",4 ,494,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'簖',"7489",4 ,532,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'簏',"7490",4 ,570,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'簌',"7491",4 ,608,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'簋',"7492",4 ,646,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'簇',"7493",4 ,684,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'篾',"7494",4 ,722,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'篼',"7495",4 ,760,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'篷',"7496",4 ,798,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'篱',"7497",4 ,836,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'篮',"7498",4 ,874,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'篪',"7499",4 ,912,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'篦',"7500",4 ,950,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'篥',"7501",4 ,0  ,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'篡',"7502",4 ,38 ,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'篝',"7503",4 ,76 ,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'篚',"7504",4 ,114,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'篙',"7505",4 ,152,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'篓',"7506",4 ,190,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'篑',"7507",4 ,228,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'篌',"7508",4 ,266,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'篇',"7509",4 ,304,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'篆',"7510",4 ,342,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'篁',"7511",4 ,380,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'箸',"7512",4 ,418,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'箴',"7513",4 ,456,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'箱',"7514",4 ,494,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'箭',"7515",4 ,532,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'箬',"7516",4 ,570,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'箫',"7517",4 ,608,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'箪',"7518",4 ,646,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'箩',"7519",4 ,684,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'箨',"7520",4 ,722,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'箧',"7521",4 ,760,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'箦',"7522",4 ,798,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'箢',"7523",4 ,836,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'管',"7524",4 ,874,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'箝',"7525",4 ,912,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'箜',"7526",4 ,950,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'算',"7527",4 ,0  ,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'箕',"7528",4 ,38 ,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'箔',"7529",4 ,76 ,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'箐',"7530",4 ,114,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'箍',"7531",4 ,152,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'箅',"7532",4 ,190,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'简',"7533",4 ,228,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'签',"7534",4 ,266,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'筻',"7535",4 ,304,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'筹',"7536",4 ,342,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'筷',"7537",4 ,380,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'筵',"7538",4 ,418,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'筲',"7539",4 ,456,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'筱',"7540",4 ,494,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'筮',"7541",4 ,532,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'筢',"7542",4 ,570,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'筠',"7543",4 ,608,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'筝',"7544",4 ,646,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'筛',"7545",4 ,684,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'筚',"7546",4 ,722,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'筘',"7547",4 ,760,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'策',"7548",4 ,798,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'答',"7549",4 ,836,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'筒',"7550",4 ,874,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'筑',"7551",4 ,912,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'筐',"7552",4 ,950,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'筏',"7553",4 ,0  ,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'筌',"7554",4 ,38 ,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'筋',"7555",4 ,76 ,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'等',"7556",4 ,114,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'筇',"7557",4 ,152,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'筅',"7558",4 ,190,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'笾',"7559",4 ,228,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'笼',"7560",4 ,266,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'笺',"7561",4 ,304,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'笸',"7562",4 ,342,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'笳',"7563",4 ,380,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'笱',"7564",4 ,418,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'笮',"7565",4 ,456,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'第',"7566",4 ,494,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'笫',"7567",4 ,532,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'笪',"7568",4 ,570,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'笨',"7569",4 ,608,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'符',"7570",4 ,646,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'笥',"7571",4 ,684,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'笤',"7572",4 ,722,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'笠',"7573",4 ,760,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'笞',"7574",4 ,798,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'笛',"7575",4 ,836,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'笙',"7576",4 ,874,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'笕',"7577",4 ,912,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'笔',"7578",4 ,950,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'笑',"7579",4 ,0  ,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'笏',"7580",4 ,38 ,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'笋',"7581",4 ,76 ,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'笊',"7582",4 ,114,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'笈',"7583",4 ,152,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'笆',"7584",4 ,190,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'笄',"7585",4 ,228,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'笃',"7586",4 ,266,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'竿',"7587",4 ,304,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'竽',"7588",4 ,342,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'竺',"7589",4 ,380,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'竹',"7590",4 ,418,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'端',"7591",4 ,456,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'竭',"7592",4 ,494,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'竦',"7593",4 ,532,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'童',"7594",4 ,570,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'竣',"7595",4 ,608,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'章',"7596",4 ,646,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'竟',"7597",4 ,684,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'竞',"7598",4 ,722,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'站',"7599",4 ,760,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'竖',"7600",4 ,798,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'立',"7601",4 ,836,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'窿',"7602",4 ,874,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'窳',"7603",4 ,912,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'窭',"7604",4 ,950,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'窬',"7605",4 ,0  ,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'窨',"7606",4 ,38 ,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'窦',"7607",4 ,76 ,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'窥',"7608",4 ,114,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'窠',"7609",4 ,152,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'窟',"7610",4 ,190,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'窝',"7611",4 ,228,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'窜',"7612",4 ,266,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'窘',"7613",4 ,304,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'窗',"7614",4 ,342,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'窖',"7615",4 ,380,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'窕',"7616",4 ,418,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'窒',"7617",4 ,456,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'窑',"7618",4 ,494,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'窍',"7619",4 ,532,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'窈',"7620",4 ,570,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'窆',"7621",4 ,608,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'窄',"7622",4 ,646,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'窃',"7623",4 ,684,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'突',"7624",4 ,722,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'窀',"7625",4 ,760,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'穿',"7626",4 ,798,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'空',"7627",4 ,836,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'穹',"7628",4 ,874,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'穸',"7629",4 ,912,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'穷',"7630",4 ,950,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'究',"7631",4 ,0  ,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'穴',"7632",4 ,38 ,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'穰',"7633",4 ,76 ,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'穗',"7634",4 ,114,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'穑',"7635",4 ,152,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'穆',"7636",4 ,190,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'稿',"7637",4 ,228,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'稽',"7638",4 ,266,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'稼',"7639",4 ,304,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'稻',"7640",4 ,342,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'稹',"7641",4 ,380,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'稷',"7642",4 ,418,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'稳',"7643",4 ,456,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'稣',"7644",4 ,494,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'稠',"7645",4 ,532,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'稞',"7646",4 ,570,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'稚',"7647",4 ,608,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'稗',"7648",4 ,646,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'稔',"7649",4 ,684,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'税',"7650",4 ,722,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'稍',"7651",4 ,760,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'程',"7652",4 ,798,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'稆',"7653",4 ,836,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'稃',"7654",4 ,874,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'稂',"7655",4 ,912,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-05",1024,'稀',"7656",4 ,950,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'诬',"7657",3 ,0  ,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'诫',"7658",3 ,38 ,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'诩',"7659",3 ,76 ,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'诨',"7660",3 ,114,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'诧',"7661",3 ,152,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'详',"7662",3 ,190,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'该',"7663",3 ,228,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'诤',"7664",3 ,266,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'诣',"7665",3 ,304,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'询',"7666",3 ,342,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'诡',"7667",3 ,380,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'诠',"7668",3 ,418,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'诟',"7669",3 ,456,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'诞',"7670",3 ,494,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'话',"7671",3 ,532,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'诜',"7672",3 ,570,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'诛',"7673",3 ,608,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'诚',"7674",3 ,646,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'诙',"7675",3 ,684,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'诘',"7676",3 ,722,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'诗',"7677",3 ,760,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'诖',"7678",3 ,798,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'试',"7679",3 ,836,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'诔',"7680",3 ,874,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'诓',"7681",3 ,912,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'诒',"7682",3 ,950,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'译',"7683",3 ,0  ,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'诏',"7684",3 ,38 ,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'诎',"7685",3 ,76 ,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'词',"7686",3 ,114,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'诌',"7687",3 ,152,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'诋',"7688",3 ,190,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'诊',"7689",3 ,228,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'诉',"7690",3 ,266,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'诈',"7691",3 ,304,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'识',"7692",3 ,342,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'诅',"7693",3 ,380,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'评',"7694",3 ,418,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'诃',"7695",3 ,456,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'诂',"7696",3 ,494,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'证',"7697",3 ,532,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'诀',"7698",3 ,570,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'访',"7699",3 ,608,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'设',"7700",3 ,646,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'讽',"7701",3 ,684,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'讼',"7702",3 ,722,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'论',"7703",3 ,760,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'讹',"7704",3 ,798,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'许',"7705",3 ,836,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'讷',"7706",3 ,874,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'讶',"7707",3 ,912,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'讵',"7708",3 ,950,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'讴',"7709",3 ,0  ,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'讳',"7710",3 ,38 ,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'讲',"7711",3 ,76 ,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'记',"7712",3 ,114,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'讯',"7713",3 ,152,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'议',"7714",3 ,190,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'训',"7715",3 ,228,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'讫',"7716",3 ,266,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'讪',"7717",3 ,304,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'让',"7718",3 ,342,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'讨',"7719",3 ,380,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'讧',"7720",3 ,418,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'讦',"7721",3 ,456,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'讥',"7722",3 ,494,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'认',"7723",3 ,532,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'讣',"7724",3 ,570,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'订',"7725",3 ,608,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'计',"7726",3 ,646,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'讠',"7727",3 ,684,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'譬',"7728",3 ,722,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'警',"7729",3 ,760,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'謦',"7730",3 ,798,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'謇',"7731",3 ,836,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'誓',"7732",3 ,874,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'誊',"7733",3 ,912,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'誉',"7734",3 ,950,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'詹',"7735",3 ,0  ,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'詈',"7736",3 ,38 ,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'訾',"7737",3 ,76 ,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'訇',"7738",3 ,114,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'言',"7739",3 ,152,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'觳',"7740",3 ,190,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'觯',"7741",3 ,228,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'觫',"7742",3 ,266,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'触',"7743",3 ,304,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'觥',"7744",3 ,342,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'解',"7745",3 ,380,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'觞',"7746",3 ,418,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'觜',"7747",3 ,456,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'觚',"7748",3 ,494,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'觖',"7749",3 ,532,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'角',"7750",3 ,570,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'觑',"7751",3 ,608,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'觐',"7752",3 ,646,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'觏',"7753",3 ,684,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'觎',"7754",3 ,722,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'觌',"7755",3 ,760,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'觋',"7756",3 ,798,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'觊',"7757",3 ,836,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'觉',"7758",3 ,874,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'览',"7759",3 ,912,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'觇',"7760",3 ,950,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'视',"7761",3 ,0  ,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'觅',"7762",3 ,38 ,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'规',"7763",3 ,76 ,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'观',"7764",3 ,114,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'见',"7765",3 ,152,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'覆',"7766",3 ,190,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'覃',"7767",3 ,228,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'要',"7768",3 ,266,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'西',"7769",3 ,304,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'襻',"7770",3 ,342,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'襦',"7771",3 ,380,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'襟',"7772",3 ,418,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'襞',"7773",3 ,456,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'襄',"7774",3 ,494,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'襁',"7775",3 ,532,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'褶',"7776",3 ,570,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'褴',"7777",3 ,608,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'褰',"7778",3 ,646,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'褫',"7779",3 ,684,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'褪',"7780",3 ,722,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'褥',"7781",3 ,760,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'褡',"7782",3 ,798,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'褛',"7783",3 ,836,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'褚',"7784",3 ,874,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'褙',"7785",3 ,912,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'褓',"7786",3 ,950,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'褒',"7787",3 ,0  ,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'褐',"7788",3 ,38 ,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'褊',"7789",3 ,76 ,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'褂',"7790",3 ,114,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'裾',"7791",3 ,152,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'裼',"7792",3 ,190,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'裹',"7793",3 ,228,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'裸',"7794",3 ,266,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'裴',"7795",3 ,304,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'裳',"7796",3 ,342,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'裱',"7797",3 ,380,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'裰',"7798",3 ,418,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'裨',"7799",3 ,456,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'裥',"7800",3 ,494,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'裤',"7801",3 ,532,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'裣',"7802",3 ,570,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'裢',"7803",3 ,608,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'裟',"7804",3 ,646,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'裙',"7805",3 ,684,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'裘',"7806",3 ,722,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'裕',"7807",3 ,760,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'裔',"7808",3 ,798,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'裒',"7809",3 ,836,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'裎',"7810",3 ,874,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'裉',"7811",3 ,912,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'裆',"7812",3 ,950,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'装',"7813",3 ,0  ,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'裂',"7814",3 ,38 ,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'裁',"7815",3 ,76 ,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'袼',"7816",3 ,114,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'袷',"7817",3 ,152,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'袱',"7818",3 ,190,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'袭',"7819",3 ,228,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'被',"7820",3 ,266,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'袤',"7821",3 ,304,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'袢',"7822",3 ,342,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'袜',"7823",3 ,380,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'袖',"7824",3 ,418,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'袒',"7825",3 ,456,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'袍',"7826",3 ,494,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'袋',"7827",3 ,532,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'袈',"7828",3 ,570,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'袅',"7829",3 ,608,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'袄',"7830",3 ,646,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'袂',"7831",3 ,684,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'袁',"7832",3 ,722,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'衿',"7833",3 ,760,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'衾',"7834",3 ,798,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'衽',"7835",3 ,836,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'衷',"7836",3 ,874,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'衲',"7837",3 ,912,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'衰',"7838",3 ,950,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'衮',"7839",3 ,0  ,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'衬',"7840",3 ,38 ,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'衫',"7841",3 ,76 ,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'衩',"7842",3 ,114,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'表',"7843",3 ,152,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'补',"7844",3 ,190,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'衤',"7845",3 ,228,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'衣',"7846",3 ,266,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'衢',"7847",3 ,304,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'衡',"7848",3 ,342,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'衙',"7849",3 ,380,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'街',"7850",3 ,418,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'衔',"7851",3 ,456,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'衍',"7852",3 ,494,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'行',"7853",3 ,532,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'衅',"7854",3 ,570,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'衄',"7855",3 ,608,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'血',"7856",3 ,646,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蠼',"7857",3 ,684,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蠹',"7858",3 ,722,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蠲',"7859",3 ,760,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蠢',"7860",3 ,798,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蠡',"7861",3 ,836,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蠛',"7862",3 ,874,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蠖',"7863",3 ,912,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蠕',"7864",3 ,950,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蠓',"7865",3 ,0  ,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蠊',"7866",3 ,38 ,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蠃',"7867",3 ,76 ,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蟾',"7868",3 ,114,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蟹',"7869",3 ,152,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蟮',"7870",3 ,190,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蟪',"7871",3 ,228,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蟥',"7872",3 ,266,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蟠',"7873",3 ,304,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蟛',"7874",3 ,342,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蟓',"7875",3 ,380,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蟒',"7876",3 ,418,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蟑',"7877",3 ,456,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蟋',"7878",3 ,494,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蟊',"7879",3 ,532,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蟆',"7880",3 ,570,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蟀',"7881",3 ,608,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'螽',"7882",3 ,646,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'螺',"7883",3 ,684,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'螵',"7884",3 ,722,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'螳',"7885",3 ,760,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'螯',"7886",3 ,798,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'螭',"7887",3 ,836,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'螬',"7888",3 ,874,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'螫',"7889",3 ,912,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'螨',"7890",3 ,950,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'螟',"7891",3 ,0  ,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'螗',"7892",3 ,38 ,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'螓',"7893",3 ,76 ,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'融',"7894",3 ,114,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'螋',"7895",3 ,152,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'螈',"7896",3 ,190,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'螅',"7897",3 ,228,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'螃',"7898",3 ,266,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'螂',"7899",3 ,304,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蝾',"7900",3 ,342,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蝽',"7901",3 ,380,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蝼',"7902",3 ,418,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蝻',"7903",3 ,456,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蝶',"7904",3 ,494,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蝴',"7905",3 ,532,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蝰',"7906",3 ,570,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蝮',"7907",3 ,608,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蝥',"7908",3 ,646,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蝤',"7909",3 ,684,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蝣',"7910",3 ,722,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蝠',"7911",3 ,760,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蝙',"7912",3 ,798,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蝗',"7913",3 ,836,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蝓',"7914",3 ,874,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蝎',"7915",3 ,912,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蝌',"7916",3 ,950,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蝉',"7917",3 ,0  ,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蝈',"7918",3 ,38 ,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蝇',"7919",3 ,76 ,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蜿',"7920",3 ,114,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蜾',"7921",3 ,152,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蜻',"7922",3 ,190,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蜷',"7923",3 ,228,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蜴',"7924",3 ,266,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蜱',"7925",3 ,304,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蜮',"7926",3 ,342,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蜩',"7927",3 ,380,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蜥',"7928",3 ,418,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蜣',"7929",3 ,456,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蜢',"7930",3 ,494,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蜡',"7931",3 ,532,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蜞',"7932",3 ,570,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蜜',"7933",3 ,608,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蜚',"7934",3 ,646,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蜘',"7935",3 ,684,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蜗',"7936",3 ,722,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蜕',"7937",3 ,760,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蜓',"7938",3 ,798,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蜒',"7939",3 ,836,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蜍',"7940",3 ,874,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蜊',"7941",3 ,912,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蜉',"7942",3 ,950,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蜈',"7943",3 ,0  ,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蜇',"7944",3 ,38 ,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蜃',"7945",3 ,76 ,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蜂',"7946",3 ,114,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蜀',"7947",3 ,152,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蛾',"7948",3 ,190,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蛹',"7949",3 ,228,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蛸',"7950",3 ,266,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蛴',"7951",3 ,304,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蛳',"7952",3 ,342,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蛲',"7953",3 ,380,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蛱',"7954",3 ,418,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蛰',"7955",3 ,456,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蛮',"7956",3 ,494,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蛭',"7957",3 ,532,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蛩',"7958",3 ,570,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蛤',"7959",3 ,608,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蛟',"7960",3 ,646,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蛞',"7961",3 ,684,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蛛',"7962",3 ,722,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蛙',"7963",3 ,760,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蛘',"7964",3 ,798,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蛔',"7965",3 ,836,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蛑',"7966",3 ,874,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蛐',"7967",3 ,912,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蛏',"7968",3 ,950,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蛎',"7969",3 ,0  ,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蛋',"7970",3 ,38 ,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蛊',"7971",3 ,76 ,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蛉',"7972",3 ,114,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蛇',"7973",3 ,152,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蛆',"7974",3 ,190,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蛄',"7975",3 ,228,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蛀',"7976",3 ,266,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蚺',"7977",3 ,304,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蚶',"7978",3 ,342,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蚵',"7979",3 ,380,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蚴',"7980",3 ,418,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蚱',"7981",3 ,456,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蚰',"7982",3 ,494,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蚯',"7983",3 ,532,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蚬',"7984",3 ,570,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蚪',"7985",3 ,608,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蚩',"7986",3 ,646,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蚨',"7987",3 ,684,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蚧',"7988",3 ,722,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蚤',"7989",3 ,760,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蚣',"7990",3 ,798,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蚝',"7991",3 ,836,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蚜',"7992",3 ,874,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蚕',"7993",3 ,912,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蚓',"7994",3 ,950,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蚍',"7995",3 ,0  ,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蚌',"7996",3 ,38 ,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蚋',"7997",3 ,76 ,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蚊',"7998",3 ,114,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蚂',"7999",3 ,152,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蚁',"8000",3 ,190,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蚀',"8001",3 ,228,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'虿',"8002",3 ,266,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'虾',"8003",3 ,304,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'虽',"8004",3 ,342,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'虼',"8005",3 ,380,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'虻',"8006",3 ,418,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'虺',"8007",3 ,456,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'虹',"8008",3 ,494,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'虱',"8009",3 ,532,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'虮',"8010",3 ,570,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'虬',"8011",3 ,608,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'虫',"8012",3 ,646,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'虢',"8013",3 ,684,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'虞',"8014",3 ,722,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'虚',"8015",3 ,760,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'虔',"8016",3 ,798,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'虑',"8017",3 ,836,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'虐',"8018",3 ,874,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'虏',"8019",3 ,912,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'虎',"8020",3 ,950,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'虍',"8021",3 ,0  ,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蘼',"8022",3 ,38 ,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蘸',"8023",3 ,76 ,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蘩',"8024",3 ,114,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蘧',"8025",3 ,152,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蘖',"8026",3 ,190,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蘑',"8027",3 ,228,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蘅',"8028",3 ,266,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'藿',"8029",3 ,304,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'藻',"8030",3 ,342,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'藩',"8031",3 ,380,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'藤',"8032",3 ,418,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'藜',"8033",3 ,456,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'藕',"8034",3 ,494,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'藓',"8035",3 ,532,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'藐',"8036",3 ,570,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'藏',"8037",3 ,608,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'藉',"8038",3 ,646,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'藁',"8039",3 ,684,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'薹',"8040",3 ,722,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'薷',"8041",3 ,760,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'薰',"8042",3 ,798,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'薯',"8043",3 ,836,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'薮',"8044",3 ,874,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'薪',"8045",3 ,912,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'薨',"8046",3 ,950,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'薤',"8047",3 ,0  ,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'薜',"8048",3 ,38 ,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'薛',"8049",3 ,76 ,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'薏',"8050",3 ,114,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'薇',"8051",3 ,152,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'薅',"8052",3 ,190,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'薄',"8053",3 ,228,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蕾',"8054",3 ,266,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蕻',"8055",3 ,304,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蕺',"8056",3 ,342,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蕹',"8057",3 ,380,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蕴',"8058",3 ,418,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蕲',"8059",3 ,456,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蕨',"8060",3 ,494,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蕤',"8061",3 ,532,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蕞',"8062",3 ,570,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蕙',"8063",3 ,608,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蕖',"8064",3 ,646,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蕊',"8065",3 ,684,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蕉',"8066",3 ,722,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蕈',"8067",3 ,760,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蕃',"8068",3 ,798,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蔽',"8069",3 ,836,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蔼',"8070",3 ,874,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蔻',"8071",3 ,912,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蔺',"8072",3 ,950,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蔹',"8073",3 ,0  ,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蔸',"8074",3 ,38 ,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蔷',"8075",3 ,76 ,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蔬',"8076",3 ,114,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蔫',"8077",3 ,152,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蔡',"8078",3 ,190,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蔟',"8079",3 ,228,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蔚',"8080",3 ,266,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蔗',"8081",3 ,304,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蔓',"8082",3 ,342,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蔑',"8083",3 ,380,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蔌',"8084",3 ,418,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蓿',"8085",3 ,456,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蓼',"8086",3 ,494,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蓰',"8087",3 ,532,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蓬',"8088",3 ,570,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蓦',"8089",3 ,608,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蓥',"8090",3 ,646,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蓣',"8091",3 ,684,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蓠',"8092",3 ,722,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蓟',"8093",3 ,760,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蓝',"8094",3 ,798,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蓖',"8095",3 ,836,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蓓',"8096",3 ,874,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蓑',"8097",3 ,912,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蓐',"8098",3 ,950,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蓍',"8099",3 ,0  ,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蓊',"8100",3 ,38 ,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蓉',"8101",3 ,76 ,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蓄',"8102",3 ,114,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蓁',"8103",3 ,152,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蒿',"8104",3 ,190,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蒽',"8105",3 ,228,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蒺',"8106",3 ,266,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蒹',"8107",3 ,304,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蒸',"8108",3 ,342,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蒴',"8109",3 ,380,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蒲',"8110",3 ,418,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蒯',"8111",3 ,456,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蒡',"8112",3 ,494,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蒜',"8113",3 ,532,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蒙',"8114",3 ,570,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蒗',"8115",3 ,608,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蒎',"8116",3 ,646,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蒌',"8117",3 ,684,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蒋',"8118",3 ,722,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蒉',"8119",3 ,760,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蒈',"8120",3 ,798,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蒇',"8121",3 ,836,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'蒂',"8122",3 ,874,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'葺',"8123",3 ,912,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'葸',"8124",3 ,950,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'葶',"8125",3 ,0  ,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'葵',"8126",3 ,38 ,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'葳',"8127",3 ,76 ,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'葱',"8128",3 ,114,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'葭',"8129",3 ,152,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'葬',"8130",3 ,190,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'葫',"8131",3 ,228,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'葩',"8132",3 ,266,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'董',"8133",3 ,304,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'葡',"8134",3 ,342,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'葜',"8135",3 ,380,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'葛',"8136",3 ,418,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'葚',"8137",3 ,456,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'葙',"8138",3 ,494,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'著',"8139",3 ,532,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'葑',"8140",3 ,570,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'葆',"8141",3 ,608,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'落',"8142",3 ,646,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'萼',"8143",3 ,684,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'萸',"8144",3 ,722,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'萱',"8145",3 ,760,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'萨',"8146",3 ,798,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'萧',"8147",3 ,836,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'萦',"8148",3 ,874,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'营',"8149",3 ,912,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'萤',"8150",3 ,950,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'萝',"8151",3 ,0  ,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'萜',"8152",3 ,38 ,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'萘',"8153",3 ,76 ,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'萑',"8154",3 ,114,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'萏',"8155",3 ,152,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'萎',"8156",3 ,190,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'萍',"8157",3 ,228,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'萌',"8158",3 ,266,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'萋',"8159",3 ,304,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'萆',"8160",3 ,342,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'萄',"8161",3 ,380,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'萃',"8162",3 ,418,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'萁',"8163",3 ,456,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'菽',"8164",3 ,494,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'菹',"8165",3 ,532,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'菸',"8166",3 ,570,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'菲',"8167",3 ,608,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'菱',"8168",3 ,646,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'菰',"8169",3 ,684,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'菪',"8170",3 ,722,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'菩',"8171",3 ,760,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'菥',"8172",3 ,798,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'菡',"8173",3 ,836,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'菠',"8174",3 ,874,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'菟',"8175",3 ,912,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'菝',"8176",3 ,950,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'菜',"8177",3 ,0  ,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'菘',"8178",3 ,38 ,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'菖',"8179",3 ,76 ,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'菔',"8180",3 ,114,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'菏',"8181",3 ,152,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'菌',"8182",3 ,190,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'菊',"8183",3 ,228,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'菇',"8184",3 ,266,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'菅',"8185",3 ,304,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'菁',"8186",3 ,342,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'菀',"8187",3 ,380,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'莽',"8188",3 ,418,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'莼',"8189",3 ,456,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'莺',"8190",3 ,494,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'莹',"8191",3 ,532,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'莸',"8192",3 ,570,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'获',"8193",3 ,608,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'莶',"8194",3 ,646,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'莴',"8195",3 ,684,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'莳',"8196",3 ,722,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'莲',"8197",3 ,760,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'莱',"8198",3 ,798,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'莰',"8199",3 ,836,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'莫',"8200",3 ,874,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'莪',"8201",3 ,912,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'莩',"8202",3 ,950,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'莨',"8203",3 ,0  ,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'莠',"8204",3 ,38 ,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'莞',"8205",3 ,76 ,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'莜',"8206",3 ,114,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'莛',"8207",3 ,152,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'莘',"8208",3 ,190,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'莓',"8209",3 ,228,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'莒',"8210",3 ,266,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'莎',"8211",3 ,304,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'莉',"8212",3 ,342,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'莆',"8213",3 ,380,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'莅',"8214",3 ,418,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'荽',"8215",3 ,456,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'荼',"8216",3 ,494,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'荻',"8217",3 ,532,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'荸',"8218",3 ,570,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'荷',"8219",3 ,608,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'药',"8220",3 ,646,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'荮',"8221",3 ,684,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'荭',"8222",3 ,722,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'荬',"8223",3 ,760,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'荫',"8224",3 ,798,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'荪',"8225",3 ,836,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'荩',"8226",3 ,874,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'荨',"8227",3 ,912,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'荧',"8228",3 ,950,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'荦',"8229",3 ,0  ,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'荥',"8230",3 ,38 ,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'荤',"8231",3 ,76 ,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'荣',"8232",3 ,114,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'荡',"8233",3 ,152,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'荠',"8234",3 ,190,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'荟',"8235",3 ,228,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'荞',"8236",3 ,266,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'荜',"8237",3 ,304,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'荛',"8238",3 ,342,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'荚',"8239",3 ,380,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'荔',"8240",3 ,418,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'荒',"8241",3 ,456,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'荑',"8242",3 ,494,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'荐',"8243",3 ,532,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'荏',"8244",3 ,570,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'草',"8245",3 ,608,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'荇',"8246",3 ,646,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'荆',"8247",3 ,684,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'荃',"8248",3 ,722,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'荀',"8249",3 ,760,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'茼',"8250",3 ,798,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'茺',"8251",3 ,836,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'茹',"8252",3 ,874,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'茸',"8253",3 ,912,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'茶',"8254",3 ,950,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'茵',"8255",3 ,0  ,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'茴',"8256",3 ,38 ,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'茳',"8257",3 ,76 ,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'茱',"8258",3 ,114,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'茯',"8259",3 ,152,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'茭',"8260",3 ,190,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'茬',"8261",3 ,228,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'茫',"8262",3 ,266,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'茨',"8263",3 ,304,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'茧',"8264",3 ,342,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'茜',"8265",3 ,380,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'茛',"8266",3 ,418,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'茚',"8267",3 ,456,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'茗',"8268",3 ,494,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'茕',"8269",3 ,532,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'茔',"8270",3 ,570,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'茑',"8271",3 ,608,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'茏',"8272",3 ,646,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'茎',"8273",3 ,684,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'茌',"8274",3 ,722,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'茉',"8275",3 ,760,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'茈',"8276",3 ,798,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'茇',"8277",3 ,836,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'茆',"8278",3 ,874,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'茅',"8279",3 ,912,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'茄',"8280",3 ,950,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'范',"8281",3 ,0  ,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'茂',"8282",3 ,38 ,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'茁',"8283",3 ,76 ,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'苻',"8284",3 ,114,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'苹',"8285",3 ,152,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'苷',"8286",3 ,190,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'苴',"8287",3 ,228,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'英',"8288",3 ,266,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'苯',"8289",3 ,304,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'苫',"8290",3 ,342,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'苦',"8291",3 ,380,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'若',"8292",3 ,418,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'苤',"8293",3 ,456,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'苣',"8294",3 ,494,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'苡',"8295",3 ,532,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'苠',"8296",3 ,570,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'苟',"8297",3 ,608,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'苞',"8298",3 ,646,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'苜',"8299",3 ,684,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'苛',"8300",3 ,722,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'苘',"8301",3 ,760,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'苗',"8302",3 ,798,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'苕',"8303",3 ,836,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'苔',"8304",3 ,874,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'苓',"8305",3 ,912,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'苒',"8306",3 ,950,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'苑',"8307",3 ,0  ,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'苏',"8308",3 ,38 ,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'苎',"8309",3 ,76 ,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'苍',"8310",3 ,114,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'苌',"8311",3 ,152,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'苋',"8312",3 ,190,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'苊',"8313",3 ,228,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'苈',"8314",3 ,266,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'苇',"8315",3 ,304,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'苄',"8316",3 ,342,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'苁',"8317",3 ,380,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'芾',"8318",3 ,418,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'芽',"8319",3 ,456,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'芹',"8320",3 ,494,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'芸',"8321",3 ,532,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'芷',"8322",3 ,570,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'芴',"8323",3 ,608,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'芳',"8324",3 ,646,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'花',"8325",3 ,684,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'芰',"8326",3 ,722,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'芯',"8327",3 ,760,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'芮',"8328",3 ,798,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'芭',"8329",3 ,836,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'芬',"8330",3 ,874,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'芫',"8331",3 ,912,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'芪',"8332",3 ,950,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'芩',"8333",3 ,0  ,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'芨',"8334",3 ,38 ,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'芦',"8335",3 ,76 ,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'芥',"8336",3 ,114,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'芤',"8337",3 ,152,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'芡',"8338",3 ,190,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'芟',"8339",3 ,228,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'芝',"8340",3 ,266,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'芜',"8341",3 ,304,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'芙',"8342",3 ,342,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'芘',"8343",3 ,380,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'芗',"8344",3 ,418,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'芒',"8345",3 ,456,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'芑',"8346",3 ,494,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'芏',"8347",3 ,532,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'芎',"8348",3 ,570,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'芍',"8349",3 ,608,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'芋',"8350",3 ,646,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'芊',"8351",3 ,684,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'芈',"8352",3 ,722,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'芄',"8353",3 ,760,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'节',"8354",3 ,798,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'艿',"8355",3 ,836,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'艾',"8356",3 ,874,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'艽',"8357",3 ,912,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-04",1024,'艺',"8358",3 ,950,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'锊',"8359",2 ,0  ,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'锉',"8360",2 ,38 ,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'锈',"8361",2 ,76 ,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'锇',"8362",2 ,114,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'锆',"8363",2 ,152,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'锅',"8364",2 ,190,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'锄',"8365",2 ,228,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'锃',"8366",2 ,266,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'锂',"8367",2 ,304,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'锁',"8368",2 ,342,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'销',"8369",2 ,380,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'铿',"8370",2 ,418,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'链',"8371",2 ,456,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'铽',"8372",2 ,494,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'铼',"8373",2 ,532,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'铺',"8374",2 ,570,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'铹',"8375",2 ,608,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'铸',"8376",2 ,646,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'铷',"8377",2 ,684,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'银',"8378",2 ,722,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'铵',"8379",2 ,760,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'铴',"8380",2 ,798,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'铳',"8381",2 ,836,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'铲',"8382",2 ,874,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'铱',"8383",2 ,912,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'铰',"8384",2 ,950,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'铯',"8385",2 ,0  ,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'铮',"8386",2 ,38 ,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'铭',"8387",2 ,76 ,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'铬',"8388",2 ,114,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'铫',"8389",2 ,152,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'铪',"8390",2 ,190,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'铩',"8391",2 ,228,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'铨',"8392",2 ,266,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'铧',"8393",2 ,304,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'铥',"8394",2 ,342,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'铤',"8395",2 ,380,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'铣',"8396",2 ,418,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'铢',"8397",2 ,456,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'铡',"8398",2 ,494,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'铠',"8399",2 ,532,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'铟',"8400",2 ,570,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'铞',"8401",2 ,608,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'铝',"8402",2 ,646,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'铜',"8403",2 ,684,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'铛',"8404",2 ,722,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'铙',"8405",2 ,760,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'铘',"8406",2 ,798,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'铗',"8407",2 ,836,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'铖',"8408",2 ,874,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'铕',"8409",2 ,912,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'铒',"8410",2 ,950,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'铑',"8411",2 ,0  ,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'铐',"8412",2 ,38 ,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'铎',"8413",2 ,76 ,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'铍',"8414",2 ,114,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'铌',"8415",2 ,152,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'铋',"8416",2 ,190,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'铊',"8417",2 ,228,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'铉',"8418",2 ,266,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'铈',"8419",2 ,304,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'铆',"8420",2 ,342,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'铅',"8421",2 ,380,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'铄',"8422",2 ,418,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'铃',"8423",2 ,456,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'铂',"8424",2 ,494,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'铁',"8425",2 ,532,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'铀',"8426",2 ,570,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'钿',"8427",2 ,608,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'钾',"8428",2 ,646,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'钽',"8429",2 ,684,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'钼',"8430",2 ,722,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'钻',"8431",2 ,760,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'钺',"8432",2 ,798,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'钹',"8433",2 ,836,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'钸',"8434",2 ,874,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'钷',"8435",2 ,912,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'钶',"8436",2 ,950,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'钵',"8437",2 ,0  ,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'钴',"8438",2 ,38 ,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'钳',"8439",2 ,76 ,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'钲',"8440",2 ,114,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'钱',"8441",2 ,152,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'钰',"8442",2 ,190,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'钯',"8443",2 ,228,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'钮',"8444",2 ,266,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'钭',"8445",2 ,304,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'钬',"8446",2 ,342,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'钫',"8447",2 ,380,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'钪',"8448",2 ,418,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'钩',"8449",2 ,456,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'钨',"8450",2 ,494,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'钧',"8451",2 ,532,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'钦',"8452",2 ,570,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'钥',"8453",2 ,608,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'钤',"8454",2 ,646,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'钣',"8455",2 ,684,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'钢',"8456",2 ,722,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'钡',"8457",2 ,760,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'钠',"8458",2 ,798,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'钟',"8459",2 ,836,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'钞',"8460",2 ,874,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'钝',"8461",2 ,912,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'钜',"8462",2 ,950,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'钛',"8463",2 ,0  ,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'钚',"8464",2 ,38 ,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'钙',"8465",2 ,76 ,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'钗',"8466",2 ,114,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'钕',"8467",2 ,152,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'钔',"8468",2 ,190,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'钓',"8469",2 ,228,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'钒',"8470",2 ,266,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'钐',"8471",2 ,304,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'钏',"8472",2 ,342,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'钎',"8473",2 ,380,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'钍',"8474",2 ,418,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'钌',"8475",2 ,456,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'钋',"8476",2 ,494,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'钊',"8477",2 ,532,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'钉',"8478",2 ,570,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'针',"8479",2 ,608,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'钇',"8480",2 ,646,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'钆',"8481",2 ,684,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'钅',"8482",2 ,722,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'鑫',"8483",2 ,760,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'鐾',"8484",2 ,798,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'鏖',"8485",2 ,836,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'鏊',"8486",2 ,874,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'鎏',"8487",2 ,912,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'鍪',"8488",2 ,950,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'錾',"8489",2 ,0  ,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'鋈',"8490",2 ,38 ,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'銮',"8491",2 ,76 ,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'銎',"8492",2 ,114,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'鉴',"8493",2 ,152,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'釜',"8494",2 ,190,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'金',"8495",2 ,228,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'量',"8496",2 ,266,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'野',"8497",2 ,304,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'重',"8498",2 ,342,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'里',"8499",2 ,380,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'释',"8500",2 ,418,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'釉',"8501",2 ,456,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'采',"8502",2 ,494,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'醺',"8503",2 ,532,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'醵',"8504",2 ,570,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'醴',"8505",2 ,608,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'醯',"8506",2 ,646,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'醮',"8507",2 ,684,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'醭',"8508",2 ,722,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'醪',"8509",2 ,760,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'醣',"8510",2 ,798,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'醢',"8511",2 ,836,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'醛',"8512",2 ,874,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'醚',"8513",2 ,912,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'醒',"8514",2 ,950,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'醑',"8515",2 ,0  ,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'醐',"8516",2 ,38 ,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'醍',"8517",2 ,76 ,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'醌',"8518",2 ,114,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'醋',"8519",2 ,152,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'醉',"8520",2 ,190,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'醇',"8521",2 ,228,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'醅',"8522",2 ,266,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'酿',"8523",2 ,304,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'酾',"8524",2 ,342,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'酽',"8525",2 ,380,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'酹',"8526",2 ,418,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'酸',"8527",2 ,456,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'酷',"8528",2 ,494,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'酶',"8529",2 ,532,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'酵',"8530",2 ,570,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'酴',"8531",2 ,608,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'酲',"8532",2 ,646,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'酱',"8533",2 ,684,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'酰',"8534",2 ,722,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'酯',"8535",2 ,760,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'酮',"8536",2 ,798,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'酬',"8537",2 ,836,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'酪',"8538",2 ,874,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'酩',"8539",2 ,912,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'酥',"8540",2 ,950,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'酤',"8541",2 ,0  ,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'酣',"8542",2 ,38 ,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'酢',"8543",2 ,76 ,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'酡',"8544",2 ,114,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'酞',"8545",2 ,152,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'酝',"8546",2 ,190,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'酚',"8547",2 ,228,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'酗',"8548",2 ,266,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'酒',"8549",2 ,304,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'酐',"8550",2 ,342,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'酏',"8551",2 ,380,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'酎',"8552",2 ,418,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'配',"8553",2 ,456,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'酌',"8554",2 ,494,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'酋',"8555",2 ,532,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'酊',"8556",2 ,570,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'酉',"8557",2 ,608,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'酆',"8558",2 ,646,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'酃',"8559",2 ,684,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'鄹',"8560",2 ,722,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'鄱',"8561",2 ,760,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'鄯',"8562",2 ,798,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'鄣',"8563",2 ,836,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'鄢',"8564",2 ,874,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'鄞',"8565",2 ,912,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'鄙',"8566",2 ,950,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'鄄',"8567",2 ,0  ,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'鄂',"8568",2 ,38 ,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'郾',"8569",2 ,76 ,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'都',"8570",2 ,114,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'郸',"8571",2 ,152,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'郴',"8572",2 ,190,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'郯',"8573",2 ,228,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'郭',"8574",2 ,266,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'郫',"8575",2 ,304,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'部',"8576",2 ,342,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'郧',"8577",2 ,380,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'郦',"8578",2 ,418,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'郢',"8579",2 ,456,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'郡',"8580",2 ,494,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'郝',"8581",2 ,532,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'郜',"8582",2 ,570,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'郛',"8583",2 ,608,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'郗',"8584",2 ,646,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'郓',"8585",2 ,684,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'郑',"8586",2 ,722,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'郐',"8587",2 ,760,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'郏',"8588",2 ,798,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'郎',"8589",2 ,836,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'郊',"8590",2 ,874,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'郇',"8591",2 ,912,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'郅',"8592",2 ,950,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'郄',"8593",2 ,0  ,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'郁',"8594",2 ,38 ,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'邾',"8595",2 ,76 ,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'邻',"8596",2 ,114,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'邺',"8597",2 ,152,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'邹',"8598",2 ,190,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'邸',"8599",2 ,228,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'邶',"8600",2 ,266,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'邵',"8601",2 ,304,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'邴',"8602",2 ,342,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'邳',"8603",2 ,380,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'邱',"8604",2 ,418,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'邰',"8605",2 ,456,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'邯',"8606",2 ,494,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'邮',"8607",2 ,532,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'邬',"8608",2 ,570,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'邪',"8609",2 ,608,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'邦',"8610",2 ,646,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'那',"8611",2 ,684,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'邢',"8612",2 ,722,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'邡',"8613",2 ,760,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'邝',"8614",2 ,798,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'邛',"8615",2 ,836,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'邙',"8616",2 ,874,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'邗',"8617",2 ,912,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'邕',"8618",2 ,950,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'邓',"8619",2 ,0  ,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'邑',"8620",2 ,38 ,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'邋',"8621",2 ,76 ,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'邈',"8622",2 ,114,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'邃',"8623",2 ,152,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'邂',"8624",2 ,190,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'邀',"8625",2 ,228,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'避',"8626",2 ,266,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'遽',"8627",2 ,304,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'遵',"8628",2 ,342,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'遴',"8629",2 ,380,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'遮',"8630",2 ,418,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'遭',"8631",2 ,456,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'遨',"8632",2 ,494,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'遥',"8633",2 ,532,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'遣',"8634",2 ,570,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'遢',"8635",2 ,608,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'遛',"8636",2 ,646,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'遘',"8637",2 ,684,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'遗',"8638",2 ,722,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'道',"8639",2 ,760,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'遒',"8640",2 ,798,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'遑',"8641",2 ,836,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'遐',"8642",2 ,874,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'遏',"8643",2 ,912,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'遍',"8644",2 ,950,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'遇',"8645",2 ,0  ,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'遄',"8646",2 ,38 ,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'遂',"8647",2 ,76 ,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'遁',"8648",2 ,114,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'逾',"8649",2 ,152,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'逼',"8650",2 ,190,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'逻',"8651",2 ,228,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'逸',"8652",2 ,266,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'逶',"8653",2 ,304,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'逵',"8654",2 ,342,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'逯',"8655",2 ,380,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'逮',"8656",2 ,418,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'逭',"8657",2 ,456,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'逦',"8658",2 ,494,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'逢',"8659",2 ,532,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'逡',"8660",2 ,570,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'造',"8661",2 ,608,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'速',"8662",2 ,646,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'逞',"8663",2 ,684,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'逝',"8664",2 ,722,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'逛',"8665",2 ,760,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'通',"8666",2 ,798,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'逗',"8667",2 ,836,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'逖',"8668",2 ,874,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'途',"8669",2 ,912,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'递',"8670",2 ,950,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'逑',"8671",2 ,0  ,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'逐',"8672",2 ,38 ,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'透',"8673",2 ,76 ,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'逍',"8674",2 ,114,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'逋',"8675",2 ,152,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'逊',"8676",2 ,190,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'选',"8677",2 ,228,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'逆',"8678",2 ,266,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'逅',"8679",2 ,304,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'逄',"8680",2 ,342,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'逃',"8681",2 ,380,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'适',"8682",2 ,418,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'送',"8683",2 ,456,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'退',"8684",2 ,494,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'追',"8685",2 ,532,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'迹',"8686",2 ,570,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'迸',"8687",2 ,608,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'迷',"8688",2 ,646,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'迳',"8689",2 ,684,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'述',"8690",2 ,722,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'迮',"8691",2 ,760,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'迭',"8692",2 ,798,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'迫',"8693",2 ,836,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'迪',"8694",2 ,874,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'迩',"8695",2 ,912,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'迨',"8696",2 ,950,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'迦',"8697",2 ,0  ,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'迥',"8698",2 ,38 ,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'迤',"8699",2 ,76 ,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'迢',"8700",2 ,114,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'迟',"8701",2 ,152,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'连',"8702",2 ,190,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'违',"8703",2 ,228,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'远',"8704",2 ,266,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'进',"8705",2 ,304,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'这',"8706",2 ,342,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'还',"8707",2 ,380,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'迕',"8708",2 ,418,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'返',"8709",2 ,456,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'迓',"8710",2 ,494,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'近',"8711",2 ,532,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'运',"8712",2 ,570,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'迎',"8713",2 ,608,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'迈',"8714",2 ,646,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'过',"8715",2 ,684,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'迅',"8716",2 ,722,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'迄',"8717",2 ,760,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'迂',"8718",2 ,798,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'迁',"8719",2 ,836,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'达',"8720",2 ,874,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'辽',"8721",2 ,912,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'边',"8722",2 ,950,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'辶',"8723",2 ,0  ,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'辱',"8724",2 ,38 ,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'辰',"8725",2 ,76 ,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'辫',"8726",2 ,114,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'辩',"8727",2 ,152,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'辨',"8728",2 ,190,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'辣',"8729",2 ,228,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'辟',"8730",2 ,266,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'辞',"8731",2 ,304,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'辜',"8732",2 ,342,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'辛',"8733",2 ,380,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'辚',"8734",2 ,418,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'辙',"8735",2 ,456,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'辘',"8736",2 ,494,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'辗',"8737",2 ,532,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'辖',"8738",2 ,570,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'辕',"8739",2 ,608,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'辔',"8740",2 ,646,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'输',"8741",2 ,684,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'辑',"8742",2 ,722,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'辐',"8743",2 ,760,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'辏',"8744",2 ,798,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'辎',"8745",2 ,836,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'辍',"8746",2 ,874,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'辋',"8747",2 ,912,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'辊',"8748",2 ,950,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'辉',"8749",2 ,0  ,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'辈',"8750",2 ,38 ,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'辇',"8751",2 ,76 ,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'辆',"8752",2 ,114,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'辅',"8753",2 ,152,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'辄',"8754",2 ,190,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'较',"8755",2 ,228,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'辂',"8756",2 ,266,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'辁',"8757",2 ,304,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'轿',"8758",2 ,342,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'轾',"8759",2 ,380,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'载',"8760",2 ,418,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'轼',"8761",2 ,456,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'轻',"8762",2 ,494,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'轺',"8763",2 ,532,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'轹',"8764",2 ,570,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'轸',"8765",2 ,608,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'轷',"8766",2 ,646,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'轶',"8767",2 ,684,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'轵',"8768",2 ,722,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'轴',"8769",2 ,760,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'轳',"8770",2 ,798,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'轲',"8771",2 ,836,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'轱',"8772",2 ,874,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'轰',"8773",2 ,912,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'软',"8774",2 ,950,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'轮',"8775",2 ,0  ,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'轭',"8776",2 ,38 ,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'转',"8777",2 ,76 ,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'轫',"8778",2 ,114,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'轩',"8779",2 ,152,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'轨',"8780",2 ,190,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'轧',"8781",2 ,228,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'车',"8782",2 ,266,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'軎',"8783",2 ,304,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'躺',"8784",2 ,342,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'躲',"8785",2 ,380,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'躯',"8786",2 ,418,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'躬',"8787",2 ,456,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'身',"8788",2 ,494,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'躞',"8789",2 ,532,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'躜',"8790",2 ,570,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'躔',"8791",2 ,608,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'躐',"8792",2 ,646,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'躏',"8793",2 ,684,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'躇',"8794",2 ,722,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'躅',"8795",2 ,760,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'躁',"8796",2 ,798,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'蹿',"8797",2 ,836,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'蹼',"8798",2 ,874,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'蹶',"8799",2 ,912,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'蹴',"8800",2 ,950,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'蹲',"8801",2 ,0  ,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'蹰',"8802",2 ,38 ,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'蹯',"8803",2 ,76 ,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'蹭',"8804",2 ,114,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'蹬',"8805",2 ,152,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'蹩',"8806",2 ,190,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'蹦',"8807",2 ,228,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'蹙',"8808",2 ,266,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'蹒',"8809",2 ,304,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'蹑',"8810",2 ,342,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'蹋',"8811",2 ,380,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'蹊',"8812",2 ,418,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'蹉',"8813",2 ,456,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'蹈',"8814",2 ,494,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'蹇',"8815",2 ,532,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'蹄',"8816",2 ,570,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'蹂',"8817",2 ,608,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'蹁',"8818",2 ,646,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'蹀',"8819",2 ,684,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'踽',"8820",2 ,722,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'踺',"8821",2 ,760,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'踹',"8822",2 ,798,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'踵',"8823",2 ,836,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'踱',"8824",2 ,874,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'踯',"8825",2 ,912,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'踮',"8826",2 ,950,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'踬',"8827",2 ,0  ,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'踪',"8828",2 ,38 ,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'踩',"8829",2 ,76 ,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'踣',"8830",2 ,114,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'踢',"8831",2 ,152,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'踟',"8832",2 ,190,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'踞',"8833",2 ,228,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'踝',"8834",2 ,266,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'踔',"8835",2 ,304,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'踏',"8836",2 ,342,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'踌',"8837",2 ,380,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'踊',"8838",2 ,418,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'踉',"8839",2 ,456,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'踅',"8840",2 ,494,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'跽',"8841",2 ,532,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'跻',"8842",2 ,570,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'跺',"8843",2 ,608,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'跹',"8844",2 ,646,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'跸',"8845",2 ,684,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'跷',"8846",2 ,722,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'践',"8847",2 ,760,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'跳',"8848",2 ,798,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'路',"8849",2 ,836,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'跬',"8850",2 ,874,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'跫',"8851",2 ,912,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'跪',"8852",2 ,950,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'跨',"8853",2 ,0  ,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'跤',"8854",2 ,38 ,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'跣',"8855",2 ,76 ,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'跟',"8856",2 ,114,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'跞',"8857",2 ,152,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'距',"8858",2 ,190,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'跛',"8859",2 ,228,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'跚',"8860",2 ,266,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'跗',"8861",2 ,304,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'跖',"8862",2 ,342,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'跑',"8863",2 ,380,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'跏',"8864",2 ,418,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'跎',"8865",2 ,456,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'跌',"8866",2 ,494,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'跋',"8867",2 ,532,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'跆',"8868",2 ,570,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'跄',"8869",2 ,608,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'跃',"8870",2 ,646,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'趿',"8871",2 ,684,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'趾',"8872",2 ,722,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'趼',"8873",2 ,760,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'趺',"8874",2 ,798,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'趸',"8875",2 ,836,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'趵',"8876",2 ,874,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'趴',"8877",2 ,912,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'足',"8878",2 ,950,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'趱',"8879",2 ,0  ,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'趣',"8880",2 ,38 ,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'趟',"8881",2 ,76 ,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'趔',"8882",2 ,114,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'趑',"8883",2 ,152,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'趋',"8884",2 ,190,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'越',"8885",2 ,228,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'超',"8886",2 ,266,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'趄',"8887",2 ,304,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'趁',"8888",2 ,342,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'起',"8889",2 ,380,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'赶',"8890",2 ,418,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'赵',"8891",2 ,456,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'赴',"8892",2 ,494,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'赳',"8893",2 ,532,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'走',"8894",2 ,570,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'赭',"8895",2 ,608,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'赫',"8896",2 ,646,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'赧',"8897",2 ,684,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'赦',"8898",2 ,722,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'赤',"8899",2 ,760,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'赣',"8900",2 ,798,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'赢',"8901",2 ,836,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'赡',"8902",2 ,874,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'赠',"8903",2 ,912,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'赞',"8904",2 ,950,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'赝',"8905",2 ,0  ,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'赜',"8906",2 ,38 ,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'赛',"8907",2 ,76 ,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'赚',"8908",2 ,114,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'赙',"8909",2 ,152,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'赘',"8910",2 ,190,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'赖',"8911",2 ,228,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'赕',"8912",2 ,266,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'赔',"8913",2 ,304,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'赓',"8914",2 ,342,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'赐',"8915",2 ,380,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'赏',"8916",2 ,418,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'赎',"8917",2 ,456,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'赍',"8918",2 ,494,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'赌',"8919",2 ,532,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'赋',"8920",2 ,570,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'赊',"8921",2 ,608,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'赉',"8922",2 ,646,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'赈',"8923",2 ,684,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'赇',"8924",2 ,722,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'赆',"8925",2 ,760,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'赅',"8926",2 ,798,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'资',"8927",2 ,836,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'赃',"8928",2 ,874,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'赂',"8929",2 ,912,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'赁',"8930",2 ,950,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'赀',"8931",2 ,0  ,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'贿',"8932",2 ,38 ,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'贾',"8933",2 ,76 ,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'贽',"8934",2 ,114,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'贼',"8935",2 ,152,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'贻',"8936",2 ,190,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'贺',"8937",2 ,228,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'费',"8938",2 ,266,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'贸',"8939",2 ,304,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'贷',"8940",2 ,342,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'贶',"8941",2 ,380,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'贵',"8942",2 ,418,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'贴',"8943",2 ,456,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'贳',"8944",2 ,494,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'贲',"8945",2 ,532,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'贱',"8946",2 ,570,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'贰',"8947",2 ,608,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'贯',"8948",2 ,646,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'贮',"8949",2 ,684,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'购',"8950",2 ,722,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'贬',"8951",2 ,760,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'贫',"8952",2 ,798,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'贪',"8953",2 ,836,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'贩',"8954",2 ,874,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'质',"8955",2 ,912,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'货',"8956",2 ,950,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'账',"8957",2 ,0  ,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'败',"8958",2 ,38 ,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'贤',"8959",2 ,76 ,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'责',"8960",2 ,114,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'财',"8961",2 ,152,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'贡',"8962",2 ,190,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'负',"8963",2 ,228,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'贞',"8964",2 ,266,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'贝',"8965",2 ,304,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'貘',"8966",2 ,342,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'貔',"8967",2 ,380,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'貌',"8968",2 ,418,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'貊',"8969",2 ,456,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'貉',"8970",2 ,494,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'貅',"8971",2 ,532,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'貂',"8972",2 ,570,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'豺',"8973",2 ,608,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'豹',"8974",2 ,646,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'豸',"8975",2 ,684,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'豳',"8976",2 ,722,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'豫',"8977",2 ,760,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'豪',"8978",2 ,798,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'豢',"8979",2 ,836,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'象',"8980",2 ,874,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'豚',"8981",2 ,912,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'豕',"8982",2 ,950,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'豌',"8983",2 ,0  ,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'豉',"8984",2 ,38 ,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'豇',"8985",2 ,76 ,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'豆',"8986",2 ,114,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'豁',"8987",2 ,152,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'谷',"8988",2 ,190,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'谶',"8989",2 ,228,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'谵',"8990",2 ,266,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'谴',"8991",2 ,304,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'谳',"8992",2 ,342,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'谲',"8993",2 ,380,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'谱',"8994",2 ,418,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'谰',"8995",2 ,456,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'谯',"8996",2 ,494,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'谮',"8997",2 ,532,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'谭',"8998",2 ,570,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'谬',"8999",2 ,608,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'谫',"9000",2 ,646,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'谪',"9001",2 ,684,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'谩',"9002",2 ,722,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'谨',"9003",2 ,760,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'谧',"9004",2 ,798,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'谦',"9005",2 ,836,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'谥',"9006",2 ,874,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'谤',"9007",2 ,912,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'谣',"9008",2 ,950,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'谢',"9009",2 ,0  ,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'谡',"9010",2 ,38 ,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'谠',"9011",2 ,76 ,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'谟',"9012",2 ,114,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'谝',"9013",2 ,152,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'谜',"9014",2 ,190,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'谛',"9015",2 ,228,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'谚',"9016",2 ,266,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'谙',"9017",2 ,304,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'谘',"9018",2 ,342,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'谗',"9019",2 ,380,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'谖',"9020",2 ,418,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'谕',"9021",2 ,456,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'谔',"9022",2 ,494,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'谓',"9023",2 ,532,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'谒',"9024",2 ,570,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'谑',"9025",2 ,608,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'谐',"9026",2 ,646,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'谏',"9027",2 ,684,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'谎',"9028",2 ,722,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'谍',"9029",2 ,760,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'谌',"9030",2 ,798,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'谋',"9031",2 ,836,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'谊',"9032",2 ,874,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'谈',"9033",2 ,912,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'谇',"9034",2 ,950,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'谆',"9035",2 ,0  ,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'谅',"9036",2 ,38 ,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'谄',"9037",2 ,76 ,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'调',"9038",2 ,114,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'谂',"9039",2 ,152,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'谁',"9040",2 ,190,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'谀',"9041",2 ,228,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'诿',"9042",2 ,266,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'课',"9043",2 ,304,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'诽',"9044",2 ,342,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'诼',"9045",2 ,380,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'读',"9046",2 ,418,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'诺',"9047",2 ,456,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'诹',"9048",2 ,494,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'诸',"9049",2 ,532,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'请',"9050",2 ,570,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'诶',"9051",2 ,608,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'诵',"9052",2 ,646,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'说',"9053",2 ,684,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'诳',"9054",2 ,722,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'诲',"9055",2 ,760,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'诱',"9056",2 ,798,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'诰',"9057",2 ,836,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'误',"9058",2 ,874,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'诮',"9059",2 ,912,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-03",1024,'语',"9060",2 ,950,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'龠',"9061",1 ,0  ,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'龟',"9062",1 ,38 ,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'龛',"9063",1 ,76 ,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'龚',"9064",1 ,114,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'龙',"9065",1 ,152,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'龌',"9066",1 ,190,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'龋',"9067",1 ,228,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'龊',"9068",1 ,266,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'龉',"9069",1 ,304,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'龈',"9070",1 ,342,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'龇',"9071",1 ,380,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'龆',"9072",1 ,418,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'龅',"9073",1 ,456,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'龄',"9074",1 ,494,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'龃',"9075",1 ,532,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'龀',"9076",1 ,570,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'齿',"9077",1 ,608,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'齑',"9078",1 ,646,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'齐',"9079",1 ,684,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'齄',"9080",1 ,722,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鼾',"9081",1 ,760,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鼽',"9082",1 ,798,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鼻',"9083",1 ,836,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鼹',"9084",1 ,874,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鼷',"9085",1 ,912,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鼯',"9086",1 ,950,3  ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鼬',"9087",1 ,0  ,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鼢',"9088",1 ,38 ,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鼠',"9089",1 ,76 ,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鼙',"9090",1 ,114,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鼗',"9091",1 ,152,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鼓',"9092",1 ,190,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鼐',"9093",1 ,228,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鼎',"9094",1 ,266,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鼍',"9095",1 ,304,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鼋',"9096",1 ,342,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'黾',"9097",1 ,380,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'黼',"9098",1 ,418,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'黻',"9099",1 ,456,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'黹',"9100",1 ,494,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'黯',"9101",1 ,532,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'黪',"9102",1 ,570,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'黩',"9103",1 ,608,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'黧',"9104",1 ,646,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'黥',"9105",1 ,684,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'黢',"9106",1 ,722,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'黠',"9107",1 ,760,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'黟',"9108",1 ,798,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'黝',"9109",1 ,836,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'黜',"9110",1 ,874,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'黛',"9111",1 ,912,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'默',"9112",1 ,950,40 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'黔',"9113",1 ,0  ,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'黑',"9114",1 ,38 ,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'黏',"9115",1 ,76 ,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'黎',"9116",1 ,114,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'黍',"9117",1 ,152,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'黉',"9118",1 ,190,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'黄',"9119",1 ,228,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'麾',"9120",1 ,266,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'麽',"9121",1 ,304,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'麻',"9122",1 ,342,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'麸',"9123",1 ,380,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'麴',"9124",1 ,418,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'麦',"9125",1 ,456,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'麟',"9126",1 ,494,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'麝',"9127",1 ,532,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'麓',"9128",1 ,570,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'麒',"9129",1 ,608,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'麋',"9130",1 ,646,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'麈',"9131",1 ,684,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'麇',"9132",1 ,722,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'麂',"9133",1 ,760,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鹿',"9134",1 ,798,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鹾',"9135",1 ,836,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鹳',"9136",1 ,874,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鹱',"9137",1 ,912,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鹰',"9138",1 ,950,77 ,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鹭',"9139",1 ,0  ,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鹬',"9140",1 ,38 ,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鹫',"9141",1 ,76 ,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鹪',"9142",1 ,114,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鹩',"9143",1 ,152,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鹨',"9144",1 ,190,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鹧',"9145",1 ,228,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鹦',"9146",1 ,266,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鹤',"9147",1 ,304,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鹣',"9148",1 ,342,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鹞',"9149",1 ,380,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鹜',"9150",1 ,418,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鹛',"9151",1 ,456,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鹚',"9152",1 ,494,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鹘',"9153",1 ,532,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鹗',"9154",1 ,570,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鹕',"9155",1 ,608,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鹑',"9156",1 ,646,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鹏',"9157",1 ,684,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鹎',"9158",1 ,722,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鹌',"9159",1 ,760,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鹋',"9160",1 ,798,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鹊',"9161",1 ,836,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鹉',"9162",1 ,874,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鹈',"9163",1 ,912,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鹇',"9164",1 ,950,114,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鹆',"9165",1 ,0  ,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鹅',"9166",1 ,38 ,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鹄',"9167",1 ,76 ,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鹃',"9168",1 ,114,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鹂',"9169",1 ,152,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鹁',"9170",1 ,190,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鸿',"9171",1 ,228,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鸾',"9172",1 ,266,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鸽',"9173",1 ,304,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鸺',"9174",1 ,342,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鸹',"9175",1 ,380,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鸸',"9176",1 ,418,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鸷',"9177",1 ,456,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鸶',"9178",1 ,494,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鸵',"9179",1 ,532,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鸳',"9180",1 ,570,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鸲',"9181",1 ,608,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鸱',"9182",1 ,646,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鸯',"9183",1 ,684,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鸭',"9184",1 ,722,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鸬',"9185",1 ,760,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鸫',"9186",1 ,798,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鸪',"9187",1 ,836,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鸩',"9188",1 ,874,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鸨',"9189",1 ,912,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鸦',"9190",1 ,950,151,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鸥',"9191",1 ,0  ,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鸣',"9192",1 ,38 ,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鸢',"9193",1 ,76 ,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鸡',"9194",1 ,114,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鸠',"9195",1 ,152,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鸟',"9196",1 ,190,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鳢',"9197",1 ,228,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鳟',"9198",1 ,266,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鳞',"9199",1 ,304,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鳝',"9200",1 ,342,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鳜',"9201",1 ,380,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鳙',"9202",1 ,418,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鳘',"9203",1 ,456,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鳗',"9204",1 ,494,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鳖',"9205",1 ,532,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鳕',"9206",1 ,570,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鳔',"9207",1 ,608,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鳓',"9208",1 ,646,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鳐',"9209",1 ,684,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鳏',"9210",1 ,722,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鳎',"9211",1 ,760,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鳍',"9212",1 ,798,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鳌',"9213",1 ,836,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鳋',"9214",1 ,874,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鳊',"9215",1 ,912,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鳇',"9216",1 ,950,188,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鳆',"9217",1 ,0  ,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鳅',"9218",1 ,38 ,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鳄',"9219",1 ,76 ,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鳃',"9220",1 ,114,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鲽',"9221",1 ,152,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鲼',"9222",1 ,190,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鲻',"9223",1 ,228,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鲺',"9224",1 ,266,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鲸',"9225",1 ,304,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鲷',"9226",1 ,342,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鲶',"9227",1 ,380,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鲵',"9228",1 ,418,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鲴',"9229",1 ,456,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鲳',"9230",1 ,494,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鲲',"9231",1 ,532,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鲱',"9232",1 ,570,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鲰',"9233",1 ,608,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鲮',"9234",1 ,646,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鲭',"9235",1 ,684,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鲫',"9236",1 ,722,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鲩',"9237",1 ,760,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鲨',"9238",1 ,798,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鲧',"9239",1 ,836,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鲦',"9240",1 ,874,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鲥',"9241",1 ,912,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鲤',"9242",1 ,950,225,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鲣',"9243",1 ,0  ,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鲢',"9244",1 ,38 ,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鲡',"9245",1 ,76 ,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鲠',"9246",1 ,114,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鲟',"9247",1 ,152,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鲞',"9248",1 ,190,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鲜',"9249",1 ,228,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鲛',"9250",1 ,266,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鲚',"9251",1 ,304,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鲕',"9252",1 ,342,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鲔',"9253",1 ,380,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鲒',"9254",1 ,418,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鲑',"9255",1 ,456,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鲐',"9256",1 ,494,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鲎',"9257",1 ,532,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鲍',"9258",1 ,570,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鲋',"9259",1 ,608,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鲈',"9260",1 ,646,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鲇',"9261",1 ,684,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鲆',"9262",1 ,722,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鲅',"9263",1 ,760,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鲂',"9264",1 ,798,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鲁',"9265",1 ,836,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鱿',"9266",1 ,874,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鱼',"9267",1 ,912,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'魔',"9268",1 ,950,262,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'魑',"9269",1 ,0  ,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'魏',"9270",1 ,38 ,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'魍',"9271",1 ,76 ,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'魉',"9272",1 ,114,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'魈',"9273",1 ,152,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'魇',"9274",1 ,190,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'魅',"9275",1 ,228,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'魄',"9276",1 ,266,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'魃',"9277",1 ,304,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'魂',"9278",1 ,342,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'魁',"9279",1 ,380,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鬼',"9280",1 ,418,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鬻',"9281",1 ,456,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鬲',"9282",1 ,494,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鬯',"9283",1 ,532,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鬣',"9284",1 ,570,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鬟',"9285",1 ,608,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鬓',"9286",1 ,646,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鬏',"9287",1 ,684,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鬈',"9288",1 ,722,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鬃',"9289",1 ,760,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'髻',"9290",1 ,798,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'髹',"9291",1 ,836,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'髯',"9292",1 ,874,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'髭',"9293",1 ,912,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'髫',"9294",1 ,950,299,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'髦',"9295",1 ,0  ,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'髡',"9296",1 ,38 ,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'髟',"9297",1 ,76 ,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'高',"9298",1 ,114,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'髓',"9299",1 ,152,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'髑',"9300",1 ,190,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'髌',"9301",1 ,228,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'髋',"9302",1 ,266,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'髅',"9303",1 ,304,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'髂',"9304",1 ,342,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'髁',"9305",1 ,380,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'髀',"9306",1 ,418,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'骼',"9307",1 ,456,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'骺',"9308",1 ,494,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'骸',"9309",1 ,532,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'骷',"9310",1 ,570,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'骶',"9311",1 ,608,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'骱',"9312",1 ,646,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'骰',"9313",1 ,684,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'骨',"9314",1 ,722,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'骧',"9315",1 ,760,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'骥',"9316",1 ,798,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'骤',"9317",1 ,836,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'骣',"9318",1 ,874,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'骢',"9319",1 ,912,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'骡',"9320",1 ,950,336,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'骠',"9321",1 ,0  ,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'骟',"9322",1 ,38 ,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'骞',"9323",1 ,76 ,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'骝',"9324",1 ,114,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'骜',"9325",1 ,152,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'骛',"9326",1 ,190,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'骚',"9327",1 ,228,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'骘',"9328",1 ,266,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'骗',"9329",1 ,304,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'骖',"9330",1 ,342,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'骓',"9331",1 ,380,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'骒',"9332",1 ,418,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'骑',"9333",1 ,456,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'骐',"9334",1 ,494,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'骏',"9335",1 ,532,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'验',"9336",1 ,570,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'骋',"9337",1 ,608,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'骊',"9338",1 ,646,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'骈',"9339",1 ,684,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'骇',"9340",1 ,722,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'骆',"9341",1 ,760,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'骅',"9342",1 ,798,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'骄',"9343",1 ,836,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'骂',"9344",1 ,874,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'骁',"9345",1 ,912,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'骀',"9346",1 ,950,373,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'驿',"9347",1 ,0  ,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'驾',"9348",1 ,38 ,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'驽',"9349",1 ,76 ,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'驼',"9350",1 ,114,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'驻',"9351",1 ,152,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'驺',"9352",1 ,190,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'驹',"9353",1 ,228,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'驸',"9354",1 ,266,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'驷',"9355",1 ,304,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'驶',"9356",1 ,342,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'驵',"9357",1 ,380,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'驴',"9358",1 ,418,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'驳',"9359",1 ,456,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'驱',"9360",1 ,494,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'驰',"9361",1 ,532,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'驯',"9362",1 ,570,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'驮',"9363",1 ,608,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'驭',"9364",1 ,646,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'马',"9365",1 ,684,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'馨',"9366",1 ,722,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'馥',"9367",1 ,760,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'香',"9368",1 ,798,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'馘',"9369",1 ,836,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'馗',"9370",1 ,874,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'首',"9371",1 ,912,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'馕',"9372",1 ,950,410,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'馔',"9373",1 ,0  ,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'馓',"9374",1 ,38 ,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'馒',"9375",1 ,76 ,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'馑',"9376",1 ,114,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'馐',"9377",1 ,152,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'馏',"9378",1 ,190,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'馍',"9379",1 ,228,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'馋',"9380",1 ,266,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'馊',"9381",1 ,304,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'馈',"9382",1 ,342,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'馇',"9383",1 ,380,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'馆',"9384",1 ,418,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'馅',"9385",1 ,456,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'馄',"9386",1 ,494,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'馁',"9387",1 ,532,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'馀',"9388",1 ,570,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'饿',"9389",1 ,608,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'饽',"9390",1 ,646,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'饼',"9391",1 ,684,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'饺',"9392",1 ,722,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'饷',"9393",1 ,760,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'饶',"9394",1 ,798,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'饵',"9395",1 ,836,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'饴',"9396",1 ,874,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'饲',"9397",1 ,912,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'饱',"9398",1 ,950,447,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'饰',"9399",1 ,0  ,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'饯',"9400",1 ,38 ,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'饮',"9401",1 ,76 ,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'饭',"9402",1 ,114,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'饬',"9403",1 ,152,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'饫',"9404",1 ,190,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'饪',"9405",1 ,228,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'饩',"9406",1 ,266,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'饨',"9407",1 ,304,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'饧',"9408",1 ,342,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'饥',"9409",1 ,380,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'饣',"9410",1 ,418,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'饕',"9411",1 ,456,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'饔',"9412",1 ,494,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'餮',"9413",1 ,532,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'餐',"9414",1 ,570,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'餍',"9415",1 ,608,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'飨',"9416",1 ,646,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'飧',"9417",1 ,684,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'食',"9418",1 ,722,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'飞',"9419",1 ,760,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'飚',"9420",1 ,798,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'飙',"9421",1 ,836,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'飘',"9422",1 ,874,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'飕',"9423",1 ,912,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'飓',"9424",1 ,950,484,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'飒',"9425",1 ,0  ,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'飑',"9426",1 ,38 ,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'风',"9427",1 ,76 ,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'颧',"9428",1 ,114,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'颦',"9429",1 ,152,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'颥',"9430",1 ,190,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'颤',"9431",1 ,228,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'颢',"9432",1 ,266,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'颡',"9433",1 ,304,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'颠',"9434",1 ,342,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'颟',"9435",1 ,380,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'颞',"9436",1 ,418,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'额',"9437",1 ,456,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'颜',"9438",1 ,494,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'颛',"9439",1 ,532,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'颚',"9440",1 ,570,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'题',"9441",1 ,608,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'颗',"9442",1 ,646,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'颖',"9443",1 ,684,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'颔',"9444",1 ,722,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'颓',"9445",1 ,760,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'频',"9446",1 ,798,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'颐',"9447",1 ,836,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'颏',"9448",1 ,874,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'颍',"9449",1 ,912,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'颌',"9450",1 ,950,521,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'颊',"9451",1 ,0  ,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'颉',"9452",1 ,38 ,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'颈',"9453",1 ,76 ,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'颇',"9454",1 ,114,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'领',"9455",1 ,152,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'颅',"9456",1 ,190,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'预',"9457",1 ,228,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'颃',"9458",1 ,266,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'颂',"9459",1 ,304,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'颁',"9460",1 ,342,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'颀',"9461",1 ,380,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'顿',"9462",1 ,418,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'顾',"9463",1 ,456,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'顽',"9464",1 ,494,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'顼',"9465",1 ,532,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'须',"9466",1 ,570,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'顺',"9467",1 ,608,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'项',"9468",1 ,646,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'顸',"9469",1 ,684,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'顷',"9470",1 ,722,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'顶',"9471",1 ,760,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'页',"9472",1 ,798,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'韶',"9473",1 ,836,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'韵',"9474",1 ,874,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'音',"9475",1 ,912,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'韭',"9476",1 ,950,558,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'韬',"9477",1 ,0  ,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'韫',"9478",1 ,38 ,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'韪',"9479",1 ,76 ,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'韩',"9480",1 ,114,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'韧',"9481",1 ,152,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'韦',"9482",1 ,190,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鞴',"9483",1 ,228,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鞲',"9484",1 ,266,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鞯',"9485",1 ,304,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鞭',"9486",1 ,342,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鞫',"9487",1 ,380,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鞣',"9488",1 ,418,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鞠',"9489",1 ,456,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鞘',"9490",1 ,494,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鞔',"9491",1 ,532,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鞒',"9492",1 ,570,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鞑',"9493",1 ,608,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鞍',"9494",1 ,646,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鞋',"9495",1 ,684,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'鞅',"9496",1 ,722,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'靼',"9497",1 ,760,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'靶',"9498",1 ,798,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'靴',"9499",1 ,836,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'靳',"9500",1 ,874,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'革',"9501",1 ,912,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'靥',"9502",1 ,950,595,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'面',"9503",1 ,0  ,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'靡',"9504",1 ,38 ,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'靠',"9505",1 ,76 ,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'非',"9506",1 ,114,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'靛',"9507",1 ,152,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'静',"9508",1 ,190,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'靖',"9509",1 ,228,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'靓',"9510",1 ,266,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'青',"9511",1 ,304,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'霾',"9512",1 ,342,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'霹',"9513",1 ,380,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'霸',"9514",1 ,418,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'露',"9515",1 ,456,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'霰',"9516",1 ,494,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'霭',"9517",1 ,532,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'霪',"9518",1 ,570,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'霞',"9519",1 ,608,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'霜',"9520",1 ,646,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'霖',"9521",1 ,684,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'霓',"9522",1 ,722,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'霏',"9523",1 ,760,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'霎',"9524",1 ,798,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'霍',"9525",1 ,836,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'霉',"9526",1 ,874,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'霈',"9527",1 ,912,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'震',"9528",1 ,950,632,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'霆',"9529",1 ,0  ,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'霄',"9530",1 ,38 ,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'霁',"9531",1 ,76 ,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'需',"9532",1 ,114,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'雾',"9533",1 ,152,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'雹',"9534",1 ,190,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'雷',"9535",1 ,228,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'零',"9536",1 ,266,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'雳',"9537",1 ,304,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'雯',"9538",1 ,342,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'雪',"9539",1 ,380,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'雩',"9540",1 ,418,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'雨',"9541",1 ,456,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'雠',"9542",1 ,494,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'雕',"9543",1 ,532,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'雒',"9544",1 ,570,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'雏',"9545",1 ,608,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'雎',"9546",1 ,646,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'雍',"9547",1 ,684,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'雌',"9548",1 ,722,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'雉',"9549",1 ,760,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'雇',"9550",1 ,798,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'集',"9551",1 ,836,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'雅',"9552",1 ,874,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'雄',"9553",1 ,912,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'雁',"9554",1 ,950,669,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'雀',"9555",1 ,0  ,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'难',"9556",1 ,38 ,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'隽',"9557",1 ,76 ,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'隼',"9558",1 ,114,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'隹',"9559",1 ,152,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'隶',"9560",1 ,190,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'隳',"9561",1 ,228,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'隰',"9562",1 ,266,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'隧',"9563",1 ,304,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'障',"9564",1 ,342,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'隙',"9565",1 ,380,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'隘',"9566",1 ,418,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'隗',"9567",1 ,456,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'隔',"9568",1 ,494,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'隐',"9569",1 ,532,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'随',"9570",1 ,570,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'隍',"9571",1 ,608,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'隋',"9572",1 ,646,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'隈',"9573",1 ,684,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'隆',"9574",1 ,722,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'隅',"9575",1 ,760,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'陷',"9576",1 ,798,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'陶',"9577",1 ,836,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'陵',"9578",1 ,874,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'陴',"9579",1 ,912,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'陲',"9580",1 ,950,706,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'陬',"9581",1 ,0  ,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'陪',"9582",1 ,38 ,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'险',"9583",1 ,76 ,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'陨',"9584",1 ,114,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'陧',"9585",1 ,152,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'除',"9586",1 ,190,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'院',"9587",1 ,228,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'陡',"9588",1 ,266,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'陟',"9589",1 ,304,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'陛',"9590",1 ,342,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'陕',"9591",1 ,380,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'陔',"9592",1 ,418,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'限',"9593",1 ,456,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'降',"9594",1 ,494,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'陌',"9595",1 ,532,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'陋',"9596",1 ,570,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'陉',"9597",1 ,608,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'陈',"9598",1 ,646,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'陇',"9599",1 ,684,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'陆',"9600",1 ,722,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'际',"9601",1 ,760,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'附',"9602",1 ,798,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'陂',"9603",1 ,836,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'陀',"9604",1 ,874,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'阿',"9605",1 ,912,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'阽',"9606",1 ,950,743,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'阼',"9607",1 ,0  ,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'阻',"9608",1 ,38 ,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'阶',"9609",1 ,76 ,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'阵',"9610",1 ,114,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'阴',"9611",1 ,152,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'阳',"9612",1 ,190,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'防',"9613",1 ,228,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'阱',"9614",1 ,266,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'阮',"9615",1 ,304,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'阪',"9616",1 ,342,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'阢',"9617",1 ,380,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'阡',"9618",1 ,418,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'队',"9619",1 ,456,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'阝',"9620",1 ,494,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'阜',"9621",1 ,532,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'阚',"9622",1 ,570,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'阙',"9623",1 ,608,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'阗',"9624",1 ,646,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'阖',"9625",1 ,684,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'阕',"9626",1 ,722,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'阔',"9627",1 ,760,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'阒',"9628",1 ,798,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'阑',"9629",1 ,836,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'阐',"9630",1 ,874,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'阏',"9631",1 ,912,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'阎',"9632",1 ,950,780,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'阍',"9633",1 ,0  ,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'阌',"9634",1 ,38 ,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'阋',"9635",1 ,76 ,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'阊',"9636",1 ,114,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'阉',"9637",1 ,152,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'阈',"9638",1 ,190,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'阆',"9639",1 ,228,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'阅',"9640",1 ,266,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'阄',"9641",1 ,304,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'阃',"9642",1 ,342,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'阂',"9643",1 ,380,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'阁',"9644",1 ,418,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'阀',"9645",1 ,456,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'闾',"9646",1 ,494,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'闽',"9647",1 ,532,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'闼',"9648",1 ,570,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'闻',"9649",1 ,608,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'闺',"9650",1 ,646,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'闹',"9651",1 ,684,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'闸',"9652",1 ,722,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'闷',"9653",1 ,760,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'闶',"9654",1 ,798,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'闵',"9655",1 ,836,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'间',"9656",1 ,874,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'闳',"9657",1 ,912,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'闲',"9658",1 ,950,817,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'闱',"9659",1 ,0  ,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'闰',"9660",1 ,38 ,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'闯',"9661",1 ,76 ,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'问',"9662",1 ,114,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'闭',"9663",1 ,152,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'闫',"9664",1 ,190,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'闪',"9665",1 ,228,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'闩',"9666",1 ,266,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'门',"9667",1 ,304,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'长',"9668",1 ,342,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'镶',"9669",1 ,380,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'镳',"9670",1 ,418,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'镲',"9671",1 ,456,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'镱',"9672",1 ,494,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'镰',"9673",1 ,532,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'镯',"9674",1 ,570,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'镭',"9675",1 ,608,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'镬',"9676",1 ,646,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'镫',"9677",1 ,684,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'镪',"9678",1 ,722,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'镩',"9679",1 ,760,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'镨',"9680",1 ,798,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'镧',"9681",1 ,836,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'镦',"9682",1 ,874,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'镥',"9683",1 ,912,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'镤',"9684",1 ,950,854,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'镣',"9685",1 ,0  ,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'镢',"9686",1 ,38 ,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'镡',"9687",1 ,76 ,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'镟',"9688",1 ,114,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'镞',"9689",1 ,152,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'镝',"9690",1 ,190,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'镜',"9691",1 ,228,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'镛',"9692",1 ,266,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'镙',"9693",1 ,304,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'镘',"9694",1 ,342,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'镗',"9695",1 ,380,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'镖',"9696",1 ,418,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'镔',"9697",1 ,456,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'镓',"9698",1 ,494,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'镒',"9699",1 ,532,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'镑',"9700",1 ,570,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'镐',"9701",1 ,608,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'镏',"9702",1 ,646,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'镎',"9703",1 ,684,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'镍',"9704",1 ,722,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'镌',"9705",1 ,760,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'镊',"9706",1 ,798,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'镉',"9707",1 ,836,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'镇',"9708",1 ,874,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'镆',"9709",1 ,912,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'镅',"9710",1 ,950,891,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'镄',"9711",1 ,0  ,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'镂',"9712",1 ,38 ,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'镁',"9713",1 ,76 ,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'镀',"9714",1 ,114,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'锿',"9715",1 ,152,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'锾',"9716",1 ,190,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'锼',"9717",1 ,228,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'锻',"9718",1 ,266,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'锺',"9719",1 ,304,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'锹',"9720",1 ,342,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'锸',"9721",1 ,380,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'锷',"9722",1 ,418,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'锶',"9723",1 ,456,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'锵',"9724",1 ,494,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'锴',"9725",1 ,532,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'锲',"9726",1 ,570,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'锱',"9727",1 ,608,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'锰',"9728",1 ,646,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'锯',"9729",1 ,684,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'键',"9730",1 ,722,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'锭',"9731",1 ,760,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'锬',"9732",1 ,798,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'锫',"9733",1 ,836,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'锪',"9734",1 ,874,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'锩',"9735",1 ,912,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'锨',"9736",1 ,950,928,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'锦',"9737",1 ,0  ,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'锥',"9738",1 ,38 ,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'锤',"9739",1 ,76 ,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'锣',"9740",1 ,114,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'锢',"9741",1 ,152,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'锡',"9742",1 ,190,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'锟',"9743",1 ,228,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'锞',"9744",1 ,266,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'锝',"9745",1 ,304,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'锛',"9746",1 ,342,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'锚',"9747",1 ,380,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'错',"9748",1 ,418,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'锘',"9749",1 ,456,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'锗',"9750",1 ,494,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'锖',"9751",1 ,532,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'锕',"9752",1 ,570,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'锔',"9753",1 ,608,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'锓',"9754",1 ,646,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'锒',"9755",1 ,684,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'锑',"9756",1 ,722,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'锐',"9757",1 ,760,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'锏',"9758",1 ,798,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'锎',"9759",1 ,836,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'锍',"9760",1 ,874,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'锌',"9761",1 ,912,965,37,37,33,-1);
TryAddChar("white" ,38,37,23, "BellFontData-02",1024,'锋',"9762",1 ,950,965,37,37,33,-1);

			#endregion


			#region BoxUIDefs
			var defaultdef = new UIDefinition(MyStringId.GetOrCompute("hud_bg_large_default"), 512, 4, 4, 4, 4, readOnly: true);
			
			UIDefinitions.Add(MyStringId.GetOrCompute("Default").Id, defaultdef);

			var nonedef = new UIDefinition();
			nonedef.readOnly = true;
			UIDefinitions.Add(MyStringId.GetOrCompute("None").Id, nonedef);
			var SquareDef = new UIDefinition(MyStringId.GetOrCompute("Square"), 64, 0, 0, 0, 0, 0, 0, true);
			UIDefinitions.Add(MyStringId.GetOrCompute("Square").Id, SquareDef);
			#endregion

			MyAPIGateway.Utilities.ShowMessage("TextHudAPI", "Mod menu is enabled. Open chat and press F2 to access.");
			MyAPIGateway.Utilities.MessageEntered += SuppressMenuMessage;
		}
		#region v2

		enum MessageTypes : int
		{
			HUDMessage = 0,
			BillBoardHUDMessage,
			EntityMessage,
			SpaceMessage,
			BillboardTriHUDMessage,

			MenuItem = 20,
			MenuSubCategoryItem,
			MenuRootCategoryItem,
			MenuScreenInputItem,
			MenuSliderItem,
			MenuTextItem,
			MenuKeybindItem,
			MenuColorPickerItem,

			BoxUIContainer = 40,
			BoxUIText,
			BoxUIImage,

			UIDefinition = 60,
			UIBehaviour

		}

		long id = 0;
		private enum APIinfoMembers : int
		{
			ScreenPositionOnePX = 1000,
            GetBoxUIDefinition = 1002,
			GetBoxUIBehaviour,
			GetFontDefinition,
			GetFonts,
			GetDialog
		}

		private enum RegistrationEnum : int
		{
			OnScreenUpdate = 2000
		}
		private void RemoveMsg(object arg2)
		{
			if(arg2 is ModMessageBase)
			{
				var Msg = (ModMessageBase)arg2;
				Msg.MarkForClose();
			}
		}

		private object GetMember(object arg2, int arg3)
		{

			switch ((APIinfoMembers)arg3)
			{
				case APIinfoMembers.ScreenPositionOnePX:
					return new Vector2D(m_xSPPix, m_ySPPix);
				case APIinfoMembers.GetBoxUIDefinition:
					UIDefinition value;
					if (UIDefinitions.TryGetValue(((MyStringId)arg2).Id, out value))
						return value;
					else
						return null;
				case APIinfoMembers.GetBoxUIBehaviour:
					UIBehaviourDefinition behaviourdef;
					if (UIBehaviours.TryGetValue(((MyStringId)arg2).Id , out behaviourdef))
						return behaviourdef;
					return null;
				case APIinfoMembers.GetFontDefinition:
					return GetFont((MyStringId)arg2);
				case APIinfoMembers.GetFonts:
					List<MyStringId> collection = (List<MyStringId>)arg2;
					if (collection == null)
						collection = new List<MyStringId>();
					foreach(var font in FontDefinitions)
					{
						if(font.Value.Valid)
							collection.Add(font.Value.fontname);
					}
					return null;
				case APIinfoMembers.GetDialog:
					switch((APIDialogs)arg2)
					{
						case APIDialogs.ColorPickerDialog:
							return ColorPickerDialogDelegate;
						case APIDialogs.KeybindDialog:
							return KeybindDialogDelegate;
						case APIDialogs.ScreenInputDialog:
							return ScreenInputDialogDelegate;
						case APIDialogs.SliderDialog:
							return SliderDialogDelegate;
						case APIDialogs.TextDialog:
							return TextDialogDelegate;
					}
					return null;
			}

			if(arg2 is iTextHUDAPI)
			{
				var Msg = (iTextHUDAPI)arg2;
				return Msg.GetMember(arg3);
			}
			return null;
		}
		private void SetMember(object arg2, int arg3, object arg4)
		{
			switch((RegistrationEnum)arg3)
			{
				case RegistrationEnum.OnScreenUpdate:
					OnInvalidateCache += ((MyTuple<Action>)arg4).Item1;
					return;
				default:
					if (arg2 is iTextHUDAPI)
					{
						var Msg = (iTextHUDAPI)arg2;
						Msg.SetMember(arg3, arg4);
					}
					break;
			}
		}
		private object Factory(int arg2)
		{
			ModMessageBase Adder = null;
			switch((MessageTypes)arg2)
			{
				case MessageTypes.HUDMessage:
					Adder = new ModHUDMessage();
					break;
				case MessageTypes.BillBoardHUDMessage:
					Adder = new ModBillboardHUDMessage();
					break;
				case MessageTypes.SpaceMessage:
					Adder = new ModSpaceMessage();
					break;
				case MessageTypes.EntityMessage:
					Adder = new ModEntityMessage();
					break;
				case MessageTypes.BillboardTriHUDMessage:
					Adder = new ModBillboardTriHUDMessage();
					break;

				case MessageTypes.MenuItem:
					return new MenuItem();
				case MessageTypes.MenuSubCategoryItem:
					return new MenuSubCategory();
				case MessageTypes.MenuRootCategoryItem:
					return new MenuRootCategory(ModScrollboxEsc, ModScrollboxF11);
				case MessageTypes.MenuKeybindItem:
					return new MenuKeybindItem();
				case MessageTypes.MenuScreenInputItem:
					return new MenuScreenInput();
				case MessageTypes.MenuSliderItem:
					return new MenuSliderItem();
				case MessageTypes.MenuTextItem:
					return new MenuTextInput();
				case MessageTypes.MenuColorPickerItem:
					return new MenuColorPicker();
				case MessageTypes.BoxUIContainer:
					return new BoxUIContainer();

				case MessageTypes.BoxUIImage:
					return new BoxUIImage();

				case MessageTypes.BoxUIText:
					return new BoxUIText();

				case MessageTypes.UIDefinition:
					return new UIDefinition();
				case MessageTypes.UIBehaviour:
					return new UIBehaviourDefinition();
            }
			if(Adder != null)
			{
				ModMessageDictionary.Add(Adder);
				return Adder;
            }
			return null;
		}
		HudButton EscMenuButton, F11MenuButton;
		HudMenuScrollBox ModScrollboxEsc, ModScrollboxF11;
		bool initmenu = false;

		private void BuildEscMenu()
		{
			EscMenuButton = new HudButton(Vector2D.Zero, true, EscMenu, text: "Mod Settings", rightspacing: 10, padding: 10);
			ModScrollboxEsc = new HudMenuScrollBox(Vector2D.Zero, false, EscMenuButton, headerText: "Mods", rightpadding: 10);
			F11MenuButton = new HudButton(Vector2D.Zero, true, F11Menu, text: "Mod Settings", rightspacing: 10, padding: 10);
			ModScrollboxF11 = new HudMenuScrollBox(Vector2D.Zero, false, F11MenuButton, headerText: "Mods", rightpadding: 10);
			cursor.Material = MyStringId.GetOrCompute("MouseCursor");
			cursor.Scale = 1;
			cursor.Height = (float)FontTexture.xSPPix * 20f;
			cursor.Width = cursor.Height;
			cursor.Visible = true;
			cursor.Options = Messagesv2.Options.Fixed;
			cursor.Blend = BlendTypeEnum.PostPP;
		}

		private static DialogBox ActiveDialog;
		private static KeybindInputDialog kiDiag = new KeybindInputDialog();
		private static ScreenInputDialog siDiag = new ScreenInputDialog();
		private static SliderDialog slDiag = new SliderDialog();
		private static TextInputDialog txDiag = new TextInputDialog();
		private static ColorPickerDialog cpDiag = new ColorPickerDialog();
		private ModBillboardHUDMessage cursor = new ModBillboardHUDMessage();

		private enum APIDialogs : int
		{
			ColorPickerDialog = 1100,
			TextDialog,
			KeybindDialog,
			ScreenInputDialog,
			SliderDialog
		}
		static Func<StringBuilder, Color, Action<Color>, Action<Color>, Action, bool, bool, bool> ColorPickerDialogDelegate = PromoteColorPickerDialog;

		public static bool PromoteColorPickerDialog(StringBuilder Title, Color InitialColor, Action<Color> callback, Action<Color> update, Action onCancel, bool showAlpha, bool usehsv = false)
		{
			if (hudHidden)
				return false;
			if (ActiveDialog == null)
			{
				//MyAPIGateway.Utilities.ShowMessage("PromoteColorPickerDialog", InitialColor.ToString());
				cpDiag.Request(Title, InitialColor, callback, update, onCancel, showAlpha, usehsv);
				ActiveDialog = cpDiag;
				return true;
			}
			return false;
		}
		static Func<Action<string>, StringBuilder, bool> TextDialogDelegate = PromoteTextDialog;
		public static bool PromoteTextDialog(Action<string> callback, StringBuilder Title)
		{
			if (hudHidden)
				return false;
			if (ActiveDialog == null)
			{
				txDiag.Request(Title, callback);
				ActiveDialog = txDiag;
				return true;
			}
			return false;
		}
		static Func<Action<MyKeys, bool, bool, bool>, StringBuilder, bool> KeybindDialogDelegate = PromoteKeybindDialog;
		public static bool PromoteKeybindDialog(Action<MyKeys, bool, bool, bool> callback, StringBuilder Title)
		{
			if (hudHidden)
				return false;
			if (ActiveDialog == null)
			{
				kiDiag.Request(Title, callback);
				ActiveDialog = kiDiag;
				return true;
			}
			return false;
		}
		static Func<StringBuilder, Vector2D, Vector2D, Action<Vector2D>, Action<Vector2D>, Action, bool> ScreenInputDialogDelegate = PromoteScreenInputDialog;
		public static bool PromoteScreenInputDialog(StringBuilder title, Vector2D origin, Vector2D size, Action<Vector2D> callback, Action<Vector2D> update, Action onCancel)
		{
			if (hudHidden)
				return false;
			if (ActiveDialog == null)
			{
				siDiag.Request(title, origin, size, callback, update, onCancel);
				ActiveDialog = siDiag;
				return true;
			}
			return false;

		}
		static Func<StringBuilder, Action<float>, float, Func<float, object>, Action, bool> SliderDialogDelegate = PromoteSliderDialog;
		static public bool PromoteSliderDialog(StringBuilder title, Action<float> callback, float initialvalue, Func<float, object> SliderPercentToValue, Action OnCancel)
		{
			if (hudHidden)
				return false;
			if(ActiveDialog == null)
			{
				slDiag.Request(title, callback, initialvalue, SliderPercentToValue, OnCancel);
				ActiveDialog = slDiag;
				return true;
			}
			return false;
		}

		private List<MyKeys> keys = new List<MyKeys>();
		bool AdminMenuActive = false;
		bool PlayerMenuActive = false;
		private void SuppressMenuMessage(string messageText, ref bool sendToOthers)
		{
			//if (PlayerMenuActive)
			//{
				
			if (ActiveDialog != null)
			{
				sendToOthers = false;
				ActiveDialog.Confirm();
			}
			//}
		}

		private void ResetCursor()
		{
			if(cursor != null)
			{
				cursor.Scale = 1;
				cursor.Height = (float)FontTexture.xPix * 250f;
				cursor.Width = cursor.Height;
			}
		}

		private bool DialogProcess()
		{

			if (!AdminMenuActive)
			{
				if (MyAPIGateway.Input.IsNewKeyReleased(VRage.Input.MyKeys.F10))
				{
					if (MyAPIGateway.Input.IsAnyAltKeyPressed())
					{
						AdminMenuActive = true;
						if(adminmenudirty)
						{
							adminmenudirty = false;
							F11Menu.Refresh();
							
						}
						if (PlayerMenuActive)
							EscMenu.OnMouseRelease(Vector2D.Zero);
						PlayerMenuActive = false;
					}
				}
			}
			else
			{
				if (MyAPIGateway.Gui.IsCursorVisible == false)
				{
					F11Menu.OnMouseRelease(Vector2D.Zero);
					AdminMenuActive = false;
				}

            }

			if(!PlayerMenuActive && !AdminMenuActive)
			{
				if (MyAPIGateway.Input.IsNewKeyReleased(MyKeys.F2) && MyAPIGateway.Gui.ChatEntryVisible)
				{
					PlayerMenuActive = true;
					if(playermenudirty )
					{
						playermenudirty = false;
                        EscMenu.Refresh();
					}
				}
			}
			if(PlayerMenuActive)
			{
				if (!MyAPIGateway.Gui.ChatEntryVisible)
				{
					EscMenu.OnMouseRelease(Vector2D.Zero);
					PlayerMenuActive = false;
				}
					
			}

			if (MyAPIGateway.Input.IsNewKeyReleased(VRage.Input.MyKeys.Escape))
			{
				if (AdminMenuActive)
					F11Menu.OnMouseRelease(Vector2D.Zero);
				AdminMenuActive = false;
				if (PlayerMenuActive)
					EscMenu.OnMouseRelease(Vector2D.Zero);
				PlayerMenuActive = false;
				if(ActiveDialog != null)
				{
					ActiveDialog.Cancel();
				}
            }
			if (MyAPIGateway.Input.IsNewKeyReleased(VRage.Input.MyKeys.Enter))
			{
				if (AdminMenuActive)
					F11Menu.OnMouseRelease(Vector2D.Zero);
				AdminMenuActive = false;
				if (PlayerMenuActive)
					EscMenu.OnMouseRelease(Vector2D.Zero);
				PlayerMenuActive = false;
				if (ActiveDialog != null)
				{
					ActiveDialog.Confirm();
				}
			}

			//float x = MyAPIGateway.Session?.Config?.ScreenWidth ?? MyAPIGateway.Session.Camera.ViewportSize.X;
			//float y = MyAPIGateway.Session?.Config?.ScreenHeight ?? MyAPIGateway.Session.Camera.ViewportSize.Y;
			var pos = MyAPIGateway.Input.GetMousePosition();
			var mousearea = MyAPIGateway.Input.GetMouseAreaSize();
			
			var X = ((double)(pos.X / mousearea.X) - 0.5d) * 2d;
			var Y = ((double)(pos.Y / mousearea.Y) - 0.5d) * -2d;
			Vector2D mousePostion = new Vector2D(X, Y);


			if (ActiveDialog != null)
			{
				ActiveDialog.onTextInput(MyAPIGateway.Input.TextInput);
				ActiveDialog.onMouseOver(mousePostion);
				ActiveDialog.onClick(mousePostion, MyAPIGateway.Input.IsNewLeftMousePressed(), MyAPIGateway.Input.IsNewRightMousePressed());
				ActiveDialog.onMouseRelease(mousePostion, MyAPIGateway.Input.IsNewLeftMouseReleased(), MyAPIGateway.Input.IsNewRightMouseReleased());
				MyAPIGateway.Input.GetListOfPressedKeys(keys);
				ActiveDialog.onKeyPress(keys);

				if (ActiveDialog.Active == false)
				{

					ActiveDialog = null;
				}
				else
				{
					ActiveDialog.Draw();
					if (PlayerMenuActive)
					{
						cursor.Origin = mousePostion;
						cursor.Draw();
					}

					return true;
				}
			}
			else if (AdminMenuActive)
			{
				//temp
				//cursor.Origin = mousePostion;
				//cursor.Draw();
				F11Menu.OnMouseOver(mousePostion);
				if (MyAPIGateway.Input.IsNewLeftMousePressed())
				{
					F11Menu.OnClick(mousePostion);
				}

				if(MyAPIGateway.Input.IsNewLeftMouseReleased())
				{
					F11Menu.OnMouseRelease(mousePostion);
				}
				F11Menu.Draw();
				return F11Menu.IsActive;
			}
			else if (PlayerMenuActive)
			{
				if (MyAPIGateway.Input.IsNewLeftMousePressed())
				{
					EscMenu.OnClick(mousePostion);
				}

				if (MyAPIGateway.Input.IsNewLeftMouseReleased())
				{
					EscMenu.OnMouseRelease(mousePostion);
				}
				EscMenu.Draw();

				cursor.Origin = mousePostion;
				cursor.Draw();
				EscMenu.OnMouseOver(mousePostion);

				return EscMenu.IsActive;
			}


			return true; //draw elements
		}
		private void Updatev2()
		{


			if (MyAPIGateway.Session?.Camera == null)
				return;

			for (int i = 0; i < ModMessageDictionary.Count; i++)
			{
				var Msg = ModMessageDictionary[i];
				if (Msg.TimeToLive > 0)
				{
					Msg.TimeToLive--;
				}

				if (Msg.TimeToLive == 0)
				{
					Msg.MarkForClose();
				}
				if (Msg.MarkedForClose)
				{
					ModMessageDictionary.RemoveAt(i--);
				}
				else
				{
					if (Msg.Visible && !Msg.m_HasParent)
						Msg.Draw();
				}
			}
		}

		#endregion


		internal void Close()
		{

			foreach(var item in ModMessageDictionary)
			{
				item.MarkForClose();
				item.Close();
			}
			ModMessageDictionary.Clear();
			OnInvalidateCache = null;//clear
			EscMenu.Clear();
			F11Menu.Clear();
			EscMenu = null;
			F11Menu = null;
			VersionHelper.Close();
            if (instance == this)
				instance = null;
			MyAPIGateway.Utilities.MessageEntered -= SuppressMenuMessage;
		}


		MyTuple<Func<int, object>, Action<object, int, object>, Func<object, int, object>, Action<object>> Methods1;
		Action OnInvalidateCache;
		//MyTuple<Func<int, object>, Action<object, int, object>, Func<object, int, object>, Action<object>, Func<object, int, object, object>> Methods2;
		bool init = false;
		float oldX = 0f;
		float oldY = 0f;
		bool adminmenudirty = false, playermenudirty = false;

		public static void PlayHudMouseOver()
		{
			if(instance?.HudHighlightSound != null)
			{
				instance.HudHighlightSound.PlaySingleSound(instance.HudHighlightSound.SoundId);
			}
		}
		public static void PlayMouseClick()
		{
			if(instance?.ClickSound != null)
			{
				instance.ClickSound.PlaySingleSound(instance.ClickSound.SoundId);
			}
		}
		//public delegate void Send<T, U>(T obj, int flag, U value);

		internal void Update()
		{
			VersionHelper.StartRender();
			var oldAspectRatio = aspectRatio;
			var oldFov = fov;
			var viewx = MyAPIGateway.Session.Camera.ViewportSize.X;
			var viewy = MyAPIGateway.Session.Camera.ViewportSize.Y;
            aspectRatio = viewx / viewy;
			//MyAPIGateway.Utilities.ShowNotification(viewx.ToString());
			//MyAPIGateway.Utilities.ShowNotification(viewy.ToString());
			fov = MyAPIGateway.Session.Camera.FovWithZoom;
			projectionNormal = (Vector3)MyAPIGateway.Session.Camera.ViewMatrix.Forward;
			ResetCursor();
			if (oldAspectRatio != aspectRatio || oldFov != fov || oldX != viewx || oldY != viewy)
			{
				oldX = viewx;
				oldY = viewy;
				InvalidateCache = true;
				adminmenudirty = true;
				playermenudirty = true;
                if (OnInvalidateCache != null)
					OnInvalidateCache();
			}
			if (!initmenu)
			{
				BuildEscMenu();

				initmenu = true;
			}
			heartbeatsend++;
			if(heartbeatsend >= 300)
			{
				heartbeatsend = 0;

				if(!init)
				{
					init = true;
					Methods1 = new MyTuple<Func<int, object>, Action<object, int, object>, Func<object, int, object>, Action<object>>(Factory, SetMember, GetMember, RemoveMsg);

				}
				

				//MyAPIGateway.Utilities.SendModMessage(REGISTRATIONID, get);
				MyAPIGateway.Utilities.SendModMessage(REGISTRATIONID, Methods1);

			}
			try
			{
				if (MyAPIGateway.Input.IsNewGameControlPressed(MyControlsSpace.TOGGLE_HUD))
					hudHidden = MyAPIGateway.Session?.Config?.MinimalHud ?? false;
				HudUiProcess();
				Updatev2();
				if (!hudHidden)
				{
					DialogProcess();
					//HudUiProcess();
                }




			}
			catch (Exception ex)
			{
				
				if(errorcount < 20)
				{
					errorcount++;
					MyLog.Default.WriteLineAndConsole("===== Exception in TextHudAPI =====");
					MyLog.Default.WriteLineAndConsole(ex.Message);
					MyLog.Default.WriteLineAndConsole(ex.StackTrace);
					if(errorcount == 20)
					{
						MyLog.Default.WriteLineAndConsole("===== TextHudAPI is now suppressing any further error messages due to too many errors =====");
					}
				}
			


				//ModUI.Debug.Message.AppendLine(ex.Message);
				//ModUI.Debug.Message.AppendLine(ex.StackTrace);
			}
			InvalidateCache = false;
			VersionHelper.EndRender();
		}
		bool uiInit = false;
		private void HudUiProcess()
		{
			if(!uiInit)
			{
				uiInit = true;
				var def = UIDefinitions[MyStringId.GetOrCompute("None").Id];
                RootUi = new BoxUIRoot();
				RootUi.SetDefinition(def);
				RootUi.SetBehaviour(new UIBehaviourDefinition());
				RootUi.UpdateHW((int)MyAPIGateway.Session.Camera.ViewportSize.X, (int)MyAPIGateway.Session.Camera.ViewportSize.Y);
				RootUi.SetPosition(0, 0);
				RootUi.hideHud = false;
				RootUi.visible = true;
				BoxUIRoot.RootObject = RootUi;


				HudHighlightSound = new MyEntity3DSoundEmitter(null);
				HudHighlightSound.SoundId = MySoundPair.GetCueId("HudMouseOver");
				HudHighlightSound.Force2D = true;
				ClickSound = new MyEntity3DSoundEmitter(null);
				ClickSound.SoundId = MySoundPair.GetCueId("HudMouseClick");
				ClickSound.Force2D = true;
			}


			RootUi.UpdateHW((int)MyAPIGateway.Session.Camera.ViewportSize.X, (int)MyAPIGateway.Session.Camera.ViewportSize.Y);
			RootUi.Draw(hudHidden);
		}

		public static bool InvalidateCache = false;



		private bool TryAddChar(string name, int fontbase, int lineheight, int fontsize, string material, int texturesize, char character, string charctercode, int bm,  int uv1x, int uv1y, int sizex, int sizey, int aw, int lsb, bool forcewhite = false)
		{
			//Dictionary<char, FontMatrix> FontDict;
			MyStringId id = MyStringId.GetOrCompute(name);
			FontDefinition FontDef;
			if(!FontDefinitions.TryGetValue(id.Id, out FontDef))
			{
				FontDef = new FontDefinition();
				FontDef.Lineheight = lineheight;
				FontDef.Fontbase = fontbase;
				FontDef.Fontsize = fontsize;
				FontDef.fontname = id;
				FontDef.ReadOnly = true;
				FontDefinitions.Add(id.Id, FontDef);
			}
			var ret = FontDef.TryAddCharacter(character, MyStringId.GetOrCompute(material), texturesize, charctercode, uv1x, uv1y, sizex, sizey, aw, lsb, forcewhite);
			if (ret == true)
				InvalidateCache = true;
			return ret;
		}
	}
}
