﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using UIFun.Definition;
using UIFun.Messagesv2;
using VRageMath;

namespace Draygo.TextHUDAPI.BoxUI
{
	public class BoxUIImage : BoxUIRoot
	{
		enum BoxUIImageMembers : int
		{
			SetImageContent = 100
		}
		public BoxUIImage()
		{

		}
		public override void Draw(bool hudhidden)
		{
			if (hideHud && hudhidden)
				return;
			if (!visible)
				return;
			if (Content != null)
			{
				var screenpos = this.ContentTopLeftCorner();
				var content = Content as ModBillboardHUDMessage;
				content.Options |= Options.Pixel;
				
				content.Origin = new Vector2D(screenpos.X, screenpos.Y);
			}
			base.Draw(hudhidden);
		}

		public override object GetMember(int MemberEnum)
		{
			return base.GetMember(MemberEnum);
		}

		public override void SetMember(int MemberEnum, object Value)
		{
			switch((BoxUIImageMembers)MemberEnum)
			{
				case BoxUIImageMembers.SetImageContent:
					if (Content != null)
						Content.m_HasParent = false;
					Content = (ModBillboardHUDMessage)Value;
					Content.m_HasParent = true;
					return;
				default:
					base.SetMember(MemberEnum, Value);
					return;
			}
			
		}
	}
}
