private void Dispatch(MyCubeGrid.UpdateQueue queue, bool parallel = false)
{
  bool flag = queue.IsExecutedOnce();
  
  List<MyCubeGrid.Update> updateList = this.BeginUpdate(queue);
  
  int num = 0;
  int par = 0;
  
  int cnt = updateList.Count;
  for (int index = 0; index < cnt; ++index)
  {
	MyCubeGrid.Update u = updateList[index];
	var isParallel = u.Parallel == parallel;
	
	if (isParallel && !u.Removed)
	  this.Invoke(in u, queue);
  
	if (u.Removed || flag && isParallel)
	{
	  ++num;
	  if (isParallel)
	    par++;
	}
	else if (num > 0)
	{
	  updateList[index - num] = u;
	  updateList[index] = MyCubeGrid.Update.Empty;
	}
  }

  if (num != 0) {
    if (par > 0)  
	  Interlocked.Add(ref this.m_totalQueuedParallelUpdates, -par);
	
    if (num > par)
      Interlocked.Add(ref this.m_totalQueuedSynchronousUpdates, -(num - par));
  
    updateList.RemoveAt(cnt - num, num);
  }
  
  this.EndUpdate();
}