private void Dispatch(MyCubeGrid.UpdateQueue queue, bool parallel = false)
{
  bool flag = queue.IsExecutedOnce();
  List<MyCubeGrid.Update> updateList = this.BeginUpdate(queue);
  int num = 0;
  for (int index = 0; index < updateList.Count; ++index)
  {
	MyCubeGrid.Update u = updateList[index];
	if (!u.Removed && u.Parallel == parallel)
	  this.Invoke(in u, queue);
	if (u.Removed || flag && u.Parallel == parallel)
	{
	  ++num;
	  if (u.Parallel)
		Interlocked.Decrement(ref this.m_totalQueuedParallelUpdates);
	  else
		Interlocked.Decrement(ref this.m_totalQueuedSynchronousUpdates);
	}
	else if (num > 0)
	{
	  updateList[index - num] = u;
	  updateList[index] = new MyCubeGrid.Update();
	}
  }
  while (num-- > 0)
	updateList.RemoveAt(updateList.Count - 1);
  this.EndUpdate();
}