﻿/*
 * R e a d m e
 * -----------
 * 
 * In this file you can include any instructions or other comments you want to have injected onto the 
 * top of your final script. You can safely delete this file if you do not want any such comments.
 */

//
// Go to:
// https://github.com/malware-dev/MDK-SE/wiki/Quick-Introduction-to-Space-Engineers-Ingame-Scripts
//
// to learn more about ingame scripts.

IMyTextPanel lcdSurface;
IMyTextPanel wideSurface;
IMyTextPanel dnskSurface;
IMyTextPanel lcdSurface2;
IMyTextPanel dnskSurface2;
IMyTextSurface debug;

public Program()
{
    lcdSurface = (IMyTextPanel)GridTerminalSystem.GetBlockWithName("Sprite LCD");
    wideSurface = (IMyTextPanel)GridTerminalSystem.GetBlockWithName("Wide LCD");
    dnskSurface = (IMyTextPanel)GridTerminalSystem.GetBlockWithName("DNSK LCD");
    lcdSurface2 = (IMyTextPanel)GridTerminalSystem.GetBlockWithName("LCD Panel 2");
    dnskSurface2 = (IMyTextPanel)GridTerminalSystem.GetBlockWithName("DNSK LCD 2");
    debug = (IMyTextSurface)GridTerminalSystem.GetBlockWithName("Debug LCD");

    IMyEntity entity = lcdSurface;
    debug.WriteText($"Normal LCD: {lcdSurface.DisplayNameText}, Name: {entity.Name}, Display Name: {entity.DisplayName}, Block Def: {lcdSurface.BlockDefinition}, Def DisplayName: {lcdSurface.DefinitionDisplayNameText}\n", false);
    debug.WriteText($"----  CustomName: {lcdSurface.CustomName}, DetailedInfo: {lcdSurface.DetailedInfo}, CustomInfo: {lcdSurface.CustomInfo}\n\n\n", true);

    entity = wideSurface;
    debug.WriteText($"Wide LCD: {wideSurface.DisplayNameText}, Name: {entity.Name}, Display Name: {entity.DisplayName}, Block Def: {wideSurface.BlockDefinition}, Def DisplayName: {wideSurface.DefinitionDisplayNameText}\n", true);
    debug.WriteText($"----  CustomName: {wideSurface.CustomName}, DetailedInfo: {wideSurface.DetailedInfo}, CustomInfo: {wideSurface.CustomInfo}\n\n\n", true);

    Runtime.UpdateFrequency = UpdateFrequency.Once;

    return;
}

public void Main(string argument, UpdateType updateSource)
{
    var indent = new Vector2(40.0F, 40.0F);
    spriteSample(lcdSurface, indent);
    spriteSample(wideSurface, indent);
    spriteSample(dnskSurface, indent);

    indent = new Vector2(160.0F, 40.0F);
    spriteSample(dnskSurface2, indent);
    spriteSample(lcdSurface2, indent);

    return;
}

private void spriteSample( IMyTextPanel drawSurface, Vector2 baseIndent )
{
    var viewport = new RectangleF(( drawSurface.TextureSize - drawSurface.SurfaceSize ) / 2.0F, drawSurface.SurfaceSize);

    debug.WriteText($"\n\nWorking with surface {drawSurface.DisplayNameText}\n", true);
    debug.WriteText($"Texture size:  {drawSurface.TextureSize}, Surface size: {drawSurface.SurfaceSize}\n", true);
    debug.WriteText($"Viewport posit:  {viewport.Position}, right: {viewport.Right}, bottom: {viewport.Bottom}, center: {viewport.Center}\n", true);
    debug.WriteText($"Viewport size: {viewport.Size}, height: {viewport.Height}, width: {viewport.Width}, X: {viewport.X}, Y: {viewport.Y}\n", true);

    var frame = drawSurface.DrawFrame();

    var colOffset = new Vector2(125.0F, 12.0F);
    var rowOffset = new Vector2(0.0F, 25.0F);
    var circleSize = new Vector2(12.0F, 12.0F);

    var posit = baseIndent + viewport.Position;
    debug.WriteText($"Sprite 1 posit: {posit}\n", true );

    var sprite = new MySprite()
    {
        Type = SpriteType.TEXT,
        Data = "Short Text String",
        Position = posit,
        RotationOrScale = 0.75F,
        Color = Color.White,
        Alignment = TextAlignment.RIGHT,
        FontId = "White"
    };

    frame.Add(sprite);

    var posit2 =  posit + colOffset;
    debug.WriteText($"Sprite 2 posit: {posit2}\n", true);

    sprite = new MySprite()
    {
        Type = SpriteType.TEXTURE,
        Data = "Circle",
        Position = posit2,
        Size = circleSize,
        Color = Color.Red,
        Alignment = TextAlignment.CENTER,

    };

    frame.Add(sprite);
    posit2 = posit + rowOffset;
    debug.WriteText($"Row 2 sprite 1 posit: {posit2}", true);

    sprite = new MySprite()
    {
        Type = SpriteType.TEXT,
        Data = "Right Medium Length Text String",
        Position = posit2,
        RotationOrScale = 0.75F,
        Color = Color.White,
        Alignment = TextAlignment.RIGHT,
        FontId = "White"
    };

    frame.Add(sprite);
    posit2 += colOffset;
    debug.WriteText($"Row 2 sprite 2 posit: {posit2}\n", true);

    sprite = new MySprite()
    {
        Type = SpriteType.TEXTURE,
        Data = "Circle",
        Position = posit2,
        Size = circleSize,
        Color = Color.Yellow,
        Alignment = TextAlignment.CENTER,
    };

    frame.Add(sprite);

    posit2 = posit + rowOffset + rowOffset;
    debug.WriteText($"Row 3 sprite 1 posit: {posit2}\n", true);

    sprite = new MySprite()
    {
        Type = SpriteType.TEXT,
        Data = "Left Medium Length Text String",
        Position = posit2,
        RotationOrScale = 0.75F,
        Color = Color.White,
        Alignment = TextAlignment.LEFT,
        FontId = "White"
    };

    frame.Add(sprite);

    posit2 += rowOffset;
    debug.WriteText($"Row 4 sprite 1 posit: {posit2}\n", true);
    sprite = new MySprite()
    {
        Type = SpriteType.TEXT,
        Data = "1ABCDEFGHIJKLMNOPQRSTUVWXYZ2ABCDEFGHIJKLMNOPQRSTUVWXYZ3ABCDEFGHIJKLMNOPQRSTUVWXYZ",
        Position = posit2,
        RotationOrScale = 0.75F,
        Color = Color.White,
        Alignment = TextAlignment.RIGHT,
        FontId = "White"
    };

    frame.Add(sprite);

    debug.WriteText("Pushing sprites to LCD\n", true);
    frame.Dispose();
    /*
            StringBuilder tst = new StringBuilder("Water inventory:     1497.2 of 1500.0 target");
            var msgSize = drawSurface.MeasureStringInPixels(tst, "White", 0.75F);

            debug.WriteText($"Water message size:  {msgSize}\n", true);

            tst = new StringBuilder("Nutrient inventory:");
            msgSize = drawSurface.MeasureStringInPixels(tst, "White", 0.75F);

            debug.WriteText($"Nutrient inventory size: {msgSize}\n", true);
            */

    return;
}