/* ---------------------------------------------------------------------------------
Conveyor Sorter Filter List Bug MCVE

Setup grid:
    1 Program block (with this script)
    1 Conveyor Sorter block
    1 Battery (to power the test)

Testing:
    Run program block with argument:
        testfilter   - this will attempt to set only "Stone" as the sorter's filter list
        showfilter   - this will show whats currently set in the filter list
        clearfilter  - this will clear all items in the sorter's filter list

The Bug:
    When the Stone filter is add to the sorter using the script, it SHOULD simply 
    show up as "Stone" in the sorter block control panel. However if it shows up 
    as "(null)/Stone", then this is the bug!

    If you try to manually remove the "(null)/Stone" entry from the sorter's
    filters using the Control Panel UI directly, you should get kicked off the 
    server a few seconds later.
    
    The only way to clear the bugged filter entry, is to use the script to clear
    the filter list.
    
    This bug does NOT (have not been able) to show up in a Creative or Survival
    game. It seems to be a Dedicated Server only issue.

--------------------------------------------------------------------------------- */

IMyConveyorSorter sorter = null;
IMyTextSurface debug = null;
List<IMyConveyorSorter> sorters = new List<IMyConveyorSorter>();
List<MyInventoryItemFilter> items = new List<MyInventoryItemFilter>();

public Program()
{
    
    debug = Me.GetSurface(0) as IMyTextSurface;
	if (debug != null)
	{
        debug.ContentType = ContentType.TEXT_AND_IMAGE;
        debug.BackgroundColor = new Color(0,0,0);
        debug.FontSize = (float)1.0;
        debug.Alignment = TextAlignment.LEFT;
        debug.WriteText("",false);
        debugOut("Debug Display ready: "+ debug.DisplayName );
    }
    else
	{
		Echo("Debug Display not found - BAIL");
		return;
	}
    
    GridTerminalSystem.GetBlocksOfType<IMyConveyorSorter>(sorters,(x => x.CubeGrid == Me.CubeGrid));
	if (sorters.Count > 0)
	{
		sorter = sorters[0];
		debugOut("Sorter found: " + sorter.CustomName);
	}
	else
	{
		debugOut("Sorter not found - BAIL");
		return;
	}
	
	debugOut("Arguments to run:");
	debugOut("    testfilter");
	debugOut("    showfilter");
	debugOut("    clearfilter");

}

public void Main(string argument, UpdateType updateSource)
{
    
    if (argument == "testfilter")
    {
        
        items.Add(new MyInventoryItemFilter("MyObjectBuilder_Ore/Stone"));
        sorter.SetFilter(MyConveyorSorterMode.Whitelist,items);
        sorter.DrainAll = true;
        
        argument = "showfilter";
        
    }
    
    if (argument == "showfilter")
    {
        
        items.Clear();
        debugOut("Sorter filters set to:");
        sorter.GetFilterList(items);
        debugOut($"{items}");
        if (items.Count > 0)
        {
            for (int i=0;i < items.Count;i++)
            {
                debugOut($"{items[i]} {items[i].ItemType}\n");
            }
        }
        
    }
    
    if (argument == "clearfilter")
    {
    
        items.Clear();
        sorter.SetFilter(MyConveyorSorterMode.Blacklist,items);
        sorter.DrainAll = false;
        
        debugOut("Sorter filters cleared.");
        
    }
    
}

public void debugOut(string text)
{
    Echo( text );
    if (debug != null)
    {
        debug.WriteText( text +"\n",true);
    }
}
